/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.Common;

import SevenZip.ICompressCoder;
import SevenZip.ICompressCoder2;
import SevenZipCommon.LongVector;

public class CoderInfo {
    ICompressCoder Coder;
    ICompressCoder2 Coder2;
    int NumInStreams;
    int NumOutStreams;
    LongVector InSizes = new LongVector();
    LongVector OutSizes = new LongVector();
    LongVector InSizePointers = new LongVector();
    LongVector OutSizePointers = new LongVector();

    public CoderInfo(int numInStreams, int numOutStreams) {
        this.NumInStreams = numInStreams;
        this.NumOutStreams = numOutStreams;
        this.InSizes.Reserve(this.NumInStreams);
        this.InSizePointers.Reserve(this.NumInStreams);
        this.OutSizePointers.Reserve(this.NumOutStreams);
        this.OutSizePointers.Reserve(this.NumOutStreams);
    }

    public static void SetSizes(LongVector srcSizes, LongVector sizes, LongVector sizePointers, int numItems) {
        sizes.clear();
        sizePointers.clear();
        for (int i = 0; i < numItems; ++i) {
            if (srcSizes == null || srcSizes.get(i) == -1L) {
                sizes.add(new Long(0L));
                sizePointers.add(-1L);
                continue;
            }
            sizes.add(srcSizes.get(i));
            sizePointers.add(sizes.Back());
        }
    }

    public void SetCoderInfo(LongVector inSizes, LongVector outSizes) {
        CoderInfo.SetSizes(inSizes, this.InSizes, this.InSizePointers, this.NumInStreams);
        CoderInfo.SetSizes(outSizes, this.OutSizes, this.OutSizePointers, this.NumOutStreams);
    }
}

