/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import SevenZip.Archive.Common.OutStreamWithCRC;
import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.SevenZip.ArchiveDatabaseEx;
import SevenZip.Archive.SevenZip.FileItem;
import SevenZipCommon.BoolVector;
import java.io.IOException;
import java.io.OutputStream;

class FolderOutStream
extends OutputStream {
    OutStreamWithCRC _outStreamWithHashSpec = new OutStreamWithCRC();
    OutputStream _outStreamWithHash = this._outStreamWithHashSpec;
    ArchiveDatabaseEx _archiveDatabase;
    BoolVector _extractStatuses;
    int _startIndex;
    int _ref2Offset;
    IArchiveExtractCallback _extractCallback;
    boolean _testMode;
    int _currentIndex;
    boolean _fileIsOpen;
    long _filePos;

    public int Init(ArchiveDatabaseEx archiveDatabase, int ref2Offset, int startIndex, BoolVector extractStatuses, IArchiveExtractCallback extractCallback, boolean testMode) throws IOException {
        this._archiveDatabase = archiveDatabase;
        this._ref2Offset = ref2Offset;
        this._startIndex = startIndex;
        this._extractStatuses = extractStatuses;
        this._extractCallback = extractCallback;
        this._testMode = testMode;
        this._currentIndex = 0;
        this._fileIsOpen = false;
        return this.WriteEmptyFiles();
    }

    int OpenFile() throws IOException {
        int index = this._startIndex + this._currentIndex;
        OutputStream[] realOutStream2 = new OutputStream[1];
        int askMode = this._extractStatuses.get(this._currentIndex) ? (this._testMode ? 1 : 0) : 2;
        int ret = this._extractCallback.GetStream(this._ref2Offset + index, realOutStream2, askMode);
        if (ret != 0) {
            return ret;
        }
        OutputStream realOutStream = realOutStream2[0];
        this._outStreamWithHashSpec.SetStream(realOutStream);
        this._outStreamWithHashSpec.Init();
        if (askMode == 0 && realOutStream == null) {
            FileItem fileInfo = (FileItem)this._archiveDatabase.Files.get(index);
            if (!fileInfo.IsAnti && !fileInfo.IsDirectory) {
                askMode = 2;
            }
        }
        return this._extractCallback.PrepareOperation(askMode);
    }

    int WriteEmptyFiles() throws IOException {
        while (this._currentIndex < this._extractStatuses.size()) {
            int index = this._startIndex + this._currentIndex;
            FileItem fileInfo = (FileItem)this._archiveDatabase.Files.get(index);
            if (!fileInfo.IsAnti && !fileInfo.IsDirectory && fileInfo.UnPackSize != 0L) {
                return 0;
            }
            int res = this.OpenFile();
            if (res != 0) {
                return res;
            }
            res = this._extractCallback.SetOperationResult(0);
            if (res != 0) {
                return res;
            }
            this._outStreamWithHashSpec.ReleaseStream();
            ++this._currentIndex;
        }
        return 0;
    }

    @Override
    public void write(int b2) throws IOException {
        throw new IOException("FolderOutStream - write() not implemented");
    }

    @Override
    public void write(byte[] data, int off, int size) throws IOException {
        int realProcessedSize = 0;
        while (this._currentIndex < this._extractStatuses.size()) {
            if (this._fileIsOpen) {
                int numBytesToWrite;
                int index = this._startIndex + this._currentIndex;
                FileItem fileInfo = (FileItem)this._archiveDatabase.Files.get(index);
                int tmp = size - realProcessedSize;
                long fileSize = fileInfo.UnPackSize;
                long numBytesToWrite2 = (int)(fileSize - this._filePos);
                if ((long)tmp < numBytesToWrite2) {
                    numBytesToWrite2 = tmp;
                }
                int processedSizeLocal = numBytesToWrite = (int)numBytesToWrite2;
                this._outStreamWithHash.write(data, realProcessedSize + off, numBytesToWrite);
                this._filePos += (long)processedSizeLocal;
                realProcessedSize += processedSizeLocal;
                if (this._filePos == fileSize) {
                    boolean digestsAreEqual = fileInfo.IsFileCRCDefined ? fileInfo.FileCRC == this._outStreamWithHashSpec.GetCRC() : true;
                    int res = this._extractCallback.SetOperationResult(digestsAreEqual ? 0 : 3);
                    if (res != 0) {
                        throw new IOException("_extractCallback.SetOperationResult : " + res);
                    }
                    this._outStreamWithHashSpec.ReleaseStream();
                    this._fileIsOpen = false;
                    ++this._currentIndex;
                }
                if (realProcessedSize != size) continue;
                int res = this.WriteEmptyFiles();
                if (res != 0) {
                    throw new IOException("WriteEmptyFiles : " + res);
                }
                return;
            }
            int res = this.OpenFile();
            if (res != 0) {
                throw new IOException("OpenFile : " + res);
            }
            this._fileIsOpen = true;
            this._filePos = 0L;
        }
    }

    public int FlushCorrupted(int resultEOperationResult) throws IOException {
        while (this._currentIndex < this._extractStatuses.size()) {
            int res;
            if (this._fileIsOpen) {
                res = this._extractCallback.SetOperationResult(resultEOperationResult);
                if (res != 0) {
                    return res;
                }
                this._outStreamWithHashSpec.ReleaseStream();
                this._fileIsOpen = false;
                ++this._currentIndex;
                continue;
            }
            res = this.OpenFile();
            if (res != 0) {
                return res;
            }
            this._fileIsOpen = true;
        }
        return 0;
    }

    public int WasWritingFinished() {
        int val = this._extractStatuses.size();
        if (this._currentIndex == val) {
            return 0;
        }
        return -2147467259;
    }
}

