/*
 * Decompiled with CFR 0.152.
 */
package cpythoncompiler;

import shared.Exec;
import shared.FileUtils;
import shared.GetResource;
import shared.b;
import shared.m;

public class Compiler {
    public static final String[] CommonPythonPaths = new String[]{"C:/Python22/python.exe", "C:/Python23/python.exe", "/usr/bin/python2.2", "/usr/bin/python2.3"};

    public static String FindCPythonVerFromList(int pythonVersion, String ... PossiblePaths) {
        String pyver = Compiler.GetVersionStrFromInt(pythonVersion);
        for (String PossiblePath : PossiblePaths) {
            String ver;
            if (!FileUtils.Exists(PossiblePath) || !pyver.equals(ver = Compiler.GetVersion(PossiblePath))) continue;
            return PossiblePath;
        }
        return null;
    }

    private static String GetVersionStrFromInt(int pythonVersion) {
        switch (pythonVersion) {
            case 22: {
                return "2.2";
            }
            case 23: {
                return "2.3";
            }
            case 24: {
                return "2.4";
            }
            case 25: {
                return "2.5";
            }
        }
        return null;
    }

    public static String GetVersion(String CPythonPath) {
        String program = GetResource.getResourceAsString("/cpythoncompiler/getver.py");
        program = program.replace("\r\n", "\n");
        program = program.replace("\r", "\n");
        String[] cmdarray = new String[]{"-u", "-E", "-c", program};
        Exec.ReturnInfo info = Exec.RunAndWaitWithStreams(null, null, CPythonPath, cmdarray);
        if (info == null) {
            return null;
        }
        if (info.stderr.length != 0) {
            m.err(b.BytesToString(info.stderr));
        }
        if (info.returnval != 0) {
            m.err("ErrorVal=" + Integer.toString(info.returnval));
        }
        String version = b.BytesToString(info.stdout);
        return version;
    }

    public static byte[] Compile(byte[] source, String pythonFilename, int pythonVersion, String CPythonPath) {
        String pythonver = Compiler.GetVersionStrFromInt(pythonVersion);
        String compileProgram = GetResource.getResourceAsString("/cpythoncompiler/compile.py");
        compileProgram = "pythonver='" + pythonver + "'; filename='" + pythonFilename + "'; \n" + compileProgram;
        compileProgram = compileProgram.replace("\r\n", "\n");
        compileProgram = compileProgram.replace("\r", "\n");
        String[] cmdarray = new String[]{"-u", "-E", "-c", compileProgram};
        Exec.ReturnInfo info = Exec.RunAndWaitWithStreams(null, source, CPythonPath, cmdarray);
        if (info == null) {
            return null;
        }
        if (info.stderr.length != 0) {
            m.err(b.BytesToString(info.stderr));
        }
        if (info.returnval != 0) {
            m.err("ErrorVal=" + Integer.toString(info.returnval));
        }
        byte[] bytecode = info.stdout;
        return bytecode;
    }
}

