/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import difflib.PatchFailedException;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chunk {
    private int position;
    private int size;
    private List<?> lines;

    public Chunk(int position, int size, List<?> lines) {
        this.position = position;
        this.size = size;
        this.lines = lines;
    }

    public Chunk(int position, int size, Object[] lines) {
        this.position = position;
        this.size = size;
        this.lines = Arrays.asList(lines);
    }

    public void verify(List<?> target) throws PatchFailedException {
        if (this.last() > target.size()) {
            throw new PatchFailedException("Incorrect Chunk: the position of chunk > target size");
        }
        for (int i = 0; i < this.size; ++i) {
            if (target.get(this.position + i).equals(this.lines.get(i))) continue;
            throw new PatchFailedException("Incorrect Chunk: the chunk content doesn't match the target");
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public List<?> getLines() {
        return this.lines;
    }

    public void setLines(List<?> lines) {
        this.lines = lines;
    }

    public int last() {
        return this.getPosition() + this.getSize() - 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lines == null ? 0 : ((Object)this.lines).hashCode());
        result = 31 * result + this.position;
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Chunk other = (Chunk)obj;
        if (this.lines == null ? other.lines != null : !((Object)this.lines).equals(other.lines)) {
            return false;
        }
        if (this.position != other.position) {
            return false;
        }
        return this.size == other.size;
    }

    public String toString() {
        return "[position: " + this.position + ", size: " + this.size + ", lines: " + this.lines + "]";
    }
}

