/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.util.Vector;
import moulserver.Version;
import shared.CryptHashes;
import shared.FileUtils;
import shared.b;
import shared.m;
import shared.uncaughtexception;

public class Patcher {
    public static void PatchFile(String filename, String newdomainname) {
        byte[] data = FileUtils.ReadFile(filename);
        byte[] md5 = CryptHashes.GetMd5(data);
        String md5str = b.BytesToHexString(md5).toUpperCase();
        if (md5str.equals("6F1BBD558DBC4B8963AACA6CCCECC1B3")) {
            Patcher.PatchUtf16(data, "support.cyanworlds.com", newdomainname);
            Patcher.PatchUtf16(data, "67.202.54.141", newdomainname);
            Patcher.PatchUtf16(data, "184.73.198.22", newdomainname);
            Patcher.PatchHex(data, Version.moulagain_1_893.gateserver_mod, Version.talcum.gateserver_mod);
            Patcher.PatchHex(data, Version.moulagain_1_893.gateserver_B, Version.talcum.gateserver_B);
            Patcher.PatchHex(data, Version.moulagain_1_893.authserver_mod, Version.talcum.authserver_mod);
            Patcher.PatchHex(data, Version.moulagain_1_893.authserver_B, Version.talcum.authserver_B);
            Patcher.PatchHex(data, Version.moulagain_1_893.csrserver_mod, Version.talcum.csrserver_mod);
            Patcher.PatchHex(data, Version.moulagain_1_893.csrserver_B, Version.talcum.csrserver_B);
            Patcher.PatchHex(data, Version.moulagain_1_893.gameserver_mod, Version.talcum.gameserver_mod);
            Patcher.PatchHex(data, Version.moulagain_1_893.gameserver_B, Version.talcum.gameserver_B);
        } else if (md5str.equals("6B299C93B10DF1F351C0D92DF7115C64")) {
            Patcher.PatchUtf16(data, "support.cyanworlds.com", newdomainname);
            Patcher.PatchUtf8(data, "http://www.mystonline.com/signup.html", "http://" + newdomainname + "/signup.html");
            Patcher.PatchUtf16(data, "67.202.54.141", newdomainname);
            Patcher.PatchUtf16(data, "184.73.198.22", newdomainname);
            Patcher.PatchHex(data, Version.moulagain_1_893.gateserver_mod, Version.talcum.gateserver_mod);
            Patcher.PatchHex(data, Version.moulagain_1_893.gateserver_B, Version.talcum.gateserver_B);
            Patcher.PatchHex(data, Version.moulagain_1_893.authserver_mod, Version.talcum.authserver_mod);
            Patcher.PatchHex(data, Version.moulagain_1_893.authserver_B, Version.talcum.authserver_B);
            Patcher.PatchHex(data, Version.moulagain_1_893.csrserver_mod, Version.talcum.csrserver_mod);
            Patcher.PatchHex(data, Version.moulagain_1_893.csrserver_B, Version.talcum.csrserver_B);
            Patcher.PatchHex(data, Version.moulagain_1_893.gameserver_mod, Version.talcum.gameserver_mod);
            Patcher.PatchHex(data, Version.moulagain_1_893.gameserver_B, Version.talcum.gameserver_B);
        } else {
            m.err("Cannot find a patch for this file's md5.");
            return;
        }
        FileUtils.CopyFile(filename, filename + ".orig", true, false);
        FileUtils.WriteFile(filename, data, false, true);
        m.msg("Done patching!");
    }

    public static void PatchUtf8(byte[] data, String oldstr, String newstr) {
        if (newstr.length() > oldstr.length()) {
            throw new uncaughtexception("Newhexstr *probably* shouldn't be longer than Oldhexstr.");
        }
        byte[] oldstrbs = b.StringToBytes(oldstr);
        byte[] newstrbs = b.StringToBytes(newstr);
        Vector<Integer> locs = b.findBytes_All(data, oldstrbs);
        for (int loc : locs) {
            b.writeNullTerminatedBytes(data, loc, newstrbs);
            m.msg("Patched " + oldstr + " to " + newstr + " at position " + Integer.toString(loc));
        }
    }

    public static void PatchHex(byte[] data, String oldhexstr, String newhexstr) {
        if (newhexstr.length() > oldhexstr.length()) {
            throw new uncaughtexception("Newhexstr *probably* shouldn't be longer than Oldhexstr.");
        }
        byte[] oldbytes = b.HexStringToBytes(oldhexstr);
        byte[] newbytes = b.HexStringToBytes(newhexstr);
        Vector<Integer> locs = b.findBytes_All(data, oldbytes);
        for (int loc : locs) {
            b.CopyBytes(newbytes, data, loc);
            m.msg("Patched " + oldhexstr + " to " + newhexstr + " at position " + Integer.toString(loc));
        }
    }

    public static void PatchUtf16(byte[] data, String oldstr, String str) {
        byte[] oldstrbs = b.StringToUtf16Bytes(oldstr);
        Vector<Integer> positions = b.findBytes_All(data, oldstrbs);
        for (int loc : positions) {
            Patcher.PatchUtf16(data, loc, str);
        }
    }

    public static void PatchUtf16(byte[] data, int loc, String str) {
        String curstr = b.readNullTerminatedUtf16FromBytes(data, loc);
        if (str.length() > curstr.length()) {
            throw new uncaughtexception("String " + str + " is too long to fit in " + curstr + " so make it shorter.");
        }
        b.writeNullTerminatedUtf16FromString(data, loc, str);
        m.msg("Patched " + curstr + " at location " + Integer.toString(loc) + " to " + str);
    }
}

