/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import moulserver.AbstractManager;
import moulserver.AuthServer;
import moulserver.ChunkSendHandler;
import moulserver.Client;
import moulserver.ConnectionState;
import moulserver.FileServer;
import moulserver.GateServer;
import moulserver.NetServer;
import moulserver.Server;
import moulserver.ServerType;
import moulserver.SuperManager;
import moulserver.Version;
import shared.Concurrent;
import shared.CryptHashes;
import shared.FileUtils;
import shared.MemUtils;
import shared.Str;
import shared.b;
import shared.m;
import shared.nested;
import shared.uncaughtexception;
import uru.UruCrypt;
import uru.server.MoulFileInfo;

public class Proxy {
    String uruPath;
    String proxyServerAddress;
    int proxyServerAddress2;
    int[] ourNotthedroidsKey = new int[]{0, 0, 0, 0};
    NetServer netserver;
    String fileserveraddress;
    Integer currentGameServerAddress;
    int[] notthedroidsKey;
    ConcurrentHashMap<ConnectionState, ServerConnection> c2s;
    ConcurrentHashMap<Client.ClientConnection, ConnectionState> s2c;

    public static void start(String ProxyUruFolder) {
        Proxy proxy = new Proxy(ProxyUruFolder);
        proxy.StartServers();
    }

    public static int StringAddressToIntAddress(String strAddress) {
        try {
            InetAddress addr = Inet4Address.getByName(strAddress);
            Inet4Address addr4 = (Inet4Address)addr;
            byte[] addrbs = addr4.getAddress();
            int bigEndianAddress = b.BytesToInt32(addrbs, 0);
            int intAddress = b.reverseEndianness(bigEndianAddress);
            return intAddress;
        }
        catch (Exception e2) {
            throw new uncaughtexception("unabled to get address from server name for some reason: " + strAddress);
        }
    }

    public static String IntAddressToStringAddress(int intAddress) {
        try {
            int bigEndianAddress = b.reverseEndianness(intAddress);
            byte[] addrbs = b.Int32ToBytes(bigEndianAddress);
            InetAddress addr = InetAddress.getByAddress(addrbs);
            String strAddress = addr.getHostAddress();
            return strAddress;
        }
        catch (Exception e2) {
            throw new uncaughtexception("unable to get string address from int address: " + Integer.toString(intAddress));
        }
    }

    public Proxy(String uruPath2) {
        this.uruPath = uruPath2;
        this.proxyServerAddress = "127.0.0.1";
        this.proxyServerAddress2 = Proxy.StringAddressToIntAddress(this.proxyServerAddress);
    }

    public void StartServers() {
        SuperManager.SetAgeInfoFolder(this.uruPath + "/dat/", this.uruPath + "/SDL/");
        this.c2s = Concurrent.getConcurrentHashMap();
        this.s2c = Concurrent.getConcurrentHashMap();
        AbstractManager manager = new AbstractManager(){

            @Override
            public void HandleMessage(ServerType servertype, Server.ServerMsg msg, ConnectionState cs) {
                ServerConnection serverconn = Proxy.this.c2s.get(cs);
                Class<?> kls = msg.getClass();
                if (serverconn == null) {
                    serverconn = new ServerConnection();
                    serverconn.connect(servertype, cs);
                    Proxy.this.c2s.put(cs, serverconn);
                    Proxy.this.s2c.put(serverconn.cc, cs);
                }
                if (kls == AuthServer.FileDownloadRequest.class) {
                    AuthServer.FileDownloadRequest msg2 = (AuthServer.FileDownloadRequest)msg;
                    try {
                        File f = FileServer.GetFile(msg2.filename.toString(), Proxy.this.uruPath);
                        if (f == null) {
                            Client.AuthConnection authcc = (Client.AuthConnection)serverconn.cc;
                            byte[] filedata = authcc.GetFile(msg2.filename.toString(), Proxy.this.notthedroidsKey);
                            String filepath = Proxy.this.uruPath + "/" + msg2.filename.toString();
                            FileUtils.WriteFile(filepath, filedata, true, true);
                            MemUtils.GarbageCollect();
                        }
                        f = FileServer.GetFile(msg2.filename.toString(), Proxy.this.uruPath);
                        byte[] filedata = FileUtils.ReadFile(f);
                        byte[] encfiledata = UruCrypt.EncryptNotthedroids(filedata, Proxy.this.ourNotthedroidsKey);
                        int filesize = encfiledata.length;
                        ByteArrayInputStream fis = new ByteArrayInputStream(encfiledata);
                        ChunkSendHandler.ChunkFile chunk = cs.chunksendhandler.startfile(msg2.filename.toString(), filesize, msg2.transId, fis, true);
                        AuthServer.FileDownloadChunk reply = new AuthServer.FileDownloadChunk();
                        reply.transId = msg2.transId;
                        reply.result = 0;
                        reply.filesize = filesize;
                        reply.chunkOffset = chunk.offset();
                        reply.buffer = chunk.read();
                        cs.sendMsgBytes(reply.GetMsgBytes());
                    }
                    catch (Exception e2) {
                        throw new nested(e2);
                    }
                    return;
                }
                if (kls == AuthServer.FileDownloadChunkAck.class) {
                    AuthServer.FileDownloadChunkAck ack = (AuthServer.FileDownloadChunkAck)msg;
                    ChunkSendHandler.ChunkFile chunk = cs.chunksendhandler.ack(ack.transId);
                    if (!chunk.done) {
                        AuthServer.FileDownloadChunk reply = new AuthServer.FileDownloadChunk();
                        reply.transId = ack.transId;
                        reply.result = 0;
                        reply.filesize = chunk.filesize;
                        reply.chunkOffset = chunk.offset();
                        reply.buffer = chunk.read();
                        cs.sendMsgBytes(reply.GetMsgBytes());
                    } else {
                        cs.chunksendhandler.clearfile(ack.transId);
                    }
                    return;
                }
                serverconn.send(msg);
            }

            @Override
            public void removeConnectionState(ConnectionState cs) {
                m.msg("Proxy disconnect");
            }
        };
        this.netserver = new NetServer(manager);
        this.netserver.start();
    }

    public class ServerConnection
    extends Client {
        Client.ClientConnection cc;

        public void connect(ServerType servertype, ConnectionState clientconn) {
            Version ver = Version.currentMoulagain;
            switch (servertype) {
                case GateServer: {
                    this.cc = new Client.GateConnection(ver);
                    break;
                }
                case FileServer: {
                    this.cc = new Client.FileConnection(ver, Proxy.this.fileserveraddress);
                    break;
                }
                case AuthServer: {
                    this.cc = new Client.AuthConnection(ver, ver.authserver);
                    break;
                }
                case GameServer: {
                    String addr = Proxy.IntAddressToStringAddress(Proxy.this.currentGameServerAddress);
                    ConnectionState.GameConnHeader gheader = (ConnectionState.GameConnHeader)clientconn.header.subheader;
                    this.cc = new Client.GameConnection(ver, addr, gheader.accountGuid, gheader.ageGuid);
                    break;
                }
                default: {
                    throw new uncaughtexception("unexpected");
                }
            }
            this.cc.msghandler = new Client.MsgHandler(){

                @Override
                public void HandleMsg(Server.ServerMsg msg, Client.ClientConnection caller) {
                    Server.ServerMsg msg2;
                    Class<?> kls = msg.getClass();
                    if (kls == GateServer.FileSrvIpAddressReply.class) {
                        msg2 = (GateServer.FileSrvIpAddressReply)msg;
                        Proxy.this.fileserveraddress = msg2.address.toString();
                        msg2.address = new Str("127.0.0.1");
                    } else if (kls == FileServer.ManifestReply.class) {
                        msg2 = (FileServer.ManifestReply)msg;
                        for (MoulFileInfo mfi : ((FileServer.ManifestReply)msg2).manifest.getFiles()) {
                            String fn = mfi.filename.toString();
                            if (!fn.equals("UruLauncher.exe") && !fn.equals("UruExplorer.exe")) continue;
                            File f = new File(Proxy.this.uruPath + "/" + fn);
                            if (!f.exists()) {
                                m.throwUncaughtException("File not found: " + f.getAbsolutePath());
                            }
                            mfi.Filesize = (int)f.length();
                            mfi.Hash = new Str(b.BytesToHexString(CryptHashes.GetHash(f.getAbsolutePath(), CryptHashes.Hashtype.md5)));
                        }
                    } else if (kls == AuthServer.AgeReply.class) {
                        msg2 = (AuthServer.AgeReply)msg;
                        Proxy.this.currentGameServerAddress = ((AuthServer.AgeReply)msg2).gameServerAddress;
                        ((AuthServer.AgeReply)msg2).gameServerAddress = Proxy.this.proxyServerAddress2;
                    } else if (kls == AuthServer.AcctLoginReply.class) {
                        msg2 = (AuthServer.AcctLoginReply)msg;
                        Proxy.this.notthedroidsKey = ((AuthServer.AcctLoginReply)msg2).encryptionKey;
                        ((AuthServer.AcctLoginReply)msg2).encryptionKey = Proxy.this.ourNotthedroidsKey;
                    }
                    ConnectionState cs = Proxy.this.s2c.get(caller);
                    if (cs == null) {
                        m.throwUncaughtException("this shouldn't happen");
                    }
                    cs.sendMsgBytes(msg.GetMsgBytes());
                }
            };
        }

        public void send(Server.ServerMsg msg) {
            this.cc.SendMsg(msg);
        }
    }
}

