/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import prpobjects.Pageid;
import prpobjects.Pagetype;
import prpobjects.Urustring;
import prpobjects.uruobj;
import shared.IBytestream;
import shared.State.AllStates;
import shared.cancelexception;
import shared.e;
import shared.m;
import uru.Bytedeque;
import uru.context;

public class PrpHeader
extends uruobj {
    short version;
    short version2;
    public Pageid pageid;
    public Pagetype pagetype;
    public Urustring agename;
    public Urustring pagename;
    short u1;
    int payloadlength;
    int offsetToFirstObject;
    public int offsetToObjectIndex;
    short u2;
    int u3;
    int u4;

    public PrpHeader(IBytestream data) {
        this(context.createFromBytestream(data));
    }

    public PrpHeader(context c) {
        IBytestream data = c.in;
        this.version = data.readShort();
        if (this.version == 6 || this.version == 9) {
            this.version2 = data.readShort();
            if (this.version2 == 0) {
                c.readversion = 6;
                this.pageid = new Pageid(c);
                this.pagetype = new Pagetype(c);
                this.agename = new Urustring(c);
                this.pagename = new Urustring(c);
                this.u1 = data.readShort();
                e.ensureflags(this.u1, 70);
                this.payloadlength = data.readInt();
                this.offsetToFirstObject = data.readInt();
                this.offsetToObjectIndex = data.readInt();
                this.u2 = data.readShort();
                this.u3 = data.readInt();
                this.u4 = data.readInt();
            } else {
                c.readversion = this.version == 6 ? 4 : 7;
                for (int i = 0; i < this.version2; ++i) {
                    short objecttype = c.readShort();
                    short s = c.readShort();
                }
                this.pageid = new Pageid(c);
                this.pagetype = new Pagetype(c);
                this.agename = new Urustring(c);
                this.pagename = new Urustring(c);
                int filesize = data.readInt();
                this.offsetToFirstObject = data.readInt();
                this.offsetToObjectIndex = data.readInt();
            }
        } else if (this.version == 5) {
            c.readversion = 3;
            this.version2 = data.readShort();
            this.pageid = new Pageid(c);
            this.pagetype = new Pagetype(c);
            this.agename = new Urustring(c);
            Urustring district = new Urustring(c);
            this.pagename = new Urustring(c);
            short majorversion = data.readShort();
            e.ensureflags(majorversion, 63);
            short minorversion = data.readShort();
            e.ensureflags(minorversion, 12, 11);
            int unknown3 = data.readInt();
            int unknown4 = data.readInt();
            this.payloadlength = data.readInt();
            this.offsetToFirstObject = data.readInt();
            this.offsetToObjectIndex = data.readInt();
        } else {
            if (this.version == 21504) {
                throw new cancelexception("This appears to be a copy of Myst5 with TryMedia DRM on it (probably downloaded from IGN's Direct2Drive service.)  You need a regular copy of Myst5, sorry.");
            }
            m.err("prpheader: Unknown version.");
        }
        if (AllStates.getStateAsBoolean("reportPrp")) {
            m.msg("PrpFile: name=" + c.curFile + " readversion=" + Integer.toString(c.readversion) + " agename=" + this.agename + " pagename=" + this.pagename + " pageid=" + this.pageid.toString());
        }
    }

    private PrpHeader() {
    }

    public static PrpHeader createFromInfo(String agename, Pageid pid, Pagetype pagetype, String pagename) {
        PrpHeader result = new PrpHeader();
        result.version = (short)5;
        result.version2 = 0;
        result.pageid = pid;
        result.pagetype = pagetype;
        result.agename = Urustring.createFromString(agename);
        result.pagename = Urustring.createFromString(pagename);
        result.payloadlength = -1;
        result.offsetToFirstObject = -1;
        result.offsetToObjectIndex = -1;
        return result;
    }

    @Override
    public void compile(Bytedeque deque) {
        m.msg("compile not implemented");
    }
}

