/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import auto.mystAutomation;
import java.util.HashMap;
import java.util.Vector;
import prpobjects.PrpHeader;
import prpobjects.PrpObjectIndex;
import prpobjects.PrpRootObject;
import prpobjects.Typeid;
import prpobjects.Uruobjectdesc;
import prpobjects.Uruobjectref;
import prpobjects.Urustring;
import prpobjects._staticsettings;
import prpobjects.allprpfiles;
import prpobjects.plDrawInterface;
import prpobjects.plDrawableSpans;
import prpobjects.prpfile;
import prpobjects.prpprocess;
import prpobjects.x0000Scenenode;
import prpobjects.x0007Material;
import shared.FileUtils;
import shared.Format;
import shared.IBytestream;
import shared.State.AllStates;
import shared.b;
import shared.e;
import shared.m;
import shared.readexception;
import uru.Bytedeque;
import uru.Bytestream;
import uru.context;
import uru.reflection;

public class prputils {
    public static void ThisIsJustATemplate(context c) {
        PrpHeader header = new PrpHeader(c);
        context c2 = c.Fork(header.offsetToObjectIndex);
        PrpObjectIndex objectindex = new PrpObjectIndex(c2);
        c2.close();
        int numobjecttypes = objectindex.indexCount;
        for (int i_type = 0; i_type < numobjecttypes; ++i_type) {
            Typeid type = objectindex.types[i_type].type;
            int numObjects = objectindex.types[i_type].objectcount;
            for (int j_obj = 0; j_obj < numObjects; ++j_obj) {
                Uruobjectdesc desc = objectindex.types[i_type].descs[j_obj].desc;
                int offset = objectindex.types[i_type].descs[j_obj].offset;
                int n = objectindex.types[i_type].descs[j_obj].size;
            }
        }
    }

    public static String MakeObjectIndexReport(byte[] data) {
        context c = context.createFromBytestream(new Bytestream(data));
        StringBuilder report = new StringBuilder();
        PrpHeader header = new PrpHeader(c);
        report.append("header:\n");
        report.append("    age:" + header.agename.toString() + "\n");
        report.append("    pagename:" + header.pagename.toString() + "\n");
        report.append("    pagetype:" + header.pagetype.toString() + "\n");
        report.append("    pageid:" + header.pageid.toString() + "\n");
        report.append("Object types:\n");
        context c2 = c.Fork(header.offsetToObjectIndex);
        PrpObjectIndex objectindex = new PrpObjectIndex(c2);
        c2.close();
        int numobjecttypes = objectindex.indexCount;
        for (int i = 0; i < numobjecttypes; ++i) {
            Typeid type = objectindex.types[i].type;
            int numObjects = objectindex.types[i].objectcount;
            report.append("    typeid:" + type.toString() + "\n");
            report.append("    Num objects:" + Integer.toString(numObjects) + "\n");
            for (int j = 0; j < numObjects; ++j) {
                Uruobjectdesc desc = objectindex.types[i].descs[j].desc;
                int offset = objectindex.types[i].descs[j].offset;
                int size = objectindex.types[i].descs[j].size;
                report.append("        desc:" + desc.toString() + "\n");
                report.append("        offset:0x" + Integer.toHexString(offset) + "\n");
                report.append("        length:0x" + Integer.toHexString(size) + "\n");
            }
        }
        return report.toString();
    }

    public static prpfile ProcessAllMoul(byte[] data, Typeid[] typesToRead) {
        context c = context.createFromBytestream(new Bytestream(data));
        return prputils.ProcessAllMoul(c, false, typesToRead);
    }

    public static prpfile ProcessAllMoul(context c, boolean reportProgress, Typeid[] typesToRead) {
        IBytestream data = c.in;
        PrpHeader header = new PrpHeader(c);
        prpfile result = new prpfile();
        Vector<PrpRootObject> objects = new Vector<PrpRootObject>();
        result.header = header;
        context c2 = c.Fork(header.offsetToObjectIndex);
        PrpObjectIndex objectindex = new PrpObjectIndex(c2);
        c2.close();
        result.objectindex = objectindex;
        int numobjecttypes = objectindex.indexCount;
        for (int i = 0; i < numobjecttypes; ++i) {
            Typeid type = objectindex.types[i].type;
            int numObjects = objectindex.types[i].objectcount;
            boolean parseThisType = false;
            if (typesToRead == null) {
                parseThisType = true;
            } else {
                for (int k = 0; k < typesToRead.length; ++k) {
                    if (typesToRead[k] != type) continue;
                    parseThisType = true;
                }
            }
            if (reportProgress) {
                m.msg("type=", type.toString());
            }
            for (int j = 0; j < numObjects; ++j) {
                Uruobjectdesc desc = objectindex.types[i].descs[j].desc;
                int offset = objectindex.types[i].descs[j].offset;
                int size = objectindex.types[i].descs[j].size;
                if (AllStates.getStateAsBoolean("reportObjects")) {
                    m.msg("ObjectReport: ", desc.toString());
                }
                if (!_staticsettings.doVisit(desc)) continue;
                PrpRootObject object = null;
                context stream = c.Fork(offset);
                stream.curRootObject = desc;
                stream.curRootObjectOffset = offset;
                stream.curRootObjectSize = size;
                stream.curRootObjectEnd = offset + size;
                _staticsettings.currentRootObj = desc;
                boolean handled = true;
                if (desc.objectname.toString().toLowerCase().equals("envmap02")) {
                    boolean bl = false;
                }
                if (parseThisType) {
                    try {
                        object = new PrpRootObject(stream, false, size);
                    }
                    catch (readexception readexception2) {
                    }
                    catch (Exception e2) {
                        m.err("Unexpected exception: ", e2.getMessage());
                        e2.printStackTrace();
                    }
                } else {
                    m.msg("unhandled object type:", desc.objecttype.toString());
                    handled = false;
                    if (_staticsettings.tryToFindReferencesInUnknownObjects) {
                        IBytestream bs = data.Fork(offset);
                        byte[] bytes = bs.readBytes(size);
                        for (int curbyte = 0; curbyte < bytes.length; ++curbyte) {
                            int l;
                            if (b.ByteToInt32(bytes[curbyte]) != 240 || curbyte == 0 || curbyte + (l = b.ByteToInt32(bytes[curbyte - 1])) >= bytes.length) continue;
                            byte[] str = new byte[l];
                            for (int i2 = 0; i2 < l; ++i2) {
                                str[i2] = b.not(bytes[curbyte + i2 + 1]);
                            }
                            if (!e.isGoodString(str)) continue;
                            m.msg("Found unknown reference:", b.BytesToString(str));
                        }
                    }
                }
                if (object == null) {
                    handled = false;
                }
                if (handled) {
                    objects.add(object);
                    int shortby = offset + size - stream.in.getAbsoluteOffset();
                    if (shortby != 0 && desc.objecttype != Typeid.plHKPhysical) {
                        m.msg("Prp: Object was not the expected size. It was off by:", Integer.toString(shortby) + " type=" + desc.objecttype.toString());
                    }
                }
                stream.close();
            }
        }
        result.objects2 = objects;
        result._markScenenodeSceneobjects();
        m.msg("Process All was successful!");
        return result;
    }

    public static void DumpObjects(byte[] data, Typeid typetodump, String outfolder) {
        context c = context.createFromBytestream(new Bytestream(data));
        PrpHeader header = new PrpHeader(c);
        context c2 = c.Fork(header.offsetToObjectIndex);
        PrpObjectIndex objectindex = new PrpObjectIndex(c2);
        c2.close();
        int numobjecttypes = objectindex.indexCount;
        for (int i = 0; i < numobjecttypes; ++i) {
            Typeid type = objectindex.types[i].type;
            int numObjects = objectindex.types[i].objectcount;
            for (int j = 0; j < numObjects; ++j) {
                Uruobjectdesc desc = objectindex.types[i].descs[j].desc;
                int offset = objectindex.types[i].descs[j].offset;
                int size = objectindex.types[i].descs[j].size;
                if (typetodump != null && desc.objecttype != typetodump) continue;
                IBytestream bs = c.in.Fork(offset);
                byte[] bytes = bs.readBytes(size);
                FileUtils.WriteFile(outfolder + "/" + desc.toString() + ".dat", bytes);
            }
        }
    }

    public static void ReportCrossLinks(byte[] data, String outfolder) {
        context c = context.createFromBytestream(new Bytestream(data));
        _staticsettings.reportReferences = true;
        _staticsettings.tryToFindReferencesInUnknownObjects = true;
        prputils.ProcessAllMoul(c, false, mystAutomation.moulReadable);
        String report = "howfound;fromname;fromtype;fromnumber;toname;totype;tonumber;topageid\n" + _staticsettings.referenceReport.toString() + _staticsettings.scannedReferenceReport.toString();
        FileUtils.WriteFile(outfolder + "/crosslinkreport.csv", report.getBytes());
    }

    public static void ReportDeep(byte[] data, String outfolder) {
        context c = context.createFromBytestream(new Bytestream(data));
        prpfile prp = prpprocess.ProcessAllObjects(c, false);
        reflection.reflectionReportToFile(prp, outfolder);
    }

    public static void findAllObjectsOfType(String prpdir, Typeid type) {
        class Callback
        implements allprpfiles.RootobjCallbackInterface {
            Typeid type;

            public Callback(Typeid type2) {
                this.type = type2;
            }

            @Override
            public void handleRootobj(prpfile prp, PrpObjectIndex.ObjectindexObjecttypeObjectdesc obj) {
                if (obj.desc.objecttype == this.type) {
                    boolean bl = false;
                }
            }
        }
        allprpfiles.parseAllRootobjs(new Callback(type), prpdir);
    }

    public static void FindDrawInterfacesThatUseLayerAnimations(byte[] data) {
        StringBuilder report = new StringBuilder();
        context c = context.createFromBytestream(new Bytestream(data));
        prpfile prp = prputils.ProcessAllMoul(c, false, mystAutomation.moulReadable);
        for (int i = 0; i < prp.objects2.size(); ++i) {
            PrpRootObject curobj = prp.objects2.get(i);
            if (curobj.header.desc.objecttype != Typeid.plDrawInterface) continue;
            plDrawInterface di = (plDrawInterface)curobj.prpobject.object;
            for (int j = 0; j < di.subsetgroupcount; ++j) {
                int subsetgroup = di.subsetgroups[j].subsetgroupindex;
                if (subsetgroup == -1) continue;
                Uruobjectdesc spandesc = di.subsetgroups[j].span.xdesc;
                plDrawableSpans span = (plDrawableSpans)prp.findObjectWithDesc(spandesc).castTo();
                int numsubsets = span.DIIndices[subsetgroup].indicesCount;
                for (int k = 0; k < numsubsets; ++k) {
                    int subset = span.DIIndices[subsetgroup].indices[k];
                    if (subset >= span.icicles.length) {
                        m.warn("Subset is not present.");
                        continue;
                    }
                    int material = span.icicles[subset].parent.parent.materialindex;
                    Uruobjectdesc matdesc = span.materials.get((int)material).xdesc;
                    if (matdesc.objectname.toString().toLowerCase().startsWith("crater")) {
                        boolean bl = false;
                    }
                    x0007Material mat = (x0007Material)prp.findObjectWithDesc(matdesc).castTo();
                    for (Uruobjectref layerref : mat.layerrefs) {
                        Typeid mattype = layerref.xdesc.objecttype;
                        if (mattype != Typeid.plLayerAnimation) continue;
                        report.append("LayerAnimation found in: " + curobj.header.toString() + "\n");
                    }
                }
            }
        }
    }

    public static PrpRootObject[] FindAllObjectsOfType(prpfile prp, Typeid type) {
        Vector<PrpRootObject> result = new Vector<PrpRootObject>();
        int numobjs = prp.objects2.size();
        for (int i = 0; i < numobjs; ++i) {
            PrpRootObject curobj = prp.objects2.get(i);
            if (curobj == null || curobj.header.desc.objecttype != type) continue;
            result.add(curobj);
        }
        PrpRootObject[] result2 = new PrpRootObject[]{};
        result2 = result.toArray(result2);
        return result2;
    }

    public static PrpRootObject[] FindAllObjectsWithName(prpfile prp, String name) {
        Vector<PrpRootObject> result = new Vector<PrpRootObject>();
        String name2 = name.toLowerCase();
        int numobjs = prp.objects2.size();
        for (int i = 0; i < numobjs; ++i) {
            PrpRootObject curobj = prp.objects2.get(i);
            if (curobj == null || !curobj.header.desc.objectname.toString().toLowerCase().equals(name2)) continue;
            result.add(curobj);
        }
        PrpRootObject[] result2 = new PrpRootObject[]{};
        result2 = result.toArray(result2);
        return result2;
    }

    public static class Compiler {
        public static Decider getDefaultDecider() {
            return new Decider(){

                @Override
                public boolean isObjectToBeIncluded(Uruobjectdesc desc) {
                    return true;
                }
            };
        }

        public static void RecompilePrp(byte[] data, Decider decider, String outfolder) {
            context c = context.createFromBytestream(new Bytestream(data));
            prpfile prp = prpfile.createFromContext(c, mystAutomation.moulReadable);
            Bytedeque fullbyte = Compiler.RecompilePrp(prp, decider);
            String filename = prp.header.agename.toString() + "_District_" + prp.header.pagename.toString() + ".prp";
            fullbyte.writeAllBytesToFile(outfolder + "/" + filename);
        }

        public static Bytedeque RecompilePrp(prpfile prp, Decider decider) {
            int headersize;
            Bytedeque headerdeque = new Bytedeque(Format.pots);
            Bytedeque oideque = new Bytedeque(Format.pots);
            PrpHeader header = prp.header;
            headerdeque.writeInt(5);
            header.pageid.compile(headerdeque);
            header.pagetype.compile(headerdeque);
            prp.header.agename.compile(headerdeque);
            byte[] districtbytes = new byte[]{68, 105, 115, 116, 114, 105, 99, 116};
            Urustring district = new Urustring(districtbytes);
            district.compile(headerdeque);
            prp.header.pagename.compile(headerdeque);
            headerdeque.writeShort((short)63);
            headerdeque.writeShort((short)12);
            headerdeque.writeInt(0);
            headerdeque.writeInt(8);
            Vector<byte[]> compiledObjects = new Vector<byte[]>();
            Vector<PrpRootObject> uncompiledObjects = new Vector<PrpRootObject>();
            boolean haveEncounteredSceneNode = false;
            int numobjs = prp.objects2.size();
            for (int i = 0; i < numobjs; ++i) {
                PrpRootObject curobj = prp.objects2.get(i);
                if (curobj.tagDeleted) {
                    m.msg("Skipping RootObject tagged as deleted.");
                    continue;
                }
                Typeid type = curobj.header.desc.objecttype;
                if (!decider.isObjectToBeIncluded(curobj.header.desc)) {
                    if (type != Typeid.plSceneNode) continue;
                }
                uncompiledObjects.add(curobj);
                Bytedeque deque = new Bytedeque(Format.pots);
                deque.curRootObject = curobj.header.desc;
                deque.prp = prp;
                if (type == Typeid.plSceneNode) {
                    e.ensure(!haveEncounteredSceneNode);
                    haveEncounteredSceneNode = true;
                    curobj.header.compile(deque);
                    curobj.castTo(x0000Scenenode.class).compileSpecial(deque, prp.objects2, decider);
                } else {
                    curobj.header.compile(deque);
                    curobj.compile(deque);
                }
                byte[] dequedata = deque.getAllBytes();
                compiledObjects.add(dequedata);
            }
            int sizeOfAllObjects = 0;
            int numObjects = uncompiledObjects.size();
            e.ensure(numObjects == compiledObjects.size());
            Typeid lasttype = Typeid.nil;
            int numTypes = 0;
            HashMap<Typeid, Integer> typeInfo = new HashMap<Typeid, Integer>();
            for (int i3 = 0; i3 < numObjects; ++i3) {
                sizeOfAllObjects += ((byte[])compiledObjects.get(i3)).length;
                PrpRootObject curobj = (PrpRootObject)uncompiledObjects.get(i3);
                if (curobj.header.objecttype != lasttype) {
                    lasttype = curobj.header.objecttype;
                    ++numTypes;
                    e.ensure(!typeInfo.containsKey(lasttype));
                    typeInfo.put(lasttype, 1);
                    continue;
                }
                int oldcount = (Integer)typeInfo.get(lasttype);
                typeInfo.put(lasttype, oldcount + 1);
            }
            int offset = headersize = headerdeque.getAllBytes().length + 12;
            Typeid lasttype2 = Typeid.nil;
            oideque.writeInt(numTypes);
            for (int i = 0; i < numObjects; ++i) {
                PrpRootObject curobj = (PrpRootObject)uncompiledObjects.get(i);
                if (curobj.header.objecttype != lasttype2) {
                    lasttype2 = curobj.header.objecttype;
                    lasttype2.compile(oideque);
                    int objcount = (Integer)typeInfo.get(lasttype2);
                    oideque.writeInt(objcount);
                }
                curobj.header.desc.compile(oideque);
                oideque.writeInt(offset);
                int objectsize = ((byte[])compiledObjects.get(i)).length;
                oideque.writeInt(objectsize);
                offset += objectsize;
            }
            int filedatasize = sizeOfAllObjects + oideque.getAllBytes().length;
            int firstoffset = headersize;
            int indexoffset = headersize + sizeOfAllObjects;
            headerdeque.writeInt(filedatasize);
            headerdeque.writeInt(firstoffset);
            headerdeque.writeInt(indexoffset);
            Bytedeque fulldeque = new Bytedeque(Format.pots);
            fulldeque.writeBytedeque(headerdeque);
            for (int i = 0; i < numObjects; ++i) {
                fulldeque.writeBytes((byte[])compiledObjects.get(i));
            }
            fulldeque.writeBytedeque(oideque);
            m.msg("Recompilated completed!");
            return fulldeque;
        }

        public static void fixMaterial(prpfile prp) {
            int i;
            int numobjs = prp.objects2.size();
            Uruobjectdesc stableMaterial = null;
            Vector<Uruobjectref> badMaterials = new Vector<Uruobjectref>();
            for (i = 0; i < numobjs; ++i) {
                if (prp.objects2.get((int)i).header.desc.objecttype != Typeid.plDrawableSpans) continue;
                plDrawableSpans curDrawableSpan = (plDrawableSpans)prp.objects2.get((int)i).prpobject.object;
                int numMaterials = curDrawableSpan.materialsCount;
                for (int j = 0; j < numMaterials; ++j) {
                    Uruobjectref materialRef = curDrawableSpan.materials.get(j);
                    if (materialRef.hasRef == 0) continue;
                    PrpRootObject curMaterial1 = prp.findObjectWithDesc(materialRef.xdesc);
                    if (curMaterial1 != null) {
                        x0007Material curMaterial = (x0007Material)curMaterial1.prpobject.object;
                        boolean badmaterial = false;
                        for (Uruobjectref layerref : curMaterial.layerrefs) {
                            Typeid layerType = layerref.xdesc.objecttype;
                            if (layerType != Typeid.plLayerAnimation) continue;
                            badMaterials.add(curDrawableSpan.materials.get(j));
                            badmaterial = true;
                        }
                        if (badmaterial || stableMaterial != null) continue;
                        stableMaterial = curDrawableSpan.materials.get((int)j).xdesc;
                        continue;
                    }
                    m.warn("Material is not present in this page. I don't know if it uses a plLayerAnimation.");
                }
            }
            if (badMaterials.size() != 0 && stableMaterial == null) {
                m.err("Unable to find *any* stable materials.");
            } else {
                for (i = 0; i < badMaterials.size(); ++i) {
                    ((Uruobjectref)badMaterials.get((int)i)).xdesc = stableMaterial;
                }
            }
        }

        public static interface Decider {
            public boolean isObjectToBeIncluded(Uruobjectdesc var1);
        }
    }
}

