/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import images.Image;
import java.util.Vector;
import prpobjects.uruobj;
import prpobjects.x0003Bitmap;
import shared.Format;
import shared.IBytestream;
import shared.e;
import shared.m;
import shared.readexception;
import uru.Bytedeque;
import uru.context;
import uru.generics;

public class x0004MipMap
extends uruobj {
    public boolean resetmemorysize = false;
    public x0003Bitmap parent;
    public int texwidth;
    public int texheight;
    public int stride;
    public int memorysize;
    public byte xtype;
    public int[] xu2;
    public int xjpgsize1;
    public byte[] xjpegfile1;
    public Integer[] xextra1;
    public Integer[] xextra2;
    public int xjpgsize2;
    public byte[] xjpegfile2;
    public byte xmipmaplevels;
    public byte[][] xagrb;
    public Image.Dxt xDxt;

    public void invert() {
        switch (this.parent.type) {
            case 0: {
                m.err("Image convert not implemented.");
                break;
            }
            case 1: {
                this.xDxt.invert();
                break;
            }
            case 2: {
                m.err("Image convert not implemented.");
                break;
            }
            default: {
                m.err("PlMipMap: invert: unexpected type.");
            }
        }
    }

    public void rotate90clockwise() {
        switch (this.parent.type) {
            case 0: {
                m.err("Image rotate not implemented.");
                break;
            }
            case 1: {
                this.xDxt.rotate90clockwise();
                break;
            }
            case 2: {
                m.err("Image rotate not implemented.");
                break;
            }
            default: {
                m.err("PlMipMap: invert: unexpected type.");
            }
        }
    }

    private x0004MipMap() {
    }

    public x0004MipMap(context c) throws readexception {
        IBytestream data = c.in;
        this.parent = new x0003Bitmap(c);
        this.texwidth = data.readInt();
        this.texheight = data.readInt();
        this.stride = data.readInt();
        e.ensure(this.stride == this.texwidth * 4);
        this.memorysize = data.readInt();
        this.xmipmaplevels = data.readByte();
        switch (this.parent.type) {
            case 0: {
                this.xagrb = new byte[this.xmipmaplevels][];
                for (int i = 0; i < this.xmipmaplevels; ++i) {
                    int levelsize = (this.texwidth >>> i) * (this.texheight >>> i);
                    this.xagrb[i] = data.readBytes(levelsize * 4);
                }
                break;
            }
            case 1: {
                this.xDxt = new Image.Dxt(data, this.xmipmaplevels, this.texwidth, this.texheight, this.parent.xtexel_size);
                break;
            }
            case 2: {
                int i2;
                int i1;
                this.xtype = data.readByte();
                if ((this.xtype & 1) == 0) {
                    this.xjpgsize1 = data.readInt();
                    this.xjpegfile1 = data.readBytes(this.xjpgsize1);
                } else {
                    Vector<Integer> xextra1temp = new Vector<Integer>();
                    do {
                        i1 = data.readInt();
                        i2 = data.readInt();
                        xextra1temp.add(i1);
                        xextra1temp.add(i2);
                    } while (i1 != 0);
                    this.xextra1 = (Integer[])generics.convertVectorToArray(xextra1temp, Integer.class);
                }
                if ((this.xtype & 2) == 0) {
                    this.xjpgsize2 = data.readInt();
                    this.xjpegfile2 = data.readBytes(this.xjpgsize2);
                    break;
                }
                Vector<Integer> xextra2temp = new Vector<Integer>();
                do {
                    i1 = data.readInt();
                    i2 = data.readInt();
                    xextra2temp.add(i1);
                    xextra2temp.add(i2);
                } while (i1 != 0);
                this.xextra2 = (Integer[])generics.convertVectorToArray(xextra2temp, Integer.class);
                break;
            }
            default: {
                m.msg("x0004mipmap: mystery!");
            }
        }
    }

    @Override
    public void compile(Bytedeque deque) {
        Bytedeque subdeque = new Bytedeque(Format.pots);
        switch (this.parent.type) {
            case 0: {
                int i;
                for (i = 0; i < this.xmipmaplevels; ++i) {
                    int levelsize = (this.texwidth >>> i) * (this.texheight >>> i);
                    subdeque.writeBytes(this.xagrb[i]);
                }
                break;
            }
            case 1: {
                this.xDxt.compile(subdeque);
                break;
            }
            case 2: {
                int i;
                subdeque.writeByte(this.xtype);
                if ((this.xtype & 1) == 0) {
                    subdeque.writeInt(this.xjpgsize1);
                    subdeque.writeBytes(this.xjpegfile1);
                } else {
                    for (i = 0; i < this.xextra1.length; ++i) {
                        subdeque.writeInt(this.xextra1[i]);
                    }
                }
                if ((this.xtype & 2) == 0) {
                    subdeque.writeInt(this.xjpgsize2);
                    subdeque.writeBytes(this.xjpegfile2);
                    break;
                }
                for (i = 0; i < this.xextra2.length; ++i) {
                    subdeque.writeInt(this.xextra2[i]);
                }
                break;
            }
            default: {
                m.msg("x0004mipmap: mystery!");
            }
        }
        byte[] subdequebytes = subdeque.getAllBytes();
        this.parent.compile(deque);
        deque.writeInt(this.texwidth);
        deque.writeInt(this.texheight);
        deque.writeInt(this.stride);
        if (this.resetmemorysize) {
            this.memorysize = subdequebytes.length;
        }
        deque.writeInt(this.memorysize);
        deque.writeByte(this.xmipmaplevels);
        deque.writeBytes(subdequebytes);
    }

    public static x0004MipMap createEmpty() {
        x0004MipMap r = new x0004MipMap();
        r.parent = x0003Bitmap.createEmpty();
        return r;
    }
}

