/*
 * Decompiled with CFR 0.152.
 */
package pythondec;

import java.io.ByteArrayOutputStream;
import java.util.Vector;
import pythondec.Disassemble;
import pythondec.PyCode;
import pythondec.PyInt;
import pythondec.PyNone;
import pythondec.PyObject;
import pythondec.PyString;
import pythondec.PyTuple;
import pythondec.op;
import shared.m;
import shared.uncaughtexception;

public class PyCode_Builder {
    private Vector<Disassemble.OpInfo> ops = new Vector();
    private Vector<PyObject> consts = new Vector();
    private Vector<PyObject> names = new Vector();

    private void addop(Disassemble.OpInfo o) {
        this.ops.add(o);
    }

    private int addconst(PyObject obj) {
        int cursize = this.consts.size();
        for (int i = 0; i < cursize; ++i) {
            PyObject curobj = this.consts.get(i);
            if (!curobj.equals(obj)) continue;
            return i;
        }
        this.consts.add(obj);
        return cursize;
    }

    private int addname(PyString obj) {
        int cursize = this.names.size();
        for (int i = 0; i < cursize; ++i) {
            PyObject curobj = this.names.get(i);
            if (!curobj.equals(obj)) continue;
            return i;
        }
        this.names.add(obj);
        return cursize;
    }

    public void addop(op o) {
        Disassemble.OpInfo oi = Disassemble.OpInfo.create(o);
        this.addop(oi);
    }

    public void addopWithArg(op o, int arg) {
        Disassemble.OpInfo oi = Disassemble.OpInfo.create(o, arg);
        this.addop(oi);
    }

    public void addopWithConst(op o, Object constObj) {
        PyObject co;
        if (constObj == null) {
            co = PyNone.create();
        } else if (constObj instanceof Integer) {
            co = PyInt.create((Integer)constObj);
        } else {
            throw new uncaughtexception("unhandled.");
        }
        int pos = this.addconst(co);
        this.addopWithArg(o, pos);
    }

    public void addopWithName(op o, String name) {
        PyString n2 = PyString.create(name);
        int pos = this.addname(n2);
        this.addopWithArg(o, pos);
    }

    public PyCode getPyCode() {
        PyCode r = new PyCode();
        r.argcount = 0;
        r.nlocals = 0;
        r.stacksize = 0;
        r.flags = 0;
        r.code = this.compileCode();
        r.consts = PyTuple.create(this.consts);
        r.varnames = r.names = PyTuple.create(this.names);
        r.freevars = PyTuple.create(new Vector<PyObject>());
        r.cellvars = PyTuple.create(new Vector<PyObject>());
        r.filename = PyString.create("<unknown filename>");
        r.name = PyString.create("?");
        r.firstlineno = 1;
        r.lnotab = PyString.create("");
        return r;
    }

    private PyString compileCode() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (Disassemble.OpInfo oi : this.ops) {
            if (oi.o.hasExtendedArgument()) {
                m.throwUncaughtException("unhandled.");
            }
            os.write(oi.o.getbytecode());
            if (!oi.o.hasArgument()) continue;
            os.write(oi.i0);
            os.write(oi.i1);
        }
        byte[] bytecodedata = os.toByteArray();
        PyString r = PyString.create(bytecodedata);
        return r;
    }
}

