/*
 * Decompiled with CFR 0.152.
 */
package pythondec3.ast;

import java.util.ArrayList;
import pythondec.PyCode;
import pythondec.PyNone;
import pythondec.PyString;
import pythondec.op;
import pythondec3.ast.Ast;
import pythondec3.ast.IList;
import pythondec3.ast.List;
import pythondec3.ast.Stmt;
import pythondec3.ast.StmtAssign;
import pythondec3.ast.StmtReturn;
import pythondec3.ast.Tok;
import pythondec3.ast.sgen;
import shared.m;
import shared.uncaughtexception;

public class Expr
extends Ast {
    public boolean isNoneConst() {
        return false;
    }

    public String toString() {
        return this.getGenString();
    }

    public static class Callfunction
    extends Expr {
        Ast expr;
        ArrayList<Ast> positionals = new ArrayList();
        ArrayList<Ast> keywords = new ArrayList();
        Ast var;
        Ast kw;

        public Callfunction(Ast expr, Ast[] positional, Ast[] keyword, Ast var, Ast kw) {
            this.expr = expr;
            for (Ast pos : positional) {
                this.positionals.add(pos);
            }
            for (Ast key : keyword) {
                this.keywords.add(key);
            }
            this.var = var;
            this.kw = kw;
        }

        public Callfunction(Ast var, Ast kw) {
            this.var = var;
            this.kw = kw;
        }

        public Ast setName(Ast expr) {
            this.expr = expr;
            return this;
        }

        public Ast addKwarg(Ast kwarg) {
            this.keywords.add(kwarg);
            return this;
        }

        public Ast addPoarg(Ast poarg) {
            this.positionals.add(poarg);
            return this;
        }

        @Override
        public void gen2(sgen s) {
            int i;
            String funcname = this.expr.getGenString();
            s.out(funcname);
            s.out("(");
            int numarg = 0;
            String comma = ", ";
            for (i = 0; i < this.positionals.size(); ++i) {
                Ast positional = this.positionals.get(this.positionals.size() - i - 1);
                if (numarg != 0) {
                    s.out(", ");
                }
                positional.gen(s);
                ++numarg;
            }
            for (i = 0; i < this.keywords.size(); ++i) {
                Ast keyword = this.keywords.get(this.keywords.size() - i - 1);
                if (numarg != 0) {
                    s.out(", ");
                }
                keyword.gen(s);
                ++numarg;
            }
            if (this.var != null) {
                if (numarg != 0) {
                    s.out(", ");
                }
                s.out("*");
                this.var.gen(s);
                ++numarg;
            }
            if (this.kw != null) {
                if (numarg != 0) {
                    s.out(",");
                }
                s.out("**");
                this.kw.gen(s);
                ++numarg;
            }
            s.out(")");
        }
    }

    public static class Makefunction
    extends Expr
    implements IList {
        Tok loadconsttoken;
        List exprs = new List();

        public List getlist() {
            return this.exprs;
        }

        public Makefunction(Tok loadconst) {
            this.hasparens = true;
            this.loadconsttoken = loadconst;
        }

        public boolean endsWithReturnNone() {
            PyCode code = (PyCode)this.loadconsttoken.oi.pattr;
            Stmt stmt = (Stmt)code.root.get(code.root.size() - 1);
            if (stmt instanceof StmtReturn) {
                StmtReturn ret = (StmtReturn)stmt;
                if (ret.returnvalue.isNoneConst()) {
                    return true;
                }
            }
            return false;
        }

        public void genAsClass(sgen s, String name) {
            Stmt laststmt;
            Stmt stmt;
            PyCode code = (PyCode)this.loadconsttoken.oi.pattr;
            code.debugname = name;
            if (code.root.size() > 0 && (stmt = (Stmt)code.root.get(0)) instanceof StmtAssign) {
                StmtAssign stmt2 = (StmtAssign)stmt;
                if (stmt2.destinations.getGenString().equals("__module__") && stmt2.value.getGenString().equals("__name__")) {
                    code.root.remove(stmt);
                }
            }
            if (code.root.size() > 0 && (laststmt = (Stmt)code.root.get(code.root.size() - 1)) instanceof StmtReturn) {
                StmtReturn laststmt2 = (StmtReturn)laststmt;
                if (laststmt2.returnvalue instanceof Loadlocals) {
                    code.root.remove(laststmt);
                }
            }
            code.root.gen(s);
        }

        public void genArgumentList(sgen s, PyCode code) {
            int numNonDefaults = code.argcount - this.exprs.size();
            int curarg = 0;
            for (int i = 0; i < code.argcount; ++i) {
                PyString varname2;
                String varname;
                if (curarg != 0) {
                    s.out(", ");
                }
                if ((varname = (varname2 = (PyString)code.varnames.items[i]).toJavaString()).startsWith(".")) {
                    Makefunction.handleAnonTuple(s, code, varname);
                } else {
                    s.out(varname);
                }
                if (curarg >= numNonDefaults) {
                    int curDefaultArg = curarg - numNonDefaults;
                    Object defaultval = this.exprs.get(this.exprs.size() - curDefaultArg - 1);
                    s.out(" = ");
                    ((Ast)defaultval).gen(s);
                }
                ++curarg;
            }
            if (code.flag_varargs) {
                if (curarg != 0) {
                    s.out(", ");
                }
                s.out("*");
                PyString varargsname = (PyString)code.varnames.items[curarg];
                s.out(varargsname.toJavaString());
                ++curarg;
            }
            if (code.flag_varkeywords) {
                if (curarg != 0) {
                    s.out(", ");
                }
                s.out("**");
                PyString varargsname = (PyString)code.varnames.items[curarg];
                s.out(varargsname.toJavaString());
                ++curarg;
            }
        }

        public void genAsFunction(sgen s, String debugname) {
            Stmt laststmt;
            PyCode code = (PyCode)this.loadconsttoken.oi.pattr;
            code.debugname = debugname;
            int numNonDefaults = code.argcount - this.exprs.size();
            s.out("(");
            this.genArgumentList(s, code);
            s.out("):");
            s.endline();
            s.increaseindentation();
            for (String global : code.globals) {
                s.indent();
                s.out("global ");
                s.out(global);
                s.endline();
            }
            if (code.root.size() > 0 && (laststmt = (Stmt)code.root.get(code.root.size() - 1)) instanceof StmtReturn) {
                StmtReturn laststmt2 = (StmtReturn)laststmt;
                if (laststmt2.returnvalue.isNoneConst()) {
                    code.root.remove(laststmt);
                }
            }
            code.root.gen(s);
            s.decreaseindentation();
        }

        public void genAsExpr(sgen s, String name) {
            PyCode code = (PyCode)this.loadconsttoken.oi.pattr;
            code.debugname = name;
            Object retstmt = code.root.get(code.root.size() - 1);
            if (!(retstmt instanceof StmtReturn)) {
                m.throwUncaughtException("unhandled");
            }
            StmtReturn ret = (StmtReturn)retstmt;
            s.out("(");
            s.out("lambda ");
            this.genArgumentList(s, code);
            s.out(": ");
            ret.returnvalue.gen(s);
            s.out(")");
            if (code.root.size() != 1) {
                m.throwUncaughtException("unhandled");
            }
        }

        public static void handleAnonTuple(sgen s, PyCode code, String varname) {
            int curseq = 0;
            Object ast = code.root.get(curseq);
            while (ast instanceof StmtAssign) {
                StmtAssign asgn = (StmtAssign)ast;
                String name = asgn.value.getGenString();
                if (name.equals(varname)) {
                    if (asgn.destinations.size() != 1) {
                        m.throwUncaughtException("unhandled");
                    }
                    asgn.destinations.gen(s);
                    code.root.remove(asgn);
                    curseq = -1;
                    break;
                }
                ast = code.root.get(++curseq);
            }
            if (curseq != -1) {
                m.throwUncaughtException("unhandled");
            }
        }

        @Override
        public void gen2(sgen s) {
            this.genAsExpr(s, "lambda");
        }
    }

    public static class Buildtuple
    extends Expr
    implements IList {
        List exprs = new List();

        public Buildtuple(Ast ... newexprs) {
            for (Ast expr : newexprs) {
                this.exprs.add(expr);
            }
        }

        public List getlist() {
            return this.exprs;
        }

        @Override
        public void gen2(sgen s) {
            s.out("(");
            this.gen2NoParentheses(s);
            s.out(")");
        }

        public void gen2NoParentheses(sgen s) {
            for (int i = 0; i < this.exprs.size(); ++i) {
                Object expr = this.exprs.get(this.exprs.size() - i - 1);
                if (i != 0) {
                    s.out(", ");
                }
                ((Ast)expr).gen(s);
            }
            if (this.exprs.size() == 1) {
                s.out(",");
            }
        }
    }

    public static class Buildlist
    extends Expr
    implements IList {
        List exprs = new List();

        public Buildlist(Ast ... items) {
            for (Ast item : items) {
                this.exprs.add(item);
            }
        }

        public List getlist() {
            return this.exprs;
        }

        @Override
        public void gen2(sgen s) {
            s.out("[");
            for (int i = 0; i < this.exprs.size(); ++i) {
                Object expr = this.exprs.get(this.exprs.size() - i - 1);
                if (i != 0) {
                    s.out(", ");
                }
                ((Ast)expr).gen(s);
            }
            s.out("]");
        }
    }

    public static class Binarysubscript
    extends Expr {
        Ast expr1;
        Ast expr2;

        public Binarysubscript(Ast expr1, Ast expr2) {
            this.expr1 = expr1;
            this.expr2 = expr2;
        }

        @Override
        public void gen2(sgen s) {
            this.expr1.gen(s);
            s.out("[");
            if (this.expr2 instanceof Buildtuple) {
                Buildtuple bt2 = (Buildtuple)this.expr2;
                bt2.gen2NoParentheses(s);
            } else {
                this.expr2.gen(s);
            }
            s.out("]");
        }
    }

    public static class Binary
    extends Expr {
        Expr left;
        Expr right;
        Tok binop_token;

        public Binary(Ast left, Ast right, Ast binop_token) {
            this.left = (Expr)left;
            this.right = (Expr)right;
            this.binop_token = (Tok)binop_token;
        }

        @Override
        public void gen2(sgen s) {
            boolean parens = this.binop_token.oi.o == op.BINARY_POWER;
            s.out("(");
            if (parens) {
                this.left.genWithParentheses(s);
            } else {
                this.left.gen(s);
            }
            s.out(" ");
            String opstr = this.getOpStr();
            s.out(opstr);
            s.out(" ");
            if (parens) {
                this.right.genWithParentheses(s);
            } else {
                this.right.gen(s);
            }
            s.out(")");
        }

        public String getOpStr() {
            switch (this.binop_token.oi.o) {
                case BINARY_ADD: {
                    return "+";
                }
                case BINARY_SUBTRACT: {
                    return "-";
                }
                case BINARY_MULTIPLY: {
                    return "*";
                }
                case BINARY_DIVIDE: {
                    return "/";
                }
                case BINARY_TRUE_DIVIDE: {
                    return "/";
                }
                case BINARY_FLOOR_DIVIDE: {
                    return "//";
                }
                case BINARY_MODULO: {
                    return "%";
                }
                case BINARY_LSHIFT: {
                    return "<<";
                }
                case BINARY_RSHIFT: {
                    return ">>";
                }
                case BINARY_AND: {
                    return "&";
                }
                case BINARY_OR: {
                    return "|";
                }
                case BINARY_XOR: {
                    return "^";
                }
                case BINARY_POWER: {
                    return "**";
                }
            }
            throw new uncaughtexception("unexpected token.");
        }
    }

    public static class Unary
    extends Expr {
        Ast expr;
        Tok unop_token;

        public Unary(Ast expr, Tok unop_token) {
            this.expr = expr;
            this.unop_token = unop_token;
        }

        @Override
        public void gen2(sgen s) {
            s.out("(");
            String opstr = this.getOpStr();
            s.out(opstr);
            this.expr.genWithParentheses(s);
            String opstrr = this.getOpStrRight();
            s.out(opstrr);
            s.out(")");
        }

        public String getOpStr() {
            switch (this.unop_token.oi.o) {
                case UNARY_NOT: {
                    return "not ";
                }
                case UNARY_CONVERT: {
                    return "`";
                }
                case UNARY_NEGATIVE: {
                    return "-";
                }
                case UNARY_INVERT: {
                    return "~";
                }
                case UNARY_POSITIVE: {
                    return "+";
                }
            }
            throw new uncaughtexception("unhandled");
        }

        public String getOpStrRight() {
            switch (this.unop_token.oi.o) {
                case UNARY_CONVERT: {
                    return "`";
                }
            }
            return "";
        }
    }

    public static class Loadlocals
    extends Expr {
        Tok token;

        public Loadlocals(Tok token) {
            this.token = token;
        }

        @Override
        public void gen2(sgen s) {
        }
    }

    public static class Name
    extends Expr {
        Tok token;

        public Name(Tok token) {
            this.token = token;
        }

        @Override
        public void gen2(sgen s) {
            String name = this.token.getName(s);
            s.out(name);
        }
    }

    public static class Loadglobal
    extends Expr {
        Tok token;

        public Loadglobal(Tok token) {
            this.token = token;
        }

        @Override
        public void gen2(sgen s) {
            String name = this.token.getName(s);
            s.out(name);
        }
    }

    public static class Loadconst
    extends Expr {
        Tok token;

        public Loadconst(Ast token) {
            this.token = (Tok)token;
        }

        @Override
        public void gen2(sgen s) {
            String varname = this.token.getNameQuoted(s);
            s.out(varname);
        }

        @Override
        public boolean isNoneConst() {
            Tok t = this.token;
            return t.oi.pattr instanceof PyNone;
        }
    }

    public static class Loadattr
    extends Expr {
        Ast expr;
        Tok token;

        public Loadattr(Ast expr, Tok token) {
            this.expr = expr;
            this.token = token;
        }

        @Override
        public void gen2(sgen s) {
            if (this.expr.isNumericConst()) {
                this.expr.genWithParentheses(s);
            } else {
                this.expr.gen(s);
            }
            s.out(".");
            String name = this.token.getName(s);
            s.out(name);
        }
    }

    public static class Loadfast
    extends Expr {
        Tok token;

        public Loadfast(Tok token) {
            this.token = token;
        }

        @Override
        public void gen2(sgen s) {
            String name = this.token.getName(s);
            s.out(name);
        }
    }

    public static class Loadname
    extends Expr {
        Tok token;

        public Loadname(Tok token) {
            this.token = token;
        }

        @Override
        public void gen2(sgen s) {
            String varname = this.token.getName(s);
            s.out(varname);
        }
    }

    public static class Compare
    extends Expr {
        Ast expr1;
        Ast expr2;
        Tok compareop;

        public Compare(Ast expr1, Ast expr2, Tok compareop) {
            this.expr1 = expr1;
            this.expr2 = expr2;
            this.compareop = compareop;
        }

        @Override
        public void gen2(sgen s) {
            s.out("(");
            this.expr1.gen(s);
            String compstr = (String)this.compareop.oi.pattr;
            s.out(" " + compstr + " ");
            this.expr2.gen(s);
            s.out(")");
        }
    }

    public static class Dictionary
    extends Expr {
        List entries;

        public Dictionary(Ast entries) {
            this.entries = (List)entries;
        }

        @Override
        public void gen2(sgen s) {
            s.out("{");
            for (int i = 0; i < this.entries.size(); ++i) {
                if (i != 0) {
                    s.out(", ");
                }
                ((Ast)this.entries.get(i)).gen(s);
            }
            s.out("}");
        }

        public static class Entry
        extends Ast {
            Ast left;
            Ast right;

            public Entry(Ast right, Ast left) {
                this.left = left;
                this.right = right;
            }

            @Override
            public void gen2(sgen s) {
                this.left.gen(s);
                s.out(": ");
                this.right.gen(s);
            }
        }
    }

    public static class ShortcircuitOr
    extends Expr {
        Ast expr1;
        Ast expr2;

        public ShortcircuitOr(Ast expr1, Ast expr2) {
            this.expr1 = expr1;
            this.expr2 = expr2;
        }

        @Override
        public void gen2(sgen s) {
            s.out("(");
            this.expr1.gen(s);
            s.out(" or ");
            this.expr2.gen(s);
            s.out(")");
        }
    }

    public static class ShortcircuitAnd
    extends Expr {
        Ast expr1;
        Ast expr2;

        public ShortcircuitAnd(Ast expr1, Ast expr2) {
            this.expr1 = expr1;
            this.expr2 = expr2;
        }

        @Override
        public void gen2(sgen s) {
            s.out("(");
            if (this.expr1 == null) {
                s.out("1");
            } else {
                this.expr1.gen(s);
            }
            s.out(" and ");
            this.expr2.gen(s);
            s.out(")");
        }
    }

    public static class Slice
    extends Expr {
        Ast obj;
        Ast left;
        Ast right;

        public Slice(Ast obj, Ast left, Ast right) {
            this.obj = obj;
            this.left = left;
            this.right = right;
        }

        @Override
        public void gen2(sgen s) {
            this.obj.gen(s);
            s.out("[");
            if (this.left != null) {
                this.left.gen(s);
            }
            s.out(":");
            if (this.right != null) {
                this.right.gen(s);
            }
            s.out("]");
        }
    }

    public static class Complist
    extends Expr
    implements IList {
        List<Comp> comparisons = new List();

        public List getlist() {
            return this.comparisons;
        }

        @Override
        public void gen2(sgen s) {
            for (int i = 0; i < this.comparisons.size(); ++i) {
                Comp comp = this.comparisons.get(this.comparisons.size() - i - 1);
                if (i != 0) {
                    String cmpstr = (String)comp.compareop.oi.pattr;
                    s.out(" " + cmpstr + " ");
                }
                comp.expr.gen(s);
            }
        }

        public static class Comp
        extends Ast {
            Ast expr;
            Tok compareop;

            public Comp(Ast expr, Tok compareop) {
                this.expr = expr;
                this.compareop = compareop;
            }
        }
    }

    public static class Listfor
    extends Expr
    implements IList {
        List<Ast> iters = new List();
        Tok tok;
        Ast expr;
        Tok s1;
        Ast s2;
        Ast s3;

        public List getlist() {
            return this.iters;
        }

        public Listfor(Tok tok, Ast expr) {
            this.tok = tok;
            this.expr = expr;
        }

        @Override
        public void gen2(sgen s) {
            s.out("[ ");
            this.expr.gen(s);
            for (int i = 0; i < this.iters.size(); ++i) {
                Ast ast = this.iters.get(this.iters.size() - i - 1);
                ast.gen(s);
            }
            s.out(" ]");
        }

        public Ast setInfo(Tok s1, Ast s2, Ast s3) {
            this.s1 = s1;
            this.s2 = s2;
            this.s3 = s3;
            return this;
        }

        public static class For
        extends Ast {
            Ast expr;
            Ast looper;
            Ast desig;

            public For(Ast expr, Ast looper, Ast desig) {
                this.expr = expr;
                this.looper = looper;
                this.desig = desig;
            }

            @Override
            public void gen2(sgen s) {
                s.out(" for ");
                this.desig.gen(s);
                s.out(" in ");
                this.expr.gen(s);
            }
        }

        public static class If
        extends Ast {
            Ast expr;
            Ast ifcmd;

            public If(Ast expr, Ast ifcmd) {
                this.expr = expr;
                this.ifcmd = ifcmd;
            }

            @Override
            public void gen2(sgen s) {
                s.out(" if ");
                this.expr.gen(s);
            }
        }
    }

    public static class Buildslice
    extends Expr {
        Expr a1;
        Expr a2;
        Expr a3;

        public Buildslice(Ast a1, Ast a2, Ast a3) {
            this.a1 = (Expr)a1;
            this.a2 = (Expr)a2;
            this.a3 = (Expr)a3;
        }

        @Override
        public void gen2(sgen s) {
            if (this.a3 != null) {
                if (!this.a1.isNoneConst()) {
                    this.a1.gen(s);
                }
                s.out(":");
                if (!this.a2.isNoneConst()) {
                    this.a2.gen(s);
                }
                s.out(":");
                if (!this.a3.isNoneConst()) {
                    this.a3.gen(s);
                }
            } else {
                if (!this.a1.isNoneConst()) {
                    this.a1.gen(s);
                }
                s.out(":");
                if (!this.a2.isNoneConst()) {
                    this.a2.gen(s);
                }
            }
        }
    }
}

