/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import shared.FileUtils;
import shared.uncaughtexception;

public class zip {
    public static byte[] decompressZlib(byte[] input) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        return zip.decompressZlib(input, 0, input.length, out);
    }

    public static byte[] decompressZlib(byte[] input, int offset, int length, ByteArrayOutputStream out) {
        try {
            Inflater decomp = new Inflater();
            decomp.setInput(input, offset, length);
            byte[] buffer = new byte[1024];
            while (!decomp.finished()) {
                int num = decomp.inflate(buffer);
                out.write(buffer, 0, num);
            }
            out.close();
            byte[] result = out.toByteArray();
            return result;
        }
        catch (Exception e2) {
            throw new uncaughtexception("Exception during zip decompression.");
        }
    }

    public static byte[] decompressGzip(byte[] input) {
        try {
            int num;
            ByteArrayInputStream instr = new ByteArrayInputStream(input);
            GZIPInputStream ginstr = new GZIPInputStream(instr);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((num = ginstr.read(buffer)) > 0) {
                out.write(buffer, 0, num);
            }
            out.close();
            ginstr.close();
            instr.close();
            byte[] result = out.toByteArray();
            return result;
        }
        catch (Exception e2) {
            throw new uncaughtexception("Exception during gzip decompression.");
        }
    }

    public static byte[] compressGzip(byte[] input) {
        try {
            int len;
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(baout);
            ByteArrayInputStream in = new ByteArrayInputStream(input);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.finish();
            out.close();
            byte[] result = baout.toByteArray();
            return result;
        }
        catch (Exception e2) {
            throw new uncaughtexception("Exception during gzip compression.");
        }
    }

    public static Vector<String> getAllEntries(String zipfilename) {
        Vector<String> result = new Vector<String>();
        try {
            ZipFile zf = new ZipFile(zipfilename);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                String name = ze.getName();
                result.add(name);
            }
        }
        catch (Exception e2) {
            throw new uncaughtexception("Error while reading zipfile. " + e2.getMessage());
        }
        return result;
    }

    public static void extractZipFile(String zipfilename, File outputdir) {
        try {
            ZipFile zf = new ZipFile(zipfilename);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                int num;
                ZipEntry ze = entries.nextElement();
                String name = ze.getName();
                if (ze.isDirectory()) continue;
                File filename = new File(outputdir + "/" + name);
                filename.getParentFile().mkdirs();
                InputStream in = zf.getInputStream(ze);
                FileOutputStream out = new FileOutputStream(filename);
                byte[] buffer = new byte[1024];
                while ((num = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, num);
                }
                out.close();
                in.close();
            }
        }
        catch (Exception e2) {
            throw new uncaughtexception("Error while reading zipfile. " + e2.getMessage());
        }
    }

    public static void createZipFile(File inputfolder, File outputfile) {
        try {
            outputfile.getParentFile().mkdirs();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputfile));
            Vector<String> files = FileUtils.FindAllDecendants(inputfolder, true);
            for (String file : files) {
                int len;
                String fullpath = inputfolder + "/" + file;
                FileInputStream in = new FileInputStream(fullpath);
                ZipEntry ze = new ZipEntry(file);
                out.putNextEntry(ze);
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (Exception e2) {
            throw new uncaughtexception("Error while creating zipfile. " + e2.getMessage());
        }
    }
}

