/*
 * Decompiled with CFR 0.152.
 */
package uam;

import filesearcher.search;
import gui.Interactor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import shared.CryptHashes;
import shared.b;
import shared.m;
import shared.translation;
import shared.uncaughtexception;
import uam.ConfigErrorException;

public class UamConfigNew {
    static final boolean doValidate = false;
    Document doc;
    Element root;
    XPath xpath;
    public UamConfigData data;

    public UamConfigNew(InputStream in) {
        DocumentBuilder builder;
        DocumentBuilderFactory docfact = DocumentBuilderFactory.newInstance();
        docfact.setValidating(false);
        try {
            builder = docfact.newDocumentBuilder();
            builder.setErrorHandler(new xmlErrorHandler());
        }
        catch (ParserConfigurationException e2) {
            throw new ConfigErrorException("Error creating parser.");
        }
        try {
            this.doc = builder.parse(in);
        }
        catch (SAXException e3) {
            throw new ConfigErrorException("Error parsing config. (SAXException)  The XML is probably invalid.");
        }
        catch (IOException e4) {
            throw new ConfigErrorException("Error parsing config. (IOException)  The XML is probably invalid.");
        }
        this.root = this.doc.getDocumentElement();
        XPathFactory xpathfact = XPathFactory.newInstance();
        this.xpath = xpathfact.newXPath();
        this.data = new UamConfigData(this.root);
        if (!this.data.aequalsatransposeequalsainverse) {
            throw new ConfigErrorException("Config file doesn't seem to have the correct end; it's probably corrupt.");
        }
    }

    public UamConfigData.Age getAge(String agename) {
        return this.data.getAge(agename);
    }

    public Vector<UamConfigData.Age> getAllAges() {
        return this.data.ages;
    }

    public Vector<UamConfigData.Age.Version> getAllVersions(String age) {
        UamConfigData.Age ageobj = this.data.getAge(age);
        if (ageobj == null) {
            return new Vector<UamConfigData.Age.Version>();
        }
        return ageobj.versions;
    }

    public Vector<UamConfigData.Age.Version.Mirror> getAllMirrors(String age, String ver) {
        UamConfigData.Age ageobj = this.data.getAge(age);
        if (ageobj == null) {
            return new Vector<UamConfigData.Age.Version.Mirror>();
        }
        UamConfigData.Age.Version verobj = ageobj.getVersion(ver);
        if (verobj == null) {
            return new Vector<UamConfigData.Age.Version.Mirror>();
        }
        return verobj.mirrors;
    }

    public Vector<String> getDels(String agename) {
        return this.data.getAge((String)agename).dels;
    }

    public String getArchiveType(String agename, String version) {
        return this.data.getAge((String)agename).getVersion((String)version).archive;
    }

    public boolean getDeletable(String agename) {
        String result = this.data.getAge((String)agename).deletable;
        return result.equals("true");
    }

    public String getAgeInfo(String agename) {
        String curlang = translation.getCurLanguage();
        String result = this.data.getAge((String)agename).infos.get(curlang);
        if (result == null) {
            result = this.data.getAge((String)agename).info;
        }
        return result;
    }

    public String getWelcomeMessage() {
        String curlang = translation.getCurLanguage();
        String result = this.data.welcomes.get(curlang);
        if (result == null) {
            result = this.data.welcome;
        }
        return result;
    }

    public int getDrizzleVersion() {
        int result = Integer.parseInt(this.data.drizzle);
        return result;
    }

    public String getAgeProperName(String agename) {
        return this.data.getAge((String)agename).propername;
    }

    public String getSha1(String agename, String version) {
        return this.data.getAge((String)agename).getVersion((String)version).sha1;
    }

    private static String filenameToAgename(String filename) {
        if (filename.equals("Ahra Pahts v08E(with 232 and updated python)")) {
            return "Pahts";
        }
        if (filename.equals("Andys Nexus")) {
            return "Andy_Nexus";
        }
        if (filename.equals("Atlantis Outpost")) {
            return "outpost";
        }
        if (filename.equals("Bowling Age")) {
            return "bowling";
        }
        if (filename.equals("Boxage")) {
            return "BoxAge";
        }
        if (filename.equals("Camp Bravo Daytime")) {
            return "CampBravoDayTime";
        }
        if (filename.equals("Camp Bravo Nighttime")) {
            return "Campbravo";
        }
        if (filename.equals("DkSkyClub")) {
            return "DKSkyClub";
        }
        if (filename.equals("Dragons Tooth")) {
            return "Dragons_tooth";
        }
        if (filename.equals("Eder Bahvahnin")) {
            return "Bahvahnin";
        }
        if (filename.equals("Eder Licinius")) {
            return "EderLicinius";
        }
        if (filename.equals("Eder Rilteh Inaltahv")) {
            return "ederriltehinaltahv";
        }
        if (filename.equals("Gairdin Grianmhar")) {
            return "Gairdin";
        }
        if (filename.equals("Galamay")) {
            return "galamay";
        }
        if (filename.equals("Janga im Sommer")) {
            return "Janga";
        }
        if (filename.equals("Janga im Winter")) {
            return "Janga";
        }
        if (filename.equals("Jonae final")) {
            return "Jonae";
        }
        if (filename.equals("Jonae Halloween final")) {
            return "Jonae";
        }
        if (filename.equals("Jonae Halloween")) {
            return "Jonae";
        }
        if (filename.equals("JonaeHood final")) {
            return "JonaeHood";
        }
        if (filename.equals("Katos Lab")) {
            return "katoslab";
        }
        if (filename.equals("Setal Gahmarin")) {
            return "SetalGahmarin";
        }
        if (filename.equals("Tahm Hehvo")) {
            return "Tahmhehvo";
        }
        if (filename.equals("TaklaMakan final")) {
            return "TaklaMakan";
        }
        if (filename.equals("Terrati Lab")) {
            return "ter";
        }
        if (filename.equals("TINA Testing Age")) {
            return "TINA_Testing";
        }
        if (filename.equals("Trebivdil")) {
            return "trebivdil";
        }
        if (filename.equals("Tsoidahl Sheegahtee")) {
            return "jamey_study";
        }
        if (filename.equals("Vaiskor2")) {
            return "vas2";
        }
        if (filename.equals("Zephyr Cove day")) {
            return "Zephyr_Cove";
        }
        if (filename.equals("Zephyr Cove night")) {
            return "Zephyr_Cove";
        }
        if (filename.equals("SuitUp")) {
            return "suitup";
        }
        if (filename.equals("The Writers Niche")) {
            return "WNiche";
        }
        return filename;
    }

    public static String filenameToVersionname(String filename, String version) {
        if (filename.equals("Janga im Winter")) {
            return version + "(Winter)";
        }
        if (filename.equals("Jonae Halloween final")) {
            return version + "(Halloween)";
        }
        if (filename.equals("Jonae Halloween")) {
            return version + "(Halloween)";
        }
        if (filename.equals("Zephyr Cove night")) {
            return version + "(Night)";
        }
        return version;
    }

    public static ArchivesInfo generateStatusFile(String folderWith7zs, Interactor interactor) {
        UamConfigNew config;
        String sep = "--";
        String suffix = ".7z";
        ArrayList<String> newarchives = new ArrayList<String>();
        String statusfile = folderWith7zs + "/" + "uam.status.xml";
        try {
            config = new UamConfigNew(new FileInputStream(statusfile));
        }
        catch (Exception e2) {
            throw new uncaughtexception("Error reading config file.");
        }
        for (File f : search.getAllFilesWithExtension(folderWith7zs, false, suffix)) {
            String hashstr;
            String filename = f.getName();
            int ind = filename.indexOf(sep);
            if (ind == -1) {
                m.msg("Skipping ", filename, " because it contains no version in the name.");
                break;
            }
            String name = filename.substring(0, ind);
            String agename = UamConfigNew.filenameToAgename(name);
            String versionstr = filename.substring(ind + sep.length(), filename.length() - suffix.length());
            versionstr = UamConfigNew.filenameToVersionname(name, versionstr);
            String server = "http://myst.dustbird.net/uru-ages/";
            String mirurl = server + filename;
            UamConfigData.Age age = config.data.getAgeOrCreate(agename);
            if (age.filename == null) {
                m.msg("New age: ", agename);
                age.filename = agename;
                age.propername = interactor.AskQuestionDefault("There is a new Age.  What is the proper name for " + agename + "? (blank for default)", age.filename);
                age.deletable = "true";
                age.info = "";
            }
            UamConfigData.Age.Version version = age.getVersionOrCreate(versionstr, true);
            if (version.name != null) continue;
            m.msg("New version: ", agename, ": ", versionstr);
            version.name = versionstr;
            version.archive = "7z";
            byte[] hash = CryptHashes.GetHash(f.getAbsolutePath(), CryptHashes.Hashtype.sha1);
            version.sha1 = hashstr = b.BytesToHexString(hash);
            UamConfigData.Age.Version.Mirror mirror = version.getMirrorOrCreate(mirurl);
            mirror.url = mirurl;
            newarchives.add(f.getAbsolutePath());
        }
        config.data.alphabetize("-Ages");
        ArchivesInfo r = new ArchivesInfo();
        r.newFilenames = newarchives;
        r.config = config;
        return r;
    }

    public static class UamConfigData {
        public Vector<String> comments = new Vector();
        public String welcome = "";
        public HashMap<String, String> welcomes = new HashMap();
        public String drizzle = "1";
        public Vector<Age> ages = new Vector();
        public boolean aequalsatransposeequalsainverse = false;

        public UamConfigData() {
        }

        public UamConfigData(Element n) {
            String s = n.getTagName();
            if (!s.equals("uam")) {
                throw new uncaughtexception("Doesn't have uam node");
            }
            block4: for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getNodeType()) {
                    case 8: {
                        Comment c = (Comment)child;
                        String comment = c.getTextContent();
                        this.comments.add(comment);
                        continue block4;
                    }
                    case 1: {
                        Element e2 = (Element)child;
                        String tag = e2.getTagName();
                        if (tag.equals("welcome")) {
                            this.welcome = e2.getTextContent();
                            continue block4;
                        }
                        if (tag.startsWith("welcome--")) {
                            this.welcomes.put(tag.substring("welcome--".length()), e2.getTextContent());
                            continue block4;
                        }
                        if (tag.equals("drizzle")) {
                            this.drizzle = e2.getTextContent();
                            continue block4;
                        }
                        if (tag.equals("age")) {
                            this.ages.add(new Age(e2));
                            continue block4;
                        }
                        if (tag.equals("age2")) {
                            this.ages.add(new Age(e2));
                            continue block4;
                        }
                        if (!tag.equals("aequalsatransposeequalsainverse")) continue block4;
                        this.aequalsatransposeequalsainverse = true;
                    }
                }
            }
        }

        public String generateXml() {
            StringBuilder result = new StringBuilder();
            this.generateXml(result);
            return result.toString();
        }

        void generateXml(StringBuilder s) {
            s.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
            s.append("<?xml-stylesheet type='text/xsl' href='uam.status.xsl'?>\n");
            s.append("<uam>\n");
            for (String comment : this.comments) {
                s.append("\t<!--" + comment + "-->\n");
            }
            s.append("\t<welcome>" + this.welcome + "</welcome>\n");
            for (String lang : this.welcomes.keySet()) {
                s.append("\t<welcome--" + lang + ">" + this.welcomes.get(lang) + "</welcome--" + lang + ">\n");
            }
            s.append("\t<drizzle>" + this.drizzle + "</drizzle>\n");
            for (Age age : this.ages) {
                age.generateXml(s);
            }
            s.append("\t<aequalsatransposeequalsainverse />\n");
            s.append("</uam>\n");
        }

        public Age getAge(String filename) {
            for (Age age : this.ages) {
                if (!age.filename.equals(filename)) continue;
                return age;
            }
            return null;
        }

        public Age getAgeOrCreate(String filename) {
            Age age = this.getAge(filename);
            if (age == null) {
                age = new Age();
                this.ages.add(age);
            }
            return age;
        }

        public void sort() {
            Collections.sort(this.ages, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Age a1 = (Age)o1;
                    Age a2 = (Age)o2;
                    if (a1.minver >= 16 && a2.minver < 16) {
                        return -1;
                    }
                    return a1.propername.compareTo(a2.propername);
                }
            });
        }

        public void alphabetize(String startage) {
            boolean foundstart = false;
            int start = -1;
            int end = -1;
            for (int i = 0; i < this.ages.size(); ++i) {
                Age age = this.ages.get(i);
                if (foundstart && age.filename.startsWith("-")) {
                    end = i;
                    break;
                }
                if (!age.filename.equals(startage)) continue;
                foundstart = true;
                start = i + 1;
            }
            if (start == -1) {
                m.throwUncaughtException("unexpected");
            }
            if (end == -1) {
                end = this.ages.size();
            }
            this.alphabetize(start, end);
        }

        public void alphabetize(int start, int end) {
            List<Age> sublist = this.ages.subList(start, end);
            Collections.sort(sublist, new Comparator<Age>(){

                @Override
                public int compare(Age a1, Age a2) {
                    String a1name = a1.propername.toLowerCase().replace("'", "");
                    String a2name = a2.propername.toLowerCase().replace("'", "");
                    int r = a1name.compareTo(a2name);
                    return r;
                }
            });
        }

        public static class Age {
            public String filename = null;
            private String mainfile = null;
            public String deletable = null;
            public String info = null;
            public HashMap<String, String> infos = new HashMap();
            public String propername = null;
            public int minver = 0;
            public Vector<String> dels = new Vector();
            public Vector<Version> versions = new Vector();

            public Age() {
            }

            public Age(Element n) {
                block3: for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    switch (child.getNodeType()) {
                        case 1: {
                            Element e2 = (Element)child;
                            String tag = e2.getTagName();
                            if (tag.equals("filename")) {
                                this.filename = e2.getTextContent();
                                continue block3;
                            }
                            if (tag.equals("deletable")) {
                                this.deletable = e2.getTextContent();
                                continue block3;
                            }
                            if (tag.equals("info")) {
                                this.info = e2.getTextContent();
                                continue block3;
                            }
                            if (tag.startsWith("info--")) {
                                this.infos.put(tag.substring("info--".length()), e2.getTextContent());
                                continue block3;
                            }
                            if (tag.equals("name")) {
                                this.propername = e2.getTextContent();
                                continue block3;
                            }
                            if (tag.equals("minver")) {
                                this.minver = Integer.parseInt(e2.getTextContent());
                                continue block3;
                            }
                            if (tag.equals("version")) {
                                this.versions.add(new Version(e2));
                                continue block3;
                            }
                            if (tag.equals("mainfile")) {
                                this.mainfile = e2.getTextContent();
                                continue block3;
                            }
                            if (!tag.equals("del")) continue block3;
                            this.dels.add(e2.getTextContent());
                        }
                    }
                }
                if (this.minver > 32) {
                    this.info = "(You need a newer version of Drizzle to install this Age.) " + this.info;
                    for (Version v : this.versions) {
                        v.mirrors.clear();
                    }
                }
            }

            void generateXml(StringBuilder s) {
                String tag = this.minver < 16 ? "age" : "age2";
                s.append("\t<" + tag + ">\n");
                s.append("\t\t<filename>" + this.filename + "</filename>\n");
                if (this.mainfile != null) {
                    s.append("\t\t<mainfile>" + this.mainfile + "</mainfile>\n");
                }
                s.append("\t\t<name>" + this.propername + "</name>\n");
                s.append("\t\t<deletable>" + this.deletable + "</deletable>\n");
                s.append("\t\t<info>" + this.info + "</info>\n");
                for (String lang : this.infos.keySet()) {
                    s.append("\t\t<info--" + lang + ">" + this.infos.get(lang) + "</info--" + lang + ">\n");
                }
                if (this.minver != 0) {
                    s.append("\t\t<minver>" + Integer.toString(this.minver) + "</minver>\n");
                }
                for (String del : this.dels) {
                    s.append("\t\t<del>" + del + "</del>\n");
                }
                for (Version version : this.versions) {
                    version.generateXml(s);
                }
                s.append("\t</" + tag + ">\n");
            }

            public String getMainfile() {
                String result = this.mainfile;
                if (result == null) {
                    result = "dat/" + this.filename + ".age";
                }
                return result;
            }

            public Version getVersion(String name) {
                for (Version version : this.versions) {
                    if (!version.name.equals(name)) continue;
                    return version;
                }
                return null;
            }

            public Version getVersionOrCreate(String name, boolean prepend) {
                Version version = this.getVersion(name);
                if (version == null) {
                    version = new Version();
                    if (prepend) {
                        Vector<Version> newversions = new Vector<Version>();
                        newversions.add(version);
                        for (Version v : this.versions) {
                            newversions.add(v);
                        }
                        this.versions = newversions;
                    } else {
                        this.versions.add(version);
                    }
                }
                return version;
            }

            public static class Version {
                public String name = null;
                public String archive = null;
                public String sha1 = null;
                public Vector<Mirror> mirrors = new Vector();

                public Version() {
                }

                public Version(Element n) {
                    block3: for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                        switch (child.getNodeType()) {
                            case 1: {
                                Element e2 = (Element)child;
                                String tag = e2.getTagName();
                                if (tag.equals("name")) {
                                    this.name = e2.getTextContent();
                                    continue block3;
                                }
                                if (tag.equals("archive")) {
                                    this.archive = e2.getTextContent();
                                    continue block3;
                                }
                                if (tag.equals("sha1")) {
                                    this.sha1 = e2.getTextContent();
                                    continue block3;
                                }
                                if (!tag.equals("mirror")) continue block3;
                                this.mirrors.add(new Mirror(e2));
                            }
                        }
                    }
                }

                void generateXml(StringBuilder s) {
                    s.append("\t\t<version>\n");
                    s.append("\t\t\t<name>" + this.name + "</name>\n");
                    s.append("\t\t\t<archive>" + this.archive + "</archive>\n");
                    s.append("\t\t\t<sha1>" + this.sha1 + "</sha1>\n");
                    for (Mirror mirror : this.mirrors) {
                        mirror.generateXml(s);
                    }
                    s.append("\t\t</version>\n");
                }

                public Mirror getMirror(String url) {
                    for (Mirror mirror : this.mirrors) {
                        if (!mirror.url.equals(url)) continue;
                        return mirror;
                    }
                    return null;
                }

                public Mirror getMirrorOrCreate(String url) {
                    Mirror mirror = this.getMirror(url);
                    if (mirror == null) {
                        mirror = new Mirror();
                        this.mirrors.add(mirror);
                    }
                    return mirror;
                }

                public static class Mirror {
                    public String url = null;

                    public Mirror() {
                    }

                    public Mirror(Element n) {
                        block3: for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                            switch (child.getNodeType()) {
                                case 1: {
                                    Element e2 = (Element)child;
                                    String tag = e2.getTagName();
                                    if (!tag.equals("url")) continue block3;
                                    this.url = e2.getTextContent();
                                }
                            }
                        }
                    }

                    void generateXml(StringBuilder s) {
                        s.append("\t\t\t<mirror>\n");
                        s.append("\t\t\t\t<url>" + this.url + "</url>\n");
                        s.append("\t\t\t</mirror>\n");
                    }
                }
            }
        }
    }

    public static class ArchivesInfo {
        ArrayList<String> newFilenames;
        UamConfigNew config;
    }

    public static class xmlErrorHandler
    implements ErrorHandler {
        @Override
        public void error(SAXParseException exception) {
            throw new ConfigErrorException("Error validating. Server's file may have a problem.");
        }

        @Override
        public void fatalError(SAXParseException exception) {
            throw new ConfigErrorException("Error validating; Server's file is probably corrupt.");
        }

        @Override
        public void warning(SAXParseException exception) {
            m.warn(exception.getMessage());
        }
    }
}

