/*
 * Decompiled with CFR 0.152.
 */
package uru.server;

import java.util.ArrayList;
import shared.ByteArrayBytestream;
import shared.Format;
import shared.IBytedeque;
import shared.IBytestream;
import shared.e;
import shared.mystobj;
import uru.Bytedeque;
import uru.server.MoulFileInfo;

public class Manifest
extends mystobj {
    private boolean israw;
    private byte[] rawdata;
    public int count;
    private ArrayList<MoulFileInfo> files = new ArrayList();
    short uk;

    public ArrayList<MoulFileInfo> getFiles() {
        this.parse();
        return this.files;
    }

    private void parse() {
        if (this.israw) {
            this.israw = false;
            ByteArrayBytestream c = ByteArrayBytestream.createFromByteArray(this.rawdata);
            for (int i = 0; i < this.count; ++i) {
                this.files.add(new MoulFileInfo(c));
            }
            this.uk = ((IBytestream)c).readShort();
            e.ensure(this.uk == 0);
        }
    }

    public Manifest(IBytestream c, boolean readraw) {
        this.count = c.readInt();
        int charcount = c.readInt();
        if (readraw) {
            this.israw = true;
            this.rawdata = c.readBytes(charcount * 2);
        } else {
            this.israw = false;
            IBytestream c2 = c;
            boolean readall = true;
            for (int i = 0; i < this.count; ++i) {
                MoulFileInfo mfi = new MoulFileInfo(c2);
                if (mfi.filename.toString().equals("")) {
                    readall = false;
                    break;
                }
                this.files.add(mfi);
            }
            if (readall) {
                this.uk = c.readShort();
            }
        }
    }

    public Manifest() {
    }

    @Override
    public void write(IBytedeque c) {
        if (this.israw) {
            c.writeInt(this.count);
            c.writeInt(this.rawdata.length / 2);
            c.writeBytes(this.rawdata);
        } else {
            c.writeInt(this.files.size());
            Bytedeque c2 = new Bytedeque(Format.moul);
            for (int i = 0; i < this.files.size(); ++i) {
                this.files.get(i).write(c2);
            }
            c2.writeShort(this.uk);
            byte[] data = c2.getAllBytes();
            c.writeInt(data.length / 2);
            c.writeBytes(data);
        }
    }
}

