/*
 * Decompiled with CFR 0.152.
 */
package uru.server;

import shared.IBytedeque;
import shared.IBytestream;
import shared.Str;

public class MoulFileInfo {
    public Str filename;
    public Str Downloadname;
    public Str Hash;
    public Str CompressedHash;
    public int Filesize;
    private short u1;
    public int Compressedsize;
    private short u2;
    public int Flags;
    private short u3;

    public MoulFileInfo(IBytestream c) {
        this.filename = Str.readAsUtf16NT(c);
        if (this.filename.toString().equals("")) {
            return;
        }
        this.Downloadname = Str.readAsUtf16NT(c);
        this.Hash = Str.readAsUtf16NT(c);
        this.CompressedHash = Str.readAsUtf16NT(c);
        this.Filesize = c.readIntAsTwoShorts();
        this.u1 = c.readShort();
        this.Compressedsize = c.readIntAsTwoShorts();
        this.u2 = c.readShort();
        this.Flags = c.readIntAsTwoShorts();
        this.u3 = c.readShort();
    }

    public MoulFileInfo() {
    }

    public void write(IBytedeque c) {
        this.filename.writeAsUtf16NT(c);
        if (this.filename.toString().equals("")) {
            return;
        }
        this.Downloadname.writeAsUtf16NT(c);
        this.Hash.writeAsUtf16NT(c);
        this.CompressedHash.writeAsUtf16NT(c);
        c.writeIntAsTwoShorts(this.Filesize);
        c.writeShort(this.u1);
        c.writeIntAsTwoShorts(this.Compressedsize);
        c.writeShort(this.u2);
        c.writeIntAsTwoShorts(this.Flags);
        c.writeShort(this.u3);
    }

    public String toString() {
        return "filename=" + this.filename.toString() + " downname=" + this.Downloadname.toString() + " hash=" + this.Hash.toString() + " comphash=" + this.CompressedHash.toString() + " filesize=" + Integer.toString(this.Filesize) + " compsize=" + Integer.toString(this.Compressedsize) + " flags=" + Integer.toString(this.Flags);
    }

    public void SetFilename(String str) {
        str = str.replace("/", "\\");
        if ((str = str.replace("\\\\", "\\")).startsWith("\\")) {
            str = str.substring(1);
        }
        this.filename = new Str(str);
    }

    public void SetDownloadname(String str) {
        str = str.replace("/", "\\");
        if ((str = str.replace("\\\\", "\\")).startsWith("\\")) {
            str = str.substring(1);
        }
        this.Downloadname = new Str(str);
    }
}

