#ifndef ELEVATIONGRAPHITEM_H
#define ELEVATIONGRAPHITEM_H

#include "graphitem.h"

class ElevationGraphItem : public GraphItem
{
	Q_OBJECT

public:
	enum DataType {GPS, DEM};

	ElevationGraphItem(const Graph &graph, GraphType type, int width,
	  const QColor &color, Qt::PenStyle style, QGraphicsItem *parent = 0);

	qreal ascent() const {return _ascent;}
	qreal descent() const {return _descent;}
	qreal max() const {return _max;}
	qreal min() const {return _min;}

	ToolTip info(bool extended) const;

private:
	qreal _ascent, _descent, _min, _max;
};

#endif // ELEVATIONGRAPHITEM_H
