% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_burninthining.R
\name{simulate_burninthining_single}
\alias{simulate_burninthining_single}
\title{Simulate burnin thining single}
\usage{
simulate_burninthining_single(
  partition,
  theta,
  nodes,
  effects,
  objects,
  num.steps,
  neighborhood,
  numgroups.allowed,
  numgroups.simulated,
  sizes.allowed,
  sizes.simulated,
  max.thining,
  verbose = FALSE
)
}
\arguments{
\item{partition}{Observed partition (vector)}

\item{theta}{Initial model parameters}

\item{nodes}{Node set (data frame)}

\item{effects}{Effects/sufficient statistics (list with a vector "names", and a vector "objects")}

\item{objects}{Objects used for statistics calculation (list with a vector "name", and a vector "object")}

\item{num.steps}{Number of samples wanted}

\item{neighborhood}{Way of choosing partitions: probability vector (proba actors swap, proba merge/division, proba single actor move)}

\item{numgroups.allowed}{vector containing the number of groups allowed in the partition (now, it only works with vectors like num_min:num_max)}

\item{numgroups.simulated}{vector containing the number of groups simulated}

\item{sizes.allowed}{Vector of group sizes allowed in sampling (now, it only works for vectors like size_min:size_max)}

\item{sizes.simulated}{Vector of group sizes allowed in the Markov chain but not necessraily sampled (now, it only works for vectors like size_min:size_max)}

\item{max.thining}{maximal number of simulated steps in the thining}

\item{verbose}{logical: should intermediate results during the estimation be printed or not? Defaults to FALSE.}
}
\value{
A list
}
\description{
Function that simulates the Markov chain for a given model and a set of transitions (the neighborhood), for a single partition.
It calculates the autocorrelation of statistics for different thinings and the average statistics for different burn-ins.
}
