% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_burninthining.R
\name{simulate_thining_single}
\alias{simulate_thining_single}
\title{Simulate thining single}
\usage{
simulate_thining_single(
  partition,
  theta,
  nodes,
  effects,
  objects,
  num.steps,
  neighborhood,
  numgroups.allowed,
  numgroups.simulated,
  sizes.allowed,
  sizes.simulated,
  burnin,
  max.thining,
  verbose = FALSE
)
}
\arguments{
\item{partition}{A partition (vector)}

\item{theta}{Initial model parameters}

\item{nodes}{Node set (data frame)}

\item{effects}{Effects/sufficient statistics (list with a vector "names", and a vector "objects")}

\item{objects}{Objects used for statistics calculation (list with a vector "name", and a vector "object")}

\item{num.steps}{Number of samples wanted}

\item{neighborhood}{Way of choosing partitions: probability vector (proba actors swap, proba merge/division, proba single actor move)}

\item{numgroups.allowed}{vector containing the number of groups allowed in the partition (now, it only works with vectors like num_min:num_max)}

\item{numgroups.simulated}{vector containing the number of groups simulated}

\item{sizes.allowed}{Vector of group sizes allowed in sampling (now, it only works for vectors like size_min:size_max)}

\item{sizes.simulated}{Vector of group sizes allowed in the Markov chain but not necessraily sampled (now, it only works for vectors like size_min:size_max)}

\item{burnin}{number of simulated steps for the burn-in}

\item{max.thining}{maximal number of simulated steps in the thining}

\item{verbose}{logical: should intermediate results during the estimation be printed or not? Defaults to FALSE.}
}
\value{
A list
}
\description{
Function that can be used to find a good length for the thining of the Markov chain for a given model and a set of transitions in the chain (the neighborhood).
It draws a chain and calculates the autocorrelation of statistics for different thinings.
}
