% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeWide.R
\name{.makeWide}
\alias{.makeWide}
\title{Convert Data to Wide Format}
\usage{
.makeWide(data, id, time, outcome, treatment)
}
\arguments{
\item{data}{A data frame containing the input data.}

\item{id}{The name of the variable in \code{data} that identifies units (as a string).}

\item{time}{The name of the time period variable (as a string).}

\item{outcome}{The name of the outcome variable (as a string).}

\item{treatment}{The name of the variable in \code{data} that indicates treatment status (as a string).}
}
\value{
A data frame in wide format, where each row corresponds to a time period,
and columns include the time variable, the treatment indicator, and the outcome
values for each treated unit and all untreated units.
}
\description{
This internal helper function transforms data from a long format, where each
row represents an observation for a specific unit and time, to a wide format,
where each row represents a time period and each column represents a unit's outcome.
It specifically focuses on separating treated and untreated units.
}
