% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_last_cit}
\alias{sample_last_cit}
\alias{last_cit}
\alias{sample_cit_types}
\alias{cit_types}
\alias{sample_cit_cit_types}
\alias{cit_cit_types}
\title{Random citation graphs}
\usage{
sample_last_cit(
  n,
  edges = 1,
  agebins = n/7100,
  pref = (1:(agebins + 1))^-3,
  directed = TRUE
)

last_cit(...)

sample_cit_types(
  n,
  edges = 1,
  types = rep(0, n),
  pref = rep(1, length(types)),
  directed = TRUE,
  attr = TRUE
)

cit_types(...)

sample_cit_cit_types(
  n,
  edges = 1,
  types = rep(0, n),
  pref = matrix(1, nrow = length(types), ncol = length(types)),
  directed = TRUE,
  attr = TRUE
)

cit_cit_types(...)
}
\arguments{
\item{n}{Number of vertices.}

\item{edges}{Number of edges per step.}

\item{agebins}{Number of aging bins.}

\item{pref}{Vector (\code{sample_last_cit()} and \code{sample_cit_types()} or
matrix (\code{sample_cit_cit_types()}) giving the (unnormalized) citation
probabilities for the different vertex types.}

\item{directed}{Logical scalar, whether to generate directed networks.}

\item{...}{Passed to the actual constructor.}

\item{types}{Vector of length \sQuote{\code{n}}, the types of the vertices.
Types are numbered from zero.}

\item{attr}{Logical scalar, whether to add the vertex types to the generated
graph as a vertex attribute called \sQuote{\code{type}}.}
}
\value{
A new graph.
}
\description{
\code{sample_last_cit()} creates a graph, where vertices age, and
gain new connections based on how long ago their last citation
happened.
}
\details{
\code{sample_cit_cit_types()} is a stochastic block model where the
graph is growing.

\code{sample_cit_types()} is similarly a growing stochastic block model,
but the probability of an edge depends on the (potentially) cited
vertex only.
}
\seealso{
Random graph models (games)
\code{\link{erdos.renyi.game}()},
\code{\link{sample_}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_chung_lu}()},
\code{\link{sample_correlated_gnp}()},
\code{\link{sample_correlated_gnp_pair}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_gnp}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_pa}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_tree}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{games}
\keyword{graphs}
