% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRepresentativeDocs.R
\name{plotRepresentativeDocs}
\alias{plotRepresentativeDocs}
\title{Function for plotting documents that load heavily on a topic}
\usage{
plotRepresentativeDocs(object, text.cex = 1, width = 100)
}
\arguments{
\item{object}{Model output from sts.}

\item{text.cex}{Size of the text; Defaults to 1}

\item{width}{Size of the plotting window; Defaults to 100}
}
\description{
Produces a plot of the text of documents that load most heavily on topics for an STS object
}
\examples{
\donttest{
#Examples with the Gadarian Data
library("tm"); library("stm"); library("sts")
temp<-textProcessor(documents=gadarian$open.ended.response,
metadata=gadarian, verbose = FALSE)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta, verbose = FALSE)
out$meta$noTreatment <- ifelse(out$meta$treatment == 1, -1, 1)
## low max iteration number just for testing
sts_estimate <- sts(~ treatment*pid_rep, ~ noTreatment, out, K = 3, maxIter = 2)
docs <- findRepresentativeDocs(sts_estimate, out$meta$open.ended.response, topic = 3, n = 1)
plotRepresentativeDocs(docs, text.cex = 0.7, width = 100)
}
}
