# 0.16.0にアップグレードする

asdfはバージョン0.15.0以前まではBashで書かれており、`asdf`関数がシェルにロードされたBashスクリプトのセットとして配布されていました。バージョン0.16.0はasdfをGoで完全に書き直したものです。完全に書き直したことによって多くの[破壊的変更](#breaking-changes)があり、現在ではスクリプトのセットではなくバイナリになっています。

## インストール

バージョン0.16.0のインストールは、以前のバージョンのasdfよりもはるかに簡単です。
たったの3ステップで完了します:

* お使いのオペレーティングシステム/アーキテクチャの組み合わせに適した`asdf`バイナリをダウンロードし、`$PATH`のディレクトリに配置する。
* `$PATH`の前に`$ASDF_DATA_DIR/shims`を追加する。
* 以前にasdfのデータの保存場所をカスタマイズしていた場合は、`ASDF_DATA_DIR`に旧バージョンのプラグイン、バージョン、Shimをインストールしていたディレクトリを設定する(オプション)。

オペレーティングシステムのパッケージマネージャがすでにasdf 0.16.0を提供している場合は、それをインストールするのがおそらく最良の方法です。asdfのアップグレードはOSのパッケージマネージャーと手動インストールでのみ可能です。セルフアップグレード機能はありません。

### データを失わずにアップグレードする

既存のインストールデータを失うことなく、asdfの最新バージョンにアップグレードできます。上記の手順と同じです。

#### 1. お使いのオペレーティングシステムとアーキテクチャに適した`asdf`バイナリをダウンロードする

バイナリをダウンロードして、パスの通ったディレクトリに配置します。以下ではasdfのバイナリを`$HOME/bin`に配置し、`$HOME/bin`を`$PATH`の先頭に追加します:

```
# In .zshrc, .bashrc, etc...
export PATH="$HOME/bin:$PATH"
```

#### 2. `ASDF_DATA_DIR` を設定する

`asdf info`を実行し、変数`ASDF_DATA_DIR`を含む行をコピーします:

```
...
ASDF_DATA_DIR="/home/myuser/.asdf"
...
```

シェルのRCファイル（Zshの場合は`.zshrc`、Bashの場合は`.bashrc`など）で、`ASDF_DATA_DIR`を設定してエクスポートします:

```bash
export ASDF_DATA_DIR="/home/myuser/.asdf"
```

#### 3. `$ASDF_DATA_DIR/shims`を`$PATH`の前に追加する。

シェルのRCファイル（手順2と同じファイル）で、パスの前に`$ASDF_DATA_DIR/shims`を追加します：

```bash
export ASDF_DATA_DIR="/home/myuser/.asdf"
export PATH="$ASDF_DATA_DIR/shims:$PATH"
```

#### 4. Shimを再生成する

`asdf --help`を実行して、シェルセッションの`asdf`コマンドのバージョンが0.16.0以上であることを確認してください。まだ古いバージョンが表示されている場合は、新しいシェルセッションを開始する必要があります。

`asdf`コマンドが新しいバージョンであることを確認したら、`asdf reshim`を実行してすべてのShimを再生成します。この手順は、古いShimが古いバージョンのBashを参照している可能性があるため必要となります。

### テスト

0.16.0へのアップグレードで問題が発生するかどうか確信が持てない場合は、「データを失わずにアップグレードする」で説明したように、既存のバージョンに加えて0.16.0をインストールしてテストすることができます。0.16.0へのアップグレードで不具合が生じることがわかったら、シェルのRCファイルに追加した行を削除してください。

## 破壊的変更

### ハイフン付きバージョンのコマンドは削除されました

asdfバージョン0.15.0およびそれ以前では、特定のコマンドのハイフン付きバージョンとハイフンなしバージョンがサポートされていました。バージョン 0.16.0 では、ハイフンなしバージョンのみがサポートされます。影響を受けるコマンドは以下です:

* `asdf list-all` -> `asdf list all`
* `asdf plugin-add` -> `asdf plugin add`
* `asdf plugin-list` -> `asdf plugin list`
* `asdf plugin-list-all` -> `asdf plugin list all`
* `asdf plugin-update` -> `asdf plugin update`
* `asdf plugin-remove` -> `asdf plugin remove`
* `asdf plugin-test` -> `asdf plugin test`
* `asdf shim-versions` -> `asdf shimversions`

### `asdf global` と `asdf local` コマンドが `asdf set` に変更されました

`asdf global` と `asdf local` は削除されました。「グローバル」と「ローカル」という用語は誤りで、誤解を招く恐れがありました。asdf は、実際にはあらゆる場所に適用される「グローバル」バージョンをサポートしていません。`asdf global`で指定したバージョンは、カレントディレクトリにある `.tool-versions` ファイルで簡単に上書きすることができました。これはユーザーを混乱させていました。 新しい`asdf set`はデフォルトでは`asdf local`と同じように動作しますが、ユーザーのホームディレクトリ (`--home`) や親ディレクトリ (`--parent`) にある既存の `.tool-versions` ファイルにバージョンを設定するためのフラグも用意されています。 この新しいインターフェイスは、asdfがどのようにバージョンを解決するかをよりよく理解し、同等の機能を提供することを期待しています。

### `asdf update`コマンドが削除されました

この方法ではアップデートを実行できなくなりました。OS のパッケージマネージャを使用するか、手動で最新のバイナリをダウンロードしてください。さらに、バージョン 0.15.0 以前の`asdf update`コマンドは、インストールプロセスが変更されたため、バージョン 0.16.0 にアップグレードできません。
**`asdf update`を使用して最新のGo実装にアップグレードすることはできません。**

### `asdf shell`コマンドが削除されました

このコマンドは実際にユーザーの現在のシェルセッションに環境変数を設定していました。これは`asdf`が実行可能ファイルではなく、実際にはシェル関数であったために可能でした。新しい実装では、asdfからすべてのシェルコードが削除され、シェル関数ではなくバイナリになったので、シェルで直接環境変数を設定することはできなくなりました。

### `asdf current`が変更されました

これまで出力されていた3つのカラムの代わりに、最後のカラムはバージョンが設定されている場所か、バージョンを設定またはインストールするために実行可能な推奨コマンドのいずれかが表示されるようになりました。3番目のカラムが2つのカラムに分割されています。3番目のカラムは、バージョンが設定されている場合（通常、バージョンファイルか環境変数のいずれか）のみ、バージョンのソースを示すようになり、4番目は、指定されたバージョンが実際にインストールされているかどうかを示すブール値です。インストールされていない場合は、インストールコマンドの候補が表示されます。

### プラグイン拡張コマンドの前に`cmd`を付ける必要があります


以前のプラグイン拡張コマンドは次のように実行できました:

```
asdf nodejs nodebuild --version
```

現在では、組み込みコマンドと混同するのを避けるために、`cmd`をプレフィックスとして付ける必要があります:

```
asdf cmd nodejs nodebuild --version
```

### 拡張コマンドが再設計されました

プラグイン拡張コマンドにはいくつかの変更点があります：

* 拡張コマンドは`exec`システムコールで実行可能でなければなりません。拡張コマンドがシェルスクリプトの場合、`exec`で実行するためには適切なshebang行で始まる必要があります。
* 拡張コマンドはバイナリでもスクリプトでも、どの言語でも実行できるようになりました。もはや`.bash`という拡張子を要求するのは誤解を招くので意味がありません。
* 実行権限が設定されていなければなりません。
* 実行権限がない場合、asdfによってBashスクリプトとしてソースされなくなりました。

さらに、プラグイン名の後の最初の引数のみが、実行する拡張コマンドを決定するために使用されます。これは、プラグイン名の後の最初の引数にマッチするコマンドが見つからない場合にasdfがデフォルトで実行する`command`拡張コマンドが存在することを意味します。たとえばこのようになります:

```
foo/
  lib/commands/
    command
    command-bar
    command-bat-man
```

以前は、これらのスクリプトはこのように動作していました:

```
$ asdf cmd foo         # same as running `$ASDF_DATA_DIR/plugins/foo/lib/commands/command`
$ asdf cmd foo bar     # same as running `$ASDF_DATA_DIR/plugins/foo/lib/commands/command-bar`
$ asdf cmd foo bat man # same as running `$ASDF_DATA_DIR/plugins/foo/lib/commands/command-bat-man`
```

現在はこのようになります:

```
$ asdf cmd foo         # same as running `$ASDF_DATA_DIR/plugins/foo/lib/commands/command`
$ asdf cmd foo bar     # same as running `$ASDF_DATA_DIR/plugins/foo/lib/commands/command-bar`
$ asdf cmd foo bat man # same as running `$ASDF_DATA_DIR/plugins/foo/lib/commands/command-bat man`
```

### 実行可能なShimは`syscall.Exec`によって実行できる必要があります

asdf 0.15.0以前はBashで実装されていたので、Bashで実行できる実行ファイルであれば実行することができました。つまり、shebang行がないスクリプトでも`asdf exec`で実行することができました。しかし、asdf 0.16.xがGoで実装されたことで、Goの`syscall.Exec`関数を使って実行ファイルを呼び出すようになり、shebangがないスクリプトは扱えなくなりました。

実際には、これはあまり問題ではありません。ほとんどのシェルスクリプトはshebang行を含んでいます。asdfによって管理されるツールがshebang行を持たないスクリプトを提供する場合、shebang行を追加する必要があります。

### カスタムShimテンプレートはサポートされなくなりました

これはめったに使われない機能でした。コアチームがメンテナンスしているプラグインでこの機能を使用していたのはElixirプラグインだけで、もう必要ありません。この機能はもともと、実行されるのではなくプログラムによって評価されるShimが、特定のプログラム(Elixir の場合は`iex`シェル)による評価に適したコードを含むように追加されました。さらに調べてみると、この機能は実行可能ファイルの`PATH`が不適切に設定され、選択されたバージョンの**実行可能ファイル**ではなく、**Shim**を含むように設定されていたために存在していたようです。
