---
id: compatibility
title: "Compatibility Table"
keywords: [detekt, kotlin, gradle, compatibility, android] 
summary: This page lists the version of the Gradle plugins have been used to build detekt.
sidebar_position: 11
---

## Detekt Support Commitment

detekt is developed by open-source contributors as a volunteer effort.
Due to our limited resources, we commit to support only the **latest stable versions** and related RC versions.

When opening Issues and Discussions, consider first updating to the latest version and align your tool versions
with the one listed below. This allows us to offer you better support.

## Tool Versions

When shipping the Detekt Gradle Plugin, we depend on both the **Kotlin Gradle Plugin** and the **Android Gradle Plugin**.

Those dependencies are applied as `compileOnly` ([see here](https://github.com/detekt/detekt/blob/75622d3ba88b0ae0357aec5f2d82a55aa6c6d157/detekt-gradle-plugin/build.gradle.kts#L17-L18)) to allow our users to pick the version of the Gradle plugin they prefer and don't impose the one we use inside detekt.

We try to provide **backward compatibility** when possible, although that's not always trivial (especially with AGP or across minor versions of Kotlin).

The following table lists the version of the Gradle plugin we used to compile the Detekt Gradle Plugin. The `Java Target Level` entry specifies the level of the generated bytecode (i.e. the `-target` flag used when generating bytecode). The `JDK Version` represents the highest version of the JDK we test our code against.

Consider **aligning** your Gradle plugin versions with the one listed below, as we can offer better support on Issues and Discussions for the listed versions of those tools.

| detekt Version | Gradle Version | Kotlin Version | AGP Version | Java Target Level | JDK Version |
|----------------|----------------|----------------|-------------|-------------------|-------------|
| `1.22.0`       | `7.5.1`        | `1.7.21`       | `7.3.1`     | `1.8`             | `17`        |
| `1.21.0`       | `7.5`          | `1.6.21`       | `7.2.1`     | `1.8`             | `17`        |
| `1.20.0`       | `7.4.2`        | `1.6.20`       | `7.1.3`     | `1.8`             | `17`        |
| `1.19.0`       | `7.3.0`        | `1.5.31`       | `4.2.2`     | `1.8`             | `17`        |
| `1.18.0`       | `7.0.1`        | `1.5.21`       | `4.2.0`     | `1.8`             | `16`        |
| `1.17.0`       | `7.0.1`        | `1.4.32`       | `4.2.0`     | `1.8`             | `15`        |
| `1.16.0`       | `6.8.0`        | `1.4.21`       | `4.1.2`     | `1.8`             | `15`        |
| `1.15.0`       | `6.8.0`        | `1.4.10`       | `4.0.1`     | `1.8`             | `15`        |
| `1.14.2`       | `6.7.0`        | `1.4.10`       | `4.0.1`     | `1.8`             | `14`        |
| `1.14.0`       | `6.7-rc-2`     | `1.4.10`       | `4.0.1`     | `1.8`             | `14`        |
| `1.13.1`       | `6.6.1`        | `1.4.0`        | `4.0.1`     | `1.8`             | `14`        |

_(older versions are omitted for brevity)_
