%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4
%% Purpose: Encoding and decoding of the types in PKIX-X400Address-2009.

-module('PKIX-X400Address-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("PKIX-X400Address-2009.hrl").
-asn1_info([{vsn,'5.4'},
            {module,'PKIX-X400Address-2009'},
            {options,[{i,"/buildroot/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/buildroot/otp/lib/public_key/asn1"},
 {outdir,"/buildroot/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/buildroot/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_ORAddress/2,
enc_BuiltInStandardAttributes/2,
enc_CountryName/2,
enc_AdministrationDomainName/2,
enc_NetworkAddress/2,
enc_X121Address/2,
enc_TerminalIdentifier/2,
enc_PrivateDomainName/2,
enc_OrganizationName/2,
enc_NumericUserIdentifier/2,
enc_PersonalName/2,
enc_OrganizationalUnitNames/2,
enc_OrganizationalUnitName/2,
enc_BuiltInDomainDefinedAttributes/2,
enc_BuiltInDomainDefinedAttribute/2,
enc_ExtensionAttributes/2,
enc_ExtensionAttribute/2,
enc_TeletexOrganizationalUnitName/2,
enc_PDSParameter/2,
enc_PresentationAddress/2,
enc_TeletexDomainDefinedAttribute/2
]).

-export([
dec_ORAddress/2,
dec_BuiltInStandardAttributes/2,
dec_CountryName/2,
dec_AdministrationDomainName/2,
dec_NetworkAddress/2,
dec_X121Address/2,
dec_TerminalIdentifier/2,
dec_PrivateDomainName/2,
dec_OrganizationName/2,
dec_NumericUserIdentifier/2,
dec_PersonalName/2,
dec_OrganizationalUnitNames/2,
dec_OrganizationalUnitName/2,
dec_BuiltInDomainDefinedAttributes/2,
dec_BuiltInDomainDefinedAttribute/2,
dec_ExtensionAttributes/2,
dec_ExtensionAttribute/2,
dec_TeletexOrganizationalUnitName/2,
dec_PDSParameter/2,
dec_PresentationAddress/2,
dec_TeletexDomainDefinedAttribute/2
]).

-export([
'enc_ea-commonName'/3,
'enc_ea-teletexCommonName'/3,
'enc_ea-teletexOrganizationName'/3,
'enc_ea-teletexPersonalName'/3,
'enc_ea-teletexOrganizationalUnitNames'/3,
'enc_ea-pDSName'/3,
'enc_ea-physicalDeliveryCountryName'/3,
'enc_ea-postalCode'/3,
'enc_ea-physicalDeliveryOfficeName'/3,
'enc_ea-physicalDeliveryOfficeNumber'/3,
'enc_ea-extensionORAddressComponents'/3,
'enc_ea-physicalDeliveryPersonalName'/3,
'enc_ea-physicalDeliveryOrganizationName'/3,
'enc_ea-extensionPhysicalDeliveryAddressComponents'/3,
'enc_ea-unformattedPostalAddress'/3,
'enc_ea-streetAddress'/3,
'enc_ea-postOfficeBoxAddress'/3,
'enc_ea-posteRestanteAddress'/3,
'enc_ea-uniquePostalName'/3,
'enc_ea-localPostalAttributes'/3,
'enc_ea-extendedNetworkAddress'/3,
'enc_ea-terminalType'/3,
'enc_ea-teletexDomainDefinedAttributes'/3
]).

-export([
'dec_ea-commonName'/3,
'dec_ea-teletexCommonName'/3,
'dec_ea-teletexOrganizationName'/3,
'dec_ea-teletexPersonalName'/3,
'dec_ea-teletexOrganizationalUnitNames'/3,
'dec_ea-pDSName'/3,
'dec_ea-physicalDeliveryCountryName'/3,
'dec_ea-postalCode'/3,
'dec_ea-physicalDeliveryOfficeName'/3,
'dec_ea-physicalDeliveryOfficeNumber'/3,
'dec_ea-extensionORAddressComponents'/3,
'dec_ea-physicalDeliveryPersonalName'/3,
'dec_ea-physicalDeliveryOrganizationName'/3,
'dec_ea-extensionPhysicalDeliveryAddressComponents'/3,
'dec_ea-unformattedPostalAddress'/3,
'dec_ea-streetAddress'/3,
'dec_ea-postOfficeBoxAddress'/3,
'dec_ea-posteRestanteAddress'/3,
'dec_ea-uniquePostalName'/3,
'dec_ea-localPostalAttributes'/3,
'dec_ea-extendedNetworkAddress'/3,
'dec_ea-terminalType'/3,
'dec_ea-teletexDomainDefinedAttributes'/3
]).

-export([
getenc_SupportedExtensionAttributes/1
]).

-export([
getdec_SupportedExtensionAttributes/1
]).

-export([
'ub-match'/0,
'ub-common-name-length'/0,
'ub-country-name-alpha-length'/0,
'ub-country-name-numeric-length'/0,
'ub-domain-defined-attributes'/0,
'ub-domain-defined-attribute-type-length'/0,
'ub-domain-defined-attribute-value-length'/0,
'ub-domain-name-length'/0,
'ub-extension-attributes'/0,
'ub-e163-4-number-length'/0,
'ub-e163-4-sub-address-length'/0,
'ub-generation-qualifier-length'/0,
'ub-given-name-length'/0,
'ub-initials-length'/0,
'ub-integer-options'/0,
'ub-numeric-user-id-length'/0,
'ub-organization-name-length'/0,
'ub-organizational-unit-name-length'/0,
'ub-organizational-units'/0,
'ub-pds-name-length'/0,
'ub-pds-parameter-length'/0,
'ub-pds-physical-address-lines'/0,
'ub-postal-code-length'/0,
'ub-surname-length'/0,
'ub-terminal-id-length'/0,
'ub-unformatted-address-length'/0,
'ub-x121-address-length'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('ORAddress', Data) -> enc_ORAddress(Data);
encode_disp('BuiltInStandardAttributes', Data) -> enc_BuiltInStandardAttributes(Data);
encode_disp('CountryName', Data) -> enc_CountryName(Data);
encode_disp('AdministrationDomainName', Data) -> enc_AdministrationDomainName(Data);
encode_disp('NetworkAddress', Data) -> enc_NetworkAddress(Data);
encode_disp('X121Address', Data) -> enc_X121Address(Data);
encode_disp('TerminalIdentifier', Data) -> enc_TerminalIdentifier(Data);
encode_disp('PrivateDomainName', Data) -> enc_PrivateDomainName(Data);
encode_disp('OrganizationName', Data) -> enc_OrganizationName(Data);
encode_disp('NumericUserIdentifier', Data) -> enc_NumericUserIdentifier(Data);
encode_disp('PersonalName', Data) -> enc_PersonalName(Data);
encode_disp('OrganizationalUnitNames', Data) -> enc_OrganizationalUnitNames(Data);
encode_disp('OrganizationalUnitName', Data) -> enc_OrganizationalUnitName(Data);
encode_disp('BuiltInDomainDefinedAttributes', Data) -> enc_BuiltInDomainDefinedAttributes(Data);
encode_disp('BuiltInDomainDefinedAttribute', Data) -> enc_BuiltInDomainDefinedAttribute(Data);
encode_disp('ExtensionAttributes', Data) -> enc_ExtensionAttributes(Data);
encode_disp('ExtensionAttribute', Data) -> enc_ExtensionAttribute(Data);
encode_disp('TeletexOrganizationalUnitName', Data) -> enc_TeletexOrganizationalUnitName(Data);
encode_disp('PDSParameter', Data) -> enc_PDSParameter(Data);
encode_disp('PresentationAddress', Data) -> enc_PresentationAddress(Data);
encode_disp('TeletexDomainDefinedAttribute', Data) -> enc_TeletexDomainDefinedAttribute(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('ORAddress', Data) -> dec_ORAddress(Data);
decode_disp('BuiltInStandardAttributes', Data) -> dec_BuiltInStandardAttributes(Data);
decode_disp('CountryName', Data) -> dec_CountryName(Data);
decode_disp('AdministrationDomainName', Data) -> dec_AdministrationDomainName(Data);
decode_disp('NetworkAddress', Data) -> dec_NetworkAddress(Data);
decode_disp('X121Address', Data) -> dec_X121Address(Data);
decode_disp('TerminalIdentifier', Data) -> dec_TerminalIdentifier(Data);
decode_disp('PrivateDomainName', Data) -> dec_PrivateDomainName(Data);
decode_disp('OrganizationName', Data) -> dec_OrganizationName(Data);
decode_disp('NumericUserIdentifier', Data) -> dec_NumericUserIdentifier(Data);
decode_disp('PersonalName', Data) -> dec_PersonalName(Data);
decode_disp('OrganizationalUnitNames', Data) -> dec_OrganizationalUnitNames(Data);
decode_disp('OrganizationalUnitName', Data) -> dec_OrganizationalUnitName(Data);
decode_disp('BuiltInDomainDefinedAttributes', Data) -> dec_BuiltInDomainDefinedAttributes(Data);
decode_disp('BuiltInDomainDefinedAttribute', Data) -> dec_BuiltInDomainDefinedAttribute(Data);
decode_disp('ExtensionAttributes', Data) -> dec_ExtensionAttributes(Data);
decode_disp('ExtensionAttribute', Data) -> dec_ExtensionAttribute(Data);
decode_disp('TeletexOrganizationalUnitName', Data) -> dec_TeletexOrganizationalUnitName(Data);
decode_disp('PDSParameter', Data) -> dec_PDSParameter(Data);
decode_disp('PresentationAddress', Data) -> dec_PresentationAddress(Data);
decode_disp('TeletexDomainDefinedAttribute', Data) -> dec_TeletexDomainDefinedAttribute(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  ORAddress
%%================================
enc_ORAddress(Val) ->
    enc_ORAddress(Val, [<<48>>]).

enc_ORAddress(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute built-in-standard-attributes(1)   External PKIX-X400Address-2009:BuiltInStandardAttributes
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_BuiltInStandardAttributes'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute built-in-domain-defined-attributes(2)   External PKIX-X400Address-2009:BuiltInDomainDefinedAttributes OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_BuiltInDomainDefinedAttributes'(Cindex2, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute extension-attributes(3)   External PKIX-X400Address-2009:ExtensionAttributes OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ExtensionAttributes'(Cindex3, [<<49>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ORAddress(Tlv) ->
   dec_ORAddress(Tlv, [16]).

dec_ORAddress(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute built-in-standard-attributes(1)   External PKIX-X400Address-2009:BuiltInStandardAttributes
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_BuiltInStandardAttributes'(V1, [16]),

%%-------------------------------------------------
%% attribute built-in-domain-defined-attributes(2)   External PKIX-X400Address-2009:BuiltInDomainDefinedAttributes OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'dec_BuiltInDomainDefinedAttributes'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute extension-attributes(3)   External PKIX-X400Address-2009:ExtensionAttributes OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{17,V3}|TempTlv4] ->
    {'dec_ExtensionAttributes'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'ORAddress',Term1,Term2,Term3},
Res1.


%%================================
%%  BuiltInStandardAttributes
%%================================
enc_BuiltInStandardAttributes(Val) ->
    enc_BuiltInStandardAttributes(Val, [<<48>>]).

enc_BuiltInStandardAttributes(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9} = Val,

%%-------------------------------------------------
%% attribute country-name(1)   External PKIX-X400Address-2009:CountryName OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CountryName'(Cindex1, [<<97>>])
       end,

%%-------------------------------------------------
%% attribute administration-domain-name(2)   External PKIX-X400Address-2009:AdministrationDomainName OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AdministrationDomainName'(Cindex2, [<<98>>])
       end,

%%-------------------------------------------------
%% attribute network-address(3) with type NumericString OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute terminal-identifier(4) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute private-domain-name(5)   External PKIX-X400Address-2009:PrivateDomainName OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PrivateDomainName'(Cindex5, [<<162>>])
       end,

%%-------------------------------------------------
%% attribute organization-name(6) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex6, [<<131>>])
       end,

%%-------------------------------------------------
%% attribute numeric-user-identifier(7) with type NumericString OPTIONAL
%%-------------------------------------------------
   {EncBytes7,EncLen7} =  case Cindex7 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex7, [<<132>>])
       end,

%%-------------------------------------------------
%% attribute personal-name(8)   External PKIX-X400Address-2009:PersonalName OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PersonalName'(Cindex8, [<<165>>])
       end,

%%-------------------------------------------------
%% attribute organizational-unit-names(9)   External PKIX-X400Address-2009:OrganizationalUnitNames OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OrganizationalUnitNames'(Cindex9, [<<166>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_BuiltInStandardAttributes(Tlv) ->
   dec_BuiltInStandardAttributes(Tlv, [16]).

dec_BuiltInStandardAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute country-name(1)   External PKIX-X400Address-2009:CountryName OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{65537,V1}|TempTlv2] ->
    {'dec_CountryName'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute administration-domain-name(2)   External PKIX-X400Address-2009:AdministrationDomainName OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{65538,V2}|TempTlv3] ->
    {'dec_AdministrationDomainName'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute network-address(3) with type NumericString OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131072,V3}|TempTlv4] ->
    {begin
Val1 = decode_restricted_string(V3, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute terminal-identifier(4) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131073,V4}|TempTlv5] ->
    {begin
Val2 = decode_restricted_string(V4, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 24 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute private-domain-name(5)   External PKIX-X400Address-2009:PrivateDomainName OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131074,V5}|TempTlv6] ->
    {'dec_PrivateDomainName'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute organization-name(6) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{131075,V6}|TempTlv7] ->
    {begin
Val3 = decode_restricted_string(V6, []),
C3 = byte_size(Val3),
if 1 =< C3, C3 =< 64 ->
binary_to_list(Val3);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

%%-------------------------------------------------
%% attribute numeric-user-identifier(7) with type NumericString OPTIONAL
%%-------------------------------------------------
{Term7,Tlv8} = case Tlv7 of
[{131076,V7}|TempTlv8] ->
    {begin
Val4 = decode_restricted_string(V7, []),
C4 = byte_size(Val4),
if 1 =< C4, C4 =< 32 ->
binary_to_list(Val4);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv8};
    _ ->
        { asn1_NOVALUE, Tlv7}
end,

%%-------------------------------------------------
%% attribute personal-name(8)   External PKIX-X400Address-2009:PersonalName OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{131077,V8}|TempTlv9] ->
    {'dec_PersonalName'(V8, []), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute organizational-unit-names(9)   External PKIX-X400Address-2009:OrganizationalUnitNames OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131078,V9}|TempTlv10] ->
    {'dec_OrganizationalUnitNames'(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

case Tlv10 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv10}}}) % extra fields not allowed
end,
Res1 = {'BuiltInStandardAttributes',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9},
Res1.


%%================================
%%  CountryName
%%================================
enc_CountryName(Val) ->
    enc_CountryName(Val, [<<97>>]).

enc_CountryName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'x121-dcc-code' ->
         encode_restricted_string(element(2,Val), [<<18>>]);
      'iso-3166-alpha2-code' ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_CountryName(Tlv) ->
   dec_CountryName(Tlv, [65537]).

dec_CountryName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'x121-dcc-code'
    {18, V1} -> 
        {'x121-dcc-code', begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if C1 =:= 3 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'iso-3166-alpha2-code'
    {19, V1} -> 
        {'iso-3166-alpha2-code', begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if C2 =:= 2 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  AdministrationDomainName
%%================================
enc_AdministrationDomainName(Val) ->
    enc_AdministrationDomainName(Val, [<<98>>]).

enc_AdministrationDomainName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      numeric ->
         encode_restricted_string(element(2,Val), [<<18>>]);
      printable ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_AdministrationDomainName(Tlv) ->
   dec_AdministrationDomainName(Tlv, [65538]).

dec_AdministrationDomainName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'numeric'
    {18, V1} -> 
        {numeric, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 0 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printable'
    {19, V1} -> 
        {printable, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 0 =< C2, C2 =< 16 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  NetworkAddress
%%================================
enc_NetworkAddress(Val) ->
    enc_NetworkAddress(Val, [<<18>>]).

enc_NetworkAddress(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_NetworkAddress(Tlv) ->
   dec_NetworkAddress(Tlv, [18]).

dec_NetworkAddress(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  X121Address
%%================================
enc_X121Address(Val) ->
    enc_X121Address(Val, [<<18>>]).

enc_X121Address(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_X121Address(Tlv) ->
   dec_X121Address(Tlv, [18]).

dec_X121Address(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  TerminalIdentifier
%%================================
enc_TerminalIdentifier(Val) ->
    enc_TerminalIdentifier(Val, [<<19>>]).

enc_TerminalIdentifier(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_TerminalIdentifier(Tlv) ->
   dec_TerminalIdentifier(Tlv, [19]).

dec_TerminalIdentifier(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 24 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  PrivateDomainName
%%================================
enc_PrivateDomainName(Val) ->
    enc_PrivateDomainName(Val, []).

enc_PrivateDomainName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      numeric ->
         encode_restricted_string(element(2,Val), [<<18>>]);
      printable ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_PrivateDomainName(Tlv) ->
   dec_PrivateDomainName(Tlv, []).

dec_PrivateDomainName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'numeric'
    {18, V1} -> 
        {numeric, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printable'
    {19, V1} -> 
        {printable, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 16 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  OrganizationName
%%================================
enc_OrganizationName(Val) ->
    enc_OrganizationName(Val, [<<19>>]).

enc_OrganizationName(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_OrganizationName(Tlv) ->
   dec_OrganizationName(Tlv, [19]).

dec_OrganizationName(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  NumericUserIdentifier
%%================================
enc_NumericUserIdentifier(Val) ->
    enc_NumericUserIdentifier(Val, [<<18>>]).

enc_NumericUserIdentifier(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_NumericUserIdentifier(Tlv) ->
   dec_NumericUserIdentifier(Tlv, [18]).

dec_NumericUserIdentifier(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 32 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  PersonalName
%%================================
enc_PersonalName(Val) ->
    enc_PersonalName(Val, [<<49>>]).

enc_PersonalName(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute surname(1) with type PrintableString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute given-name(2) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute initials(3) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute generation-qualifier(4) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<131>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PersonalName(Tlv) ->
   dec_PersonalName(Tlv, [17]).

dec_PersonalName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
SetFun = fun(FunTlv) ->
case FunTlv of 
      %surname
TTlv = {131072,_} ->
    {1, TTlv};
      %given-name
TTlv = {131073,_} ->
    {2, TTlv};
      %initials
TTlv = {131074,_} ->
    {3, TTlv};
      %generation-qualifier
TTlv = {131075,_} ->
    {4, TTlv};
      Else -> 
         {5, Else}
   end
   end,
PositionList = [SetFun(TempTlv)|| TempTlv <- Tlv1],
Tlv2 = [Stlv || {_,Stlv} <- lists:sort(PositionList)],

%%-------------------------------------------------
%% attribute surname(1) with type PrintableString
%%-------------------------------------------------
[V1|Tlv3] = Tlv2, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 40 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute given-name(2) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv4} = case Tlv3 of
[{131073,V2}|TempTlv4] ->
    {begin
Val2 = decode_restricted_string(V2, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 16 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute initials(3) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term3,Tlv5} = case Tlv4 of
[{131074,V3}|TempTlv5] ->
    {begin
Val3 = decode_restricted_string(V3, []),
C3 = byte_size(Val3),
if 1 =< C3, C3 =< 5 ->
binary_to_list(Val3);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute generation-qualifier(4) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term4,Tlv6} = case Tlv5 of
[{131075,V4}|TempTlv6] ->
    {begin
Val4 = decode_restricted_string(V4, []),
C4 = byte_size(Val4),
if 1 =< C4, C4 =< 3 ->
binary_to_list(Val4);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'PersonalName',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  OrganizationalUnitNames
%%================================
enc_OrganizationalUnitNames(Val) ->
    enc_OrganizationalUnitNames(Val, [<<48>>]).

enc_OrganizationalUnitNames(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_OrganizationalUnitNames_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_OrganizationalUnitNames_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_OrganizationalUnitNames_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<19>>]),
   'enc_OrganizationalUnitNames_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_OrganizationalUnitNames(Tlv) ->
   dec_OrganizationalUnitNames(Tlv, [16]).

dec_OrganizationalUnitNames(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
Val1 = decode_restricted_string(V1, [19]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 32 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end || V1 <- Tlv1].




%%================================
%%  OrganizationalUnitName
%%================================
enc_OrganizationalUnitName(Val) ->
    enc_OrganizationalUnitName(Val, [<<19>>]).

enc_OrganizationalUnitName(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_OrganizationalUnitName(Tlv) ->
   dec_OrganizationalUnitName(Tlv, [19]).

dec_OrganizationalUnitName(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 32 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  BuiltInDomainDefinedAttributes
%%================================
enc_BuiltInDomainDefinedAttributes(Val) ->
    enc_BuiltInDomainDefinedAttributes(Val, [<<48>>]).

enc_BuiltInDomainDefinedAttributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_BuiltInDomainDefinedAttributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_BuiltInDomainDefinedAttributes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_BuiltInDomainDefinedAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_BuiltInDomainDefinedAttribute'(H, [<<48>>]),
   'enc_BuiltInDomainDefinedAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_BuiltInDomainDefinedAttributes(Tlv) ->
   dec_BuiltInDomainDefinedAttributes(Tlv, [16]).

dec_BuiltInDomainDefinedAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_BuiltInDomainDefinedAttribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  BuiltInDomainDefinedAttribute
%%================================
enc_BuiltInDomainDefinedAttribute(Val) ->
    enc_BuiltInDomainDefinedAttribute(Val, [<<48>>]).

enc_BuiltInDomainDefinedAttribute(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type PrintableString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<19>>]),

%%-------------------------------------------------
%% attribute value(2) with type PrintableString
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<19>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_BuiltInDomainDefinedAttribute(Tlv) ->
   dec_BuiltInDomainDefinedAttribute(Tlv, [16]).

dec_BuiltInDomainDefinedAttribute(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type PrintableString
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [19]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 8 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute value(2) with type PrintableString
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_restricted_string(V2, [19]),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'BuiltInDomainDefinedAttribute',Term1,Term2},
Res1.


%%================================
%%  ExtensionAttributes
%%================================
enc_ExtensionAttributes(Val) ->
    enc_ExtensionAttributes(Val, [<<49>>]).

enc_ExtensionAttributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ExtensionAttributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ExtensionAttributes_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_ExtensionAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ExtensionAttribute'(H, [<<48>>]),
   'enc_ExtensionAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_ExtensionAttributes(Tlv) ->
   dec_ExtensionAttributes(Tlv, [17]).

dec_ExtensionAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_ExtensionAttribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  ExtensionAttribute
%%================================
enc_ExtensionAttribute(Val) ->
    enc_ExtensionAttribute(Val, [<<48>>]).

enc_ExtensionAttribute(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objextension_attribute_type = 
   'PKIX-X400Address-2009':'getenc_SupportedExtensionAttributes'(                                   Cindex1),

%%-------------------------------------------------
%% attribute extension-attribute-type(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute extension-attribute-value(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = Objextension_attribute_type('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [<<161>>])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ExtensionAttribute(Tlv) ->
   dec_ExtensionAttribute(Tlv, [16]).

dec_ExtensionAttribute(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extension-attribute-type(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 256 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute extension-attribute-value(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, [131073]),

DecObjextension_attribute_typeTerm1 =
   'PKIX-X400Address-2009':'getdec_SupportedExtensionAttributes'(Term1),
Term2 = 
   case (catch DecObjextension_attribute_typeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ExtensionAttribute',Term1,Term2},
Res1.


%%================================
%%  TeletexOrganizationalUnitName
%%================================
enc_TeletexOrganizationalUnitName(Val) ->
    enc_TeletexOrganizationalUnitName(Val, [<<20>>]).

enc_TeletexOrganizationalUnitName(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_TeletexOrganizationalUnitName(Tlv) ->
   dec_TeletexOrganizationalUnitName(Tlv, [20]).

dec_TeletexOrganizationalUnitName(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 32 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  PDSParameter
%%================================
enc_PDSParameter(Val) ->
    enc_PDSParameter(Val, [<<49>>]).

enc_PDSParameter(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute printable-string(1) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<19>>])
       end,

%%-------------------------------------------------
%% attribute teletex-string(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<20>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PDSParameter(Tlv) ->
   dec_PDSParameter(Tlv, [17]).

dec_PDSParameter(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
SetFun = fun(FunTlv) ->
case FunTlv of 
      %printable-string
TTlv = {19,_} ->
    {1, TTlv};
      %teletex-string
TTlv = {20,_} ->
    {2, TTlv};
      Else -> 
         {3, Else}
   end
   end,
PositionList = [SetFun(TempTlv)|| TempTlv <- Tlv1],
Tlv2 = [Stlv || {_,Stlv} <- lists:sort(PositionList)],

%%-------------------------------------------------
%% attribute printable-string(1) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term1,Tlv3} = case Tlv2 of
[{19,V1}|TempTlv3] ->
    {begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 30 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute teletex-string(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv4} = case Tlv3 of
[{20,V2}|TempTlv4] ->
    {begin
Val2 = decode_restricted_string(V2, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 30 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'PDSParameter',Term1,Term2},
Res1.


%%================================
%%  PresentationAddress
%%================================
enc_PresentationAddress(Val) ->
    enc_PresentationAddress(Val, [<<48>>]).

enc_PresentationAddress(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute pSelector(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<4>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute sSelector(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<4>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute tSelector(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<4>>,<<162>>])
       end,

%%-------------------------------------------------
%% attribute nAddresses(4) with type SET OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_PresentationAddress_nAddresses'(Cindex4, [<<49>>,<<163>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PresentationAddress_nAddresses
%%================================
enc_PresentationAddress_nAddresses(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PresentationAddress_nAddresses_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PresentationAddress_nAddresses_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_PresentationAddress_nAddresses_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<4>>]),
   'enc_PresentationAddress_nAddresses_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PresentationAddress(Tlv) ->
   dec_PresentationAddress(Tlv, [16]).

dec_PresentationAddress(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pSelector(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {decode_octet_string(V1, [4]), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute sSelector(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_octet_string(V2, [4]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute tSelector(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_octet_string(V3, [4]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute nAddresses(4) with type SET OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_PresentationAddress_nAddresses'(V4, [131075,17]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'PresentationAddress',Term1,Term2,Term3,Term4},
Res1.
'dec_PresentationAddress_nAddresses'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_octet_string(V1, [4]) || V1 <- Tlv1].




%%================================
%%  TeletexDomainDefinedAttribute
%%================================
enc_TeletexDomainDefinedAttribute(Val) ->
    enc_TeletexDomainDefinedAttribute(Val, [<<48>>]).

enc_TeletexDomainDefinedAttribute(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type TeletexString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<20>>]),

%%-------------------------------------------------
%% attribute value(2) with type TeletexString
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<20>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TeletexDomainDefinedAttribute(Tlv) ->
   dec_TeletexDomainDefinedAttribute(Tlv, [16]).

dec_TeletexDomainDefinedAttribute(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type TeletexString
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [20]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 8 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute value(2) with type TeletexString
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_restricted_string(V2, [20]),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'TeletexDomainDefinedAttribute',Term1,Term2},
Res1.
'ub-match'() ->
128.

'ub-common-name-length'() ->
64.

'ub-country-name-alpha-length'() ->
2.

'ub-country-name-numeric-length'() ->
3.

'ub-domain-defined-attributes'() ->
4.

'ub-domain-defined-attribute-type-length'() ->
8.

'ub-domain-defined-attribute-value-length'() ->
128.

'ub-domain-name-length'() ->
16.

'ub-extension-attributes'() ->
256.

'ub-e163-4-number-length'() ->
15.

'ub-e163-4-sub-address-length'() ->
40.

'ub-generation-qualifier-length'() ->
3.

'ub-given-name-length'() ->
16.

'ub-initials-length'() ->
5.

'ub-integer-options'() ->
256.

'ub-numeric-user-id-length'() ->
32.

'ub-organization-name-length'() ->
64.

'ub-organizational-unit-name-length'() ->
32.

'ub-organizational-units'() ->
4.

'ub-pds-name-length'() ->
16.

'ub-pds-parameter-length'() ->
30.

'ub-pds-physical-address-lines'() ->
6.

'ub-postal-code-length'() ->
16.

'ub-surname-length'() ->
40.

'ub-terminal-id-length'() ->
24.

'ub-unformatted-address-length'() ->
180.

'ub-x121-address-length'() ->
16.




%%================================
%%  ea-commonName
%%================================
'enc_ea-commonName'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<19>>]).


'dec_ea-commonName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
Val1 = decode_restricted_string(Tlv, [19]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  ea-teletexCommonName
%%================================
'enc_ea-teletexCommonName'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<20>>]).


'dec_ea-teletexCommonName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
Val1 = decode_restricted_string(Tlv, [20]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.




%%================================
%%  ea-teletexOrganizationName
%%================================
'enc_ea-teletexOrganizationName'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<20>>]).


'dec_ea-teletexOrganizationName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
Val1 = decode_restricted_string(Tlv, [20]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.




%%================================
%%  ea-teletexPersonalName
%%================================
'enc_ea-teletexPersonalName'('Type', Val, _RestPrimFieldName) ->
   'enc_ea-teletexPersonalName_Type'(Val,[<<49>>]).



%%================================
%%  ea-teletexPersonalName_Type
%%================================
'enc_ea-teletexPersonalName_Type'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute surname(1) with type TeletexString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute given-name(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute initials(3) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute generation-qualifier(4) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<131>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).

'dec_ea-teletexPersonalName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ea-teletexPersonalName_Type'(Tlv,[17]).



'dec_ea-teletexPersonalName_Type'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
SetFun = fun(FunTlv) ->
case FunTlv of 
      %surname
TTlv = {131072,_} ->
    {1, TTlv};
      %given-name
TTlv = {131073,_} ->
    {2, TTlv};
      %initials
TTlv = {131074,_} ->
    {3, TTlv};
      %generation-qualifier
TTlv = {131075,_} ->
    {4, TTlv};
      Else -> 
         {5, Else}
   end
   end,
PositionList = [SetFun(TempTlv)|| TempTlv <- Tlv1],
Tlv2 = [Stlv || {_,Stlv} <- lists:sort(PositionList)],

%%-------------------------------------------------
%% attribute surname(1) with type TeletexString
%%-------------------------------------------------
[V1|Tlv3] = Tlv2, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 40 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute given-name(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv4} = case Tlv3 of
[{131073,V2}|TempTlv4] ->
    {begin
Val2 = decode_restricted_string(V2, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 16 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute initials(3) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term3,Tlv5} = case Tlv4 of
[{131074,V3}|TempTlv5] ->
    {begin
Val3 = decode_restricted_string(V3, []),
C3 = byte_size(Val3),
if 1 =< C3, C3 =< 5 ->
binary_to_list(Val3);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute generation-qualifier(4) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term4,Tlv6} = case Tlv5 of
[{131075,V4}|TempTlv6] ->
    {begin
Val4 = decode_restricted_string(V4, []),
C4 = byte_size(Val4),
if 1 =< C4, C4 =< 3 ->
binary_to_list(Val4);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'ea-teletexPersonalName_Type',Term1,Term2,Term3,Term4},
Res1.



%%================================
%%  ea-teletexOrganizationalUnitNames
%%================================
'enc_ea-teletexOrganizationalUnitNames'('Type', Val, _RestPrimFieldName) ->
   'enc_ea-teletexOrganizationalUnitNames_Type'(Val,[<<48>>]).



%%================================
%%  ea-teletexOrganizationalUnitNames_Type
%%================================
'enc_ea-teletexOrganizationalUnitNames_Type'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ea-teletexOrganizationalUnitNames_Type_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ea-teletexOrganizationalUnitNames_Type_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ea-teletexOrganizationalUnitNames_Type_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<20>>]),
   'enc_ea-teletexOrganizationalUnitNames_Type_components'(T,[EncBytes|AccBytes], AccLen + EncLen).


'dec_ea-teletexOrganizationalUnitNames'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ea-teletexOrganizationalUnitNames_Type'(Tlv,[16]).



'dec_ea-teletexOrganizationalUnitNames_Type'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
Val1 = decode_restricted_string(V1, [20]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 32 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end || V1 <- Tlv1].





%%================================
%%  ea-pDSName
%%================================
'enc_ea-pDSName'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<19>>]).


'dec_ea-pDSName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
Val1 = decode_restricted_string(Tlv, [19]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.




%%================================
%%  ea-physicalDeliveryCountryName
%%================================
'enc_ea-physicalDeliveryCountryName'('Type', Val, _RestPrimFieldName) ->
   'enc_ea-physicalDeliveryCountryName_Type'(Val,[]).



%%================================
%%  ea-physicalDeliveryCountryName_Type
%%================================
'enc_ea-physicalDeliveryCountryName_Type'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'x121-dcc-code' ->
         encode_restricted_string(element(2,Val), [<<18>>]);
      'iso-3166-alpha2-code' ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).



'dec_ea-physicalDeliveryCountryName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ea-physicalDeliveryCountryName_Type'(Tlv,[]).



'dec_ea-physicalDeliveryCountryName_Type'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'x121-dcc-code'
    {18, V1} -> 
        {'x121-dcc-code', begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if C1 =:= 3 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'iso-3166-alpha2-code'
    {19, V1} -> 
        {'iso-3166-alpha2-code', begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if C2 =:= 2 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.



%%================================
%%  ea-postalCode
%%================================
'enc_ea-postalCode'('Type', Val, _RestPrimFieldName) ->
   'enc_ea-postalCode_Type'(Val,[]).



%%================================
%%  ea-postalCode_Type
%%================================
'enc_ea-postalCode_Type'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'numeric-code' ->
         encode_restricted_string(element(2,Val), [<<18>>]);
      'printable-code' ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).



'dec_ea-postalCode'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ea-postalCode_Type'(Tlv,[]).



'dec_ea-postalCode_Type'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'numeric-code'
    {18, V1} -> 
        {'numeric-code', begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printable-code'
    {19, V1} -> 
        {'printable-code', begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 16 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.



%%================================
%%  ea-physicalDeliveryOfficeName
%%================================
'enc_ea-physicalDeliveryOfficeName'('Type', Val, _RestPrimFieldName) ->
   enc_PDSParameter(Val, [<<49>>]).


'dec_ea-physicalDeliveryOfficeName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PDSParameter(Tlv, [17]).




%%================================
%%  ea-physicalDeliveryOfficeNumber
%%================================
'enc_ea-physicalDeliveryOfficeNumber'('Type', Val, _RestPrimFieldName) ->
   enc_PDSParameter(Val, [<<49>>]).


'dec_ea-physicalDeliveryOfficeNumber'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PDSParameter(Tlv, [17]).




%%================================
%%  ea-extensionORAddressComponents
%%================================
'enc_ea-extensionORAddressComponents'('Type', Val, _RestPrimFieldName) ->
   enc_PDSParameter(Val, [<<49>>]).


'dec_ea-extensionORAddressComponents'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PDSParameter(Tlv, [17]).




%%================================
%%  ea-physicalDeliveryPersonalName
%%================================
'enc_ea-physicalDeliveryPersonalName'('Type', Val, _RestPrimFieldName) ->
   enc_PDSParameter(Val, [<<49>>]).


'dec_ea-physicalDeliveryPersonalName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PDSParameter(Tlv, [17]).




%%================================
%%  ea-physicalDeliveryOrganizationName
%%================================
'enc_ea-physicalDeliveryOrganizationName'('Type', Val, _RestPrimFieldName) ->
   enc_PDSParameter(Val, [<<49>>]).


'dec_ea-physicalDeliveryOrganizationName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PDSParameter(Tlv, [17]).




%%================================
%%  ea-extensionPhysicalDeliveryAddressComponents
%%================================
'enc_ea-extensionPhysicalDeliveryAddressComponents'('Type', Val, _RestPrimFieldName) ->
   enc_PDSParameter(Val, [<<49>>]).


'dec_ea-extensionPhysicalDeliveryAddressComponents'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PDSParameter(Tlv, [17]).




%%================================
%%  ea-unformattedPostalAddress
%%================================
'enc_ea-unformattedPostalAddress'('Type', Val, _RestPrimFieldName) ->
   'enc_ea-unformattedPostalAddress_Type'(Val,[<<49>>]).



%%================================
%%  ea-unformattedPostalAddress_Type
%%================================
'enc_ea-unformattedPostalAddress_Type'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute printable-address(1) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ea-unformattedPostalAddress_Type_printable-address'(Cindex1, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute teletex-string(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<20>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ea-unformattedPostalAddress_Type_printable-address
%%================================
'enc_ea-unformattedPostalAddress_Type_printable-address'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ea-unformattedPostalAddress_Type_printable-address_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ea-unformattedPostalAddress_Type_printable-address_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ea-unformattedPostalAddress_Type_printable-address_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<19>>]),
   'enc_ea-unformattedPostalAddress_Type_printable-address_components'(T,[EncBytes|AccBytes], AccLen + EncLen).


'dec_ea-unformattedPostalAddress'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ea-unformattedPostalAddress_Type'(Tlv,[17]).



'dec_ea-unformattedPostalAddress_Type'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
SetFun = fun(FunTlv) ->
case FunTlv of 
      %printable-address
TTlv = {16,_} ->
    {1, TTlv};
      %teletex-string
TTlv = {20,_} ->
    {2, TTlv};
      Else -> 
         {3, Else}
   end
   end,
PositionList = [SetFun(TempTlv)|| TempTlv <- Tlv1],
Tlv2 = [Stlv || {_,Stlv} <- lists:sort(PositionList)],

%%-------------------------------------------------
%% attribute printable-address(1) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term1,Tlv3} = case Tlv2 of
[{16,V1}|TempTlv3] ->
    {'dec_ea-unformattedPostalAddress_Type_printable-address'(V1, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute teletex-string(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv4} = case Tlv3 of
[{20,V2}|TempTlv4] ->
    {begin
Val1 = decode_restricted_string(V2, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 180 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'ea-unformattedPostalAddress_Type',Term1,Term2},
Res1.
'dec_ea-unformattedPostalAddress_Type_printable-address'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
Val1 = decode_restricted_string(V1, [19]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 30 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end || V1 <- Tlv1].





%%================================
%%  ea-streetAddress
%%================================
'enc_ea-streetAddress'('Type', Val, _RestPrimFieldName) ->
   enc_PDSParameter(Val, [<<49>>]).


'dec_ea-streetAddress'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PDSParameter(Tlv, [17]).




%%================================
%%  ea-postOfficeBoxAddress
%%================================
'enc_ea-postOfficeBoxAddress'('Type', Val, _RestPrimFieldName) ->
   enc_PDSParameter(Val, [<<49>>]).


'dec_ea-postOfficeBoxAddress'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PDSParameter(Tlv, [17]).




%%================================
%%  ea-posteRestanteAddress
%%================================
'enc_ea-posteRestanteAddress'('Type', Val, _RestPrimFieldName) ->
   enc_PDSParameter(Val, [<<49>>]).


'dec_ea-posteRestanteAddress'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PDSParameter(Tlv, [17]).




%%================================
%%  ea-uniquePostalName
%%================================
'enc_ea-uniquePostalName'('Type', Val, _RestPrimFieldName) ->
   enc_PDSParameter(Val, [<<49>>]).


'dec_ea-uniquePostalName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PDSParameter(Tlv, [17]).




%%================================
%%  ea-localPostalAttributes
%%================================
'enc_ea-localPostalAttributes'('Type', Val, _RestPrimFieldName) ->
   enc_PDSParameter(Val, [<<49>>]).


'dec_ea-localPostalAttributes'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PDSParameter(Tlv, [17]).




%%================================
%%  ea-extendedNetworkAddress
%%================================
'enc_ea-extendedNetworkAddress'('Type', Val, _RestPrimFieldName) ->
   'enc_ea-extendedNetworkAddress_Type'(Val,[]).



%%================================
%%  ea-extendedNetworkAddress_Type
%%================================
'enc_ea-extendedNetworkAddress_Type'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'e163-4-address' ->
         'enc_ea-extendedNetworkAddress_Type_e163-4-address'(element(2,Val), [<<48>>]);
      'psap-address' ->
         'enc_PresentationAddress'(element(2,Val), [<<160>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  ea-extendedNetworkAddress_Type_e163-4-address
%%================================
'enc_ea-extendedNetworkAddress_Type_e163-4-address'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute number(1) with type NumericString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute sub-address(2) with type NumericString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).

'dec_ea-extendedNetworkAddress'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ea-extendedNetworkAddress_Type'(Tlv,[]).



'dec_ea-extendedNetworkAddress_Type'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'e163-4-address'
    {16, V1} -> 
        {'e163-4-address', 'dec_ea-extendedNetworkAddress_Type_e163-4-address'(V1, [])};


%% 'psap-address'
    {131072, V1} -> 
        {'psap-address', 'dec_PresentationAddress'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_ea-extendedNetworkAddress_Type_e163-4-address'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute number(1) with type NumericString
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 15 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute sub-address(2) with type NumericString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_restricted_string(V2, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 40 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ea-extendedNetworkAddress_Type_e163-4-address',Term1,Term2},
Res1.



%%================================
%%  ea-terminalType
%%================================
'enc_ea-terminalType'('Type', Val, _RestPrimFieldName) ->
encode_integer(Val, [{telex,3},{teletex,4},{'g3-facsimile',5},{'g4-facsimile',6},{'ia5-terminal',7},{videotex,8}], [<<2>>]).


'dec_ea-terminalType'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
Val1 = decode_integer(Tlv, [2]),
if 0 =< Val1, Val1 =< 256 ->
Val2 = Val1,
number2name(Val2, [{telex,3},{teletex,4},{'g3-facsimile',5},{'g4-facsimile',6},{'ia5-terminal',7},{videotex,8}]);
true ->
exit({error,{asn1,bad_range}})
end
end.




%%================================
%%  ea-teletexDomainDefinedAttributes
%%================================
'enc_ea-teletexDomainDefinedAttributes'('Type', Val, _RestPrimFieldName) ->
   'enc_ea-teletexDomainDefinedAttributes_Type'(Val,[<<48>>]).



%%================================
%%  ea-teletexDomainDefinedAttributes_Type
%%================================
'enc_ea-teletexDomainDefinedAttributes_Type'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ea-teletexDomainDefinedAttributes_Type_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ea-teletexDomainDefinedAttributes_Type_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ea-teletexDomainDefinedAttributes_Type_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TeletexDomainDefinedAttribute'(H, [<<48>>]),
   'enc_ea-teletexDomainDefinedAttributes_Type_components'(T,[EncBytes|AccBytes], AccLen + EncLen).


'dec_ea-teletexDomainDefinedAttributes'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ea-teletexDomainDefinedAttributes_Type'(Tlv,[16]).



'dec_ea-teletexDomainDefinedAttributes_Type'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TeletexDomainDefinedAttribute'(V1, [16]) || V1 <- Tlv1].





%%================================
%%  SupportedExtensionAttributes
%%================================
getenc_SupportedExtensionAttributes(Id) when Id =:= 1 ->
    fun 'enc_ea-commonName'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 2 ->
    fun 'enc_ea-teletexCommonName'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 3 ->
    fun 'enc_ea-teletexOrganizationName'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 4 ->
    fun 'enc_ea-teletexPersonalName'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 5 ->
    fun 'enc_ea-teletexOrganizationalUnitNames'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 6 ->
    fun 'enc_ea-teletexDomainDefinedAttributes'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 7 ->
    fun 'enc_ea-pDSName'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 8 ->
    fun 'enc_ea-physicalDeliveryCountryName'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 9 ->
    fun 'enc_ea-postalCode'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 10 ->
    fun 'enc_ea-physicalDeliveryOfficeName'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 11 ->
    fun 'enc_ea-physicalDeliveryOfficeNumber'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 12 ->
    fun 'enc_ea-extensionORAddressComponents'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 13 ->
    fun 'enc_ea-physicalDeliveryPersonalName'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 14 ->
    fun 'enc_ea-physicalDeliveryOrganizationName'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 15 ->
    fun 'enc_ea-extensionPhysicalDeliveryAddressComponents'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 16 ->
    fun 'enc_ea-unformattedPostalAddress'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 17 ->
    fun 'enc_ea-streetAddress'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 18 ->
    fun 'enc_ea-postOfficeBoxAddress'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 19 ->
    fun 'enc_ea-posteRestanteAddress'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 20 ->
    fun 'enc_ea-uniquePostalName'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 21 ->
    fun 'enc_ea-localPostalAttributes'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 22 ->
    fun 'enc_ea-extendedNetworkAddress'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 23 ->
    fun 'enc_ea-terminalType'/3;
getenc_SupportedExtensionAttributes(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SupportedExtensionAttributes(Id) when Id =:= 1 ->
    fun 'dec_ea-commonName'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 2 ->
    fun 'dec_ea-teletexCommonName'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 3 ->
    fun 'dec_ea-teletexOrganizationName'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 4 ->
    fun 'dec_ea-teletexPersonalName'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 5 ->
    fun 'dec_ea-teletexOrganizationalUnitNames'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 6 ->
    fun 'dec_ea-teletexDomainDefinedAttributes'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 7 ->
    fun 'dec_ea-pDSName'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 8 ->
    fun 'dec_ea-physicalDeliveryCountryName'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 9 ->
    fun 'dec_ea-postalCode'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 10 ->
    fun 'dec_ea-physicalDeliveryOfficeName'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 11 ->
    fun 'dec_ea-physicalDeliveryOfficeNumber'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 12 ->
    fun 'dec_ea-extensionORAddressComponents'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 13 ->
    fun 'dec_ea-physicalDeliveryPersonalName'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 14 ->
    fun 'dec_ea-physicalDeliveryOrganizationName'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 15 ->
    fun 'dec_ea-extensionPhysicalDeliveryAddressComponents'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 16 ->
    fun 'dec_ea-unformattedPostalAddress'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 17 ->
    fun 'dec_ea-streetAddress'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 18 ->
    fun 'dec_ea-postOfficeBoxAddress'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 19 ->
    fun 'dec_ea-posteRestanteAddress'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 20 ->
    fun 'dec_ea-uniquePostalName'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 21 ->
    fun 'dec_ea-localPostalAttributes'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 22 ->
    fun 'dec_ea-extendedNetworkAddress'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 23 ->
    fun 'dec_ea-terminalType'/3;
getdec_SupportedExtensionAttributes(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

decode_restricted_string(Tlv, TagsIn) ->
    match_and_collect(Tlv, TagsIn).

dynamicsort_SETOF(ListOfEncVal) ->
    BinL =
        lists:map(fun(L) when is_list(L) ->
                         list_to_binary(L);
                     (B) ->
                         B
                  end,
                  ListOfEncVal),
    lists:sort(BinL).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_, NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error, {asn1, {encode_integer_namednumber, Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal, _} ->
            NamedVal;
        _ ->
            Int
    end.
