vcpkg_from_github(
  OUT_SOURCE_PATH SOURCE_PATH
  REPO intel/gpgmm
  REF v0.0.4
  SHA512 2ffc3c8299f2d10cb1c0013cd306ba45781a644fa0aa426ef1dfa616e4b53671461a376f65b7068b1ff8a4a2d1a6f9539664174eb5830ea6a760ef5e5d0fc6b0
  HEAD_REF main
)

vcpkg_cmake_configure(
  SOURCE_PATH "${SOURCE_PATH}"
  DISABLE_PARALLEL_CONFIGURE
  OPTIONS
      -DGPGMM_STANDALONE=OFF
      -DGPGMM_ENABLE_TESTS=OFF
      -DGPGMM_ENABLE_VK=OFF
)

vcpkg_cmake_install()

file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/include")
file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/share")

if(VCPKG_LIBRARY_LINKAGE STREQUAL "static")
  file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/bin" "${CURRENT_PACKAGES_DIR}/debug/bin")
endif()

file(GLOB GPGMM_INCLUDE "${SOURCE_PATH}/src/include/*.h")
file(COPY ${GPGMM_INCLUDE} DESTINATION "${CURRENT_PACKAGES_DIR}/include")

file(INSTALL "${SOURCE_PATH}/LICENSE" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}" RENAME copyright)
