!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubesyntax_value_real_types
  use cubetools_parameters
  use cubetools_structure
  use cubesyntax_messaging
  !
  public :: value_real_comm_t
  private
  !
  type value_real_comm_t
     type(standard_arg_t) :: value
     real(kind=real_k)    :: default
   contains
     procedure, public :: register => cubesyntax_value_real_comm_register
  end type value_real_comm_t
  !
contains
  !
  subroutine cubesyntax_value_real_comm_register(comm,name,default,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(value_real_comm_t), intent(inout) :: comm
    character(len=*),         intent(in)    :: name
    real(kind=real_k),        intent(in)    :: default
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='VALUE>REAL>COMM>REGISTER'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    comm%default = default
    call comm%value%register(&
         'VALUE',&
         trim(name)//' value',&
         'Default to ???',&
         code_arg_mandatory,&
         error)
    if (error) return
  end subroutine cubesyntax_value_real_comm_register
end module cubesyntax_value_real_types
! 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubesyntax_value_dble_types
  use cubetools_parameters
  use cubetools_structure
  use cubesyntax_messaging
  !
  public :: value_dble_comm_t
  private
  !
  type value_dble_comm_t
     type(standard_arg_t) :: value
     real(kind=dble_k)    :: default
   contains
     procedure, public :: register => cubesyntax_value_dble_comm_register
  end type value_dble_comm_t
  !
contains
  !
  subroutine cubesyntax_value_dble_comm_register(comm,name,default,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(value_dble_comm_t), intent(inout) :: comm
    character(len=*),         intent(in)    :: name
    real(kind=dble_k),        intent(in)    :: default
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='VALUE>DBLE>COMM>REGISTER'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    comm%default = default
    call comm%value%register(&
         'VALUE',&
         trim(name)//' value',&
         'Default to ???',&
         code_arg_mandatory,&
         error)
    if (error) return
  end subroutine cubesyntax_value_dble_comm_register
end module cubesyntax_value_dble_types
! 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubesyntax_value_strg_types
  !------------------------------------------------------------------------
  ! This one is special in order to be able to propose the "COMMAND strg"
  ! syntax. ***JP: This one may bring trouble when going to python
  !------------------------------------------------------------------------
  use cubetools_parameters
  use cubetools_structure
  use cubesyntax_messaging
  !
  public :: value_strg_comm_t,value_strg_user_t
  private
  !
  type value_strg_comm_t
     type(standard_arg_t)  :: value
     character(len=argu_l) :: default
     logical               :: mandatory
   contains
     procedure, public :: register => cubesyntax_value_strg_comm_register
     procedure, public :: parse    => cubesyntax_value_strg_comm_parse
  end type value_strg_comm_t
  !
  type value_strg_user_t
     logical               :: present = .false.
     character(len=argu_l) :: val     = strg_star
   contains
     procedure, public :: toprog => cubesyntax_value_strg_user_toprog
     procedure, public :: list   => cubesyntax_value_strg_user_list
  end type value_strg_user_t
  !
contains
  !
  subroutine cubesyntax_value_strg_comm_register(comm,name,abstract,default,mandatory,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(value_strg_comm_t), intent(inout) :: comm
    character(len=*),         intent(in)    :: name
    character(len=*),         intent(in)    :: abstract
    character(len=*),         intent(in)    :: default
    integer(kind=code_k),     intent(in)    :: mandatory
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='VALUE>STRG>COMM>REGISTER'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    comm%default = default
    comm%mandatory = mandatory.eq.code_arg_mandatory
    call comm%value%register(&
         name,&
         abstract,&
         'Default to '//trim(default),&
         mandatory,&
         error)
    if (error) return
  end subroutine cubesyntax_value_strg_comm_register
  !
  subroutine cubesyntax_value_strg_comm_parse(comm,line,key,user,error)
    use cubetools_structure
    use cubetools_primitive_opt
    !----------------------------------------------------------------------
    ! value
    !----------------------------------------------------------------------
    class(value_strg_comm_t), intent(in)    :: comm
    character(len=*),         intent(in)    :: line
    class(primitive_opt_t),   intent(in)    :: key
    type(value_strg_user_t),  intent(out)   :: user ! => Initialized!
    logical,                  intent(inout) :: error
    !
    !logical :: mandatory
    integer(kind=argu_k), parameter :: ival=1
    character(len=*), parameter :: rname='VALUE>STRG>COMM>PARSE'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    !***JP: Why isn't the following working?
    ! mandatory = comm%value%mandatory.eq.code_arg_mandatory
    !call cubetools_getarg(line,key,ival,user%val,mandatory,error)
    call cubetools_getarg(line,key,ival,user%val,comm%mandatory,error)
    if (error) return
  end subroutine cubesyntax_value_strg_comm_parse
  !
  !------------------------------------------------------------------------
  !
  subroutine cubesyntax_value_strg_user_toprog(user,comm,prog,error)
    use cubetools_user2prog
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(value_strg_user_t), intent(in)    :: user
    type(value_strg_comm_t),  intent(in)    :: comm
    character(len=*),         intent(inout) :: prog
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='VALUE>STRG>USER>TOPROG'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
!***JP: Something like the following could/would be desirable
!    call comm%value%present(line,user%present,error)
!    if (error) return
    call cubetools_user2prog_resolve_star(user%val,comm%default,prog,error)
    if (error) return
  end subroutine cubesyntax_value_strg_user_toprog
  !
  subroutine cubesyntax_value_strg_user_list(user,error)
    !----------------------------------------------------------------------
    ! Mostly for debugging purpose
    !----------------------------------------------------------------------
    class(value_strg_user_t), intent(in)    :: user 
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='VALUE>STRG>USER>LIST'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    print *,'PRESENT: ',user%present
    print *,'VALUE:   ',user%val
  end subroutine cubesyntax_value_strg_user_list
end module cubesyntax_value_strg_types
! 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubesyntax_value_keywordlist_types
  use cubetools_parameters
  use cubetools_structure
  use cubesyntax_messaging
  !
  public :: value_keywordlist_comm_t
  private
  !
  type value_keywordlist_comm_t
     type(keywordlist_comm_t), pointer :: value
     character(len=argu_l)             :: default
   contains
     procedure, public :: register => cubesyntax_value_keywordlist_comm_register
  end type value_keywordlist_comm_t
  !
contains
  !
  subroutine cubesyntax_value_keywordlist_comm_register(comm,name,default, &
    list,flexibl,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(value_keywordlist_comm_t), intent(inout) :: comm
    character(len=*),                intent(in)    :: name
    character(len=*),                intent(in)    :: default
    character(len=*),                intent(in)    :: list(:)
    logical,                         intent(in)    :: flexibl
    logical,                         intent(inout) :: error
    !
    type(keywordlist_comm_t) :: tool  ! Registering tool
    character(len=*), parameter :: rname='VALUE>KEYWORDLIST>COMM>REGISTER'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    comm%default = default
    call tool%register(&
         'KEYWORD',&
         trim(name)//' value',&
         'Default to '//trim(default),&
         code_arg_mandatory,&
         list,&
         flexibl,&
         comm%value,&  ! Pointer to the registered keywordlist_comm_t
         error)
    if (error) return
  end subroutine cubesyntax_value_keywordlist_comm_register
end module cubesyntax_value_keywordlist_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
