"""Generated message classes for cloudaicompanion version v1.

The AI-powered assistant for Google Cloud.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudaicompanion'


class AttributionContext(_messages.Message):
  r"""Represents citation and attribution context of the output.

  Fields:
    citationMetadata: Optional. Citation metadata of the output
  """

  citationMetadata = _messages.MessageField('CitationMetadata', 1)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class BackendResourcesContext(_messages.Message):
  r"""Represents ids of resources that the operation needs to reference or
  target. E.g. for BigQuery SQL generation, this could reference the Dataset
  or Table names (go/backend-resources-context-eg).

  Messages:
    AdditionalContextValue: Optional. Represents GCP product-specific backend
      resources context.

  Fields:
    additionalContext: Optional. Represents GCP product-specific backend
      resources context.
    fullResourceNames: The full resource names
      (https://cloud.google.com/apis/design/resource_names) of the GCP
      resources that are referenced or relevant to the Duet query. For
      example, a BigQuery SQL generation in the context of a particular
      BigQuery table would set this to: `//bigquery.googleapis.com/bigquery/v2
      /projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalContextValue(_messages.Message):
    r"""Optional. Represents GCP product-specific backend resources context.

    Messages:
      AdditionalProperty: An additional property for a AdditionalContextValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalContextValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContext = _messages.MessageField('AdditionalContextValue', 1)
  fullResourceNames = _messages.StringField(2, repeated=True)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class BooleanParameterArray(_messages.Message):
  r"""This message only contains a field of boolean array.

  Fields:
    booleanValues: Boolean array.
  """

  booleanValues = _messages.BooleanField(1, repeated=True)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CheckStatusRequest(_messages.Message):
  r"""Request message for EntitlementService.CheckStatus.

  Fields:
    experienceContext: Required. Duet AI experience to check an entitlement
      for.
  """

  experienceContext = _messages.MessageField('ExperienceContext', 1)


class CheckStatusResponse(_messages.Message):
  r"""Response message for EntitlementService.CheckStatus.

  Fields:
    entitled: Identifies whether the caller is eligible to access Duet AI.
  """

  entitled = _messages.BooleanField(1)


class CheckUserLicenseRequest(_messages.Message):
  r"""Request message for EntitlementService.CheckUserLicense.

  Fields:
    experienceContext: Duet AI experience to check an entitlement for.
  """

  experienceContext = _messages.MessageField('ExperienceContext', 1)


class CheckUserLicenseResponse(_messages.Message):
  r"""Response message for EntitlementService.CheckUserLicense.

  Fields:
    entitled: Identifies whether the caller is eligible to access Duet AI.
  """

  entitled = _messages.BooleanField(1)


class CitationEntry(_messages.Message):
  r"""Metadata of one citation. (named entry because of clash with code.proto)

  Fields:
    endIndex: Index in the prediction output where the citation ends
      (exclusive). Must be > start_index and < len(output).
    license: License associated with this recitation. If present, it refers to
      the license of the source of this citation. Possible licenses include
      code licenses, e.g., mit license.
    publicationDate: Publication date associated with this citation. If
      present, it refers to the date at which the source of this citation was
      published. Possible formats are YYYY, YYYY-MM, YYYY-MM-DD.
    startIndex: Index in the prediction output where the citation starts
      (inclusive). Must be >= 0 and < end_index.
    title: Title associated with this citation. If present, it refers to the
      title of the source of this citation. Possible titles include news
      titles, book titles, etc.
    url: URL associated with this citation. If present, this URL links to the
      webpage of the source of this citation. Possible URLs include news
      websites, GitHub repos, etc.
  """

  endIndex = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  license = _messages.StringField(2)
  publicationDate = _messages.StringField(3)
  startIndex = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  title = _messages.StringField(5)
  url = _messages.StringField(6)


class CitationMetadata(_messages.Message):
  r"""The schema of citations found in textual prediction outputs. Citations
  originate from various sources and indicate that these contents should be
  cited properly.

  Fields:
    citations: Metadata of all citations found in this prediction output.
  """

  citations = _messages.MessageField('CitationEntry', 1, repeated=True)


class ClientContext(_messages.Message):
  r"""Represents context about the UI client. Must NOT contain customer
  content.

  Messages:
    AdditionalContextValue: Optional. Represents GCP product-specific
      UI/client context.

  Fields:
    additionalContext: Optional. Represents GCP product-specific UI/client
      context.
    name: Optional. Name of the Duet plugin/UI running in the client space
    version: Optional. Duet plugin/UI version
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalContextValue(_messages.Message):
    r"""Optional. Represents GCP product-specific UI/client context.

    Messages:
      AdditionalProperty: An additional property for a AdditionalContextValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalContextValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContext = _messages.MessageField('AdditionalContextValue', 1)
  name = _messages.StringField(2)
  version = _messages.StringField(3)


class CloudSchedulerConfig(_messages.Message):
  r"""Cloud Scheduler Trigger configuration

  Fields:
    cronTab: Required. The cron tab of cloud scheduler trigger.
    errorMessage: Optional. When the job was deleted from Pantheon UI,
      error_message will be populated when Get/List integrations
    location: Required. The location where associated cloud scheduler job will
      be created
    serviceAccountEmail: Required. Service account used by Cloud Scheduler to
      trigger the integration at scheduled time
  """

  cronTab = _messages.StringField(1)
  errorMessage = _messages.StringField(2)
  location = _messages.StringField(3)
  serviceAccountEmail = _messages.StringField(4)


class CloudaicompanionProjectsCheckStatusRequest(_messages.Message):
  r"""A CloudaicompanionProjectsCheckStatusRequest object.

  Fields:
    checkStatusRequest: A CheckStatusRequest resource to be passed as the
      request body.
    project: Required. Project name formatted as projects/{project_id} or
      projects/{project_number}.
  """

  checkStatusRequest = _messages.MessageField('CheckStatusRequest', 1)
  project = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesCreateRequest
  object.

  Fields:
    codeRepositoryIndex: A CodeRepositoryIndex resource to be passed as the
      request body.
    codeRepositoryIndexId: Required. Id of the requesting object
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
  """

  codeRepositoryIndex = _messages.MessageField('CodeRepositoryIndex', 1)
  codeRepositoryIndexId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesDeleteRequest
  object.

  Fields:
    force: Optional. If set to true, any RepositoryGroups from this
      CodeRepositoryIndex will also be deleted. (Otherwise, the request will
      only work if the CodeRepositoryIndex has no RepositoryGroups.)
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesListRequest
  object.

  Fields:
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListCodeRepositoryIndexesRequest
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesPatchRequest
  object.

  Fields:
    codeRepositoryIndex: A CodeRepositoryIndex resource to be passed as the
      request body.
    name: Immutable. Identifier. name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the CodeRepositoryIndex resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field will be overwritten if it is in the mask. If
      the user does not provide a mask then all fields will be overwritten.
  """

  codeRepositoryIndex = _messages.MessageField('CodeRepositoryIndex', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  CreateRequest object.

  Fields:
    parent: Required. Value for parent.
    repositoryGroup: A RepositoryGroup resource to be passed as the request
      body.
    repositoryGroupId: Required. Id of the requesting object
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
  """

  parent = _messages.StringField(1, required=True)
  repositoryGroup = _messages.MessageField('RepositoryGroup', 2)
  repositoryGroupId = _messages.StringField(3)
  requestId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  DeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetIamPolicyRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  GetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  GetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  ListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListRepositoryGroupsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  PatchRequest object.

  Fields:
    name: Immutable. Identifier. name of resource
    repositoryGroup: A RepositoryGroup resource to be passed as the request
      body.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the RepositoryGroup resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  repositoryGroup = _messages.MessageField('RepositoryGroup', 2)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsSetIamPolicyRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  SetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  TestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudaicompanionProjectsLocationsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsInstancesCompleteCodeRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesCompleteCodeRequest object.

  Fields:
    codeCompletionRequest: A CodeCompletionRequest resource to be passed as
      the request body.
    instance: Required. The full name of the Instance resource for this
      completion request. Format:
      `projects/{project}/locations/{location}/instances/{instance}` Use the
      special 'default' name to refer to the default instance.
  """

  codeCompletionRequest = _messages.MessageField('CodeCompletionRequest', 1)
  instance = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsInstancesCompleteTaskRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesCompleteTaskRequest object.

  Fields:
    instance: Required. The full name of the Instance resource for this
      generation request. Format:
      `projects/{project}/locations/{location}/instances/{instance}` Use the
      special 'default' name to refer to the default instance.
    taskCompletionRequest: A TaskCompletionRequest resource to be passed as
      the request body.
  """

  instance = _messages.StringField(1, required=True)
  taskCompletionRequest = _messages.MessageField('TaskCompletionRequest', 2)


class CloudaicompanionProjectsLocationsInstancesGenerateCodeRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesGenerateCodeRequest object.

  Fields:
    codeGenerationRequest: A CodeGenerationRequest resource to be passed as
      the request body.
    instance: Required. The full name of the Instance resource for this
      generation request. Format:
      `projects/{project}/locations/{location}/instances/{instance}` Use the
      special 'default' name to refer to the default instance.
  """

  codeGenerationRequest = _messages.MessageField('CodeGenerationRequest', 1)
  instance = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsInstancesGenerateTextRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesGenerateTextRequest object.

  Fields:
    instance: Required. The full name of the Instance resource for this
      generation request. Format:
      `projects/{project}/locations/{location}/instances/{instance}` Use the
      special 'default' name to refer to the default instance.
    textGenerationRequest: A TextGenerationRequest resource to be passed as
      the request body.
  """

  instance = _messages.StringField(1, required=True)
  textGenerationRequest = _messages.MessageField('TextGenerationRequest', 2)


class CloudaicompanionProjectsLocationsInstancesServerStreamingCompleteTaskRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsInstancesServerStreamingCompleteTaskRequest
  object.

  Fields:
    name: Required. The full name of the Instance resource for this request.
      Format: `projects/{project}/locations/{location}/instances/{instance}`
      Use the special 'default' name to refer to the default instance.
    serverStreamingCompleteTaskRequest: A ServerStreamingCompleteTaskRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  serverStreamingCompleteTaskRequest = _messages.MessageField('ServerStreamingCompleteTaskRequest', 2)


class CloudaicompanionProjectsLocationsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class CloudaicompanionProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class CloudaicompanionProjectsSelfAssignLicenseRequest(_messages.Message):
  r"""A CloudaicompanionProjectsSelfAssignLicenseRequest object.

  Fields:
    parent: Required. Project name formatted as projects/{project_id} or
      projects/{project_number}.
    selfAssignLicenseRequest: A SelfAssignLicenseRequest resource to be passed
      as the request body.
  """

  parent = _messages.StringField(1, required=True)
  selfAssignLicenseRequest = _messages.MessageField('SelfAssignLicenseRequest', 2)


class CodeCompletionInput(_messages.Message):
  r"""Input format for Code Completion.

  Fields:
    prefix: Optional. The code/text snippet preceding the code completion
      prediction result.
    suffix: Optional. The code/text snippet following the end of code
      completion prediction result.
  """

  prefix = _messages.StringField(1)
  suffix = _messages.StringField(2)


class CodeCompletionOutput(_messages.Message):
  r"""Prediction output format for Code Completion.

  Fields:
    content: The generated text.
  """

  content = _messages.StringField(1)


class CodeCompletionRequest(_messages.Message):
  r"""Input to code completion.

  Fields:
    backendResourcesContext: The GCP resources that the code generation
      process needs to reference
    clientContext: Client context (e.g. IDE name, version, etc)
    experienceContext: Duet product context -- required
    input: Represents the raw input for inference. It will be modified as part
      of prompt engineering and other transforms before it is consumed by the
      LLM.
    inputDataContext: Additional user content not captured in the `input`
      field above
  """

  backendResourcesContext = _messages.MessageField('BackendResourcesContext', 1)
  clientContext = _messages.MessageField('ClientContext', 2)
  experienceContext = _messages.MessageField('ExperienceContext', 3)
  input = _messages.MessageField('CodeCompletionInput', 4)
  inputDataContext = _messages.MessageField('InputDataContext', 5)


class CodeCompletionResponse(_messages.Message):
  r"""Output of code completion.

  Fields:
    attributionContext: Attribution context
    displayContext: Output display context
    output: The generated code output.
    outputDataContext: Additional generated data
  """

  attributionContext = _messages.MessageField('AttributionContext', 1)
  displayContext = _messages.MessageField('DisplayContext', 2)
  output = _messages.MessageField('CodeCompletionOutput', 3)
  outputDataContext = _messages.MessageField('OutputDataContext', 4)


class CodeGenerationInput(_messages.Message):
  r"""Input format for Code Generation.

  Fields:
    prompt: Optional. The code/text snippet preceding the code generation
      prediction result.
  """

  prompt = _messages.StringField(1)


class CodeGenerationOutput(_messages.Message):
  r"""Prediction output format for Code Generation.

  Fields:
    content: The generated text.
  """

  content = _messages.StringField(1)


class CodeGenerationRequest(_messages.Message):
  r"""Input to code generation.

  Fields:
    backendResourcesContext: The GCP resources that the code generation
      process needs to reference
    clientContext: Client context (e.g. IDE name, version, etc)
    experienceContext: Duet product context -- required
    input: Represents the raw input for inference. It will be modified as part
      of prompt engineering and other transforms before it is consumed by the
      LLM.
    inputDataContext: Additional user content not captured in the `input`
      field above
  """

  backendResourcesContext = _messages.MessageField('BackendResourcesContext', 1)
  clientContext = _messages.MessageField('ClientContext', 2)
  experienceContext = _messages.MessageField('ExperienceContext', 3)
  input = _messages.MessageField('CodeGenerationInput', 4)
  inputDataContext = _messages.MessageField('InputDataContext', 5)


class CodeGenerationResponse(_messages.Message):
  r"""Output of code generation.

  Fields:
    attributionContext: Attribution context
    displayContext: Output display context
    output: The generated code output.
    outputDataContext: Additional generated data
  """

  attributionContext = _messages.MessageField('AttributionContext', 1)
  displayContext = _messages.MessageField('DisplayContext', 2)
  output = _messages.MessageField('CodeGenerationOutput', 3)
  outputDataContext = _messages.MessageField('OutputDataContext', 4)


class CodeRepositoryIndex(_messages.Message):
  r"""Message describing CodeRepositoryIndex object

  Enums:
    StateValueValuesEnum: Output only. Code Repository Index instance State

  Messages:
    LabelsValue: Optional. Labels as key value pairs

  Fields:
    createTime: Output only. Create time stamp
    kmsKey: Optional. Immutable. Customer-managed encryption key name, in the
      format projects/*/locations/*/keyRings/*/cryptoKeys/*.
    labels: Optional. Labels as key value pairs
    name: Immutable. Identifier. name of resource
    state: Output only. Code Repository Index instance State
    updateTime: Output only. Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Code Repository Index instance State

    Values:
      STATE_UNSPECIFIED: Not set.
      CREATING: Instance is being created.
      ACTIVE: Instance is active.
      DELETING: Instance is being deleted.
      SUSPENDED: Instance is suspended.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    SUSPENDED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  kmsKey = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  updateTime = _messages.StringField(6)


class DisplayContext(_messages.Message):
  r"""Represents context about the display requirements of the output.

  Messages:
    AdditionalContextValue: Optional. Represents GCP product specific
      UI/client context.

  Fields:
    additionalContext: Optional. Represents GCP product specific UI/client
      context.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalContextValue(_messages.Message):
    r"""Optional. Represents GCP product specific UI/client context.

    Messages:
      AdditionalProperty: An additional property for a AdditionalContextValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalContextValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContext = _messages.MessageField('AdditionalContextValue', 1)


class DoubleParameterArray(_messages.Message):
  r"""This message only contains a field of double number array.

  Fields:
    doubleValues: Double number array.
  """

  doubleValues = _messages.FloatField(1, repeated=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class ErrorCatcherConfig(_messages.Message):
  r"""Configuration detail of a error catch task

  Fields:
    description: Optional. User-provided description intended to give more
      business context about the error catcher config.
    errorCatcherId: Required. An error catcher id is string representation for
      the error catcher config. Within a workflow, error_catcher_id uniquely
      identifies an error catcher config among all error catcher configs for
      the workflow
    errorCatcherNumber: Required. A number to uniquely identify each error
      catcher config within the workflow on UI.
    label: Optional. The user created label for a particular error catcher.
      Optional.
    startErrorTasks: Required. The set of start tasks that are to be executed
      for the error catch flow
  """

  description = _messages.StringField(1)
  errorCatcherId = _messages.StringField(2)
  errorCatcherNumber = _messages.StringField(3)
  label = _messages.StringField(4)
  startErrorTasks = _messages.MessageField('NextTask', 5, repeated=True)


class EventParameter(_messages.Message):
  r"""This message is used for processing and persisting (when applicable) key
  value pair parameters for each event in the event bus.

  Fields:
    key: Key is used to retrieve the corresponding parameter value. This
      should be unique for a given fired event. These parameters must be
      predefined in the integration definition.
    value: Values for the defined keys. Each value can either be string, int,
      double or any proto message.
  """

  key = _messages.StringField(1)
  value = _messages.MessageField('ValueType', 2)


class ExperienceContext(_messages.Message):
  r"""The specific Duet product and flow a request belongs to. E.g. Appsheet
  code generation ("/appsheet/generate").

  Fields:
    experience: Required. The Duet experience that this request belongs to.
  """

  experience = _messages.StringField(1)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class InputDataContext(_messages.Message):
  r"""Intended to hold customer content over and above what is present in the
  `input` field.

  Messages:
    AdditionalContextValue: Optional. Represents GCP product-specific source
      code context.

  Fields:
    additionalContext: Optional. Represents GCP product-specific source code
      context.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalContextValue(_messages.Message):
    r"""Optional. Represents GCP product-specific source code context.

    Messages:
      AdditionalProperty: An additional property for a AdditionalContextValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalContextValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContext = _messages.MessageField('AdditionalContextValue', 1)


class IntParameterArray(_messages.Message):
  r"""This message only contains a field of integer array.

  Fields:
    intValues: Integer array.
  """

  intValues = _messages.IntegerField(1, repeated=True)


class IntegrationBranch(_messages.Message):
  r"""An integration branch skeleton containing basic fields which can be used
  to create an integration branch on the UI.

  Fields:
    branchCondition: The condition for the branch.
    explanation: Explanation of why this integration branch was generated.
    integrationParameters: The newly generated workflow parameters.
    taskConfigs: The newly generated tasks which can be branched into the
      current integration.
  """

  branchCondition = _messages.StringField(1)
  explanation = _messages.StringField(2)
  integrationParameters = _messages.MessageField('IntegrationParameter', 3, repeated=True)
  taskConfigs = _messages.MessageField('TaskConfig', 4, repeated=True)


class IntegrationBranchRequest(_messages.Message):
  r"""The request for generating an integration branch.

  Fields:
    branchCondition: Optional. The condition for the particular branch which
      the user selected.
    integrationParameters: Optional. A list of all the workflow parameters of
      the current integration.
    taskConfigs: Required. A list of all the tasks of the current integration.
  """

  branchCondition = _messages.StringField(1)
  integrationParameters = _messages.MessageField('IntegrationParameter', 2, repeated=True)
  taskConfigs = _messages.MessageField('TaskConfig', 3, repeated=True)


class IntegrationBranchResponse(_messages.Message):
  r"""The response containing an integration branch.

  Fields:
    integrationBranch: The integration branch returned by Duet
  """

  integrationBranch = _messages.MessageField('IntegrationBranch', 1)


class IntegrationDocumentRequest(_messages.Message):
  r"""The request for generating description of an integration.

  Fields:
    integrationVersion: Required. The current integrtion on the canvas.
  """

  integrationVersion = _messages.MessageField('IntegrationVersion', 1)


class IntegrationDocumentResponse(_messages.Message):
  r"""The response containing the integration description.

  Fields:
    document: The description of the integration returned by Duet AI.
  """

  document = _messages.StringField(1)


class IntegrationParameter(_messages.Message):
  r"""Integration Parameter is defined in the integration config and are used
  to provide information about data types of the expected parameters and
  provide any default values if needed. They can also be used to add custom
  attributes. These are static in nature and should not be used for dynamic
  event definition.

  Enums:
    DataTypeValueValuesEnum: Type of the parameter.
    InputOutputTypeValueValuesEnum: Specifies the input/output type for the
      parameter.

  Fields:
    dataType: Type of the parameter.
    defaultValue: Default values for the defined keys. Each value can either
      be string, int, double or any proto message or a serialized object.
    displayName: The name (without prefix) to be displayed in the UI for this
      parameter. E.g. if the key is "foo.bar.myName", then the name would be
      "myName".
    inputOutputType: Specifies the input/output type for the parameter.
    isTransient: Whether this parameter is a transient parameter.
    jsonSchema: This schema will be used to validate runtime JSON-typed values
      of this parameter.
    key: Key is used to retrieve the corresponding parameter value. This
      should be unique for a given fired event. These parameters must be
      predefined in the integration definition.
  """

  class DataTypeValueValuesEnum(_messages.Enum):
    r"""Type of the parameter.

    Values:
      INTEGRATION_PARAMETER_DATA_TYPE_UNSPECIFIED: Unspecified.
      STRING_VALUE: String.
      INT_VALUE: Integer.
      DOUBLE_VALUE: Double Number.
      BOOLEAN_VALUE: Boolean.
      STRING_ARRAY: String Array.
      INT_ARRAY: Integer Array.
      DOUBLE_ARRAY: Double Number Array.
      BOOLEAN_ARRAY: Boolean Array.
      JSON_VALUE: Json.
      PROTO_VALUE: Proto Value (Internal use only).
      PROTO_ARRAY: Proto Array (Internal use only).
    """
    INTEGRATION_PARAMETER_DATA_TYPE_UNSPECIFIED = 0
    STRING_VALUE = 1
    INT_VALUE = 2
    DOUBLE_VALUE = 3
    BOOLEAN_VALUE = 4
    STRING_ARRAY = 5
    INT_ARRAY = 6
    DOUBLE_ARRAY = 7
    BOOLEAN_ARRAY = 8
    JSON_VALUE = 9
    PROTO_VALUE = 10
    PROTO_ARRAY = 11

  class InputOutputTypeValueValuesEnum(_messages.Enum):
    r"""Specifies the input/output type for the parameter.

    Values:
      IN_OUT_TYPE_UNSPECIFIED: Default.
      IN: Input parameters for the integration. EventBus validates that these
        parameters exist in the integrations before execution.
      OUT: Output Parameters for the integration. EventBus will only return
        the integration parameters tagged with OUT in the response back.
      IN_OUT: Input and Output Parameters. These can be used as both input and
        output. EventBus will validate for the existence of these parameters
        before execution and will also return this parameter back in the
        response.
    """
    IN_OUT_TYPE_UNSPECIFIED = 0
    IN = 1
    OUT = 2
    IN_OUT = 3

  dataType = _messages.EnumField('DataTypeValueValuesEnum', 1)
  defaultValue = _messages.MessageField('ValueType', 2)
  displayName = _messages.StringField(3)
  inputOutputType = _messages.EnumField('InputOutputTypeValueValuesEnum', 4)
  isTransient = _messages.BooleanField(5)
  jsonSchema = _messages.StringField(6)
  key = _messages.StringField(7)


class IntegrationSkeleton(_messages.Message):
  r"""An integration skeleton containing basic fields which can be used to
  create an integration on the UI.

  Fields:
    explanation: Explanation of why this integration was generated.
    integrationVersion: The integration version containing basic triggers and
      tasks.
    name: The name of the integration.
    tag: Indicate the strategy/methodology used to generate the integration.
  """

  explanation = _messages.StringField(1)
  integrationVersion = _messages.MessageField('IntegrationVersion', 2)
  name = _messages.StringField(3)
  tag = _messages.StringField(4)


class IntegrationSkeletonsResponse(_messages.Message):
  r"""The response containing a list of integrations.

  Fields:
    skeletonIntegrations: The list of integration skeletons returned by Duet
      AI.
  """

  skeletonIntegrations = _messages.MessageField('IntegrationSkeleton', 1, repeated=True)


class IntegrationVersion(_messages.Message):
  r"""The integration version definition.

  Fields:
    description: Optional. The integration description.
    errorCatcherConfigs: Optional. Error Catch Task configuration for the
      integration. It's optional.
    integrationParameters: Optional. Parameters that are expected to be passed
      to the integration when an event is triggered. This consists of all the
      parameters that are expected in the integration execution. This gives
      the user the ability to provide default values, add information like PII
      and also provide data types of each parameter.
    name: Optional. Auto-generated primary key.
    taskConfigs: Optional. Task configuration for the integration. It's
      optional, but the integration doesn't do anything without task_configs.
    triggerConfigs: Optional. Trigger configurations.
  """

  description = _messages.StringField(1)
  errorCatcherConfigs = _messages.MessageField('ErrorCatcherConfig', 2, repeated=True)
  integrationParameters = _messages.MessageField('IntegrationParameter', 3, repeated=True)
  name = _messages.StringField(4)
  taskConfigs = _messages.MessageField('TaskConfig', 5, repeated=True)
  triggerConfigs = _messages.MessageField('TriggerConfig', 6, repeated=True)


class JavascriptRecommendation(_messages.Message):
  r"""Individual Javascript recommendation containing the task config with the
  new code, integration parameters and the explanation.

  Fields:
    explanation: The explanation of the Javascript code.
    integrationParameters: Optional. The list of the new integration
      parameters.
    taskConfig: Optional. The task config of the Javascript task.
  """

  explanation = _messages.StringField(1)
  integrationParameters = _messages.MessageField('IntegrationParameter', 2, repeated=True)
  taskConfig = _messages.MessageField('TaskConfig', 3)


class JavascriptRequest(_messages.Message):
  r"""Request message for Javascript Task using Gemini.

  Fields:
    integrationVersion: Required. The integration version which contains all
      the integration parameters, all triggers and tasks including the
      Javascript task.
    taskId: Required. The task id of the Javascript task.
    useCurrentScript: Optional. Whether to use the current javascript task
      config (JS code) to generate the Javascript code.
  """

  integrationVersion = _messages.MessageField('IntegrationVersion', 1)
  taskId = _messages.StringField(2)
  useCurrentScript = _messages.BooleanField(3)


class JavascriptResponse(_messages.Message):
  r"""Response message for Javascript Task using Gemini.

  Fields:
    recommendations: List of the Javascript recommendations.
  """

  recommendations = _messages.MessageField('JavascriptRecommendation', 1, repeated=True)


class ListCodeRepositoryIndexesResponse(_messages.Message):
  r"""Message for response to listing CodeRepositoryIndexes

  Fields:
    codeRepositoryIndexes: The list of CodeRepositoryIndex
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  codeRepositoryIndexes = _messages.MessageField('CodeRepositoryIndex', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListRepositoryGroupsResponse(_messages.Message):
  r"""Message for response to listing RepositoryGroups

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    repositoryGroups: The list of RepositoryGroup
  """

  nextPageToken = _messages.StringField(1)
  repositoryGroups = _messages.MessageField('RepositoryGroup', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class NextTask(_messages.Message):
  r"""The task that is next in line to be executed, if the condition specified
  evaluated to true.

  Fields:
    condition: Standard filter expression for this task to become an eligible
      next task.
    description: User-provided description intended to give additional
      business context about the task.
    displayName: User-provided label that is attached to this edge in the UI.
    taskConfigId: ID of the next task.
    taskId: Task number of the next task.
  """

  condition = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  taskConfigId = _messages.StringField(4)
  taskId = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OutputDataContext(_messages.Message):
  r"""Intended to hold LLM-generated content over and above what is present in
  the `predictions` field. E.g. tooltip instructions.

  Messages:
    AdditionalContextValue: Optional. Represents GCP product specific source
      code context.

  Fields:
    additionalContext: Optional. Represents GCP product specific source code
      context.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalContextValue(_messages.Message):
    r"""Optional. Represents GCP product specific source code context.

    Messages:
      AdditionalProperty: An additional property for a AdditionalContextValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalContextValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContext = _messages.MessageField('AdditionalContextValue', 1)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ReplaceTaskRequest(_messages.Message):
  r"""Message for Replace Task Scenario.

  Enums:
    TaskTypesValueListEntryValuesEnum:

  Fields:
    taskConfig: Required. The current task selected on the UI.
    taskTypes: The list of task types.
  """

  class TaskTypesValueListEntryValuesEnum(_messages.Enum):
    r"""TaskTypesValueListEntryValuesEnum enum type.

    Values:
      TASK_TYPE_UNSPECIFIED: Unspecified.
      CONNECTOR_TASK: Connector Task.
      REST_TASK: Rest task.
    """
    TASK_TYPE_UNSPECIFIED = 0
    CONNECTOR_TASK = 1
    REST_TASK = 2

  taskConfig = _messages.MessageField('TaskConfig', 1)
  taskTypes = _messages.EnumField('TaskTypesValueListEntryValuesEnum', 2, repeated=True)


class ReplaceTaskResponse(_messages.Message):
  r"""Response proto for task recommendations.

  Fields:
    taskConfigs: The list of recommended tasks.
    taskResponseStatus: The list of task response status based on the
      task_types in the request.
  """

  taskConfigs = _messages.MessageField('TaskConfig', 1, repeated=True)
  taskResponseStatus = _messages.MessageField('TaskResponseStatus', 2, repeated=True)


class Repository(_messages.Message):
  r"""Repository contains RAG indexing settings for the provided Git
  repository

  Fields:
    branchPattern: Required. The Git branch pattern used for indexing in RE2
      syntax. See https://github.com/google/re2/wiki/syntax for syntax.
    resource: Required. The DeveloperConnect repository full resource name,
      relative resource name or resource URL to be indexed.
  """

  branchPattern = _messages.StringField(1)
  resource = _messages.StringField(2)


class RepositoryGroup(_messages.Message):
  r"""Message describing RepositoryGroup object

  Messages:
    LabelsValue: Optional. Labels as key value pairs

  Fields:
    createTime: Output only. Create time stamp
    labels: Optional. Labels as key value pairs
    name: Immutable. Identifier. name of resource
    repositories: Required. List of repositories to group
    updateTime: Output only. Update time stamp
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  repositories = _messages.MessageField('Repository', 4, repeated=True)
  updateTime = _messages.StringField(5)


class SelfAssignLicenseRequest(_messages.Message):
  r"""Request message for EntitlementService.SelfAssignLicense.

  Fields:
    experienceContext: Duet AI experience to use to assign license for.
    validateOnly: Optional. The service validates the request without
      performing any mutations. Clients can set this to check if the self-
      assignment would succeed. The default is false. See
      https://google.aip.dev/163.
  """

  experienceContext = _messages.MessageField('ExperienceContext', 1)
  validateOnly = _messages.BooleanField(2)


class SelfAssignLicenseResponse(_messages.Message):
  r"""Response message for EntitlementService.SelfAssignLicense."""


class ServerStreamingCompleteTaskRequest(_messages.Message):
  r"""Input for task completion.

  Fields:
    backendResourcesContext: Optional. The GCP resources that the code
      generation process needs to reference
    clientContext: Optional. Client context (e.g. IDE name, version, etc)
    experienceContext: Required. Duet product context -- required
    input: Required. Represents the raw input for inference. It will be
      modified as part of prompt engineering and other transforms before it is
      consumed by the LLM.
    inputDataContext: Optional. Additional user content not captured in the
      `input` field above
  """

  backendResourcesContext = _messages.MessageField('BackendResourcesContext', 1)
  clientContext = _messages.MessageField('ClientContext', 2)
  experienceContext = _messages.MessageField('ExperienceContext', 3)
  input = _messages.MessageField('TaskCompletionInput', 4)
  inputDataContext = _messages.MessageField('InputDataContext', 5)


class ServerStreamingCompleteTaskResponse(_messages.Message):
  r"""Output of task completion.

  Fields:
    attributionContext: Attribution context.
    displayContext: Output display context.
    output: The task completion/chat output.
    outputDataContext: Additional generated data.
  """

  attributionContext = _messages.MessageField('AttributionContext', 1)
  displayContext = _messages.MessageField('DisplayContext', 2)
  output = _messages.MessageField('TaskCompletionOutput', 3)
  outputDataContext = _messages.MessageField('OutputDataContext', 4)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StringParameterArray(_messages.Message):
  r"""This message only contains a field of string array.

  Fields:
    stringValues: String array.
  """

  stringValues = _messages.StringField(1, repeated=True)


class TaskCompletionInput(_messages.Message):
  r"""Input format for Task completion/multi-turn chat coversation.

  Fields:
    messages: Optional. Chat messages between 2 users. The messages are
      ordered by time with the zed value (0) being the oldest message.
    preamble: Text that should be provided to the model first to ground the
      response.
  """

  messages = _messages.MessageField('TaskCompletionMessage', 1, repeated=True)
  preamble = _messages.StringField(2)


class TaskCompletionMessage(_messages.Message):
  r"""Represents a single message.

  Fields:
    author: Author tag for the turn.
    content: Text content of the task completion/chat message.
  """

  author = _messages.StringField(1)
  content = _messages.StringField(2)


class TaskCompletionOutput(_messages.Message):
  r"""Output format for task completion/multi-turn chat.

  Fields:
    messages: The task completion/chat result generated from given message.
  """

  messages = _messages.MessageField('TaskCompletionMessage', 1, repeated=True)


class TaskCompletionRequest(_messages.Message):
  r"""Input for task completion.

  Fields:
    backendResourcesContext: The GCP resources that the code generation
      process needs to reference
    clientContext: Client context (e.g. IDE name, version, etc)
    experienceContext: Duet product context -- required
    input: Represents the raw input for inference. It will be modified as part
      of prompt engineering and other transforms before it is consumed by the
      LLM.
    inputDataContext: Additional user content not captured in the `input`
      field above
  """

  backendResourcesContext = _messages.MessageField('BackendResourcesContext', 1)
  clientContext = _messages.MessageField('ClientContext', 2)
  experienceContext = _messages.MessageField('ExperienceContext', 3)
  input = _messages.MessageField('TaskCompletionInput', 4)
  inputDataContext = _messages.MessageField('InputDataContext', 5)


class TaskCompletionResponse(_messages.Message):
  r"""Output of task completion.

  Fields:
    attributionContext: Attribution context.
    displayContext: Output display context.
    output: The task completion/chat output.
    outputDataContext: Additional generated data.
  """

  attributionContext = _messages.MessageField('AttributionContext', 1)
  displayContext = _messages.MessageField('DisplayContext', 2)
  output = _messages.MessageField('TaskCompletionOutput', 3)
  outputDataContext = _messages.MessageField('OutputDataContext', 4)


class TaskConfig(_messages.Message):
  r"""The task configuration details. This is not the implementation of Task.
  There might be multiple TaskConfigs for the same Task.

  Enums:
    ExternalTaskTypeValueValuesEnum: Optional. External task type of the task

  Messages:
    ParametersValue: Optional. The customized parameters the user can pass to
      this task.

  Fields:
    description: Optional. User-provided description intended to give
      additional business context about the task.
    displayName: Optional. User-provided label that is attached to this
      TaskConfig in the UI.
    errorCatcherId: Optional. Optional Error catcher id of the error catch
      flow which will be executed when execution error happens in the task
    externalTaskType: Optional. External task type of the task
    nextTasks: Optional. The set of tasks that are next in line to be executed
      as per the execution graph defined for the parent event, specified by
      `event_config_id`. Each of these next tasks are executed only if the
      condition associated with them evaluates to true.
    parameters: Optional. The customized parameters the user can pass to this
      task.
    task: Optional. The name for the task.
    taskId: Required. The identifier of this task within its parent event
      config, specified by the client. This should be unique among all the
      tasks belong to the same event config. We use this field as the
      identifier to find next tasks (via field `next_tasks.task_id`).
  """

  class ExternalTaskTypeValueValuesEnum(_messages.Enum):
    r"""Optional. External task type of the task

    Values:
      EXTERNAL_TASK_TYPE_UNSPECIFIED: Default value. External task type is not
        specified
      NORMAL_TASK: Tasks belongs to the normal task flows
      ERROR_TASK: Task belongs to the error catch task flows
    """
    EXTERNAL_TASK_TYPE_UNSPECIFIED = 0
    NORMAL_TASK = 1
    ERROR_TASK = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. The customized parameters the user can pass to this task.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A EventParameter attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('EventParameter', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  errorCatcherId = _messages.StringField(3)
  externalTaskType = _messages.EnumField('ExternalTaskTypeValueValuesEnum', 4)
  nextTasks = _messages.MessageField('NextTask', 5, repeated=True)
  parameters = _messages.MessageField('ParametersValue', 6)
  task = _messages.StringField(7)
  taskId = _messages.StringField(8)


class TaskResponseStatus(_messages.Message):
  r"""Message for task response status.

  Enums:
    TaskTypeValueValuesEnum: The task type.

  Fields:
    errorMessage: The error message of the task response in case of failure.
    httpCode: The http code of the task response.
    taskType: The task type.
  """

  class TaskTypeValueValuesEnum(_messages.Enum):
    r"""The task type.

    Values:
      TASK_TYPE_UNSPECIFIED: Unspecified.
      CONNECTOR_TASK: Connector Task.
      REST_TASK: Rest task.
    """
    TASK_TYPE_UNSPECIFIED = 0
    CONNECTOR_TASK = 1
    REST_TASK = 2

  errorMessage = _messages.StringField(1)
  httpCode = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  taskType = _messages.EnumField('TaskTypeValueValuesEnum', 3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TextGenerationInput(_messages.Message):
  r"""Input format for Text Generation.

  Fields:
    prompt: The text snippet to make the predictions on.
  """

  prompt = _messages.StringField(1)


class TextGenerationOutput(_messages.Message):
  r"""Output format for Text Generation.

  Fields:
    content: The result generated from input text.
  """

  content = _messages.StringField(1)


class TextGenerationRequest(_messages.Message):
  r"""Input for text generation.

  Fields:
    backendResourcesContext: The GCP resources that the code generation
      process needs to reference
    clientContext: Client context (e.g. IDE name, version, etc)
    experienceContext: Duet product context -- required
    input: Represents the raw input for inference. It will be modified as part
      of prompt engineering and other transforms before it is consumed by the
      LLM.
    inputDataContext: Additional user content not captured in the `input`
      field above
  """

  backendResourcesContext = _messages.MessageField('BackendResourcesContext', 1)
  clientContext = _messages.MessageField('ClientContext', 2)
  experienceContext = _messages.MessageField('ExperienceContext', 3)
  input = _messages.MessageField('TextGenerationInput', 4)
  inputDataContext = _messages.MessageField('InputDataContext', 5)


class TextGenerationResponse(_messages.Message):
  r"""Output of text generation.

  Fields:
    attributionContext: Attribution context
    displayContext: Output display context
    output: The generated text output
    outputDataContext: Additional generated data
  """

  attributionContext = _messages.MessageField('AttributionContext', 1)
  displayContext = _messages.MessageField('DisplayContext', 2)
  output = _messages.MessageField('TextGenerationOutput', 3)
  outputDataContext = _messages.MessageField('OutputDataContext', 4)


class TriggerConfig(_messages.Message):
  r"""Configuration detail of a trigger.

  Enums:
    TriggerTypeValueValuesEnum: Optional. Type of trigger

  Messages:
    PropertiesValue: Optional. Configurable properties of the trigger, not to
      be confused with integration parameters. E.g. "name" is a property for
      API triggers and "subscription" is a property for Pub/sub triggers.

  Fields:
    cloudSchedulerConfig: Optional. Cloud Scheduler Trigger related metadata
    description: Optional. User-provided description intended to give
      additional business context about the task.
    errorCatcherId: Optional. Optional Error catcher id of the error catch
      flow which will be executed when execution error happens in the task
    label: Optional. The user created label for a particular trigger.
    properties: Optional. Configurable properties of the trigger, not to be
      confused with integration parameters. E.g. "name" is a property for API
      triggers and "subscription" is a property for Pub/sub triggers.
    startTasks: Optional. Set of tasks numbers from where the integration
      execution is started by this trigger. If this is empty, then integration
      is executed with default start tasks. In the list of start tasks, none
      of two tasks can have direct ancestor-descendant relationships (i.e. in
      a same integration execution graph).
    trigger: Optional. Name of the trigger. Example: "API Trigger", "Cloud Pub
      Sub Trigger" When set will be sent out to monitoring dashabord for
      tracking purpose.
    triggerId: Optional. The backend trigger ID.
    triggerNumber: Required. A number to uniquely identify each trigger config
      within the integration on UI.
    triggerType: Optional. Type of trigger
  """

  class TriggerTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Type of trigger

    Values:
      TRIGGER_TYPE_UNSPECIFIED: Unknown.
      CRON: Trigger by scheduled time.
      API: Trigger by API call.
      SFDC_CHANNEL: Trigger by Salesforce Channel.
      CLOUD_PUBSUB_EXTERNAL: Trigger by Pub/Sub external.
      SFDC_CDC_CHANNEL: SFDC Channel Trigger for CDC.
      CLOUD_SCHEDULER: Trigger by Cloud Scheduler job.
      INTEGRATION_CONNECTOR_TRIGGER: Trigger by Connector Event
      PRIVATE_TRIGGER: Trigger for private workflow
    """
    TRIGGER_TYPE_UNSPECIFIED = 0
    CRON = 1
    API = 2
    SFDC_CHANNEL = 3
    CLOUD_PUBSUB_EXTERNAL = 4
    SFDC_CDC_CHANNEL = 5
    CLOUD_SCHEDULER = 6
    INTEGRATION_CONNECTOR_TRIGGER = 7
    PRIVATE_TRIGGER = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. Configurable properties of the trigger, not to be confused
    with integration parameters. E.g. "name" is a property for API triggers
    and "subscription" is a property for Pub/sub triggers.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cloudSchedulerConfig = _messages.MessageField('CloudSchedulerConfig', 1)
  description = _messages.StringField(2)
  errorCatcherId = _messages.StringField(3)
  label = _messages.StringField(4)
  properties = _messages.MessageField('PropertiesValue', 5)
  startTasks = _messages.MessageField('NextTask', 6, repeated=True)
  trigger = _messages.StringField(7)
  triggerId = _messages.StringField(8)
  triggerNumber = _messages.StringField(9)
  triggerType = _messages.EnumField('TriggerTypeValueValuesEnum', 10)


class ValueType(_messages.Message):
  r"""The type of the parameter.

  Fields:
    booleanArray: Boolean Array.
    booleanValue: Boolean.
    doubleArray: Double Number Array.
    doubleValue: Double Number.
    intArray: Integer Array.
    intValue: Integer.
    jsonValue: Json.
    stringArray: String Array.
    stringValue: String.
  """

  booleanArray = _messages.MessageField('BooleanParameterArray', 1)
  booleanValue = _messages.BooleanField(2)
  doubleArray = _messages.MessageField('DoubleParameterArray', 3)
  doubleValue = _messages.FloatField(4)
  intArray = _messages.MessageField('IntParameterArray', 5)
  intValue = _messages.IntegerField(6)
  jsonValue = _messages.StringField(7)
  stringArray = _messages.MessageField('StringParameterArray', 8)
  stringValue = _messages.StringField(9)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
encoding.AddCustomJsonFieldMapping(
    CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
