/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProvider;
import org.gradle.api.internal.artifacts.transform.ArtifactVariantSelector;
import org.gradle.api.internal.artifacts.transform.AttributeMatchingArtifactVariantSelector;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedVariantFinder;
import org.gradle.api.internal.artifacts.transform.DefaultTransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.artifacts.transform.VariantSelectorFactory;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.operations.dependencies.configurations.ConfigurationIdentity;

public class DefaultVariantSelectorFactory
implements VariantSelectorFactory {
    private final ConsumerProvidedVariantFinder consumerProvidedVariantFinder;
    private final ImmutableAttributesFactory attributesFactory;
    private final AttributeSchemaServices attributeSchemaServices;
    private final TransformedVariantFactory transformedVariantFactory;
    private final ResolutionFailureHandler failureProcessor;
    private final DomainObjectContext domainObjectContext;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final TaskDependencyFactory taskDependencyFactory;

    @Inject
    public DefaultVariantSelectorFactory(ConsumerProvidedVariantFinder consumerProvidedVariantFinder, ImmutableAttributesFactory attributesFactory, AttributeSchemaServices attributeSchemaServices, TransformedVariantFactory transformedVariantFactory, ResolutionFailureHandler failureProcessor, DomainObjectContext domainObjectContext, CalculatedValueContainerFactory calculatedValueContainerFactory, TaskDependencyFactory taskDependencyFactory) {
        this.consumerProvidedVariantFinder = consumerProvidedVariantFinder;
        this.attributesFactory = attributesFactory;
        this.attributeSchemaServices = attributeSchemaServices;
        this.transformedVariantFactory = transformedVariantFactory;
        this.failureProcessor = failureProcessor;
        this.domainObjectContext = domainObjectContext;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    @Override
    public ArtifactVariantSelector create(ResolutionHost resolutionHost, ImmutableAttributes requestAttributes, ImmutableAttributesSchema consumerSchema, @Nullable ConfigurationIdentity configurationId, ResolutionStrategy.SortOrder artifactDependencySortOrder, ResolutionResultProvider<ResolverResults> resolverResults, ResolutionResultProvider<ResolverResults> strictResolverResults) {
        DefaultTransformUpstreamDependenciesResolver dependenciesResolver = new DefaultTransformUpstreamDependenciesResolver(resolutionHost, configurationId, requestAttributes, artifactDependencySortOrder, strictResolverResults, resolverResults, this.domainObjectContext, this.calculatedValueContainerFactory, this.attributesFactory, this.taskDependencyFactory);
        return new AttributeMatchingArtifactVariantSelector(consumerSchema, dependenciesResolver, this.consumerProvidedVariantFinder, this.attributesFactory, this.attributeSchemaServices, this.transformedVariantFactory, this.failureProcessor);
    }
}

