/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instrumentation.api.jvmbytecode;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.internal.instrumentation.api.jvmbytecode.BridgeMethodBuilder;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;
import org.gradle.model.internal.asm.MethodVisitorScope;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class DefaultBridgeMethodBuilder
implements BridgeMethodBuilder {
    private static final Type VISITOR_CONTEXT_TYPE = Type.getType(BytecodeInterceptorFilter.class);
    private final String bridgeDesc;
    private final String interceptorOwner;
    private final String interceptorName;
    private final String interceptorDesc;
    private boolean hasKotlinDefaultMask;
    @Nullable
    private String binaryClassName;
    @Nullable
    private BytecodeInterceptorFilter context;

    public static DefaultBridgeMethodBuilder create(int originalTag, String originalOwner, String originalDesc, String interceptorOwner, String interceptorName, String interceptorDesc) {
        String bridgeDesc = DefaultBridgeMethodBuilder.buildBridgeDescriptor(originalTag, originalOwner, originalDesc);
        if (originalTag == 8) {
            if (Type.getMethodType((String)interceptorDesc).getReturnType().getSort() != 0) {
                throw new IllegalArgumentException(String.format("Cannot intercept constructor %s of %s with a non-void returning method %s.%s(%s)!", originalDesc, originalOwner, interceptorOwner, interceptorName, interceptorDesc));
            }
            return new ConstructorBridgeMethodBuilder(originalOwner, originalDesc, bridgeDesc, interceptorOwner, interceptorName, interceptorDesc);
        }
        return new DefaultBridgeMethodBuilder(bridgeDesc, interceptorOwner, interceptorName, interceptorDesc);
    }

    private DefaultBridgeMethodBuilder(String bridgeDesc, String interceptorOwner, String interceptorName, String interceptorDesc) {
        this.bridgeDesc = bridgeDesc;
        this.interceptorOwner = interceptorOwner;
        this.interceptorName = interceptorName;
        this.interceptorDesc = interceptorDesc;
    }

    public final DefaultBridgeMethodBuilder withKotlinDefaultMask() {
        this.hasKotlinDefaultMask = true;
        return this;
    }

    public final DefaultBridgeMethodBuilder withClassName(String className) {
        this.binaryClassName = Type.getObjectType((String)className).getClassName();
        return this;
    }

    public final DefaultBridgeMethodBuilder withVisitorContext(BytecodeInterceptorFilter context) {
        this.context = context;
        return this;
    }

    @Override
    public final String getBridgeMethodDescriptor() {
        return this.bridgeDesc;
    }

    @Override
    public final void buildBridgeMethod(MethodVisitor methodVisitor) {
        MethodVisitorScope mv = new MethodVisitorScope(methodVisitor);
        this.buildBridgeMethodImpl(mv);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildBridgeMethodImpl(MethodVisitorScope mv) {
        this.copyBridgeMethodArgsOnStack(mv);
        if (this.hasKotlinDefaultMask) {
            mv._LDC((Object)0);
        }
        if (this.binaryClassName != null) {
            mv._LDC((Object)this.binaryClassName);
        }
        if (this.context != null) {
            mv._GETSTATIC(VISITOR_CONTEXT_TYPE, this.context.name(), VISITOR_CONTEXT_TYPE.getDescriptor());
        }
        mv._INVOKESTATIC(this.interceptorOwner, this.interceptorName, this.interceptorDesc);
        mv._IRETURN_OF(this.getBridgeMethod().getReturnType());
    }

    protected final void copyBridgeMethodArgsOnStack(MethodVisitorScope mv) {
        Type[] args = this.getBridgeMethod().getArgumentTypes();
        for (int i = 0; i < args.length; ++i) {
            mv._ILOAD_OF(args[i], i);
        }
    }

    @Nonnull
    private Type getBridgeMethod() {
        return Type.getMethodType((String)this.bridgeDesc);
    }

    private static String buildBridgeDescriptor(int tag, String owner, String desc) {
        switch (tag) {
            case 6: {
                return desc;
            }
            case 8: {
                Type originalOwner = Type.getObjectType((String)owner);
                Type originalMethodType = Type.getMethodType((String)desc);
                return Type.getMethodDescriptor((Type)originalOwner, (Type[])originalMethodType.getArgumentTypes());
            }
            case 5: 
            case 9: {
                Type originalOwner = Type.getObjectType((String)owner);
                Type originalMethodType = Type.getMethodType((String)desc);
                ArrayList<Type> interceptorArguments = new ArrayList<Type>(originalMethodType.getArgumentCount() + 1);
                interceptorArguments.add(originalOwner);
                interceptorArguments.addAll(Arrays.asList(originalMethodType.getArgumentTypes()));
                return Type.getMethodDescriptor((Type)originalMethodType.getReturnType(), (Type[])interceptorArguments.toArray(new Type[0]));
            }
        }
        throw new IllegalArgumentException("Unsupported tag " + tag);
    }

    private static class ConstructorBridgeMethodBuilder
    extends DefaultBridgeMethodBuilder {
        private final String originalOwner;
        private final String originalConstructorDesc;

        private ConstructorBridgeMethodBuilder(String originalOwner, String originalConstructorDesc, String bridgeDesc, String interceptorOwner, String interceptorName, String interceptorDesc) {
            super(bridgeDesc, interceptorOwner, interceptorName, interceptorDesc);
            this.originalOwner = originalOwner;
            this.originalConstructorDesc = originalConstructorDesc;
        }

        @Override
        protected void buildBridgeMethodImpl(MethodVisitorScope mv) {
            Type ownerType = Type.getObjectType((String)this.originalOwner);
            mv._NEW(ownerType);
            mv._DUP();
            this.copyBridgeMethodArgsOnStack(mv);
            mv._INVOKESPECIAL(ownerType, "<init>", this.originalConstructorDesc);
            mv._DUP();
            super.buildBridgeMethodImpl(mv);
        }
    }
}

