/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.fileevents;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.ThreadSafe;
import net.rubygrapefruit.platform.internal.LibraryDef;
import net.rubygrapefruit.platform.internal.NativeLibraryLocator;
import net.rubygrapefruit.platform.internal.Platform;
import org.gradle.fileevents.internal.AbstractNativeFileEventFunctions;
import org.gradle.fileevents.internal.LinuxFileEventFunctions;
import org.gradle.fileevents.internal.OsxFileEventFunctions;
import org.gradle.fileevents.internal.WindowsFileEventFunctions;

@ThreadSafe
public class FileEvents {
    private static final Map<Class<?>, Object> integrations = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public static void init(File extractDir) throws NativeException {
        Class<FileEvents> clazz = FileEvents.class;
        synchronized (FileEvents.class) {
            Platform platform = Platform.current();
            String platformName = FileEvents.getPlatformName(platform);
            try {
                NativeLibraryLocator loader = new NativeLibraryLocator(extractDir, "0.2.5");
                File library = loader.find(new LibraryDef(FileEvents.determineLibraryName(platform), platformName));
                if (library == null) {
                    throw new NativeIntegrationUnavailableException(String.format("Native file events integration is not available for %s.", platform));
                }
                System.load(library.getCanonicalPath());
                String nativeVersion = AbstractNativeFileEventFunctions.getVersion();
                if (!nativeVersion.equals("0.2.5")) {
                    throw new NativeException(String.format("Unexpected file events library version loaded. Expected %s, was %s.", "0.2.5", nativeVersion));
                }
            }
            catch (NativeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NativeException("Failed to initialise native integration.", t);
            }
            return;
        }
    }

    private static String getPlatformName(Platform platform) {
        switch (platform.getId()) {
            case "windows-i386": {
                return "i386-windows-gnu";
            }
            case "windows-amd64": {
                return "x86_64-windows-gnu";
            }
            case "windows-aarch64": {
                return "aarch64-windows-gnu";
            }
            case "linux-i386": {
                return "i386-linux-" + FileEvents.getLinuxVariant();
            }
            case "linux-amd64": {
                return "x86_64-linux-" + FileEvents.getLinuxVariant();
            }
            case "linux-aarch64": {
                return "aarch64-linux-" + FileEvents.getLinuxVariant();
            }
            case "osx-amd64": {
                return "x86_64-macos";
            }
            case "osx-aarch64": {
                return "aarch64-macos";
            }
        }
        throw new NativeIntegrationUnavailableException(String.format("Native file events integration is not available for %s.", platform));
    }

    private static String getLinuxVariant() {
        return FileEvents.isLinuxWithMusl() ? "musl" : "gnu";
    }

    private static boolean isLinuxWithMusl() {
        try {
            File mapFilesDir = new File("/proc/self/map_files");
            if (!mapFilesDir.isDirectory()) {
                return false;
            }
            File[] files = mapFilesDir.listFiles();
            if (files == null) {
                return false;
            }
            for (File file : files) {
                if (!file.getCanonicalFile().getName().contains("-musl-")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public static <T extends NativeIntegration> T get(Class<T> type) throws NativeIntegrationUnavailableException, NativeException {
        FileEvents.init(null);
        Class<FileEvents> clazz = FileEvents.class;
        synchronized (FileEvents.class) {
            Platform platform = Platform.current();
            Object instance = integrations.get(type);
            if (instance == null) {
                try {
                    instance = FileEvents.getEventFunctions(type, platform);
                }
                catch (NativeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new NativeException(String.format("Failed to load native integration %s.", type.getSimpleName()), t);
                }
                integrations.put(type, instance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (T)((NativeIntegration)type.cast(instance));
        }
    }

    private static <T extends NativeIntegration> T getEventFunctions(Class<T> type, Platform platform) {
        if (platform.isWindows() && type.equals(WindowsFileEventFunctions.class)) {
            return (T)((NativeIntegration)type.cast(new WindowsFileEventFunctions()));
        }
        if (platform.isLinux() && type.equals(LinuxFileEventFunctions.class)) {
            return (T)((NativeIntegration)type.cast(new LinuxFileEventFunctions()));
        }
        if (platform.isMacOs() && type.equals(OsxFileEventFunctions.class)) {
            return (T)((NativeIntegration)type.cast(new OsxFileEventFunctions()));
        }
        throw new NativeIntegrationUnavailableException(String.format("Native integration %s is not supported for %s.", type.getSimpleName(), platform.toString()));
    }

    private static String determineLibraryName(Platform platform) {
        if (platform.isLinux()) {
            return "libgradle-fileevents.so";
        }
        if (platform.isMacOs()) {
            return "libgradle-fileevents.dylib";
        }
        if (platform.isWindows()) {
            return "gradle-fileevents.dll";
        }
        throw new NativeIntegrationUnavailableException(String.format("Native file events integration is not available for %s.", platform));
    }
}

