/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.deprecation.DocumentedFailure;

public class VariantIdentityUniquenessVerifier {
    public static VerificationReport buildReport(ConfigurationsProvider configurations) {
        ListMultimap byIdentity = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        configurations.visitAll(configuration -> {
            if (!VariantIdentityUniquenessVerifier.mustHaveUniqueAttributes(configuration)) {
                return;
            }
            byIdentity.put((Object)VariantIdentity.from(configuration), configuration);
        });
        return new VerificationReport(byIdentity);
    }

    private static boolean mustHaveUniqueAttributes(Configuration configuration) {
        return configuration.isCanBeConsumed() && !configuration.isCanBeResolved() && !"default".equals(configuration.getName()) && !configuration.getAttributes().isEmpty();
    }

    public static class VerificationReport {
        private final ListMultimap<VariantIdentity, ConfigurationInternal> byIdentity;

        private VerificationReport(ListMultimap<VariantIdentity, ConfigurationInternal> byIdentity) {
            this.byIdentity = byIdentity;
        }

        @Nullable
        public GradleException failureFor(ConfigurationInternal configuration, boolean withTaskAdvice) {
            List<ConfigurationInternal> collisions = this.byIdentity.get((Object)VariantIdentity.from(configuration)).stream().filter(it -> !it.getName().equals(configuration.getName())).collect(Collectors.toList());
            if (collisions.isEmpty()) {
                return null;
            }
            return VerificationReport.buildFailure(configuration, withTaskAdvice, collisions);
        }

        public void assertNoConflicts() {
            for (VariantIdentity identity : this.byIdentity.keySet()) {
                List collisions = this.byIdentity.get((Object)identity);
                if (collisions.size() <= 1) continue;
                ConfigurationInternal configuration = (ConfigurationInternal)collisions.get(0);
                List<ConfigurationInternal> filtered = this.byIdentity.get((Object)identity).stream().filter(it -> !it.getName().equals(configuration.getName())).collect(Collectors.toList());
                throw VerificationReport.buildFailure(configuration, true, filtered);
            }
        }

        private static GradleException buildFailure(ConfigurationInternal configuration, boolean withTaskAdvice, List<ConfigurationInternal> collisions) {
            DocumentedFailure.Builder builder = DocumentedFailure.builder();
            String advice = "Consider adding an additional attribute to one of the configurations to disambiguate them.";
            if (withTaskAdvice) {
                advice = advice + "  Run the 'outgoingVariants' task for more details.";
            }
            String message = "Consumable configurations with identical capabilities within a project (other than the default configuration) must have unique attributes, but " + configuration.getDisplayName() + " and " + collisions + " contain identical attribute sets.";
            return ((DocumentedFailure.Builder)builder.withSummary(message).withAdvice(advice).withUserManual("upgrading_version_7", "unique_attribute_sets")).build();
        }
    }

    private static class VariantIdentity {
        private final ImmutableAttributes attributes;
        private final ImmutableCapabilities capabilities;

        private VariantIdentity(ImmutableAttributes attributes, ImmutableCapabilities capabilities) {
            this.attributes = attributes;
            this.capabilities = capabilities;
        }

        public static VariantIdentity from(ConfigurationInternal configuration) {
            return new VariantIdentity(configuration.getAttributes().asImmutable(), VariantIdentity.allCapabilitiesIncludingDefault(configuration));
        }

        private static ImmutableCapabilities allCapabilitiesIncludingDefault(ConfigurationInternal conf) {
            Collection declaredCapabilities = conf.getOutgoing().getCapabilities();
            if (!declaredCapabilities.isEmpty()) {
                return ImmutableCapabilities.of(declaredCapabilities);
            }
            ProjectInternal project = conf.getDomainObjectContext().getProject();
            if (project == null) {
                return ImmutableCapabilities.EMPTY;
            }
            return ImmutableCapabilities.of((Capability)new ProjectDerivedCapability((Project)project));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariantIdentity that = (VariantIdentity)o;
            return Objects.equals(this.attributes, that.attributes) && Objects.equals(this.capabilities, that.capabilities);
        }

        public int hashCode() {
            return this.attributes.hashCode() ^ this.capabilities.hashCode();
        }
    }
}

