/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.transform;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.internal.artifacts.transform.TransformStep;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.internal.component.resolution.failure.transform.SourceVariantData;
import org.gradle.internal.component.resolution.failure.transform.TransformData;
import org.gradle.internal.component.resolution.failure.transform.TransformationChainData;

public final class TransformedVariantConverter {
    public ImmutableList<TransformationChainData> convert(Collection<TransformedVariant> transformedVariants) {
        ImmutableList.Builder builder = ImmutableList.builder();
        transformedVariants.forEach(transformedVariant -> builder.add((Object)this.convert((TransformedVariant)transformedVariant)));
        return builder.build();
    }

    public TransformationChainData convert(TransformedVariant transformedVariant) {
        TransformDataRecordingVisitor visitor = new TransformDataRecordingVisitor();
        transformedVariant.getTransformChain().visitTransformSteps(visitor);
        SourceVariantData source = new SourceVariantData(transformedVariant.getRoot().asDescribable().getDisplayName(), transformedVariant.getRoot().getAttributes());
        return new TransformationChainData(source, visitor.getSteps(), transformedVariant.getAttributes());
    }

    private static final class TransformDataRecordingVisitor
    implements Action<TransformStep> {
        private final ImmutableList.Builder<TransformData> stepsBuilder = ImmutableList.builder();

        private TransformDataRecordingVisitor() {
        }

        public void execute(TransformStep transformStep) {
            TransformData transformData = this.convert(transformStep);
            this.stepsBuilder.add((Object)transformData);
        }

        public ImmutableList<TransformData> getSteps() {
            return this.stepsBuilder.build();
        }

        private TransformData convert(TransformStep step) {
            Transform transform = step.getTransform();
            return new TransformData(transform.getImplementationClass(), transform.getDisplayName(), transform.getFromAttributes(), transform.getToAttributes());
        }
    }
}

