/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.converter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gradle.cli.CommandLineConverter;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.gradle.internal.Cast;
import org.gradle.launcher.configuration.InitialProperties;
import org.gradle.process.internal.CurrentProcess;
import org.gradle.process.internal.JvmOptions;

public class InitialPropertiesConverter {
    private final CommandLineConverter<Map<String, String>> systemPropertiesCommandLineConverter = new SystemPropertiesCommandLineConverter();

    public void configure(CommandLineParser parser) {
        this.systemPropertiesCommandLineConverter.configure(parser);
    }

    public InitialProperties convert(ParsedCommandLine commandLine) {
        JvmOptions currentProcessJvmOptions = new CurrentProcess(null).getJvmOptions();
        Map target = (Map)Cast.uncheckedCast(new HashMap(currentProcessJvmOptions.getImmutableSystemProperties()));
        final Map requestedSystemProperties = (Map)this.systemPropertiesCommandLineConverter.convert(commandLine, (Object)target);
        return new InitialProperties(){

            @Override
            public Map<String, String> getRequestedSystemProperties() {
                return Collections.unmodifiableMap(requestedSystemProperties);
            }
        };
    }
}

