/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.LiteralTextEscaper;
import org.jetbrains.kotlin.com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/psi/KotlinStringLiteralTextEscaper;", "Lorg/jetbrains/kotlin/com/intellij/psi/LiteralTextEscaper;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "host", "<init>", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)V", "sourceOffsets", "", "decode", "", "rangeInsideHost", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOffsetInHost", "", "offsetInDecoded", "getRelevantTextRange", "isOneLine", "psi-api"})
public final class KotlinStringLiteralTextEscaper
extends LiteralTextEscaper<KtStringTemplateExpression> {
    @Nullable
    private int[] sourceOffsets;

    public KotlinStringLiteralTextEscaper(@NotNull KtStringTemplateExpression host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super((PsiLanguageInjectionHost)host);
    }

    @Override
    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
        Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
        IntArrayList sourceOffsetsList = new IntArrayList();
        int sourceOffset = 0;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)this.myHost).getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        for (KtStringTemplateEntry child : ktStringTemplateEntryArray) {
            TextRange textRange;
            int it;
            int n2;
            int n3;
            TextRange childRange;
            Intrinsics.checkNotNullExpressionValue((Object)TextRange.from(child.getStartOffsetInParent(), child.getTextLength()), (String)"from(...)");
            if (rangeInsideHost.getEndOffset() <= childRange.getStartOffset()) break;
            if (childRange.getEndOffset() <= rangeInsideHost.getStartOffset()) continue;
            if (child instanceof KtEscapeStringTemplateEntry) {
                if (!rangeInsideHost.contains(childRange)) {
                    sourceOffsetsList.add(sourceOffset);
                    this.sourceOffsets = sourceOffsetsList.toIntArray();
                    return false;
                }
                String unescaped = ((KtEscapeStringTemplateEntry)child).getUnescapedValue();
                outChars.append(unescaped);
                n3 = unescaped.length();
                n2 = 0;
                while (n2 < n3) {
                    it = n2++;
                    boolean bl = false;
                    sourceOffsetsList.add(sourceOffset);
                }
                sourceOffset += ((KtEscapeStringTemplateEntry)child).getTextLength();
                continue;
            }
            TextRange textRange2 = rangeInsideHost.intersection(childRange);
            Intrinsics.checkNotNull((Object)textRange2);
            Intrinsics.checkNotNullExpressionValue((Object)textRange2.shiftRight(-childRange.getStartOffset()), (String)"shiftRight(...)");
            outChars.append(child.getText(), textRange.getStartOffset(), textRange.getEndOffset());
            n3 = textRange.getLength();
            n2 = 0;
            while (n2 < n3) {
                it = n2++;
                boolean bl = false;
                int n4 = sourceOffset;
                sourceOffset = n4 + 1;
                sourceOffsetsList.add(n4);
            }
        }
        sourceOffsetsList.add(sourceOffset);
        this.sourceOffsets = sourceOffsetsList.toIntArray();
        return true;
    }

    @Override
    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
        int[] offsets = this.sourceOffsets;
        if (offsets == null || offsetInDecoded >= offsets.length) {
            return -1;
        }
        return Math.min(offsets[offsetInDecoded], rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    @Override
    @NotNull
    public TextRange getRelevantTextRange() {
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
        Intrinsics.checkNotNullExpressionValue((Object)psiLanguageInjectionHost, (String)"myHost");
        return KtPsiUtilKt.getContentRange((KtStringTemplateExpression)psiLanguageInjectionHost);
    }

    @Override
    public boolean isOneLine() {
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
        Intrinsics.checkNotNullExpressionValue((Object)psiLanguageInjectionHost, (String)"myHost");
        return KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)psiLanguageInjectionHost);
    }
}

