/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.install;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.temp.GradleUserHomeTemporaryFileProvider;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.DefaultLockOptions;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.RenderingUtils;
import org.gradle.internal.jvm.inspection.JavaInstallationCapability;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.JdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.install.JvmInstallationMetadataMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJdkCacheDirectory
implements JdkCacheDirectory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJdkCacheDirectory.class);
    @VisibleForTesting
    static final String LEGACY_MARKER_FILE = "provisioned.ok";
    @VisibleForTesting
    static final String MARKER_FILE = ".ready";
    private static final String MAC_OS_JAVA_HOME_FOLDER = "Contents/Home";
    private final FileOperations operations;
    private final File jdkDirectory;
    private final FileLockManager lockManager;
    private final JvmMetadataDetector detector;
    private final GradleUserHomeTemporaryFileProvider temporaryFileProvider;
    private static final String JDK_CAPABILITIES_DISPLAY = (String)JavaInstallationCapability.JDK_CAPABILITIES.stream().map(cap -> "the " + cap.toDisplayName()).collect(RenderingUtils.oxfordJoin((String)"and"));

    public DefaultJdkCacheDirectory(GradleUserHomeDirProvider homeDirProvider, FileOperations operations, FileLockManager lockManager, JvmMetadataDetector detector, GradleUserHomeTemporaryFileProvider temporaryFileProvider) {
        this.operations = operations;
        this.jdkDirectory = new File(homeDirProvider.getGradleUserHomeDirectory(), "jdks");
        this.lockManager = lockManager;
        this.detector = detector;
        this.temporaryFileProvider = temporaryFileProvider;
    }

    public Set<File> listJavaHomes() {
        File[] candidates = this.jdkDirectory.listFiles();
        if (candidates != null) {
            return Arrays.stream(candidates).filter(this::isMarkedLocation).map(this::getJavaHome).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private boolean isMarkedLocation(File candidate) {
        return new File(candidate, MARKER_FILE).exists();
    }

    private File getJavaHome(File location) {
        if (OperatingSystem.current().isMacOsX()) {
            if (new File(location, MAC_OS_JAVA_HOME_FOLDER).exists()) {
                return new File(location, MAC_OS_JAVA_HOME_FOLDER);
            }
            File[] subfolders = location.listFiles(File::isDirectory);
            if (subfolders != null) {
                for (File subfolder : subfolders) {
                    if (!new File(subfolder, MAC_OS_JAVA_HOME_FOLDER).exists()) continue;
                    return new File(subfolder, MAC_OS_JAVA_HOME_FOLDER);
                }
            }
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public File provisionFromArchive(JavaToolchainSpec spec, File jdkArchive, URI uri) throws IOException {
        block25: {
            block23: {
                block24: {
                    unpackFolder = this.unpack(jdkArchive);
                    unpackedRoot = this.determineUnpackedRoot(unpackFolder);
                    DefaultJdkCacheDirectory.validateMetadataMatchesSpec(spec, uri, UnpackedRoot.access$000(unpackedRoot));
                    installFolder = new File(this.jdkDirectory, DefaultJdkCacheDirectory.getInstallFolderName(UnpackedRoot.access$000(unpackedRoot)));
                    if (!installFolder.getParentFile().mkdirs() && !installFolder.getParentFile().isDirectory()) {
                        throw new IOException("Failed to create install parent directory: " + installFolder.getParentFile());
                    }
                    ignored = this.acquireWriteLock(new File(installFolder.getParentFile(), installFolder.getName() + ".reserved"), "Provisioning JDK from " + uri);
                    if (!installFolder.exists()) ** GOTO lbl30
                    if (!this.isMarkedLocation(installFolder)) break block23;
                    DefaultJdkCacheDirectory.LOGGER.info("Toolchain from {} already installed at {}", (Object)uri, (Object)installFolder);
                    var8_8 = this.getJavaHome(installFolder);
                    if (ignored == null) break block24;
                    ignored.close();
                }
                try {
                    this.operations.delete(new Object[]{unpackFolder});
                }
                catch (Throwable t) {
                    DefaultJdkCacheDirectory.LOGGER.warn("Failed to delete temporary unpack folder: " + unpackFolder, t);
                }
                return var8_8;
            }
            DefaultJdkCacheDirectory.LOGGER.info("Found partially installed toolchain at {}, overwriting with toolchain from {}", (Object)installFolder, (Object)uri);
            this.operations.delete(new Object[]{installFolder});
lbl30:
            // 2 sources

            try {
                Files.move(UnpackedRoot.access$100(unpackedRoot).toPath(), installFolder.toPath(), new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
            }
            catch (AtomicMoveNotSupportedException e) {
                DefaultJdkCacheDirectory.LOGGER.info("Failed to use an atomic move for unpacked JDK from {} to {}. Will try to copy instead.", new Object[]{UnpackedRoot.access$100(unpackedRoot), installFolder, e});
                try {
                    this.operations.copy((Action)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$provisionFromArchive$0(org.gradle.jvm.toolchain.internal.install.DefaultJdkCacheDirectory$UnpackedRoot java.io.File org.gradle.api.file.CopySpec ), (Lorg/gradle/api/file/CopySpec;)V)((UnpackedRoot)unpackedRoot, (File)installFolder));
                }
                catch (Throwable t) {
                    this.deleteWithoutThrowing(t, installFolder);
                    throw t;
                }
            }
            try {
                this.markAsReady(installFolder);
                break block25;
            }
            catch (Throwable t) {
                this.deleteWithoutThrowing(t, installFolder);
                throw t;
            }
            {
                catch (Throwable t) {
                    throw t;
                }
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        var7_7 = this.getJavaHome(installFolder);
        try {
            this.operations.delete(new Object[]{unpackFolder});
        }
        catch (Throwable t) {
            DefaultJdkCacheDirectory.LOGGER.warn("Failed to delete temporary unpack folder: " + unpackFolder, t);
        }
        return var7_7;
        catch (Throwable var10_16) {
            try {
                this.operations.delete(new Object[]{unpackFolder});
            }
            catch (Throwable t) {
                DefaultJdkCacheDirectory.LOGGER.warn("Failed to delete temporary unpack folder: " + unpackFolder, t);
            }
            throw var10_16;
        }
    }

    private void deleteWithoutThrowing(Throwable t, File installFolder) {
        try {
            this.operations.delete(new Object[]{installFolder});
        }
        catch (Throwable t2) {
            t.addSuppressed(t2);
        }
    }

    private UnpackedRoot determineUnpackedRoot(File unpackFolder) {
        JvmInstallationMetadata uncheckedMetadata = this.getUncheckedMetadata(unpackFolder);
        if (uncheckedMetadata.isValidInstallation()) {
            return new UnpackedRoot(unpackFolder, uncheckedMetadata);
        }
        File[] subFolders = unpackFolder.listFiles(File::isDirectory);
        if (subFolders == null) {
            throw new IllegalStateException("Unpacked JDK archive is not a directory: " + unpackFolder);
        }
        for (File subFolder : subFolders) {
            uncheckedMetadata = this.getUncheckedMetadata(subFolder);
            if (!uncheckedMetadata.isValidInstallation()) continue;
            return new UnpackedRoot(subFolder, uncheckedMetadata);
        }
        throw new IllegalStateException("Unpacked JDK archive does not contain a Java home: " + unpackFolder, uncheckedMetadata.getErrorCause());
    }

    private JvmInstallationMetadata getUncheckedMetadata(File root) {
        File javaHome = this.getJavaHome(root);
        return this.detector.getMetadata(InstallationLocation.autoProvisioned((File)javaHome, (String)"provisioned toolchain"));
    }

    private static void validateMetadataMatchesSpec(JavaToolchainSpec spec, URI uri, JvmInstallationMetadata metadata) {
        if (!new JvmInstallationMetadataMatcher(spec, JavaInstallationCapability.JDK_CAPABILITIES).test(metadata)) {
            LOGGER.info("Provisioned JDK from '{}' does not satisfy the specification {} with metadata {} and capabilities {}", new Object[]{uri, spec.getDisplayName(), metadata, metadata.getCapabilities()});
            throw new GradleException("Toolchain provisioned from '" + uri + "' doesn't satisfy the specification: " + spec.getDisplayName() + " and must have " + JDK_CAPABILITIES_DISPLAY + ".");
        }
    }

    public static String getInstallFolderName(JvmInstallationMetadata metadata) {
        String vendor = metadata.getJvmVendor();
        if (vendor == null || vendor.isEmpty()) {
            vendor = metadata.getVendor().getRawVendor();
        }
        int version = metadata.getJavaMajorVersion();
        String architecture = metadata.getArchitecture();
        String os = OperatingSystem.current().getFamilyName();
        return String.format("%s-%d-%s-%s", vendor, version, architecture, os).replaceAll("[^a-zA-Z0-9\\-]", "_").toLowerCase(Locale.ROOT) + ".2";
    }

    private File unpack(File jdkArchive) {
        FileTree fileTree = this.asFileTree(jdkArchive);
        String unpackFolderName = DefaultJdkCacheDirectory.getNameWithoutExtension(jdkArchive);
        File unpackFolder = this.temporaryFileProvider.createTemporaryDirectory(unpackFolderName, null, new String[]{"jdks"});
        unpackFolder.deleteOnExit();
        this.operations.copy(spec -> {
            spec.from(new Object[]{fileTree});
            spec.into((Object)unpackFolder);
            spec.setDuplicatesStrategy(DuplicatesStrategy.WARN);
        });
        return unpackFolder;
    }

    private void markAsReady(File root) {
        try {
            new File(root, LEGACY_MARKER_FILE).createNewFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create provisioned.ok file", e);
        }
        try {
            new File(root, MARKER_FILE).createNewFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create .ready file", e);
        }
    }

    private FileTree asFileTree(File jdkArchive) {
        String extension = FilenameUtils.getExtension((String)jdkArchive.getName());
        if (Objects.equals(extension, "zip")) {
            return this.operations.zipTree((Object)jdkArchive);
        }
        return this.operations.tarTree((Object)this.operations.getResources().gzip((Object)jdkArchive));
    }

    public FileLock acquireWriteLock(File destinationFile, String operationName) {
        return this.lockManager.lock(destinationFile, (LockOptions)DefaultLockOptions.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive), destinationFile.getName(), operationName);
    }

    public File getDownloadLocation() {
        return this.jdkDirectory;
    }

    private static String getNameWithoutExtension(File file) {
        String input;
        String output = file.getName();
        while (!(input = output).equals(output = com.google.common.io.Files.getNameWithoutExtension((String)input))) {
        }
        return output;
    }

    private static /* synthetic */ void lambda$provisionFromArchive$0(UnpackedRoot unpackedRoot, File installFolder, CopySpec copySpec) {
        copySpec.from(new Object[]{unpackedRoot.dir});
        copySpec.into((Object)installFolder);
    }

    private static final class UnpackedRoot {
        private final File dir;
        private final JvmInstallationMetadata metadata;

        private UnpackedRoot(File dir, JvmInstallationMetadata metadata) {
            this.dir = dir;
            this.metadata = metadata;
        }

        static /* synthetic */ JvmInstallationMetadata access$000(UnpackedRoot x0) {
            return x0.metadata;
        }
    }
}

