/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.plugins.BuildModel;
import org.gradle.api.internal.plugins.HasBuildModel;
import org.gradle.api.internal.plugins.SoftwareFeatureTransform;
import org.gradle.api.internal.plugins.TargetTypeInformation;
import org.gradle.plugin.software.internal.BoundSoftwareFeatureImplementation;
import org.gradle.plugin.software.internal.ModelDefault;
import org.jspecify.annotations.Nullable;

public class DefaultBoundSoftwareFeatureImplementation<T extends HasBuildModel<V>, V extends BuildModel>
implements BoundSoftwareFeatureImplementation<T, V> {
    private final String featureName;
    private final Class<T> definitionPublicType;
    private final Class<? extends T> definitionImplementationType;
    private final TargetTypeInformation<?> targetDefinitionType;
    private final Class<V> buildModelType;
    private final Class<? extends V> buildModelImplementationType;
    private final Class<? extends Plugin<Project>> pluginClass;
    private final Class<? extends Plugin<Settings>> registeringPluginClass;
    private final List<ModelDefault<?>> defaults = new ArrayList();
    private final @Nullable String registeringPluginId;
    private final SoftwareFeatureTransform<T, V, ?> bindingTransform;

    public DefaultBoundSoftwareFeatureImplementation(String featureName, Class<T> definitionPublicType, Class<? extends T> definitionImplementationType, TargetTypeInformation<?> targetDefinitionType, Class<V> buildModelType, Class<? extends V> buildModelImplementationType, Class<? extends Plugin<Project>> pluginClass, Class<? extends Plugin<Settings>> registeringPluginClass, @Nullable String registeringPluginId, SoftwareFeatureTransform<T, V, ?> bindingTransform) {
        this.featureName = featureName;
        this.definitionPublicType = definitionPublicType;
        this.definitionImplementationType = definitionImplementationType;
        this.targetDefinitionType = targetDefinitionType;
        this.buildModelType = buildModelType;
        this.buildModelImplementationType = buildModelImplementationType;
        this.pluginClass = pluginClass;
        this.registeringPluginClass = registeringPluginClass;
        this.registeringPluginId = registeringPluginId;
        this.bindingTransform = bindingTransform;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public Class<T> getDefinitionPublicType() {
        return this.definitionPublicType;
    }

    public Class<? extends T> getDefinitionImplementationType() {
        return this.definitionImplementationType;
    }

    public Class<V> getBuildModelType() {
        return this.buildModelType;
    }

    public Class<? extends V> getBuildModelImplementationType() {
        return this.buildModelImplementationType;
    }

    public TargetTypeInformation<?> getTargetDefinitionType() {
        return this.targetDefinitionType;
    }

    public Class<? extends Plugin<Project>> getPluginClass() {
        return this.pluginClass;
    }

    public Class<? extends Plugin<Settings>> getRegisteringPluginClass() {
        return this.registeringPluginClass;
    }

    public @Nullable String getRegisteringPluginId() {
        return this.registeringPluginId;
    }

    public SoftwareFeatureTransform<T, V, ?> getBindingTransform() {
        return this.bindingTransform;
    }

    public void addModelDefault(ModelDefault<?> modelDefault) {
        this.defaults.add(modelDefault);
    }

    public <M extends ModelDefault.Visitor<?>> void visitModelDefaults(Class<? extends ModelDefault<M>> type, M visitor) {
        this.defaults.stream().filter(type::isInstance).map(type::cast).forEach(modelDefault -> modelDefault.visit(visitor));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultBoundSoftwareFeatureImplementation that = (DefaultBoundSoftwareFeatureImplementation)o;
        return Objects.equals(this.featureName, that.featureName) && Objects.equals(this.definitionPublicType, that.definitionPublicType) && Objects.equals(this.pluginClass, that.pluginClass);
    }

    public int hashCode() {
        return Objects.hash(this.featureName, this.definitionPublicType, this.pluginClass);
    }
}

