/********************************************************************************************
 * Little File Compressor for *nix systems.
 *
 * Copyright (C) 2002 Claudio Scordino , Linda Martorini, Francesco Lelli
 *
 * ******************************************************************************************
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ********************************************************************************************/

/*bitIO.h*/


#include <sys/stat.h>
#include <unistd.h>

/*Le seguenti funzioni operano in modo analogo alle rispettive chiamate di
sistema lavorando bit a bit. Percio' il parametro lung specifica il numero di
bit da leggere o scrivere

La struttura bitIO viene allocata dinamicamente dalla funzione bit_open.
*/

struct bitIO;

struct bitIO* bit_open (const char* nome, int modo, mode_t diritti);

int bit_write (struct bitIO* struttura ,void*  buffer, int lung);

int bit_read (struct bitIO* struttura ,void*  buffer, int lung);

int bit_close (struct bitIO* struttura);

int descrittore(struct bitIO* nod);
/*Ritorna il descrittore del file contenuto nella struttura*/



