#include <koio.h>
#include <stdlib.h>

void koio_load_assets(void);

int main(int argc, char **argv) {
	// This source file is embedded in the executable as //main.c
	koio_load_assets();

	char *alias = getenv("KOIO_ROOT");
	if (alias) {
		ko_add_alias("//", alias);
	}

	for (int i = 1; i < argc; ++i) {
		FILE *f = ko_fopen(argv[i], "r");
		if (!f) {
			fprintf(stderr, "Failed to open '%s' for reading\n", argv[i]);
			return 1;
		}
		int c;
		while ((c = fgetc(f)) != EOF) {
			putchar(c);
		}
		fclose(f);
	}
	return 0;
}
