koio(1)

# NAME

koio - bundles assets for embedding in your program

# SYNOPSIS

*koio* -o _path_ [flags...] [assets...]

# OPTIONS

*-h*
	Show help message and exit.

*-d* _function_
	Specify the symbol name to assign to the deinitialization function. You may
	call this to unload any assets loaded with the function specified by *-i*.
	This defaults to *koio\_unload\_assets*.

*-i* _function_
	Specify the symbol name to assign to the initialization function. You must
	call this function in your program before using any koio-controlled assets.
	This defaults to *koio\_load\_assets*.

*-o* _path_
	Required. Specifies a _path_ at which the bundle will be written as a C
	source file.

# ASSETS

You can specify any number of files to be embedded the bundle. Simply
specifying a path is enough - the file will be available at *//that/path* via
the koio API. You may also optionally add a colon and specify the virtual path
for that file - this needn't begin with *//* if you wish to overlay files on
the genuine filesystem.

# EXAMPLE

The following command produces *asset\_bundle.c*:

```
$ koio -o asset_bundle.c \\
	images/hello.png \\
	images/world.png://hello/world.png \\
	fakepasswd:/etc/passwd
```

If you compile and link *asset\_bundle.c*, you can then use these files:

```
#include <koio.h>

int main(int argc, char **argv) {
	koio_load_assets();
	
	FILE *f = ko_fopen("//images/hello.png", "r");
	// ...
	f = ko_fopen("//hello/world.png", "r");
	// ...
	f = ko_fopen("/etc/passwd", "r");
}
```

# AUTHORS

Maintained by Drew DeVault <sir@cmpwn.com>. Upstream sources are available at
<https://git.sr.ht/~sircmpwn/koio> and patches/bugs should be emailed to Drew.
