#define _POSIX_C_SOURCE 200809L
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "koio_private.h"

FILE *ko_fopen(const char *path, const char *mode) {
	FILE *f;
	struct path_alias *alias = koio_aliases.next;
	while (alias) {
		size_t alias_len = strlen(alias->prefix);
		if (strncmp(path, alias->prefix, alias_len) == 0) {
			char *unaliased_path = malloc(strlen(path) - alias_len);
			strcpy(unaliased_path, &path[alias_len]);
			size_t new_path_size = snprintf(NULL, 0,
					"%s%s", alias->path, &path[alias_len]);
			char *new_path = malloc(new_path_size + 1);
			if (!new_path) {
				continue;
			}
			snprintf(new_path, new_path_size + 1,
					"%s%s", alias->path, &path[alias_len]);
			if ((f = fopen(new_path, mode))) {
				free(new_path);
				return f;
			}
			free(new_path);
		}
		alias = alias->next;
	}

	f = fopen(path, mode);
	if (f) {
		return f;
	}
	struct file_entry *entry = ko_hashtable_get(&koio_vfs, path);
	if (!entry) {
		return NULL;
	}
	if (mode[0] != 'r' || mode[1] != '\0') {
		errno = ENOTSUP;
		return NULL;
	}
	return fmemopen(entry->data, entry->len, "r");
}
