/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_k_pg.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t14, t15, t17, t18, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t29, t30;
  double t31, t32, t33, t35, t36, t40, t43, t44;
  double t48, tzk0;

  gga_k_pg_params *params;

  assert(p->params != NULL);
  params = (gga_k_pg_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t15 = t14 * t14;
  t17 = POW_1_3(t12);
  t18 = t17 * t17;
  t20 = my_piecewise3(t12 <= p->zeta_threshold, t15 * p->zeta_threshold, t18 * t12);
  t21 = POW_1_3(rho[0]);
  t22 = t21 * t21;
  t23 = t20 * t22;
  t24 = M_CBRT6;
  t25 = M_PI * M_PI;
  t26 = POW_1_3(t25);
  t27 = t26 * t26;
  t28 = 0.1e1 / t27;
  t29 = t24 * t28;
  t30 = M_CBRT2;
  t31 = t30 * t30;
  t32 = sigma[0] * t31;
  t33 = rho[0] * rho[0];
  t35 = 0.1e1 / t22 / t33;
  t36 = t32 * t35;
  t40 = params->pg_mu * t24 * t28;
  t43 = exp(-t40 * t36 / 0.24e2);
  t44 = 0.5e1 / 0.72e2 * t29 * t36 + t43;
  t48 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t23 * t44);
  tzk0 = 0.2e1 * t48;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t14, t15, t17, t18, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t29, t30;
  double t31, t32, t33, t35, t36, t40, t43, t44;
  double t48, tzk0;

  double t50, t54, t56, t64, t69, tvrho0, t72, t78;
  double t82, tvsigma0;

  gga_k_pg_params *params;

  assert(p->params != NULL);
  params = (gga_k_pg_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t15 = t14 * t14;
  t17 = POW_1_3(t12);
  t18 = t17 * t17;
  t20 = my_piecewise3(t12 <= p->zeta_threshold, t15 * p->zeta_threshold, t18 * t12);
  t21 = POW_1_3(rho[0]);
  t22 = t21 * t21;
  t23 = t20 * t22;
  t24 = M_CBRT6;
  t25 = M_PI * M_PI;
  t26 = POW_1_3(t25);
  t27 = t26 * t26;
  t28 = 0.1e1 / t27;
  t29 = t24 * t28;
  t30 = M_CBRT2;
  t31 = t30 * t30;
  t32 = sigma[0] * t31;
  t33 = rho[0] * rho[0];
  t35 = 0.1e1 / t22 / t33;
  t36 = t32 * t35;
  t40 = params->pg_mu * t24 * t28;
  t43 = exp(-t40 * t36 / 0.24e2);
  t44 = 0.5e1 / 0.72e2 * t29 * t36 + t43;
  t48 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t23 * t44);
  tzk0 = 0.2e1 * t48;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t50 = t20 / t21;
  t54 = t33 * rho[0];
  t56 = 0.1e1 / t22 / t54;
  t64 = -0.5e1 / 0.27e2 * t29 * t32 * t56 + t40 * t32 * t56 * t43 / 0.9e1;
  t69 = my_piecewise3(t2, 0, t7 * t50 * t44 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t23 * t64);
  tvrho0 = 0.2e1 * rho[0] * t69 + 0.2e1 * t48;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t31 * t35;
  t78 = 0.5e1 / 0.72e2 * t29 * t72 - t40 * t72 * t43 / 0.24e2;
  t82 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t23 * t78);
  tvsigma0 = 0.2e1 * rho[0] * t82;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t14, t15, t17, t18, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t29, t30;
  double t31, t32, t33, t35, t36, t40, t43, t44;
  double t48, tzk0;

  double t50, t54, t56, t64, t69, tvrho0, t72, t78;
  double t82, tvsigma0;

  double t87, t94, t96, t104, t105, t106, t108, t109;
  double t110, t111, t114, t119, t124, tv2rho20, t130, t136;
  double t140, t144, t149, tv2rhosigma0, t156, t159, tv2sigma20;

  gga_k_pg_params *params;

  assert(p->params != NULL);
  params = (gga_k_pg_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t15 = t14 * t14;
  t17 = POW_1_3(t12);
  t18 = t17 * t17;
  t20 = my_piecewise3(t12 <= p->zeta_threshold, t15 * p->zeta_threshold, t18 * t12);
  t21 = POW_1_3(rho[0]);
  t22 = t21 * t21;
  t23 = t20 * t22;
  t24 = M_CBRT6;
  t25 = M_PI * M_PI;
  t26 = POW_1_3(t25);
  t27 = t26 * t26;
  t28 = 0.1e1 / t27;
  t29 = t24 * t28;
  t30 = M_CBRT2;
  t31 = t30 * t30;
  t32 = sigma[0] * t31;
  t33 = rho[0] * rho[0];
  t35 = 0.1e1 / t22 / t33;
  t36 = t32 * t35;
  t40 = params->pg_mu * t24 * t28;
  t43 = exp(-t40 * t36 / 0.24e2);
  t44 = 0.5e1 / 0.72e2 * t29 * t36 + t43;
  t48 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t23 * t44);
  tzk0 = 0.2e1 * t48;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t50 = t20 / t21;
  t54 = t33 * rho[0];
  t56 = 0.1e1 / t22 / t54;
  t64 = -0.5e1 / 0.27e2 * t29 * t32 * t56 + t40 * t32 * t56 * t43 / 0.9e1;
  t69 = my_piecewise3(t2, 0, t7 * t50 * t44 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t23 * t64);
  tvrho0 = 0.2e1 * rho[0] * t69 + 0.2e1 * t48;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t31 * t35;
  t78 = 0.5e1 / 0.72e2 * t29 * t72 - t40 * t72 * t43 / 0.24e2;
  t82 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t23 * t78);
  tvsigma0 = 0.2e1 * rho[0] * t82;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t87 = t20 / t21 / rho[0];
  t94 = t33 * t33;
  t96 = 0.1e1 / t22 / t94;
  t104 = params->pg_mu * params->pg_mu;
  t105 = t24 * t24;
  t106 = t104 * t105;
  t108 = 0.1e1 / t26 / t25;
  t109 = t106 * t108;
  t110 = sigma[0] * sigma[0];
  t111 = t110 * t30;
  t114 = 0.1e1 / t21 / t94 / t54;
  t119 = 0.55e2 / 0.81e2 * t29 * t32 * t96 - 0.11e2 / 0.27e2 * t40 * t32 * t96 * t43 + 0.2e1 / 0.81e2 * t109 * t111 * t114 * t43;
  t124 = my_piecewise3(t2, 0, -t7 * t87 * t44 / 0.3e2 + t7 * t50 * t64 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t23 * t119);
  tv2rho20 = 0.2e1 * rho[0] * t124 + 0.4e1 * t69;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t130 = t31 * t56;
  t136 = t94 * t33;
  t140 = sigma[0] * t43;
  t144 = -0.5e1 / 0.27e2 * t29 * t130 + t40 * t130 * t43 / 0.9e1 - t109 * t30 / t21 / t136 * t140 / 0.108e3;
  t149 = my_piecewise3(t2, 0, t7 * t50 * t78 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t23 * t144);
  tv2rhosigma0 = 0.2e1 * rho[0] * t149 + 0.2e1 * t82;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t156 = t106 * t108 * t30 * t43;
  t159 = my_piecewise3(t2, 0, t7 * t20 * t96 * t156 / 0.192e4);
  tv2sigma20 = 0.2e1 * rho[0] * t159;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t14, t15, t17, t18, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t29, t30;
  double t31, t32, t33, t35, t36, t40, t43, t44;
  double t48, tzk0;

  double t50, t54, t56, t64, t69, tvrho0, t72, t78;
  double t82, tvsigma0;

  double t87, t94, t96, t104, t105, t106, t108, t109;
  double t110, t111, t114, t119, t124, tv2rho20, t130, t136;
  double t140, t144, t149, tv2rhosigma0, t156, t159, tv2sigma20;

  double t164, t174, t176, t184, t186, t191, t192, t193;
  double t194, t195, t197, t202, t207, tv3rho30, t217, t228;
  double t233, t238, tv3rho2sigma0, t245, t248, t249, t250, t255;
  double tv3rhosigma20, t262, tv3sigma30;

  gga_k_pg_params *params;

  assert(p->params != NULL);
  params = (gga_k_pg_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t15 = t14 * t14;
  t17 = POW_1_3(t12);
  t18 = t17 * t17;
  t20 = my_piecewise3(t12 <= p->zeta_threshold, t15 * p->zeta_threshold, t18 * t12);
  t21 = POW_1_3(rho[0]);
  t22 = t21 * t21;
  t23 = t20 * t22;
  t24 = M_CBRT6;
  t25 = M_PI * M_PI;
  t26 = POW_1_3(t25);
  t27 = t26 * t26;
  t28 = 0.1e1 / t27;
  t29 = t24 * t28;
  t30 = M_CBRT2;
  t31 = t30 * t30;
  t32 = sigma[0] * t31;
  t33 = rho[0] * rho[0];
  t35 = 0.1e1 / t22 / t33;
  t36 = t32 * t35;
  t40 = params->pg_mu * t24 * t28;
  t43 = exp(-t40 * t36 / 0.24e2);
  t44 = 0.5e1 / 0.72e2 * t29 * t36 + t43;
  t48 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t23 * t44);
  tzk0 = 0.2e1 * t48;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t50 = t20 / t21;
  t54 = t33 * rho[0];
  t56 = 0.1e1 / t22 / t54;
  t64 = -0.5e1 / 0.27e2 * t29 * t32 * t56 + t40 * t32 * t56 * t43 / 0.9e1;
  t69 = my_piecewise3(t2, 0, t7 * t50 * t44 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t23 * t64);
  tvrho0 = 0.2e1 * rho[0] * t69 + 0.2e1 * t48;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t31 * t35;
  t78 = 0.5e1 / 0.72e2 * t29 * t72 - t40 * t72 * t43 / 0.24e2;
  t82 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t23 * t78);
  tvsigma0 = 0.2e1 * rho[0] * t82;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t87 = t20 / t21 / rho[0];
  t94 = t33 * t33;
  t96 = 0.1e1 / t22 / t94;
  t104 = params->pg_mu * params->pg_mu;
  t105 = t24 * t24;
  t106 = t104 * t105;
  t108 = 0.1e1 / t26 / t25;
  t109 = t106 * t108;
  t110 = sigma[0] * sigma[0];
  t111 = t110 * t30;
  t114 = 0.1e1 / t21 / t94 / t54;
  t119 = 0.55e2 / 0.81e2 * t29 * t32 * t96 - 0.11e2 / 0.27e2 * t40 * t32 * t96 * t43 + 0.2e1 / 0.81e2 * t109 * t111 * t114 * t43;
  t124 = my_piecewise3(t2, 0, -t7 * t87 * t44 / 0.3e2 + t7 * t50 * t64 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t23 * t119);
  tv2rho20 = 0.2e1 * rho[0] * t124 + 0.4e1 * t69;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t130 = t31 * t56;
  t136 = t94 * t33;
  t140 = sigma[0] * t43;
  t144 = -0.5e1 / 0.27e2 * t29 * t130 + t40 * t130 * t43 / 0.9e1 - t109 * t30 / t21 / t136 * t140 / 0.108e3;
  t149 = my_piecewise3(t2, 0, t7 * t50 * t78 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t23 * t144);
  tv2rhosigma0 = 0.2e1 * rho[0] * t149 + 0.2e1 * t82;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t156 = t106 * t108 * t30 * t43;
  t159 = my_piecewise3(t2, 0, t7 * t20 * t96 * t156 / 0.192e4);
  tv2sigma20 = 0.2e1 * rho[0] * t159;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t164 = t20 / t21 / t33;
  t174 = t94 * rho[0];
  t176 = 0.1e1 / t22 / t174;
  t184 = t94 * t94;
  t186 = 0.1e1 / t21 / t184;
  t191 = t104 * params->pg_mu;
  t192 = t25 * t25;
  t193 = 0.1e1 / t192;
  t194 = t191 * t193;
  t195 = t110 * sigma[0];
  t197 = 0.1e1 / t184 / t54;
  t202 = -0.77e3 / 0.243e3 * t29 * t32 * t176 + 0.154e3 / 0.81e2 * t40 * t32 * t176 * t43 - 0.22e2 / 0.81e2 * t109 * t111 * t186 * t43 + 0.8e1 / 0.243e3 * t194 * t195 * t197 * t43;
  t207 = my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t164 * t44 - t7 * t87 * t64 / 0.1e2 + 0.3e1 / 0.1e2 * t7 * t50 * t119 + 0.3e1 / 0.2e2 * t7 * t23 * t202);
  tv3rho30 = 0.2e1 * rho[0] * t207 + 0.6e1 * t124;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t217 = t31 * t96;
  t228 = 0.1e1 / t184 / t33;
  t233 = 0.55e2 / 0.81e2 * t29 * t217 - 0.11e2 / 0.27e2 * t40 * t217 * t43 + t109 * t30 * t114 * t140 / 0.12e2 - t194 * t228 * t110 * t43 / 0.81e2;
  t238 = my_piecewise3(t2, 0, -t7 * t87 * t78 / 0.3e2 + t7 * t50 * t144 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t23 * t233);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t238 + 0.4e1 * t149;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t245 = t5 * t5;
  t248 = t4 / t245 / t25;
  t249 = t248 * t20;
  t250 = t186 * t191;
  t255 = my_piecewise3(t2, 0, -0.7e1 / 0.288e4 * t7 * t20 * t176 * t156 + t249 * t250 * t140 / 0.144e4);
  tv3rhosigma20 = 0.2e1 * rho[0] * t255 + 0.2e1 * t159;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t262 = my_piecewise3(t2, 0, -t249 * t114 * t191 * t43 / 0.384e4);
  tv3sigma30 = 0.2e1 * rho[0] * t262;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t14, t15, t17, t18, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t29, t30;
  double t31, t32, t33, t35, t36, t40, t43, t44;
  double t48, tzk0;

  double t50, t54, t56, t64, t69, tvrho0, t72, t78;
  double t82, tvsigma0;

  double t87, t94, t96, t104, t105, t106, t108, t109;
  double t110, t111, t114, t119, t124, tv2rho20, t130, t136;
  double t140, t144, t149, tv2rhosigma0, t156, t159, tv2sigma20;

  double t164, t174, t176, t184, t186, t191, t192, t193;
  double t194, t195, t197, t202, t207, tv3rho30, t217, t228;
  double t233, t238, tv3rho2sigma0, t245, t248, t249, t250, t255;
  double tv3rhosigma20, t262, tv3sigma30;

  double t281, t291, t297, t302, t303, t304, t311, t319;
  double tv4rho40, t332, t358, tv4rho3sigma0, t375, t380, tv4rho2sigma20, t394;
  double tv4rhosigma30, t403, tv4sigma40;

  gga_k_pg_params *params;

  assert(p->params != NULL);
  params = (gga_k_pg_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t15 = t14 * t14;
  t17 = POW_1_3(t12);
  t18 = t17 * t17;
  t20 = my_piecewise3(t12 <= p->zeta_threshold, t15 * p->zeta_threshold, t18 * t12);
  t21 = POW_1_3(rho[0]);
  t22 = t21 * t21;
  t23 = t20 * t22;
  t24 = M_CBRT6;
  t25 = M_PI * M_PI;
  t26 = POW_1_3(t25);
  t27 = t26 * t26;
  t28 = 0.1e1 / t27;
  t29 = t24 * t28;
  t30 = M_CBRT2;
  t31 = t30 * t30;
  t32 = sigma[0] * t31;
  t33 = rho[0] * rho[0];
  t35 = 0.1e1 / t22 / t33;
  t36 = t32 * t35;
  t40 = params->pg_mu * t24 * t28;
  t43 = exp(-t40 * t36 / 0.24e2);
  t44 = 0.5e1 / 0.72e2 * t29 * t36 + t43;
  t48 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t23 * t44);
  tzk0 = 0.2e1 * t48;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t50 = t20 / t21;
  t54 = t33 * rho[0];
  t56 = 0.1e1 / t22 / t54;
  t64 = -0.5e1 / 0.27e2 * t29 * t32 * t56 + t40 * t32 * t56 * t43 / 0.9e1;
  t69 = my_piecewise3(t2, 0, t7 * t50 * t44 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t23 * t64);
  tvrho0 = 0.2e1 * rho[0] * t69 + 0.2e1 * t48;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t31 * t35;
  t78 = 0.5e1 / 0.72e2 * t29 * t72 - t40 * t72 * t43 / 0.24e2;
  t82 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t23 * t78);
  tvsigma0 = 0.2e1 * rho[0] * t82;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t87 = t20 / t21 / rho[0];
  t94 = t33 * t33;
  t96 = 0.1e1 / t22 / t94;
  t104 = params->pg_mu * params->pg_mu;
  t105 = t24 * t24;
  t106 = t104 * t105;
  t108 = 0.1e1 / t26 / t25;
  t109 = t106 * t108;
  t110 = sigma[0] * sigma[0];
  t111 = t110 * t30;
  t114 = 0.1e1 / t21 / t94 / t54;
  t119 = 0.55e2 / 0.81e2 * t29 * t32 * t96 - 0.11e2 / 0.27e2 * t40 * t32 * t96 * t43 + 0.2e1 / 0.81e2 * t109 * t111 * t114 * t43;
  t124 = my_piecewise3(t2, 0, -t7 * t87 * t44 / 0.3e2 + t7 * t50 * t64 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t23 * t119);
  tv2rho20 = 0.2e1 * rho[0] * t124 + 0.4e1 * t69;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t130 = t31 * t56;
  t136 = t94 * t33;
  t140 = sigma[0] * t43;
  t144 = -0.5e1 / 0.27e2 * t29 * t130 + t40 * t130 * t43 / 0.9e1 - t109 * t30 / t21 / t136 * t140 / 0.108e3;
  t149 = my_piecewise3(t2, 0, t7 * t50 * t78 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t23 * t144);
  tv2rhosigma0 = 0.2e1 * rho[0] * t149 + 0.2e1 * t82;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t156 = t106 * t108 * t30 * t43;
  t159 = my_piecewise3(t2, 0, t7 * t20 * t96 * t156 / 0.192e4);
  tv2sigma20 = 0.2e1 * rho[0] * t159;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t164 = t20 / t21 / t33;
  t174 = t94 * rho[0];
  t176 = 0.1e1 / t22 / t174;
  t184 = t94 * t94;
  t186 = 0.1e1 / t21 / t184;
  t191 = t104 * params->pg_mu;
  t192 = t25 * t25;
  t193 = 0.1e1 / t192;
  t194 = t191 * t193;
  t195 = t110 * sigma[0];
  t197 = 0.1e1 / t184 / t54;
  t202 = -0.77e3 / 0.243e3 * t29 * t32 * t176 + 0.154e3 / 0.81e2 * t40 * t32 * t176 * t43 - 0.22e2 / 0.81e2 * t109 * t111 * t186 * t43 + 0.8e1 / 0.243e3 * t194 * t195 * t197 * t43;
  t207 = my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t164 * t44 - t7 * t87 * t64 / 0.1e2 + 0.3e1 / 0.1e2 * t7 * t50 * t119 + 0.3e1 / 0.2e2 * t7 * t23 * t202);
  tv3rho30 = 0.2e1 * rho[0] * t207 + 0.6e1 * t124;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t217 = t31 * t96;
  t228 = 0.1e1 / t184 / t33;
  t233 = 0.55e2 / 0.81e2 * t29 * t217 - 0.11e2 / 0.27e2 * t40 * t217 * t43 + t109 * t30 * t114 * t140 / 0.12e2 - t194 * t228 * t110 * t43 / 0.81e2;
  t238 = my_piecewise3(t2, 0, -t7 * t87 * t78 / 0.3e2 + t7 * t50 * t144 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t23 * t233);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t238 + 0.4e1 * t149;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t245 = t5 * t5;
  t248 = t4 / t245 / t25;
  t249 = t248 * t20;
  t250 = t186 * t191;
  t255 = my_piecewise3(t2, 0, -0.7e1 / 0.288e4 * t7 * t20 * t176 * t156 + t249 * t250 * t140 / 0.144e4);
  tv3rhosigma20 = 0.2e1 * rho[0] * t255 + 0.2e1 * t159;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t262 = my_piecewise3(t2, 0, -t249 * t114 * t191 * t43 / 0.384e4);
  tv3sigma30 = 0.2e1 * rho[0] * t262;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t281 = 0.1e1 / t22 / t136;
  t291 = 0.1e1 / t21 / t184 / rho[0];
  t297 = 0.1e1 / t184 / t94;
  t302 = t104 * t104;
  t303 = t302 * t193;
  t304 = t110 * t110;
  t311 = t29 * t31 * t43;
  t319 = my_piecewise3(t2, 0, -0.14e2 / 0.135e3 * t7 * t20 / t21 / t54 * t44 + 0.8e1 / 0.45e2 * t7 * t164 * t64 - t7 * t87 * t119 / 0.5e1 + 0.2e1 / 0.5e1 * t7 * t50 * t202 + 0.3e1 / 0.2e2 * t7 * t23 * (0.1309e5 / 0.729e3 * t29 * t32 * t281 - 0.2618e4 / 0.243e3 * t40 * t32 * t281 * t43 + 0.1958e4 / 0.729e3 * t109 * t111 * t291 * t43 - 0.176e3 / 0.243e3 * t194 * t195 * t297 * t43 + 0.8e1 / 0.2187e4 * t303 * t304 / t22 / t184 / t136 * t311));
  tv4rho40 = 0.2e1 * rho[0] * t319 + 0.8e1 * t207;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t332 = t31 * t176;
  t358 = my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t164 * t78 - t7 * t87 * t144 / 0.1e2 + 0.3e1 / 0.1e2 * t7 * t50 * t233 + 0.3e1 / 0.2e2 * t7 * t23 * (-0.77e3 / 0.243e3 * t29 * t332 + 0.154e3 / 0.81e2 * t40 * t332 * t43 - 0.341e3 / 0.486e3 * t109 * t30 * t186 * t140 + 0.19e2 / 0.81e2 * t194 * t197 * t110 * t43 - t303 / t22 / t184 / t174 * t195 * t311 / 0.729e3));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t358 + 0.6e1 * t238;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t375 = t28 * t31 * t43;
  t380 = my_piecewise3(t2, 0, 0.119e3 / 0.864e4 * t7 * t20 * t281 * t156 - 0.13e2 / 0.144e4 * t249 * t291 * t191 * t140 + t248 * t20 * t297 * t302 * t110 * t24 * t375 / 0.1296e5);
  tv4rho2sigma20 = 0.2e1 * rho[0] * t380 + 0.4e1 * t255;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t394 = my_piecewise3(t2, 0, 0.11e2 / 0.576e4 * t249 * t250 * t43 - t248 * t20 * t197 * t302 * t29 * t32 * t43 / 0.3456e5);
  tv4rhosigma30 = 0.2e1 * rho[0] * t394 + 0.2e1 * t262;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t403 = my_piecewise3(t2, 0, t248 * t20 * t228 * t302 * t24 * t375 / 0.9216e5);
  tv4sigma40 = 0.2e1 * rho[0] * t403;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t25, t26, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t39;
  double t40, t42, t46, t47, t51, t52, t56, t57;
  double t58, t60, t61, t62, t63, t64, t66, t67;
  double t68, t69, t70, t72, t76, t80, t81, t85;
  double tzk0;

  gga_k_pg_params *params;

  assert(p->params != NULL);
  params = (gga_k_pg_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = t2 * t2;
  t4 = M_CBRTPI;
  t6 = t3 * t4 * M_PI;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * p->zeta_threshold;
  t25 = POW_1_3(t20);
  t26 = t25 * t25;
  t28 = my_piecewise3(t21, t24, t26 * t20);
  t29 = POW_1_3(t7);
  t30 = t29 * t29;
  t31 = t28 * t30;
  t32 = M_CBRT6;
  t33 = M_PI * M_PI;
  t34 = POW_1_3(t33);
  t35 = t34 * t34;
  t36 = 0.1e1 / t35;
  t37 = t32 * t36;
  t38 = rho[0] * rho[0];
  t39 = POW_1_3(rho[0]);
  t40 = t39 * t39;
  t42 = 0.1e1 / t40 / t38;
  t46 = params->pg_mu * t32;
  t47 = t36 * sigma[0];
  t51 = exp(-t46 * t47 * t42 / 0.24e2);
  t52 = 0.5e1 / 0.72e2 * t37 * sigma[0] * t42 + t51;
  t56 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t31 * t52);
  t57 = rho[1] <= p->dens_threshold;
  t58 = -t17;
  t60 = my_piecewise5(t15, t12, t11, t16, t58 * t8);
  t61 = 0.1e1 + t60;
  t62 = t61 <= p->zeta_threshold;
  t63 = POW_1_3(t61);
  t64 = t63 * t63;
  t66 = my_piecewise3(t62, t24, t64 * t61);
  t67 = t66 * t30;
  t68 = rho[1] * rho[1];
  t69 = POW_1_3(rho[1]);
  t70 = t69 * t69;
  t72 = 0.1e1 / t70 / t68;
  t76 = t36 * sigma[2];
  t80 = exp(-t46 * t76 * t72 / 0.24e2);
  t81 = 0.5e1 / 0.72e2 * t37 * sigma[2] * t72 + t80;
  t85 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t67 * t81);
  tzk0 = t56 + t85;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t25, t26, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t39;
  double t40, t42, t46, t47, t51, t52, t56, t57;
  double t58, t60, t61, t62, t63, t64, t66, t67;
  double t68, t69, t70, t72, t76, t80, t81, t85;
  double tzk0;

  double t86, t87, t88, t90, t93, t94, t98, t99;
  double t102, t103, t105, t106, t109, t113, t118, t119;
  double t121, t124, t125, t129, t132, t134, tvrho0, t138;
  double t141, t142, t147, t149, t152, t153, t157, t159;
  double t160, t166, t171, tvrho1, t180, t184, tvsigma0, tvsigma1;
  double t191, t195, tvsigma2;

  gga_k_pg_params *params;

  assert(p->params != NULL);
  params = (gga_k_pg_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = t2 * t2;
  t4 = M_CBRTPI;
  t6 = t3 * t4 * M_PI;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * p->zeta_threshold;
  t25 = POW_1_3(t20);
  t26 = t25 * t25;
  t28 = my_piecewise3(t21, t24, t26 * t20);
  t29 = POW_1_3(t7);
  t30 = t29 * t29;
  t31 = t28 * t30;
  t32 = M_CBRT6;
  t33 = M_PI * M_PI;
  t34 = POW_1_3(t33);
  t35 = t34 * t34;
  t36 = 0.1e1 / t35;
  t37 = t32 * t36;
  t38 = rho[0] * rho[0];
  t39 = POW_1_3(rho[0]);
  t40 = t39 * t39;
  t42 = 0.1e1 / t40 / t38;
  t46 = params->pg_mu * t32;
  t47 = t36 * sigma[0];
  t51 = exp(-t46 * t47 * t42 / 0.24e2);
  t52 = 0.5e1 / 0.72e2 * t37 * sigma[0] * t42 + t51;
  t56 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t31 * t52);
  t57 = rho[1] <= p->dens_threshold;
  t58 = -t17;
  t60 = my_piecewise5(t15, t12, t11, t16, t58 * t8);
  t61 = 0.1e1 + t60;
  t62 = t61 <= p->zeta_threshold;
  t63 = POW_1_3(t61);
  t64 = t63 * t63;
  t66 = my_piecewise3(t62, t24, t64 * t61);
  t67 = t66 * t30;
  t68 = rho[1] * rho[1];
  t69 = POW_1_3(rho[1]);
  t70 = t69 * t69;
  t72 = 0.1e1 / t70 / t68;
  t76 = t36 * sigma[2];
  t80 = exp(-t46 * t76 * t72 / 0.24e2);
  t81 = 0.5e1 / 0.72e2 * t37 * sigma[2] * t72 + t80;
  t85 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t67 * t81);
  tzk0 = t56 + t85;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t86 = t7 * t7;
  t87 = 0.1e1 / t86;
  t88 = t17 * t87;
  t90 = my_piecewise5(t11, 0, t15, 0, t8 - t88);
  t93 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t90);
  t94 = t93 * t30;
  t98 = 0.1e1 / t29;
  t99 = t28 * t98;
  t102 = t6 * t99 * t52 / 0.1e2;
  t103 = t38 * rho[0];
  t105 = 0.1e1 / t40 / t103;
  t106 = sigma[0] * t105;
  t109 = t46 * t36;
  t113 = -0.5e1 / 0.27e2 * t37 * t106 + t109 * t106 * t51 / 0.9e1;
  t118 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t94 * t52 + t102 + 0.3e1 / 0.2e2 * t6 * t31 * t113);
  t119 = t58 * t87;
  t121 = my_piecewise5(t15, 0, t11, 0, -t8 - t119);
  t124 = my_piecewise3(t62, 0, 0.5e1 / 0.3e1 * t64 * t121);
  t125 = t124 * t30;
  t129 = t66 * t98;
  t132 = t6 * t129 * t81 / 0.1e2;
  t134 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t125 * t81 + t132);
  tvrho0 = t56 + t85 + t7 * (t118 + t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t138 = my_piecewise5(t11, 0, t15, 0, -t8 - t88);
  t141 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t138);
  t142 = t141 * t30;
  t147 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t142 * t52 + t102);
  t149 = my_piecewise5(t15, 0, t11, 0, t8 - t119);
  t152 = my_piecewise3(t62, 0, 0.5e1 / 0.3e1 * t64 * t149);
  t153 = t152 * t30;
  t157 = t68 * rho[1];
  t159 = 0.1e1 / t70 / t157;
  t160 = sigma[2] * t159;
  t166 = -0.5e1 / 0.27e2 * t37 * t160 + t109 * t160 * t80 / 0.9e1;
  t171 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t153 * t81 + t132 + 0.3e1 / 0.2e2 * t6 * t67 * t166);
  tvrho1 = t56 + t85 + t7 * (t147 + t171);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t180 = 0.5e1 / 0.72e2 * t37 * t42 - t46 * t36 * t42 * t51 / 0.24e2;
  t184 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t31 * t180);
  tvsigma0 = t7 * t184;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t191 = 0.5e1 / 0.72e2 * t37 * t72 - t46 * t36 * t72 * t80 / 0.24e2;
  t195 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t67 * t191);
  tvsigma2 = t7 * t195;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t25, t26, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t39;
  double t40, t42, t46, t47, t51, t52, t56, t57;
  double t58, t60, t61, t62, t63, t64, t66, t67;
  double t68, t69, t70, t72, t76, t80, t81, t85;
  double tzk0;

  double t86, t87, t88, t90, t93, t94, t98, t99;
  double t102, t103, t105, t106, t109, t113, t118, t119;
  double t121, t124, t125, t129, t132, t134, tvrho0, t138;
  double t141, t142, t147, t149, t152, t153, t157, t159;
  double t160, t166, t171, tvrho1, t180, t184, tvsigma0, tvsigma1;
  double t191, t195, tvsigma2;

  double t198, t199, t202, t203, t204, t207, t211, t212;
  double t216, t218, t224, t225, t228, t230, t232, t234;
  double t235, t241, t242, t243, t245, t246, t247, t250;
  double t255, t260, t261, t262, t265, t268, t272, t273;
  double t277, t279, t281, t284, t286, tv2rho20, t289, t293;
  double t297, t298, t302, t304, t312, t313, t317, t321;
  double t322, t326, t328, t335, t338, tv2rho21, t343, t348;
  double t352, t353, t359, t360, t365, t369, t370, t379;
  double t381, t382, t388, t391, t396, t401, tv2rho22, t409;
  double t416, t418, t423, t428, tv2rhosigma0, tv2rhosigma1, t435, t437;
  double tv2rhosigma2, t443, tv2rhosigma3, tv2rhosigma4, t454, t456, t461, t466;
  double tv2rhosigma5, t468, t469, t474, t477, tv2sigma20, tv2sigma21, tv2sigma22;
  double tv2sigma23, tv2sigma24, t478, t479, t484, t487, tv2sigma25;

  gga_k_pg_params *params;

  assert(p->params != NULL);
  params = (gga_k_pg_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = t2 * t2;
  t4 = M_CBRTPI;
  t6 = t3 * t4 * M_PI;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * p->zeta_threshold;
  t25 = POW_1_3(t20);
  t26 = t25 * t25;
  t28 = my_piecewise3(t21, t24, t26 * t20);
  t29 = POW_1_3(t7);
  t30 = t29 * t29;
  t31 = t28 * t30;
  t32 = M_CBRT6;
  t33 = M_PI * M_PI;
  t34 = POW_1_3(t33);
  t35 = t34 * t34;
  t36 = 0.1e1 / t35;
  t37 = t32 * t36;
  t38 = rho[0] * rho[0];
  t39 = POW_1_3(rho[0]);
  t40 = t39 * t39;
  t42 = 0.1e1 / t40 / t38;
  t46 = params->pg_mu * t32;
  t47 = t36 * sigma[0];
  t51 = exp(-t46 * t47 * t42 / 0.24e2);
  t52 = 0.5e1 / 0.72e2 * t37 * sigma[0] * t42 + t51;
  t56 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t31 * t52);
  t57 = rho[1] <= p->dens_threshold;
  t58 = -t17;
  t60 = my_piecewise5(t15, t12, t11, t16, t58 * t8);
  t61 = 0.1e1 + t60;
  t62 = t61 <= p->zeta_threshold;
  t63 = POW_1_3(t61);
  t64 = t63 * t63;
  t66 = my_piecewise3(t62, t24, t64 * t61);
  t67 = t66 * t30;
  t68 = rho[1] * rho[1];
  t69 = POW_1_3(rho[1]);
  t70 = t69 * t69;
  t72 = 0.1e1 / t70 / t68;
  t76 = t36 * sigma[2];
  t80 = exp(-t46 * t76 * t72 / 0.24e2);
  t81 = 0.5e1 / 0.72e2 * t37 * sigma[2] * t72 + t80;
  t85 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t67 * t81);
  tzk0 = t56 + t85;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t86 = t7 * t7;
  t87 = 0.1e1 / t86;
  t88 = t17 * t87;
  t90 = my_piecewise5(t11, 0, t15, 0, t8 - t88);
  t93 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t90);
  t94 = t93 * t30;
  t98 = 0.1e1 / t29;
  t99 = t28 * t98;
  t102 = t6 * t99 * t52 / 0.1e2;
  t103 = t38 * rho[0];
  t105 = 0.1e1 / t40 / t103;
  t106 = sigma[0] * t105;
  t109 = t46 * t36;
  t113 = -0.5e1 / 0.27e2 * t37 * t106 + t109 * t106 * t51 / 0.9e1;
  t118 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t94 * t52 + t102 + 0.3e1 / 0.2e2 * t6 * t31 * t113);
  t119 = t58 * t87;
  t121 = my_piecewise5(t15, 0, t11, 0, -t8 - t119);
  t124 = my_piecewise3(t62, 0, 0.5e1 / 0.3e1 * t64 * t121);
  t125 = t124 * t30;
  t129 = t66 * t98;
  t132 = t6 * t129 * t81 / 0.1e2;
  t134 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t125 * t81 + t132);
  tvrho0 = t56 + t85 + t7 * (t118 + t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t138 = my_piecewise5(t11, 0, t15, 0, -t8 - t88);
  t141 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t138);
  t142 = t141 * t30;
  t147 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t142 * t52 + t102);
  t149 = my_piecewise5(t15, 0, t11, 0, t8 - t119);
  t152 = my_piecewise3(t62, 0, 0.5e1 / 0.3e1 * t64 * t149);
  t153 = t152 * t30;
  t157 = t68 * rho[1];
  t159 = 0.1e1 / t70 / t157;
  t160 = sigma[2] * t159;
  t166 = -0.5e1 / 0.27e2 * t37 * t160 + t109 * t160 * t80 / 0.9e1;
  t171 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t153 * t81 + t132 + 0.3e1 / 0.2e2 * t6 * t67 * t166);
  tvrho1 = t56 + t85 + t7 * (t147 + t171);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t180 = 0.5e1 / 0.72e2 * t37 * t42 - t46 * t36 * t42 * t51 / 0.24e2;
  t184 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t31 * t180);
  tvsigma0 = t7 * t184;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t191 = 0.5e1 / 0.72e2 * t37 * t72 - t46 * t36 * t72 * t80 / 0.24e2;
  t195 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t67 * t191);
  tvsigma2 = t7 * t195;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t198 = 0.1e1 / t25;
  t199 = t90 * t90;
  t202 = t86 * t7;
  t203 = 0.1e1 / t202;
  t204 = t17 * t203;
  t207 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t87 + 0.2e1 * t204);
  t211 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t198 * t199 + 0.5e1 / 0.3e1 * t26 * t207);
  t212 = t211 * t30;
  t216 = t93 * t98;
  t218 = t6 * t216 * t52;
  t224 = 0.1e1 / t29 / t7;
  t225 = t28 * t224;
  t228 = t6 * t225 * t52 / 0.3e2;
  t230 = t6 * t99 * t113;
  t232 = t38 * t38;
  t234 = 0.1e1 / t40 / t232;
  t235 = sigma[0] * t234;
  t241 = params->pg_mu * params->pg_mu;
  t242 = t32 * t32;
  t243 = t241 * t242;
  t245 = 0.1e1 / t34 / t33;
  t246 = t243 * t245;
  t247 = sigma[0] * sigma[0];
  t250 = 0.1e1 / t39 / t232 / t103;
  t255 = 0.55e2 / 0.81e2 * t37 * t235 - 0.11e2 / 0.27e2 * t109 * t235 * t51 + t246 * t247 * t250 * t51 / 0.81e2;
  t260 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t212 * t52 + t218 / 0.5e1 + 0.3e1 / 0.1e2 * t6 * t94 * t113 - t228 + t230 / 0.5e1 + 0.3e1 / 0.2e2 * t6 * t31 * t255);
  t261 = 0.1e1 / t63;
  t262 = t121 * t121;
  t265 = t58 * t203;
  t268 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t87 + 0.2e1 * t265);
  t272 = my_piecewise3(t62, 0, 0.1e2 / 0.9e1 * t261 * t262 + 0.5e1 / 0.3e1 * t64 * t268);
  t273 = t272 * t30;
  t277 = t124 * t98;
  t279 = t6 * t277 * t81;
  t281 = t66 * t224;
  t284 = t6 * t281 * t81 / 0.3e2;
  t286 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t273 * t81 + t279 / 0.5e1 - t284);
  tv2rho20 = 0.2e1 * t118 + 0.2e1 * t134 + t7 * (t260 + t286);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t289 = t198 * t138;
  t293 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t204);
  t297 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t289 * t90 + 0.5e1 / 0.3e1 * t26 * t293);
  t298 = t297 * t30;
  t302 = t141 * t98;
  t304 = t6 * t302 * t52;
  t312 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t298 * t52 + t304 / 0.1e2 + 0.3e1 / 0.2e2 * t6 * t142 * t113 + t218 / 0.1e2 - t228 + t230 / 0.1e2);
  t313 = t261 * t149;
  t317 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t265);
  t321 = my_piecewise3(t62, 0, 0.1e2 / 0.9e1 * t313 * t121 + 0.5e1 / 0.3e1 * t64 * t317);
  t322 = t321 * t30;
  t326 = t152 * t98;
  t328 = t6 * t326 * t81;
  t335 = t6 * t129 * t166;
  t338 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t322 * t81 + t328 / 0.1e2 + t279 / 0.1e2 - t284 + 0.3e1 / 0.2e2 * t6 * t125 * t166 + t335 / 0.1e2);
  tv2rho21 = t118 + t134 + t147 + t171 + t7 * (t312 + t338);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t343 = t138 * t138;
  t348 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t87 + 0.2e1 * t204);
  t352 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t198 * t343 + 0.5e1 / 0.3e1 * t26 * t348);
  t353 = t352 * t30;
  t359 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t353 * t52 + t304 / 0.5e1 - t228);
  t360 = t149 * t149;
  t365 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t87 + 0.2e1 * t265);
  t369 = my_piecewise3(t62, 0, 0.1e2 / 0.9e1 * t261 * t360 + 0.5e1 / 0.3e1 * t64 * t365);
  t370 = t369 * t30;
  t379 = t68 * t68;
  t381 = 0.1e1 / t70 / t379;
  t382 = sigma[2] * t381;
  t388 = sigma[2] * sigma[2];
  t391 = 0.1e1 / t69 / t379 / t157;
  t396 = 0.55e2 / 0.81e2 * t37 * t382 - 0.11e2 / 0.27e2 * t109 * t382 * t80 + t246 * t388 * t391 * t80 / 0.81e2;
  t401 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t370 * t81 + t328 / 0.5e1 + 0.3e1 / 0.1e2 * t6 * t153 * t166 - t284 + t335 / 0.5e1 + 0.3e1 / 0.2e2 * t6 * t67 * t396);
  tv2rho22 = 0.2e1 * t147 + 0.2e1 * t171 + t7 * (t359 + t401);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t409 = t6 * t99 * t180 / 0.1e2;
  t416 = t232 * t38;
  t418 = 0.1e1 / t39 / t416;
  t423 = -0.5e1 / 0.27e2 * t37 * t105 + t46 * t36 * t105 * t51 / 0.9e1 - t246 * t418 * sigma[0] * t51 / 0.216e3;
  t428 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t94 * t180 + t409 + 0.3e1 / 0.2e2 * t6 * t31 * t423);
  tv2rhosigma0 = t7 * t428 + t184;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t435 = t6 * t129 * t191 / 0.1e2;
  t437 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t125 * t191 + t435);
  tv2rhosigma2 = t7 * t437 + t195;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t443 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t142 * t180 + t409);
  tv2rhosigma3 = t7 * t443 + t184;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t454 = t379 * t68;
  t456 = 0.1e1 / t69 / t454;
  t461 = -0.5e1 / 0.27e2 * t37 * t159 + t46 * t36 * t159 * t80 / 0.9e1 - t246 * t456 * sigma[2] * t80 / 0.216e3;
  t466 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t153 * t191 + t435 + 0.3e1 / 0.2e2 * t6 * t67 * t461);
  tv2rhosigma5 = t7 * t466 + t195;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t468 = t6 * t31;
  t469 = t232 * rho[0];
  t474 = t243 * t245 / t39 / t469 * t51;
  t477 = my_piecewise3(t1, 0, t468 * t474 / 0.384e4);
  tv2sigma20 = t7 * t477;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t478 = t6 * t67;
  t479 = t379 * rho[1];
  t484 = t243 * t245 / t69 / t479 * t80;
  t487 = my_piecewise3(t57, 0, t478 * t484 / 0.384e4);
  tv2sigma25 = t7 * t487;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t25, t26, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t39;
  double t40, t42, t46, t47, t51, t52, t56, t57;
  double t58, t60, t61, t62, t63, t64, t66, t67;
  double t68, t69, t70, t72, t76, t80, t81, t85;
  double tzk0;

  double t86, t87, t88, t90, t93, t94, t98, t99;
  double t102, t103, t105, t106, t109, t113, t118, t119;
  double t121, t124, t125, t129, t132, t134, tvrho0, t138;
  double t141, t142, t147, t149, t152, t153, t157, t159;
  double t160, t166, t171, tvrho1, t180, t184, tvsigma0, tvsigma1;
  double t191, t195, tvsigma2;

  double t198, t199, t202, t203, t204, t207, t211, t212;
  double t216, t218, t224, t225, t228, t230, t232, t234;
  double t235, t241, t242, t243, t245, t246, t247, t250;
  double t255, t260, t261, t262, t265, t268, t272, t273;
  double t277, t279, t281, t284, t286, tv2rho20, t289, t293;
  double t297, t298, t302, t304, t312, t313, t317, t321;
  double t322, t326, t328, t335, t338, tv2rho21, t343, t348;
  double t352, t353, t359, t360, t365, t369, t370, t379;
  double t381, t382, t388, t391, t396, t401, tv2rho22, t409;
  double t416, t418, t423, t428, tv2rhosigma0, tv2rhosigma1, t435, t437;
  double tv2rhosigma2, t443, tv2rhosigma3, tv2rhosigma4, t454, t456, t461, t466;
  double tv2rhosigma5, t468, t469, t474, t477, tv2sigma20, tv2sigma21, tv2sigma22;
  double tv2sigma23, tv2sigma24, t478, t479, t484, t487, tv2sigma25;

  double t491, t492, t495, t498, t499, t500, t503, t507;
  double t508, t512, t514, t519, t521, t524, t530, t531;
  double t534, t536, t539, t542, t543, t549, t551, t556;
  double t557, t558, t559, t560, t561, t562, t567, t572;
  double t574, t575, t578, t581, t584, t588, t589, t593;
  double t595, t597, t599, t601, t604, t606, tv3rho30, t609;
  double t610, t611, t614, t619, t620, t622, t626, t627;
  double t631, t634, t638, t640, t644, t653, t654, t655;
  double t658, t663, t665, t669, t670, t674, t677, t678;
  double t680, t689, t691, t694, tv3rho31, t697, t702, t706;
  double t710, t711, t715, t717, t726, t727, t732, t736;
  double t740, t741, t745, t747, t754, t762, t764, t765;
  double tv3rho32, t770, t777, t781, t782, t789, t790, t797;
  double t801, t802, t818, t819, t825, t827, t832, t833;
  double t834, t839, t844, tv3rho33, t852, t859, t861, t873;
  double t874, t879, t884, tv3rho2sigma0, tv3rho2sigma1, t891, t895, t897;
  double tv3rho2sigma2, t903, t911, tv3rho2sigma3, tv3rho2sigma4, t917, t924, t927;
  double tv3rho2sigma5, t935, tv3rho2sigma6, tv3rho2sigma7, t956, t957, t962, t967;
  double tv3rho2sigma8, t969, t972, t974, t977, t980, t983, t984;
  double t985, t986, t988, t989, t993, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22;
  double tv3rhosigma23, tv3rhosigma24, t995, t998, t1000, t1002, tv3rhosigma25, t1004;
  double t1008, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1010, t1015;
  double t1018, t1019, t1020, t1022, t1023, t1027, tv3rhosigma211, t1029;
  double t1030, t1032, t1033, t1036, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33;
  double tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t1037, t1039, t1040;
  double t1043, tv3sigma39;

  gga_k_pg_params *params;

  assert(p->params != NULL);
  params = (gga_k_pg_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = t2 * t2;
  t4 = M_CBRTPI;
  t6 = t3 * t4 * M_PI;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * p->zeta_threshold;
  t25 = POW_1_3(t20);
  t26 = t25 * t25;
  t28 = my_piecewise3(t21, t24, t26 * t20);
  t29 = POW_1_3(t7);
  t30 = t29 * t29;
  t31 = t28 * t30;
  t32 = M_CBRT6;
  t33 = M_PI * M_PI;
  t34 = POW_1_3(t33);
  t35 = t34 * t34;
  t36 = 0.1e1 / t35;
  t37 = t32 * t36;
  t38 = rho[0] * rho[0];
  t39 = POW_1_3(rho[0]);
  t40 = t39 * t39;
  t42 = 0.1e1 / t40 / t38;
  t46 = params->pg_mu * t32;
  t47 = t36 * sigma[0];
  t51 = exp(-t46 * t47 * t42 / 0.24e2);
  t52 = 0.5e1 / 0.72e2 * t37 * sigma[0] * t42 + t51;
  t56 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t31 * t52);
  t57 = rho[1] <= p->dens_threshold;
  t58 = -t17;
  t60 = my_piecewise5(t15, t12, t11, t16, t58 * t8);
  t61 = 0.1e1 + t60;
  t62 = t61 <= p->zeta_threshold;
  t63 = POW_1_3(t61);
  t64 = t63 * t63;
  t66 = my_piecewise3(t62, t24, t64 * t61);
  t67 = t66 * t30;
  t68 = rho[1] * rho[1];
  t69 = POW_1_3(rho[1]);
  t70 = t69 * t69;
  t72 = 0.1e1 / t70 / t68;
  t76 = t36 * sigma[2];
  t80 = exp(-t46 * t76 * t72 / 0.24e2);
  t81 = 0.5e1 / 0.72e2 * t37 * sigma[2] * t72 + t80;
  t85 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t67 * t81);
  tzk0 = t56 + t85;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t86 = t7 * t7;
  t87 = 0.1e1 / t86;
  t88 = t17 * t87;
  t90 = my_piecewise5(t11, 0, t15, 0, t8 - t88);
  t93 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t90);
  t94 = t93 * t30;
  t98 = 0.1e1 / t29;
  t99 = t28 * t98;
  t102 = t6 * t99 * t52 / 0.1e2;
  t103 = t38 * rho[0];
  t105 = 0.1e1 / t40 / t103;
  t106 = sigma[0] * t105;
  t109 = t46 * t36;
  t113 = -0.5e1 / 0.27e2 * t37 * t106 + t109 * t106 * t51 / 0.9e1;
  t118 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t94 * t52 + t102 + 0.3e1 / 0.2e2 * t6 * t31 * t113);
  t119 = t58 * t87;
  t121 = my_piecewise5(t15, 0, t11, 0, -t8 - t119);
  t124 = my_piecewise3(t62, 0, 0.5e1 / 0.3e1 * t64 * t121);
  t125 = t124 * t30;
  t129 = t66 * t98;
  t132 = t6 * t129 * t81 / 0.1e2;
  t134 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t125 * t81 + t132);
  tvrho0 = t56 + t85 + t7 * (t118 + t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t138 = my_piecewise5(t11, 0, t15, 0, -t8 - t88);
  t141 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t138);
  t142 = t141 * t30;
  t147 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t142 * t52 + t102);
  t149 = my_piecewise5(t15, 0, t11, 0, t8 - t119);
  t152 = my_piecewise3(t62, 0, 0.5e1 / 0.3e1 * t64 * t149);
  t153 = t152 * t30;
  t157 = t68 * rho[1];
  t159 = 0.1e1 / t70 / t157;
  t160 = sigma[2] * t159;
  t166 = -0.5e1 / 0.27e2 * t37 * t160 + t109 * t160 * t80 / 0.9e1;
  t171 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t153 * t81 + t132 + 0.3e1 / 0.2e2 * t6 * t67 * t166);
  tvrho1 = t56 + t85 + t7 * (t147 + t171);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t180 = 0.5e1 / 0.72e2 * t37 * t42 - t46 * t36 * t42 * t51 / 0.24e2;
  t184 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t31 * t180);
  tvsigma0 = t7 * t184;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t191 = 0.5e1 / 0.72e2 * t37 * t72 - t46 * t36 * t72 * t80 / 0.24e2;
  t195 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t67 * t191);
  tvsigma2 = t7 * t195;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t198 = 0.1e1 / t25;
  t199 = t90 * t90;
  t202 = t86 * t7;
  t203 = 0.1e1 / t202;
  t204 = t17 * t203;
  t207 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t87 + 0.2e1 * t204);
  t211 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t198 * t199 + 0.5e1 / 0.3e1 * t26 * t207);
  t212 = t211 * t30;
  t216 = t93 * t98;
  t218 = t6 * t216 * t52;
  t224 = 0.1e1 / t29 / t7;
  t225 = t28 * t224;
  t228 = t6 * t225 * t52 / 0.3e2;
  t230 = t6 * t99 * t113;
  t232 = t38 * t38;
  t234 = 0.1e1 / t40 / t232;
  t235 = sigma[0] * t234;
  t241 = params->pg_mu * params->pg_mu;
  t242 = t32 * t32;
  t243 = t241 * t242;
  t245 = 0.1e1 / t34 / t33;
  t246 = t243 * t245;
  t247 = sigma[0] * sigma[0];
  t250 = 0.1e1 / t39 / t232 / t103;
  t255 = 0.55e2 / 0.81e2 * t37 * t235 - 0.11e2 / 0.27e2 * t109 * t235 * t51 + t246 * t247 * t250 * t51 / 0.81e2;
  t260 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t212 * t52 + t218 / 0.5e1 + 0.3e1 / 0.1e2 * t6 * t94 * t113 - t228 + t230 / 0.5e1 + 0.3e1 / 0.2e2 * t6 * t31 * t255);
  t261 = 0.1e1 / t63;
  t262 = t121 * t121;
  t265 = t58 * t203;
  t268 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t87 + 0.2e1 * t265);
  t272 = my_piecewise3(t62, 0, 0.1e2 / 0.9e1 * t261 * t262 + 0.5e1 / 0.3e1 * t64 * t268);
  t273 = t272 * t30;
  t277 = t124 * t98;
  t279 = t6 * t277 * t81;
  t281 = t66 * t224;
  t284 = t6 * t281 * t81 / 0.3e2;
  t286 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t273 * t81 + t279 / 0.5e1 - t284);
  tv2rho20 = 0.2e1 * t118 + 0.2e1 * t134 + t7 * (t260 + t286);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t289 = t198 * t138;
  t293 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t204);
  t297 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t289 * t90 + 0.5e1 / 0.3e1 * t26 * t293);
  t298 = t297 * t30;
  t302 = t141 * t98;
  t304 = t6 * t302 * t52;
  t312 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t298 * t52 + t304 / 0.1e2 + 0.3e1 / 0.2e2 * t6 * t142 * t113 + t218 / 0.1e2 - t228 + t230 / 0.1e2);
  t313 = t261 * t149;
  t317 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t265);
  t321 = my_piecewise3(t62, 0, 0.1e2 / 0.9e1 * t313 * t121 + 0.5e1 / 0.3e1 * t64 * t317);
  t322 = t321 * t30;
  t326 = t152 * t98;
  t328 = t6 * t326 * t81;
  t335 = t6 * t129 * t166;
  t338 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t322 * t81 + t328 / 0.1e2 + t279 / 0.1e2 - t284 + 0.3e1 / 0.2e2 * t6 * t125 * t166 + t335 / 0.1e2);
  tv2rho21 = t118 + t134 + t147 + t171 + t7 * (t312 + t338);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t343 = t138 * t138;
  t348 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t87 + 0.2e1 * t204);
  t352 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t198 * t343 + 0.5e1 / 0.3e1 * t26 * t348);
  t353 = t352 * t30;
  t359 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t353 * t52 + t304 / 0.5e1 - t228);
  t360 = t149 * t149;
  t365 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t87 + 0.2e1 * t265);
  t369 = my_piecewise3(t62, 0, 0.1e2 / 0.9e1 * t261 * t360 + 0.5e1 / 0.3e1 * t64 * t365);
  t370 = t369 * t30;
  t379 = t68 * t68;
  t381 = 0.1e1 / t70 / t379;
  t382 = sigma[2] * t381;
  t388 = sigma[2] * sigma[2];
  t391 = 0.1e1 / t69 / t379 / t157;
  t396 = 0.55e2 / 0.81e2 * t37 * t382 - 0.11e2 / 0.27e2 * t109 * t382 * t80 + t246 * t388 * t391 * t80 / 0.81e2;
  t401 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t370 * t81 + t328 / 0.5e1 + 0.3e1 / 0.1e2 * t6 * t153 * t166 - t284 + t335 / 0.5e1 + 0.3e1 / 0.2e2 * t6 * t67 * t396);
  tv2rho22 = 0.2e1 * t147 + 0.2e1 * t171 + t7 * (t359 + t401);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t409 = t6 * t99 * t180 / 0.1e2;
  t416 = t232 * t38;
  t418 = 0.1e1 / t39 / t416;
  t423 = -0.5e1 / 0.27e2 * t37 * t105 + t46 * t36 * t105 * t51 / 0.9e1 - t246 * t418 * sigma[0] * t51 / 0.216e3;
  t428 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t94 * t180 + t409 + 0.3e1 / 0.2e2 * t6 * t31 * t423);
  tv2rhosigma0 = t7 * t428 + t184;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t435 = t6 * t129 * t191 / 0.1e2;
  t437 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t125 * t191 + t435);
  tv2rhosigma2 = t7 * t437 + t195;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t443 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t142 * t180 + t409);
  tv2rhosigma3 = t7 * t443 + t184;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t454 = t379 * t68;
  t456 = 0.1e1 / t69 / t454;
  t461 = -0.5e1 / 0.27e2 * t37 * t159 + t46 * t36 * t159 * t80 / 0.9e1 - t246 * t456 * sigma[2] * t80 / 0.216e3;
  t466 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t153 * t191 + t435 + 0.3e1 / 0.2e2 * t6 * t67 * t461);
  tv2rhosigma5 = t7 * t466 + t195;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t468 = t6 * t31;
  t469 = t232 * rho[0];
  t474 = t243 * t245 / t39 / t469 * t51;
  t477 = my_piecewise3(t1, 0, t468 * t474 / 0.384e4);
  tv2sigma20 = t7 * t477;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t478 = t6 * t67;
  t479 = t379 * rho[1];
  t484 = t243 * t245 / t69 / t479 * t80;
  t487 = my_piecewise3(t57, 0, t478 * t484 / 0.384e4);
  tv2sigma25 = t7 * t487;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t491 = 0.1e1 / t25 / t20;
  t492 = t199 * t90;
  t495 = t198 * t90;
  t498 = t86 * t86;
  t499 = 0.1e1 / t498;
  t500 = t17 * t499;
  t503 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t203 - 0.6e1 * t500);
  t507 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t491 * t492 + 0.1e2 / 0.3e1 * t495 * t207 + 0.5e1 / 0.3e1 * t26 * t503);
  t508 = t507 * t30;
  t512 = t211 * t98;
  t514 = t6 * t512 * t52;
  t519 = t93 * t224;
  t521 = t6 * t519 * t52;
  t524 = t6 * t216 * t113;
  t530 = 0.1e1 / t29 / t86;
  t531 = t28 * t530;
  t534 = 0.2e1 / 0.45e2 * t6 * t531 * t52;
  t536 = t6 * t225 * t113;
  t539 = t6 * t99 * t255;
  t542 = 0.1e1 / t40 / t469;
  t543 = sigma[0] * t542;
  t549 = t232 * t232;
  t551 = 0.1e1 / t39 / t549;
  t556 = t241 * params->pg_mu;
  t557 = t33 * t33;
  t558 = 0.1e1 / t557;
  t559 = t556 * t558;
  t560 = t247 * sigma[0];
  t561 = t549 * t103;
  t562 = 0.1e1 / t561;
  t567 = -0.77e3 / 0.243e3 * t37 * t543 + 0.154e3 / 0.81e2 * t109 * t543 * t51 - 0.11e2 / 0.81e2 * t246 * t247 * t551 * t51 + 0.2e1 / 0.243e3 * t559 * t560 * t562 * t51;
  t572 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t508 * t52 + 0.3e1 / 0.1e2 * t514 + 0.9e1 / 0.2e2 * t6 * t212 * t113 - t521 / 0.1e2 + 0.3e1 / 0.5e1 * t524 + 0.9e1 / 0.2e2 * t6 * t94 * t255 + t534 - t536 / 0.1e2 + 0.3e1 / 0.1e2 * t539 + 0.3e1 / 0.2e2 * t6 * t31 * t567);
  t574 = 0.1e1 / t63 / t61;
  t575 = t262 * t121;
  t578 = t261 * t121;
  t581 = t58 * t499;
  t584 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t203 - 0.6e1 * t581);
  t588 = my_piecewise3(t62, 0, -0.1e2 / 0.27e2 * t574 * t575 + 0.1e2 / 0.3e1 * t578 * t268 + 0.5e1 / 0.3e1 * t64 * t584);
  t589 = t588 * t30;
  t593 = t272 * t98;
  t595 = t6 * t593 * t81;
  t597 = t124 * t224;
  t599 = t6 * t597 * t81;
  t601 = t66 * t530;
  t604 = 0.2e1 / 0.45e2 * t6 * t601 * t81;
  t606 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t589 * t81 + 0.3e1 / 0.1e2 * t595 - t599 / 0.1e2 + t604);
  tv3rho30 = 0.3e1 * t260 + 0.3e1 * t286 + t7 * (t572 + t606);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t609 = 0.2e1 * t312;
  t610 = 0.2e1 * t338;
  t611 = t491 * t138;
  t614 = t198 * t293;
  t619 = 0.2e1 * t203;
  t620 = 0.6e1 * t500;
  t622 = my_piecewise5(t11, 0, t15, 0, t619 - t620);
  t626 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t611 * t199 + 0.2e2 / 0.9e1 * t614 * t90 + 0.1e2 / 0.9e1 * t289 * t207 + 0.5e1 / 0.3e1 * t26 * t622);
  t627 = t626 * t30;
  t631 = t297 * t98;
  t634 = t6 * t631 * t52 / 0.5e1;
  t638 = t141 * t224;
  t640 = t6 * t638 * t52;
  t644 = t6 * t302 * t113 / 0.5e1;
  t653 = 0.3e1 / 0.2e2 * t6 * t627 * t52 + t634 + 0.3e1 / 0.1e2 * t6 * t298 * t113 - t640 / 0.3e2 + t644 + 0.3e1 / 0.2e2 * t6 * t142 * t255 + t514 / 0.1e2 - t521 / 0.15e2 + t524 / 0.5e1 + t534 - t536 / 0.15e2 + t539 / 0.1e2;
  t654 = my_piecewise3(t1, 0, t653);
  t655 = t574 * t149;
  t658 = t261 * t317;
  t663 = 0.6e1 * t581;
  t665 = my_piecewise5(t15, 0, t11, 0, -t619 - t663);
  t669 = my_piecewise3(t62, 0, -0.1e2 / 0.27e2 * t655 * t262 + 0.2e2 / 0.9e1 * t658 * t121 + 0.1e2 / 0.9e1 * t313 * t268 + 0.5e1 / 0.3e1 * t64 * t665);
  t670 = t669 * t30;
  t674 = t321 * t98;
  t677 = t6 * t674 * t81 / 0.5e1;
  t678 = t152 * t224;
  t680 = t6 * t678 * t81;
  t689 = t6 * t277 * t166 / 0.5e1;
  t691 = t6 * t281 * t166;
  t694 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t670 * t81 + t677 - t680 / 0.3e2 + t595 / 0.1e2 - t599 / 0.15e2 + t604 + 0.3e1 / 0.2e2 * t6 * t273 * t166 + t689 - t691 / 0.3e2);
  tv3rho31 = t260 + t286 + t609 + t610 + t7 * (t654 + t694);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t697 = t491 * t343;
  t702 = t198 * t348;
  t706 = my_piecewise5(t11, 0, t15, 0, -t619 - t620);
  t710 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t697 * t90 + 0.2e2 / 0.9e1 * t289 * t293 + 0.1e2 / 0.9e1 * t702 * t90 + 0.5e1 / 0.3e1 * t26 * t706);
  t711 = t710 * t30;
  t715 = t352 * t98;
  t717 = t6 * t715 * t52;
  t726 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t711 * t52 + t717 / 0.1e2 + 0.3e1 / 0.2e2 * t6 * t353 * t113 + t634 - t640 / 0.15e2 + t644 - t521 / 0.3e2 + t534 - t536 / 0.3e2);
  t727 = t574 * t360;
  t732 = t261 * t365;
  t736 = my_piecewise5(t15, 0, t11, 0, t619 - t663);
  t740 = my_piecewise3(t62, 0, -0.1e2 / 0.27e2 * t727 * t121 + 0.2e2 / 0.9e1 * t313 * t317 + 0.1e2 / 0.9e1 * t732 * t121 + 0.5e1 / 0.3e1 * t64 * t736);
  t741 = t740 * t30;
  t745 = t369 * t98;
  t747 = t6 * t745 * t81;
  t754 = t6 * t326 * t166;
  t762 = t6 * t129 * t396;
  t764 = 0.3e1 / 0.2e2 * t6 * t741 * t81 + t747 / 0.1e2 + t677 - t680 / 0.15e2 + 0.3e1 / 0.1e2 * t6 * t322 * t166 + t754 / 0.5e1 - t599 / 0.3e2 + t604 + t689 - t691 / 0.15e2 + 0.3e1 / 0.2e2 * t6 * t125 * t396 + t762 / 0.1e2;
  t765 = my_piecewise3(t57, 0, t764);
  tv3rho32 = t609 + t610 + t359 + t401 + t7 * (t726 + t765);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t770 = t343 * t138;
  t777 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t203 - 0.6e1 * t500);
  t781 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t491 * t770 + 0.1e2 / 0.3e1 * t289 * t348 + 0.5e1 / 0.3e1 * t26 * t777);
  t782 = t781 * t30;
  t789 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t782 * t52 + 0.3e1 / 0.1e2 * t717 - t640 / 0.1e2 + t534);
  t790 = t360 * t149;
  t797 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t203 - 0.6e1 * t581);
  t801 = my_piecewise3(t62, 0, -0.1e2 / 0.27e2 * t574 * t790 + 0.1e2 / 0.3e1 * t313 * t365 + 0.5e1 / 0.3e1 * t64 * t797);
  t802 = t801 * t30;
  t818 = 0.1e1 / t70 / t479;
  t819 = sigma[2] * t818;
  t825 = t379 * t379;
  t827 = 0.1e1 / t69 / t825;
  t832 = t388 * sigma[2];
  t833 = t825 * t157;
  t834 = 0.1e1 / t833;
  t839 = -0.77e3 / 0.243e3 * t37 * t819 + 0.154e3 / 0.81e2 * t109 * t819 * t80 - 0.11e2 / 0.81e2 * t246 * t388 * t827 * t80 + 0.2e1 / 0.243e3 * t559 * t832 * t834 * t80;
  t844 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t802 * t81 + 0.3e1 / 0.1e2 * t747 + 0.9e1 / 0.2e2 * t6 * t370 * t166 - t680 / 0.1e2 + 0.3e1 / 0.5e1 * t754 + 0.9e1 / 0.2e2 * t6 * t153 * t396 + t604 - t691 / 0.1e2 + 0.3e1 / 0.1e2 * t762 + 0.3e1 / 0.2e2 * t6 * t67 * t839);
  tv3rho33 = 0.3e1 * t359 + 0.3e1 * t401 + t7 * (t789 + t844);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t852 = t6 * t216 * t180;
  t859 = t6 * t225 * t180 / 0.3e2;
  t861 = t6 * t99 * t423;
  t873 = t549 * t38;
  t874 = 0.1e1 / t873;
  t879 = 0.55e2 / 0.81e2 * t37 * t234 - 0.11e2 / 0.27e2 * t46 * t36 * t234 * t51 + t246 * t250 * sigma[0] * t51 / 0.24e2 - t559 * t874 * t247 * t51 / 0.324e3;
  t884 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t212 * t180 + t852 / 0.5e1 + 0.3e1 / 0.1e2 * t6 * t94 * t423 - t859 + t861 / 0.5e1 + 0.3e1 / 0.2e2 * t6 * t31 * t879);
  tv3rho2sigma0 = t7 * t884 + 0.2e1 * t428;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t891 = t6 * t277 * t191;
  t895 = t6 * t281 * t191 / 0.3e2;
  t897 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t273 * t191 + t891 / 0.5e1 - t895);
  tv3rho2sigma2 = t7 * t897 + 0.2e1 * t437;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t903 = t6 * t302 * t180;
  t911 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t298 * t180 + t903 / 0.1e2 + 0.3e1 / 0.2e2 * t6 * t142 * t423 + t852 / 0.1e2 - t859 + t861 / 0.1e2);
  tv3rho2sigma3 = t7 * t911 + t428 + t443;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t917 = t6 * t326 * t191;
  t924 = t6 * t129 * t461;
  t927 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t322 * t191 + t917 / 0.1e2 + t891 / 0.1e2 - t895 + 0.3e1 / 0.2e2 * t6 * t125 * t461 + t924 / 0.1e2);
  tv3rho2sigma5 = t7 * t927 + t437 + t466;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t935 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t353 * t180 + t903 / 0.5e1 - t859);
  tv3rho2sigma6 = t7 * t935 + 0.2e1 * t443;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t956 = t825 * t68;
  t957 = 0.1e1 / t956;
  t962 = 0.55e2 / 0.81e2 * t37 * t381 - 0.11e2 / 0.27e2 * t46 * t36 * t381 * t80 + t246 * t391 * sigma[2] * t80 / 0.24e2 - t559 * t957 * t388 * t80 / 0.324e3;
  t967 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t370 * t191 + t917 / 0.5e1 + 0.3e1 / 0.1e2 * t6 * t153 * t461 - t895 + t924 / 0.5e1 + 0.3e1 / 0.2e2 * t6 * t67 * t962);
  tv3rho2sigma8 = t7 * t967 + 0.2e1 * t466;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t969 = t6 * t94;
  t972 = t6 * t99;
  t974 = t972 * t474 / 0.576e4;
  t977 = t243 * t245 * t418 * t51;
  t980 = t4 * t4;
  t983 = t3 / t980 / t33;
  t984 = t983 * t31;
  t985 = t549 * rho[0];
  t986 = 0.1e1 / t985;
  t988 = sigma[0] * t51;
  t989 = t556 * t986 * t988;
  t993 = my_piecewise3(t1, 0, t969 * t474 / 0.384e4 + t974 - t468 * t977 / 0.72e3 + t984 * t989 / 0.576e4);
  tv3rhosigma20 = t7 * t993 + t477;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t995 = t6 * t125;
  t998 = t6 * t129;
  t1000 = t998 * t484 / 0.576e4;
  t1002 = my_piecewise3(t57, 0, t995 * t484 / 0.384e4 + t1000);
  tv3rhosigma25 = t7 * t1002 + t487;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1004 = t6 * t142;
  t1008 = my_piecewise3(t1, 0, t1004 * t474 / 0.384e4 + t974);
  tv3rhosigma26 = t7 * t1008 + t477;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1010 = t6 * t153;
  t1015 = t243 * t245 * t456 * t80;
  t1018 = t983 * t67;
  t1019 = t825 * rho[1];
  t1020 = 0.1e1 / t1019;
  t1022 = sigma[2] * t80;
  t1023 = t556 * t1020 * t1022;
  t1027 = my_piecewise3(t57, 0, t1010 * t484 / 0.384e4 + t1000 - t478 * t1015 / 0.72e3 + t1018 * t1023 / 0.576e4);
  tv3rhosigma211 = t7 * t1027 + t487;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1029 = t983 * t28;
  t1030 = t30 * t556;
  t1032 = 0.1e1 / t549 * t51;
  t1033 = t1030 * t1032;
  t1036 = my_piecewise3(t1, 0, -t1029 * t1033 / 0.1536e5);
  tv3sigma30 = t7 * t1036;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1037 = t983 * t66;
  t1039 = 0.1e1 / t825 * t80;
  t1040 = t1030 * t1039;
  t1043 = my_piecewise3(t57, 0, -t1037 * t1040 / 0.1536e5);
  tv3sigma39 = t7 * t1043;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t25, t26, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t39;
  double t40, t42, t46, t47, t51, t52, t56, t57;
  double t58, t60, t61, t62, t63, t64, t66, t67;
  double t68, t69, t70, t72, t76, t80, t81, t85;
  double tzk0;

  double t86, t87, t88, t90, t93, t94, t98, t99;
  double t102, t103, t105, t106, t109, t113, t118, t119;
  double t121, t124, t125, t129, t132, t134, tvrho0, t138;
  double t141, t142, t147, t149, t152, t153, t157, t159;
  double t160, t166, t171, tvrho1, t180, t184, tvsigma0, tvsigma1;
  double t191, t195, tvsigma2;

  double t198, t199, t202, t203, t204, t207, t211, t212;
  double t216, t218, t224, t225, t228, t230, t232, t234;
  double t235, t241, t242, t243, t245, t246, t247, t250;
  double t255, t260, t261, t262, t265, t268, t272, t273;
  double t277, t279, t281, t284, t286, tv2rho20, t289, t293;
  double t297, t298, t302, t304, t312, t313, t317, t321;
  double t322, t326, t328, t335, t338, tv2rho21, t343, t348;
  double t352, t353, t359, t360, t365, t369, t370, t379;
  double t381, t382, t388, t391, t396, t401, tv2rho22, t409;
  double t416, t418, t423, t428, tv2rhosigma0, tv2rhosigma1, t435, t437;
  double tv2rhosigma2, t443, tv2rhosigma3, tv2rhosigma4, t454, t456, t461, t466;
  double tv2rhosigma5, t468, t469, t474, t477, tv2sigma20, tv2sigma21, tv2sigma22;
  double tv2sigma23, tv2sigma24, t478, t479, t484, t487, tv2sigma25;

  double t491, t492, t495, t498, t499, t500, t503, t507;
  double t508, t512, t514, t519, t521, t524, t530, t531;
  double t534, t536, t539, t542, t543, t549, t551, t556;
  double t557, t558, t559, t560, t561, t562, t567, t572;
  double t574, t575, t578, t581, t584, t588, t589, t593;
  double t595, t597, t599, t601, t604, t606, tv3rho30, t609;
  double t610, t611, t614, t619, t620, t622, t626, t627;
  double t631, t634, t638, t640, t644, t653, t654, t655;
  double t658, t663, t665, t669, t670, t674, t677, t678;
  double t680, t689, t691, t694, tv3rho31, t697, t702, t706;
  double t710, t711, t715, t717, t726, t727, t732, t736;
  double t740, t741, t745, t747, t754, t762, t764, t765;
  double tv3rho32, t770, t777, t781, t782, t789, t790, t797;
  double t801, t802, t818, t819, t825, t827, t832, t833;
  double t834, t839, t844, tv3rho33, t852, t859, t861, t873;
  double t874, t879, t884, tv3rho2sigma0, tv3rho2sigma1, t891, t895, t897;
  double tv3rho2sigma2, t903, t911, tv3rho2sigma3, tv3rho2sigma4, t917, t924, t927;
  double tv3rho2sigma5, t935, tv3rho2sigma6, tv3rho2sigma7, t956, t957, t962, t967;
  double tv3rho2sigma8, t969, t972, t974, t977, t980, t983, t984;
  double t985, t986, t988, t989, t993, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22;
  double tv3rhosigma23, tv3rhosigma24, t995, t998, t1000, t1002, tv3rhosigma25, t1004;
  double t1008, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1010, t1015;
  double t1018, t1019, t1020, t1022, t1023, t1027, tv3rhosigma211, t1029;
  double t1030, t1032, t1033, t1036, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33;
  double tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t1037, t1039, t1040;
  double t1043, tv3sigma39;

  double t1047, t1053, t1056, t1062, t1065, t1068, t1072, t1084;
  double t1090, t1091, t1092, t1098, t1106, t1108, t1109, t1115;
  double t1121, t1122, t1125, t1129, t1139, t1142, t1146, t1149;
  double t1153, t1155, t1156, t1157, t1159, t1160, t1166, t1171;
  double t1174, t1178, t1185, t1189, t1193, t1198, t1200, tv4rho40;
  double t1221, t1222, t1224, t1228, t1237, t1243, t1244, t1246;
  double t1259, t1263, t1264, t1267, t1272, t1273, t1290, t1292;
  double t1296, t1303, t1307, t1308, t1311, t1320, t1323, t1324;
  double t1326, t1328, t1329, tv4rho41, t1344, t1357, t1361, t1370;
  double t1383, t1387, t1394, t1395, t1404, t1417, t1421, t1428;
  double t1432, t1441, t1444, t1455, t1458, t1460, t1461, tv4rho42;
  double t1482, t1486, t1493, t1504, t1505, t1522, t1526, t1533;
  double t1541, t1550, t1560, t1562, t1563, tv4rho43, t1568, t1573;
  double t1580, t1584, t1593, t1594, t1599, t1606, t1610, t1626;
  double t1638, t1644, t1650, t1667, t1668, tv4rho44, t1676, t1682;
  double t1685, t1692, t1694, t1697, t1726, tv4rho3sigma0, tv4rho3sigma1, t1733;
  double t1736, t1740, t1742, tv4rho3sigma2, t1744, t1750, t1755, t1759;
  double t1768, t1769, tv4rho3sigma3, tv4rho3sigma4, t1771, t1777, t1779, t1788;
  double t1790, t1793, tv4rho3sigma5, t1799, t1808, tv4rho3sigma6, tv4rho3sigma7, t1814;
  double t1821, t1829, t1831, t1832, tv4rho3sigma8, t1841, tv4rho3sigma9, tv4rho3sigma10;
  double t1885, tv4rho3sigma11, t1892, t1901, t1902, t1905, t1917, t1921;
  double t1926, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t1933, t1937;
  double t1939, tv4rho2sigma25, t1945, t1956, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29;
  double tv4rho2sigma210, t1962, t1967, t1973, t1976, tv4rho2sigma211, t1984, tv4rho2sigma212;
  double tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t2008, t2012, t2017, tv4rho2sigma217;
  double t2022, t2025, t2038, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34;
  double tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t2045, t2047, tv4rhosigma39, t2053;
  double tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317;
  double tv4rhosigma318, t2070, tv4rhosigma319, t2078, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43;
  double tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411;
  double tv4sigma412, tv4sigma413, t2085, tv4sigma414;

  gga_k_pg_params *params;

  assert(p->params != NULL);
  params = (gga_k_pg_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = t2 * t2;
  t4 = M_CBRTPI;
  t6 = t3 * t4 * M_PI;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * p->zeta_threshold;
  t25 = POW_1_3(t20);
  t26 = t25 * t25;
  t28 = my_piecewise3(t21, t24, t26 * t20);
  t29 = POW_1_3(t7);
  t30 = t29 * t29;
  t31 = t28 * t30;
  t32 = M_CBRT6;
  t33 = M_PI * M_PI;
  t34 = POW_1_3(t33);
  t35 = t34 * t34;
  t36 = 0.1e1 / t35;
  t37 = t32 * t36;
  t38 = rho[0] * rho[0];
  t39 = POW_1_3(rho[0]);
  t40 = t39 * t39;
  t42 = 0.1e1 / t40 / t38;
  t46 = params->pg_mu * t32;
  t47 = t36 * sigma[0];
  t51 = exp(-t46 * t47 * t42 / 0.24e2);
  t52 = 0.5e1 / 0.72e2 * t37 * sigma[0] * t42 + t51;
  t56 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t31 * t52);
  t57 = rho[1] <= p->dens_threshold;
  t58 = -t17;
  t60 = my_piecewise5(t15, t12, t11, t16, t58 * t8);
  t61 = 0.1e1 + t60;
  t62 = t61 <= p->zeta_threshold;
  t63 = POW_1_3(t61);
  t64 = t63 * t63;
  t66 = my_piecewise3(t62, t24, t64 * t61);
  t67 = t66 * t30;
  t68 = rho[1] * rho[1];
  t69 = POW_1_3(rho[1]);
  t70 = t69 * t69;
  t72 = 0.1e1 / t70 / t68;
  t76 = t36 * sigma[2];
  t80 = exp(-t46 * t76 * t72 / 0.24e2);
  t81 = 0.5e1 / 0.72e2 * t37 * sigma[2] * t72 + t80;
  t85 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t67 * t81);
  tzk0 = t56 + t85;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t86 = t7 * t7;
  t87 = 0.1e1 / t86;
  t88 = t17 * t87;
  t90 = my_piecewise5(t11, 0, t15, 0, t8 - t88);
  t93 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t90);
  t94 = t93 * t30;
  t98 = 0.1e1 / t29;
  t99 = t28 * t98;
  t102 = t6 * t99 * t52 / 0.1e2;
  t103 = t38 * rho[0];
  t105 = 0.1e1 / t40 / t103;
  t106 = sigma[0] * t105;
  t109 = t46 * t36;
  t113 = -0.5e1 / 0.27e2 * t37 * t106 + t109 * t106 * t51 / 0.9e1;
  t118 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t94 * t52 + t102 + 0.3e1 / 0.2e2 * t6 * t31 * t113);
  t119 = t58 * t87;
  t121 = my_piecewise5(t15, 0, t11, 0, -t8 - t119);
  t124 = my_piecewise3(t62, 0, 0.5e1 / 0.3e1 * t64 * t121);
  t125 = t124 * t30;
  t129 = t66 * t98;
  t132 = t6 * t129 * t81 / 0.1e2;
  t134 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t125 * t81 + t132);
  tvrho0 = t56 + t85 + t7 * (t118 + t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t138 = my_piecewise5(t11, 0, t15, 0, -t8 - t88);
  t141 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t138);
  t142 = t141 * t30;
  t147 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t142 * t52 + t102);
  t149 = my_piecewise5(t15, 0, t11, 0, t8 - t119);
  t152 = my_piecewise3(t62, 0, 0.5e1 / 0.3e1 * t64 * t149);
  t153 = t152 * t30;
  t157 = t68 * rho[1];
  t159 = 0.1e1 / t70 / t157;
  t160 = sigma[2] * t159;
  t166 = -0.5e1 / 0.27e2 * t37 * t160 + t109 * t160 * t80 / 0.9e1;
  t171 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t153 * t81 + t132 + 0.3e1 / 0.2e2 * t6 * t67 * t166);
  tvrho1 = t56 + t85 + t7 * (t147 + t171);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t180 = 0.5e1 / 0.72e2 * t37 * t42 - t46 * t36 * t42 * t51 / 0.24e2;
  t184 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t31 * t180);
  tvsigma0 = t7 * t184;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t191 = 0.5e1 / 0.72e2 * t37 * t72 - t46 * t36 * t72 * t80 / 0.24e2;
  t195 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t67 * t191);
  tvsigma2 = t7 * t195;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t198 = 0.1e1 / t25;
  t199 = t90 * t90;
  t202 = t86 * t7;
  t203 = 0.1e1 / t202;
  t204 = t17 * t203;
  t207 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t87 + 0.2e1 * t204);
  t211 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t198 * t199 + 0.5e1 / 0.3e1 * t26 * t207);
  t212 = t211 * t30;
  t216 = t93 * t98;
  t218 = t6 * t216 * t52;
  t224 = 0.1e1 / t29 / t7;
  t225 = t28 * t224;
  t228 = t6 * t225 * t52 / 0.3e2;
  t230 = t6 * t99 * t113;
  t232 = t38 * t38;
  t234 = 0.1e1 / t40 / t232;
  t235 = sigma[0] * t234;
  t241 = params->pg_mu * params->pg_mu;
  t242 = t32 * t32;
  t243 = t241 * t242;
  t245 = 0.1e1 / t34 / t33;
  t246 = t243 * t245;
  t247 = sigma[0] * sigma[0];
  t250 = 0.1e1 / t39 / t232 / t103;
  t255 = 0.55e2 / 0.81e2 * t37 * t235 - 0.11e2 / 0.27e2 * t109 * t235 * t51 + t246 * t247 * t250 * t51 / 0.81e2;
  t260 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t212 * t52 + t218 / 0.5e1 + 0.3e1 / 0.1e2 * t6 * t94 * t113 - t228 + t230 / 0.5e1 + 0.3e1 / 0.2e2 * t6 * t31 * t255);
  t261 = 0.1e1 / t63;
  t262 = t121 * t121;
  t265 = t58 * t203;
  t268 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t87 + 0.2e1 * t265);
  t272 = my_piecewise3(t62, 0, 0.1e2 / 0.9e1 * t261 * t262 + 0.5e1 / 0.3e1 * t64 * t268);
  t273 = t272 * t30;
  t277 = t124 * t98;
  t279 = t6 * t277 * t81;
  t281 = t66 * t224;
  t284 = t6 * t281 * t81 / 0.3e2;
  t286 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t273 * t81 + t279 / 0.5e1 - t284);
  tv2rho20 = 0.2e1 * t118 + 0.2e1 * t134 + t7 * (t260 + t286);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t289 = t198 * t138;
  t293 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t204);
  t297 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t289 * t90 + 0.5e1 / 0.3e1 * t26 * t293);
  t298 = t297 * t30;
  t302 = t141 * t98;
  t304 = t6 * t302 * t52;
  t312 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t298 * t52 + t304 / 0.1e2 + 0.3e1 / 0.2e2 * t6 * t142 * t113 + t218 / 0.1e2 - t228 + t230 / 0.1e2);
  t313 = t261 * t149;
  t317 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t265);
  t321 = my_piecewise3(t62, 0, 0.1e2 / 0.9e1 * t313 * t121 + 0.5e1 / 0.3e1 * t64 * t317);
  t322 = t321 * t30;
  t326 = t152 * t98;
  t328 = t6 * t326 * t81;
  t335 = t6 * t129 * t166;
  t338 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t322 * t81 + t328 / 0.1e2 + t279 / 0.1e2 - t284 + 0.3e1 / 0.2e2 * t6 * t125 * t166 + t335 / 0.1e2);
  tv2rho21 = t118 + t134 + t147 + t171 + t7 * (t312 + t338);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t343 = t138 * t138;
  t348 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t87 + 0.2e1 * t204);
  t352 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t198 * t343 + 0.5e1 / 0.3e1 * t26 * t348);
  t353 = t352 * t30;
  t359 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t353 * t52 + t304 / 0.5e1 - t228);
  t360 = t149 * t149;
  t365 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t87 + 0.2e1 * t265);
  t369 = my_piecewise3(t62, 0, 0.1e2 / 0.9e1 * t261 * t360 + 0.5e1 / 0.3e1 * t64 * t365);
  t370 = t369 * t30;
  t379 = t68 * t68;
  t381 = 0.1e1 / t70 / t379;
  t382 = sigma[2] * t381;
  t388 = sigma[2] * sigma[2];
  t391 = 0.1e1 / t69 / t379 / t157;
  t396 = 0.55e2 / 0.81e2 * t37 * t382 - 0.11e2 / 0.27e2 * t109 * t382 * t80 + t246 * t388 * t391 * t80 / 0.81e2;
  t401 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t370 * t81 + t328 / 0.5e1 + 0.3e1 / 0.1e2 * t6 * t153 * t166 - t284 + t335 / 0.5e1 + 0.3e1 / 0.2e2 * t6 * t67 * t396);
  tv2rho22 = 0.2e1 * t147 + 0.2e1 * t171 + t7 * (t359 + t401);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t409 = t6 * t99 * t180 / 0.1e2;
  t416 = t232 * t38;
  t418 = 0.1e1 / t39 / t416;
  t423 = -0.5e1 / 0.27e2 * t37 * t105 + t46 * t36 * t105 * t51 / 0.9e1 - t246 * t418 * sigma[0] * t51 / 0.216e3;
  t428 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t94 * t180 + t409 + 0.3e1 / 0.2e2 * t6 * t31 * t423);
  tv2rhosigma0 = t7 * t428 + t184;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t435 = t6 * t129 * t191 / 0.1e2;
  t437 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t125 * t191 + t435);
  tv2rhosigma2 = t7 * t437 + t195;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t443 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t142 * t180 + t409);
  tv2rhosigma3 = t7 * t443 + t184;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t454 = t379 * t68;
  t456 = 0.1e1 / t69 / t454;
  t461 = -0.5e1 / 0.27e2 * t37 * t159 + t46 * t36 * t159 * t80 / 0.9e1 - t246 * t456 * sigma[2] * t80 / 0.216e3;
  t466 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t153 * t191 + t435 + 0.3e1 / 0.2e2 * t6 * t67 * t461);
  tv2rhosigma5 = t7 * t466 + t195;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t468 = t6 * t31;
  t469 = t232 * rho[0];
  t474 = t243 * t245 / t39 / t469 * t51;
  t477 = my_piecewise3(t1, 0, t468 * t474 / 0.384e4);
  tv2sigma20 = t7 * t477;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t478 = t6 * t67;
  t479 = t379 * rho[1];
  t484 = t243 * t245 / t69 / t479 * t80;
  t487 = my_piecewise3(t57, 0, t478 * t484 / 0.384e4);
  tv2sigma25 = t7 * t487;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t491 = 0.1e1 / t25 / t20;
  t492 = t199 * t90;
  t495 = t198 * t90;
  t498 = t86 * t86;
  t499 = 0.1e1 / t498;
  t500 = t17 * t499;
  t503 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t203 - 0.6e1 * t500);
  t507 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t491 * t492 + 0.1e2 / 0.3e1 * t495 * t207 + 0.5e1 / 0.3e1 * t26 * t503);
  t508 = t507 * t30;
  t512 = t211 * t98;
  t514 = t6 * t512 * t52;
  t519 = t93 * t224;
  t521 = t6 * t519 * t52;
  t524 = t6 * t216 * t113;
  t530 = 0.1e1 / t29 / t86;
  t531 = t28 * t530;
  t534 = 0.2e1 / 0.45e2 * t6 * t531 * t52;
  t536 = t6 * t225 * t113;
  t539 = t6 * t99 * t255;
  t542 = 0.1e1 / t40 / t469;
  t543 = sigma[0] * t542;
  t549 = t232 * t232;
  t551 = 0.1e1 / t39 / t549;
  t556 = t241 * params->pg_mu;
  t557 = t33 * t33;
  t558 = 0.1e1 / t557;
  t559 = t556 * t558;
  t560 = t247 * sigma[0];
  t561 = t549 * t103;
  t562 = 0.1e1 / t561;
  t567 = -0.77e3 / 0.243e3 * t37 * t543 + 0.154e3 / 0.81e2 * t109 * t543 * t51 - 0.11e2 / 0.81e2 * t246 * t247 * t551 * t51 + 0.2e1 / 0.243e3 * t559 * t560 * t562 * t51;
  t572 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t508 * t52 + 0.3e1 / 0.1e2 * t514 + 0.9e1 / 0.2e2 * t6 * t212 * t113 - t521 / 0.1e2 + 0.3e1 / 0.5e1 * t524 + 0.9e1 / 0.2e2 * t6 * t94 * t255 + t534 - t536 / 0.1e2 + 0.3e1 / 0.1e2 * t539 + 0.3e1 / 0.2e2 * t6 * t31 * t567);
  t574 = 0.1e1 / t63 / t61;
  t575 = t262 * t121;
  t578 = t261 * t121;
  t581 = t58 * t499;
  t584 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t203 - 0.6e1 * t581);
  t588 = my_piecewise3(t62, 0, -0.1e2 / 0.27e2 * t574 * t575 + 0.1e2 / 0.3e1 * t578 * t268 + 0.5e1 / 0.3e1 * t64 * t584);
  t589 = t588 * t30;
  t593 = t272 * t98;
  t595 = t6 * t593 * t81;
  t597 = t124 * t224;
  t599 = t6 * t597 * t81;
  t601 = t66 * t530;
  t604 = 0.2e1 / 0.45e2 * t6 * t601 * t81;
  t606 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t589 * t81 + 0.3e1 / 0.1e2 * t595 - t599 / 0.1e2 + t604);
  tv3rho30 = 0.3e1 * t260 + 0.3e1 * t286 + t7 * (t572 + t606);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t609 = 0.2e1 * t312;
  t610 = 0.2e1 * t338;
  t611 = t491 * t138;
  t614 = t198 * t293;
  t619 = 0.2e1 * t203;
  t620 = 0.6e1 * t500;
  t622 = my_piecewise5(t11, 0, t15, 0, t619 - t620);
  t626 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t611 * t199 + 0.2e2 / 0.9e1 * t614 * t90 + 0.1e2 / 0.9e1 * t289 * t207 + 0.5e1 / 0.3e1 * t26 * t622);
  t627 = t626 * t30;
  t631 = t297 * t98;
  t634 = t6 * t631 * t52 / 0.5e1;
  t638 = t141 * t224;
  t640 = t6 * t638 * t52;
  t644 = t6 * t302 * t113 / 0.5e1;
  t653 = 0.3e1 / 0.2e2 * t6 * t627 * t52 + t634 + 0.3e1 / 0.1e2 * t6 * t298 * t113 - t640 / 0.3e2 + t644 + 0.3e1 / 0.2e2 * t6 * t142 * t255 + t514 / 0.1e2 - t521 / 0.15e2 + t524 / 0.5e1 + t534 - t536 / 0.15e2 + t539 / 0.1e2;
  t654 = my_piecewise3(t1, 0, t653);
  t655 = t574 * t149;
  t658 = t261 * t317;
  t663 = 0.6e1 * t581;
  t665 = my_piecewise5(t15, 0, t11, 0, -t619 - t663);
  t669 = my_piecewise3(t62, 0, -0.1e2 / 0.27e2 * t655 * t262 + 0.2e2 / 0.9e1 * t658 * t121 + 0.1e2 / 0.9e1 * t313 * t268 + 0.5e1 / 0.3e1 * t64 * t665);
  t670 = t669 * t30;
  t674 = t321 * t98;
  t677 = t6 * t674 * t81 / 0.5e1;
  t678 = t152 * t224;
  t680 = t6 * t678 * t81;
  t689 = t6 * t277 * t166 / 0.5e1;
  t691 = t6 * t281 * t166;
  t694 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t670 * t81 + t677 - t680 / 0.3e2 + t595 / 0.1e2 - t599 / 0.15e2 + t604 + 0.3e1 / 0.2e2 * t6 * t273 * t166 + t689 - t691 / 0.3e2);
  tv3rho31 = t260 + t286 + t609 + t610 + t7 * (t654 + t694);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t697 = t491 * t343;
  t702 = t198 * t348;
  t706 = my_piecewise5(t11, 0, t15, 0, -t619 - t620);
  t710 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t697 * t90 + 0.2e2 / 0.9e1 * t289 * t293 + 0.1e2 / 0.9e1 * t702 * t90 + 0.5e1 / 0.3e1 * t26 * t706);
  t711 = t710 * t30;
  t715 = t352 * t98;
  t717 = t6 * t715 * t52;
  t726 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t711 * t52 + t717 / 0.1e2 + 0.3e1 / 0.2e2 * t6 * t353 * t113 + t634 - t640 / 0.15e2 + t644 - t521 / 0.3e2 + t534 - t536 / 0.3e2);
  t727 = t574 * t360;
  t732 = t261 * t365;
  t736 = my_piecewise5(t15, 0, t11, 0, t619 - t663);
  t740 = my_piecewise3(t62, 0, -0.1e2 / 0.27e2 * t727 * t121 + 0.2e2 / 0.9e1 * t313 * t317 + 0.1e2 / 0.9e1 * t732 * t121 + 0.5e1 / 0.3e1 * t64 * t736);
  t741 = t740 * t30;
  t745 = t369 * t98;
  t747 = t6 * t745 * t81;
  t754 = t6 * t326 * t166;
  t762 = t6 * t129 * t396;
  t764 = 0.3e1 / 0.2e2 * t6 * t741 * t81 + t747 / 0.1e2 + t677 - t680 / 0.15e2 + 0.3e1 / 0.1e2 * t6 * t322 * t166 + t754 / 0.5e1 - t599 / 0.3e2 + t604 + t689 - t691 / 0.15e2 + 0.3e1 / 0.2e2 * t6 * t125 * t396 + t762 / 0.1e2;
  t765 = my_piecewise3(t57, 0, t764);
  tv3rho32 = t609 + t610 + t359 + t401 + t7 * (t726 + t765);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t770 = t343 * t138;
  t777 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t203 - 0.6e1 * t500);
  t781 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t491 * t770 + 0.1e2 / 0.3e1 * t289 * t348 + 0.5e1 / 0.3e1 * t26 * t777);
  t782 = t781 * t30;
  t789 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t782 * t52 + 0.3e1 / 0.1e2 * t717 - t640 / 0.1e2 + t534);
  t790 = t360 * t149;
  t797 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t203 - 0.6e1 * t581);
  t801 = my_piecewise3(t62, 0, -0.1e2 / 0.27e2 * t574 * t790 + 0.1e2 / 0.3e1 * t313 * t365 + 0.5e1 / 0.3e1 * t64 * t797);
  t802 = t801 * t30;
  t818 = 0.1e1 / t70 / t479;
  t819 = sigma[2] * t818;
  t825 = t379 * t379;
  t827 = 0.1e1 / t69 / t825;
  t832 = t388 * sigma[2];
  t833 = t825 * t157;
  t834 = 0.1e1 / t833;
  t839 = -0.77e3 / 0.243e3 * t37 * t819 + 0.154e3 / 0.81e2 * t109 * t819 * t80 - 0.11e2 / 0.81e2 * t246 * t388 * t827 * t80 + 0.2e1 / 0.243e3 * t559 * t832 * t834 * t80;
  t844 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t802 * t81 + 0.3e1 / 0.1e2 * t747 + 0.9e1 / 0.2e2 * t6 * t370 * t166 - t680 / 0.1e2 + 0.3e1 / 0.5e1 * t754 + 0.9e1 / 0.2e2 * t6 * t153 * t396 + t604 - t691 / 0.1e2 + 0.3e1 / 0.1e2 * t762 + 0.3e1 / 0.2e2 * t6 * t67 * t839);
  tv3rho33 = 0.3e1 * t359 + 0.3e1 * t401 + t7 * (t789 + t844);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t852 = t6 * t216 * t180;
  t859 = t6 * t225 * t180 / 0.3e2;
  t861 = t6 * t99 * t423;
  t873 = t549 * t38;
  t874 = 0.1e1 / t873;
  t879 = 0.55e2 / 0.81e2 * t37 * t234 - 0.11e2 / 0.27e2 * t46 * t36 * t234 * t51 + t246 * t250 * sigma[0] * t51 / 0.24e2 - t559 * t874 * t247 * t51 / 0.324e3;
  t884 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t212 * t180 + t852 / 0.5e1 + 0.3e1 / 0.1e2 * t6 * t94 * t423 - t859 + t861 / 0.5e1 + 0.3e1 / 0.2e2 * t6 * t31 * t879);
  tv3rho2sigma0 = t7 * t884 + 0.2e1 * t428;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t891 = t6 * t277 * t191;
  t895 = t6 * t281 * t191 / 0.3e2;
  t897 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t273 * t191 + t891 / 0.5e1 - t895);
  tv3rho2sigma2 = t7 * t897 + 0.2e1 * t437;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t903 = t6 * t302 * t180;
  t911 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t298 * t180 + t903 / 0.1e2 + 0.3e1 / 0.2e2 * t6 * t142 * t423 + t852 / 0.1e2 - t859 + t861 / 0.1e2);
  tv3rho2sigma3 = t7 * t911 + t428 + t443;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t917 = t6 * t326 * t191;
  t924 = t6 * t129 * t461;
  t927 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t322 * t191 + t917 / 0.1e2 + t891 / 0.1e2 - t895 + 0.3e1 / 0.2e2 * t6 * t125 * t461 + t924 / 0.1e2);
  tv3rho2sigma5 = t7 * t927 + t437 + t466;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t935 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t353 * t180 + t903 / 0.5e1 - t859);
  tv3rho2sigma6 = t7 * t935 + 0.2e1 * t443;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t956 = t825 * t68;
  t957 = 0.1e1 / t956;
  t962 = 0.55e2 / 0.81e2 * t37 * t381 - 0.11e2 / 0.27e2 * t46 * t36 * t381 * t80 + t246 * t391 * sigma[2] * t80 / 0.24e2 - t559 * t957 * t388 * t80 / 0.324e3;
  t967 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t370 * t191 + t917 / 0.5e1 + 0.3e1 / 0.1e2 * t6 * t153 * t461 - t895 + t924 / 0.5e1 + 0.3e1 / 0.2e2 * t6 * t67 * t962);
  tv3rho2sigma8 = t7 * t967 + 0.2e1 * t466;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t969 = t6 * t94;
  t972 = t6 * t99;
  t974 = t972 * t474 / 0.576e4;
  t977 = t243 * t245 * t418 * t51;
  t980 = t4 * t4;
  t983 = t3 / t980 / t33;
  t984 = t983 * t31;
  t985 = t549 * rho[0];
  t986 = 0.1e1 / t985;
  t988 = sigma[0] * t51;
  t989 = t556 * t986 * t988;
  t993 = my_piecewise3(t1, 0, t969 * t474 / 0.384e4 + t974 - t468 * t977 / 0.72e3 + t984 * t989 / 0.576e4);
  tv3rhosigma20 = t7 * t993 + t477;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t995 = t6 * t125;
  t998 = t6 * t129;
  t1000 = t998 * t484 / 0.576e4;
  t1002 = my_piecewise3(t57, 0, t995 * t484 / 0.384e4 + t1000);
  tv3rhosigma25 = t7 * t1002 + t487;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1004 = t6 * t142;
  t1008 = my_piecewise3(t1, 0, t1004 * t474 / 0.384e4 + t974);
  tv3rhosigma26 = t7 * t1008 + t477;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1010 = t6 * t153;
  t1015 = t243 * t245 * t456 * t80;
  t1018 = t983 * t67;
  t1019 = t825 * rho[1];
  t1020 = 0.1e1 / t1019;
  t1022 = sigma[2] * t80;
  t1023 = t556 * t1020 * t1022;
  t1027 = my_piecewise3(t57, 0, t1010 * t484 / 0.384e4 + t1000 - t478 * t1015 / 0.72e3 + t1018 * t1023 / 0.576e4);
  tv3rhosigma211 = t7 * t1027 + t487;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1029 = t983 * t28;
  t1030 = t30 * t556;
  t1032 = 0.1e1 / t549 * t51;
  t1033 = t1030 * t1032;
  t1036 = my_piecewise3(t1, 0, -t1029 * t1033 / 0.1536e5);
  tv3sigma30 = t7 * t1036;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1037 = t983 * t66;
  t1039 = 0.1e1 / t825 * t80;
  t1040 = t1030 * t1039;
  t1043 = my_piecewise3(t57, 0, -t1037 * t1040 / 0.1536e5);
  tv3sigma39 = t7 * t1043;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t1047 = t6 * t512 * t113;
  t1053 = t6 * t519 * t113;
  t1056 = t6 * t216 * t255;
  t1062 = t6 * t531 * t113;
  t1065 = t6 * t225 * t255;
  t1068 = t6 * t99 * t567;
  t1072 = sigma[0] / t40 / t416;
  t1084 = t549 * t232;
  t1090 = t241 * t241;
  t1091 = t1090 * t558;
  t1092 = t247 * t247;
  t1098 = t36 * t51;
  t1106 = t20 * t20;
  t1108 = 0.1e1 / t25 / t1106;
  t1109 = t199 * t199;
  t1115 = t207 * t207;
  t1121 = 0.1e1 / t498 / t7;
  t1122 = t17 * t1121;
  t1125 = my_piecewise5(t11, 0, t15, 0, -0.24e2 * t499 + 0.24e2 * t1122);
  t1129 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t1108 * t1109 - 0.2e2 / 0.9e1 * t491 * t199 * t207 + 0.1e2 / 0.3e1 * t198 * t1115 + 0.4e2 / 0.9e1 * t495 * t503 + 0.5e1 / 0.3e1 * t26 * t1125);
  t1139 = t6 * t93 * t530 * t52;
  t1142 = 0.1e1 / t29 / t202;
  t1146 = 0.14e2 / 0.135e3 * t6 * t28 * t1142 * t52;
  t1149 = t6 * t507 * t98 * t52;
  t1153 = t6 * t211 * t224 * t52;
  t1155 = 0.6e1 / 0.5e1 * t1047 + 0.9e1 / 0.1e2 * t6 * t212 * t255 - 0.2e1 / 0.5e1 * t1053 + 0.6e1 / 0.5e1 * t1056 + 0.3e1 / 0.5e1 * t6 * t94 * t567 + 0.8e1 / 0.45e2 * t1062 - t1065 / 0.5e1 + 0.2e1 / 0.5e1 * t1068 + 0.3e1 / 0.2e2 * t6 * t31 * (0.1309e5 / 0.729e3 * t37 * t1072 - 0.2618e4 / 0.243e3 * t109 * t1072 * t51 + 0.979e3 / 0.729e3 * t246 * t247 / t39 / t985 * t51 - 0.44e2 / 0.243e3 * t559 * t560 / t1084 * t51 + 0.2e1 / 0.2187e4 * t1091 * t1092 / t40 / t549 / t416 * t32 * t1098) + 0.3e1 / 0.2e2 * t6 * t1129 * t30 * t52 + 0.3e1 / 0.5e1 * t6 * t508 * t113 + 0.8e1 / 0.45e2 * t1139 - t1146 + 0.2e1 / 0.5e1 * t1149 - t1153 / 0.5e1;
  t1156 = my_piecewise3(t1, 0, t1155);
  t1157 = t61 * t61;
  t1159 = 0.1e1 / t63 / t1157;
  t1160 = t262 * t262;
  t1166 = t268 * t268;
  t1171 = t58 * t1121;
  t1174 = my_piecewise5(t15, 0, t11, 0, 0.24e2 * t499 + 0.24e2 * t1171);
  t1178 = my_piecewise3(t62, 0, 0.4e2 / 0.81e2 * t1159 * t1160 - 0.2e2 / 0.9e1 * t574 * t262 * t268 + 0.1e2 / 0.3e1 * t261 * t1166 + 0.4e2 / 0.9e1 * t578 * t584 + 0.5e1 / 0.3e1 * t64 * t1174);
  t1185 = t6 * t588 * t98 * t81;
  t1189 = t6 * t272 * t224 * t81;
  t1193 = t6 * t124 * t530 * t81;
  t1198 = 0.14e2 / 0.135e3 * t6 * t66 * t1142 * t81;
  t1200 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t1178 * t30 * t81 + 0.2e1 / 0.5e1 * t1185 - t1189 / 0.5e1 + 0.8e1 / 0.45e2 * t1193 - t1198);
  tv4rho40 = 0.4e1 * t572 + 0.4e1 * t606 + t7 * (t1156 + t1200);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1221 = 0.12e2 * t499;
  t1222 = 0.24e2 * t1122;
  t1224 = my_piecewise5(t11, 0, t15, 0, -t1221 + t1222);
  t1228 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t1108 * t138 * t492 - 0.1e2 / 0.9e1 * t491 * t293 * t199 - 0.1e2 / 0.9e1 * t611 * t90 * t207 + 0.1e2 / 0.3e1 * t198 * t622 * t90 + 0.1e2 / 0.3e1 * t614 * t207 + 0.1e2 / 0.9e1 * t289 * t503 + 0.5e1 / 0.3e1 * t26 * t1224);
  t1237 = t6 * t631 * t113;
  t1243 = t6 * t638 * t113;
  t1244 = t1243 / 0.1e2;
  t1246 = t6 * t302 * t255;
  t1259 = t6 * t626 * t98 * t52;
  t1263 = t6 * t297 * t224 * t52;
  t1264 = t1263 / 0.1e2;
  t1267 = t6 * t141 * t530 * t52;
  t1272 = 0.3e1 / 0.2e2 * t6 * t1228 * t30 * t52 + 0.9e1 / 0.2e2 * t6 * t627 * t113 + 0.3e1 / 0.5e1 * t1237 + 0.9e1 / 0.2e2 * t6 * t298 * t255 - t1244 + 0.3e1 / 0.1e2 * t1246 + 0.3e1 / 0.2e2 * t6 * t142 * t567 + 0.3e1 / 0.1e2 * t1047 - t1053 / 0.5e1 + 0.3e1 / 0.1e2 * t1056 + 0.2e1 / 0.15e2 * t1062 - t1065 / 0.1e2 + t1068 / 0.1e2 + 0.3e1 / 0.1e2 * t1259 - t1264 + 0.2e1 / 0.45e2 * t1267 + 0.2e1 / 0.15e2 * t1139 - t1146 + t1149 / 0.1e2 - t1153 / 0.1e2;
  t1273 = my_piecewise3(t1, 0, t1272);
  t1290 = 0.24e2 * t1171;
  t1292 = my_piecewise5(t15, 0, t11, 0, t1221 + t1290);
  t1296 = my_piecewise3(t62, 0, 0.4e2 / 0.81e2 * t1159 * t149 * t575 - 0.1e2 / 0.9e1 * t574 * t317 * t262 - 0.1e2 / 0.9e1 * t655 * t121 * t268 + 0.1e2 / 0.3e1 * t261 * t665 * t121 + 0.1e2 / 0.3e1 * t658 * t268 + 0.1e2 / 0.9e1 * t313 * t584 + 0.5e1 / 0.3e1 * t64 * t1292);
  t1303 = t6 * t669 * t98 * t81;
  t1307 = t6 * t321 * t224 * t81;
  t1308 = t1307 / 0.1e2;
  t1311 = t6 * t152 * t530 * t81;
  t1320 = t6 * t593 * t166;
  t1323 = t6 * t597 * t166;
  t1324 = t1323 / 0.1e2;
  t1326 = t6 * t601 * t166;
  t1328 = 0.3e1 / 0.2e2 * t6 * t1296 * t30 * t81 + 0.3e1 / 0.1e2 * t1303 - t1308 + 0.2e1 / 0.45e2 * t1311 + t1185 / 0.1e2 - t1189 / 0.1e2 + 0.2e1 / 0.15e2 * t1193 - t1198 + 0.3e1 / 0.2e2 * t6 * t589 * t166 + 0.3e1 / 0.1e2 * t1320 - t1324 + 0.2e1 / 0.45e2 * t1326;
  t1329 = my_piecewise3(t57, 0, t1328);
  tv4rho41 = t572 + t606 + 0.3e1 * t654 + 0.3e1 * t694 + t7 * (t1273 + t1329);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1344 = t293 * t293;
  t1357 = my_piecewise5(t11, 0, t15, 0, t1222);
  t1361 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t1108 * t343 * t199 - 0.4e2 / 0.27e2 * t611 * t90 * t293 - 0.1e2 / 0.27e2 * t697 * t207 + 0.2e2 / 0.9e1 * t198 * t1344 + 0.2e2 / 0.9e1 * t289 * t622 - 0.1e2 / 0.27e2 * t491 * t348 * t199 + 0.2e2 / 0.9e1 * t198 * t706 * t90 + 0.1e2 / 0.9e1 * t702 * t207 + 0.5e1 / 0.3e1 * t26 * t1357);
  t1370 = t6 * t715 * t113;
  t1383 = t6 * t710 * t98 * t52;
  t1387 = t6 * t352 * t224 * t52;
  t1394 = 0.3e1 / 0.2e2 * t6 * t1361 * t30 * t52 + 0.3e1 / 0.1e2 * t6 * t711 * t113 + t1370 / 0.5e1 + 0.3e1 / 0.2e2 * t6 * t353 * t255 + 0.2e1 / 0.5e1 * t1237 - 0.2e1 / 0.15e2 * t1243 + t1246 / 0.5e1 - t1053 / 0.15e2 + 0.4e1 / 0.45e2 * t1062 - t1065 / 0.3e2 + t1383 / 0.5e1 - t1387 / 0.3e2 + t1259 / 0.5e1 - 0.2e1 / 0.15e2 * t1263 + 0.4e1 / 0.45e2 * t1267 + 0.4e1 / 0.45e2 * t1139 - t1146 - t1153 / 0.3e2;
  t1395 = my_piecewise3(t1, 0, t1394);
  t1404 = t317 * t317;
  t1417 = my_piecewise5(t15, 0, t11, 0, t1290);
  t1421 = my_piecewise3(t62, 0, 0.4e2 / 0.81e2 * t1159 * t360 * t262 - 0.4e2 / 0.27e2 * t655 * t121 * t317 - 0.1e2 / 0.27e2 * t727 * t268 + 0.2e2 / 0.9e1 * t261 * t1404 + 0.2e2 / 0.9e1 * t313 * t665 - 0.1e2 / 0.27e2 * t574 * t365 * t262 + 0.2e2 / 0.9e1 * t261 * t736 * t121 + 0.1e2 / 0.9e1 * t732 * t268 + 0.5e1 / 0.3e1 * t64 * t1417);
  t1428 = t6 * t740 * t98 * t81;
  t1432 = t6 * t369 * t224 * t81;
  t1441 = t6 * t674 * t166;
  t1444 = t6 * t678 * t166;
  t1455 = t6 * t277 * t396;
  t1458 = t6 * t281 * t396;
  t1460 = 0.3e1 / 0.2e2 * t6 * t1421 * t30 * t81 + t1428 / 0.5e1 - t1432 / 0.3e2 + t1303 / 0.5e1 - 0.2e1 / 0.15e2 * t1307 + 0.4e1 / 0.45e2 * t1311 + 0.3e1 / 0.1e2 * t6 * t670 * t166 + 0.2e1 / 0.5e1 * t1441 - t1444 / 0.15e2 - t1189 / 0.3e2 + 0.4e1 / 0.45e2 * t1193 - t1198 + t1320 / 0.5e1 - 0.2e1 / 0.15e2 * t1323 + 0.4e1 / 0.45e2 * t1326 + 0.3e1 / 0.2e2 * t6 * t273 * t396 + t1455 / 0.5e1 - t1458 / 0.3e2;
  t1461 = my_piecewise3(t57, 0, t1460);
  tv4rho42 = 0.2e1 * t654 + 0.2e1 * t694 + 0.2e1 * t726 + 0.2e1 * t765 + t7 * (t1395 + t1461);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1482 = my_piecewise5(t11, 0, t15, 0, t1221 + t1222);
  t1486 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t1108 * t770 * t90 - 0.1e2 / 0.9e1 * t697 * t293 - 0.1e2 / 0.9e1 * t611 * t348 * t90 + 0.1e2 / 0.3e1 * t614 * t348 + 0.1e2 / 0.3e1 * t289 * t706 + 0.1e2 / 0.9e1 * t198 * t777 * t90 + 0.5e1 / 0.3e1 * t26 * t1482);
  t1493 = t6 * t781 * t98 * t52;
  t1504 = 0.3e1 / 0.2e2 * t6 * t1486 * t30 * t52 + t1493 / 0.1e2 + 0.3e1 / 0.2e2 * t6 * t782 * t113 + 0.3e1 / 0.1e2 * t1383 - t1387 / 0.1e2 + 0.3e1 / 0.1e2 * t1370 - t1264 + 0.2e1 / 0.15e2 * t1267 - t1244 + 0.2e1 / 0.45e2 * t1139 - t1146 + 0.2e1 / 0.45e2 * t1062;
  t1505 = my_piecewise3(t1, 0, t1504);
  t1522 = my_piecewise5(t15, 0, t11, 0, -t1221 + t1290);
  t1526 = my_piecewise3(t62, 0, 0.4e2 / 0.81e2 * t1159 * t790 * t121 - 0.1e2 / 0.9e1 * t727 * t317 - 0.1e2 / 0.9e1 * t655 * t365 * t121 + 0.1e2 / 0.3e1 * t658 * t365 + 0.1e2 / 0.3e1 * t313 * t736 + 0.1e2 / 0.9e1 * t261 * t797 * t121 + 0.5e1 / 0.3e1 * t64 * t1522);
  t1533 = t6 * t801 * t98 * t81;
  t1541 = t6 * t745 * t166;
  t1550 = t6 * t326 * t396;
  t1560 = t6 * t129 * t839;
  t1562 = 0.3e1 / 0.2e2 * t6 * t1526 * t30 * t81 + t1533 / 0.1e2 + 0.3e1 / 0.1e2 * t1428 - t1432 / 0.1e2 + 0.9e1 / 0.2e2 * t6 * t741 * t166 + 0.3e1 / 0.1e2 * t1541 - t1308 + 0.2e1 / 0.15e2 * t1311 + 0.3e1 / 0.5e1 * t1441 - t1444 / 0.5e1 + 0.9e1 / 0.2e2 * t6 * t322 * t396 + 0.3e1 / 0.1e2 * t1550 + 0.2e1 / 0.45e2 * t1193 - t1198 - t1324 + 0.2e1 / 0.15e2 * t1326 + 0.3e1 / 0.1e2 * t1455 - t1458 / 0.1e2 + 0.3e1 / 0.2e2 * t6 * t125 * t839 + t1560 / 0.1e2;
  t1563 = my_piecewise3(t57, 0, t1562);
  tv4rho43 = 0.3e1 * t726 + 0.3e1 * t765 + t789 + t844 + t7 * (t1505 + t1563);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1568 = t343 * t343;
  t1573 = t348 * t348;
  t1580 = my_piecewise5(t11, 0, t15, 0, 0.24e2 * t499 + 0.24e2 * t1122);
  t1584 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t1108 * t1568 - 0.2e2 / 0.9e1 * t697 * t348 + 0.1e2 / 0.3e1 * t198 * t1573 + 0.4e2 / 0.9e1 * t289 * t777 + 0.5e1 / 0.3e1 * t26 * t1580);
  t1593 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t1584 * t30 * t52 + 0.2e1 / 0.5e1 * t1493 - t1387 / 0.5e1 + 0.8e1 / 0.45e2 * t1267 - t1146);
  t1594 = t360 * t360;
  t1599 = t365 * t365;
  t1606 = my_piecewise5(t15, 0, t11, 0, -0.24e2 * t499 + 0.24e2 * t1171);
  t1610 = my_piecewise3(t62, 0, 0.4e2 / 0.81e2 * t1159 * t1594 - 0.2e2 / 0.9e1 * t727 * t365 + 0.1e2 / 0.3e1 * t261 * t1599 + 0.4e2 / 0.9e1 * t313 * t797 + 0.5e1 / 0.3e1 * t64 * t1606);
  t1626 = sigma[2] / t70 / t454;
  t1638 = t825 * t379;
  t1644 = t388 * t388;
  t1650 = t36 * t80;
  t1667 = 0.3e1 / 0.2e2 * t6 * t1610 * t30 * t81 + 0.3e1 / 0.5e1 * t6 * t802 * t166 + 0.9e1 / 0.1e2 * t6 * t370 * t396 + 0.3e1 / 0.5e1 * t6 * t153 * t839 + 0.3e1 / 0.2e2 * t6 * t67 * (0.1309e5 / 0.729e3 * t37 * t1626 - 0.2618e4 / 0.243e3 * t109 * t1626 * t80 + 0.979e3 / 0.729e3 * t246 * t388 / t69 / t1019 * t80 - 0.44e2 / 0.243e3 * t559 * t832 / t1638 * t80 + 0.2e1 / 0.2187e4 * t1091 * t1644 / t70 / t825 / t454 * t32 * t1650) + 0.2e1 / 0.5e1 * t1560 - t1432 / 0.5e1 - 0.2e1 / 0.5e1 * t1444 - t1458 / 0.5e1 + 0.2e1 / 0.5e1 * t1533 + 0.6e1 / 0.5e1 * t1541 + 0.6e1 / 0.5e1 * t1550 + 0.8e1 / 0.45e2 * t1311 + 0.8e1 / 0.45e2 * t1326 - t1198;
  t1668 = my_piecewise3(t57, 0, t1667);
  tv4rho44 = 0.4e1 * t789 + 0.4e1 * t844 + t7 * (t1593 + t1668);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t1676 = t6 * t512 * t180;
  t1682 = t6 * t519 * t180;
  t1685 = t6 * t216 * t423;
  t1692 = 0.2e1 / 0.45e2 * t6 * t531 * t180;
  t1694 = t6 * t225 * t423;
  t1697 = t6 * t99 * t879;
  t1726 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t508 * t180 + 0.3e1 / 0.1e2 * t1676 + 0.9e1 / 0.2e2 * t6 * t212 * t423 - t1682 / 0.1e2 + 0.3e1 / 0.5e1 * t1685 + 0.9e1 / 0.2e2 * t6 * t94 * t879 + t1692 - t1694 / 0.1e2 + 0.3e1 / 0.1e2 * t1697 + 0.3e1 / 0.2e2 * t6 * t31 * (-0.77e3 / 0.243e3 * t37 * t542 + 0.154e3 / 0.81e2 * t46 * t36 * t542 * t51 - 0.341e3 / 0.972e3 * t246 * t551 * sigma[0] * t51 + 0.19e2 / 0.324e3 * t559 * t562 * t247 * t51 - t1091 / t40 / t549 / t469 * t560 * t32 * t1098 / 0.2916e4));
  tv4rho3sigma0 = t7 * t1726 + 0.3e1 * t884;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t1733 = t6 * t593 * t191;
  t1736 = t6 * t597 * t191;
  t1740 = 0.2e1 / 0.45e2 * t6 * t601 * t191;
  t1742 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t589 * t191 + 0.3e1 / 0.1e2 * t1733 - t1736 / 0.1e2 + t1740);
  tv4rho3sigma2 = t7 * t1742 + 0.3e1 * t897;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t1744 = 0.2e1 * t911;
  t1750 = t6 * t631 * t180 / 0.5e1;
  t1755 = t6 * t638 * t180;
  t1759 = t6 * t302 * t423 / 0.5e1;
  t1768 = 0.3e1 / 0.2e2 * t6 * t627 * t180 + t1750 + 0.3e1 / 0.1e2 * t6 * t298 * t423 - t1755 / 0.3e2 + t1759 + 0.3e1 / 0.2e2 * t6 * t142 * t879 + t1676 / 0.1e2 - t1682 / 0.15e2 + t1685 / 0.5e1 + t1692 - t1694 / 0.15e2 + t1697 / 0.1e2;
  t1769 = my_piecewise3(t1, 0, t1768);
  tv4rho3sigma3 = t7 * t1769 + t1744 + t884;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t1771 = 0.2e1 * t927;
  t1777 = t6 * t674 * t191 / 0.5e1;
  t1779 = t6 * t678 * t191;
  t1788 = t6 * t277 * t461 / 0.5e1;
  t1790 = t6 * t281 * t461;
  t1793 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t670 * t191 + t1777 - t1779 / 0.3e2 + t1733 / 0.1e2 - t1736 / 0.15e2 + t1740 + 0.3e1 / 0.2e2 * t6 * t273 * t461 + t1788 - t1790 / 0.3e2);
  tv4rho3sigma5 = t7 * t1793 + t1771 + t897;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t1799 = t6 * t715 * t180;
  t1808 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t711 * t180 + t1799 / 0.1e2 + 0.3e1 / 0.2e2 * t6 * t353 * t423 + t1750 - t1755 / 0.15e2 + t1759 - t1682 / 0.3e2 + t1692 - t1694 / 0.3e2);
  tv4rho3sigma6 = t7 * t1808 + t1744 + t935;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t1814 = t6 * t745 * t191;
  t1821 = t6 * t326 * t461;
  t1829 = t6 * t129 * t962;
  t1831 = 0.3e1 / 0.2e2 * t6 * t741 * t191 + t1814 / 0.1e2 + t1777 - t1779 / 0.15e2 + 0.3e1 / 0.1e2 * t6 * t322 * t461 + t1821 / 0.5e1 - t1736 / 0.3e2 + t1740 + t1788 - t1790 / 0.15e2 + 0.3e1 / 0.2e2 * t6 * t125 * t962 + t1829 / 0.1e2;
  t1832 = my_piecewise3(t57, 0, t1831);
  tv4rho3sigma8 = t7 * t1832 + t1771 + t967;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t1841 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t782 * t180 + 0.3e1 / 0.1e2 * t1799 - t1755 / 0.1e2 + t1692);
  tv4rho3sigma9 = t7 * t1841 + 0.3e1 * t935;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t1885 = my_piecewise3(t57, 0, 0.3e1 / 0.2e2 * t6 * t802 * t191 + 0.3e1 / 0.1e2 * t1814 + 0.9e1 / 0.2e2 * t6 * t370 * t461 - t1779 / 0.1e2 + 0.3e1 / 0.5e1 * t1821 + 0.9e1 / 0.2e2 * t6 * t153 * t962 + t1740 - t1790 / 0.1e2 + 0.3e1 / 0.1e2 * t1829 + 0.3e1 / 0.2e2 * t6 * t67 * (-0.77e3 / 0.243e3 * t37 * t818 + 0.154e3 / 0.81e2 * t46 * t36 * t818 * t80 - 0.341e3 / 0.972e3 * t246 * t827 * sigma[2] * t80 + 0.19e2 / 0.324e3 * t559 * t834 * t388 * t80 - t1091 / t70 / t825 / t479 * t832 * t32 * t1650 / 0.2916e4));
  tv4rho3sigma11 = t7 * t1885 + 0.3e1 * t967;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t1892 = t6 * t216 * t474;
  t1901 = t6 * t225 * t474 / 0.1728e5;
  t1902 = t972 * t977;
  t1905 = t983 * t99 * t989;
  t1917 = t983 * t31 * t1090;
  t1921 = t37 * t51;
  t1926 = my_piecewise3(t1, 0, t6 * t212 * t474 / 0.384e4 + t1892 / 0.288e4 - t969 * t977 / 0.36e3 + t983 * t94 * t989 / 0.288e4 - t1901 - t1902 / 0.54e3 + t1905 / 0.432e4 + 0.19e2 / 0.216e4 * t468 * t243 * t245 * t250 * t51 - 0.43e2 / 0.1728e5 * t984 * t556 * t874 * t988 + t1917 / t40 / t1084 * t247 * t1921 / 0.5184e5);
  tv4rho2sigma20 = t7 * t1926 + 0.2e1 * t993;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t1933 = t6 * t277 * t484;
  t1937 = t6 * t281 * t484 / 0.1728e5;
  t1939 = my_piecewise3(t57, 0, t6 * t273 * t484 / 0.384e4 + t1933 / 0.288e4 - t1937);
  tv4rho2sigma25 = t7 * t1939 + 0.2e1 * t1002;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t1945 = t6 * t302 * t474;
  t1956 = my_piecewise3(t1, 0, t6 * t298 * t474 / 0.384e4 + t1945 / 0.576e4 - t1004 * t977 / 0.72e3 + t983 * t142 * t989 / 0.576e4 + t1892 / 0.576e4 - t1901 - t1902 / 0.108e4 + t1905 / 0.864e4);
  tv4rho2sigma26 = t7 * t1956 + t1008 + t993;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t1962 = t6 * t326 * t484;
  t1967 = t998 * t1015;
  t1973 = t983 * t129 * t1023;
  t1976 = my_piecewise3(t57, 0, t6 * t322 * t484 / 0.384e4 + t1962 / 0.576e4 + t1933 / 0.576e4 - t1937 - t995 * t1015 / 0.72e3 - t1967 / 0.108e4 + t983 * t125 * t1023 / 0.576e4 + t1973 / 0.864e4);
  tv4rho2sigma211 = t7 * t1976 + t1002 + t1027;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t1984 = my_piecewise3(t1, 0, t6 * t353 * t474 / 0.384e4 + t1945 / 0.288e4 - t1901);
  tv4rho2sigma212 = t7 * t1984 + 0.2e1 * t1008;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t2008 = t983 * t67 * t1090;
  t2012 = t37 * t80;
  t2017 = my_piecewise3(t57, 0, t6 * t370 * t484 / 0.384e4 + t1962 / 0.288e4 - t1010 * t1015 / 0.36e3 + t983 * t153 * t1023 / 0.288e4 - t1937 - t1967 / 0.54e3 + t1973 / 0.432e4 + 0.19e2 / 0.216e4 * t478 * t243 * t245 * t391 * t80 - 0.43e2 / 0.1728e5 * t1018 * t556 * t957 * t1022 + t2008 / t70 / t1638 * t388 * t2012 / 0.5184e5);
  tv4rho2sigma217 = t7 * t2017 + 0.2e1 * t1027;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t2022 = t98 * t556;
  t2025 = t1029 * t2022 * t1032 / 0.2304e5;
  t2038 = my_piecewise3(t1, 0, -t983 * t93 * t1033 / 0.1536e5 - t2025 + t1029 * t1030 * t986 * t51 / 0.192e4 - t1917 / t40 / t561 * t32 * t47 * t51 / 0.13824e6);
  tv4rhosigma30 = t7 * t2038 + t1036;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t2045 = t1037 * t2022 * t1039 / 0.2304e5;
  t2047 = my_piecewise3(t57, 0, -t983 * t124 * t1040 / 0.1536e5 - t2045);
  tv4rhosigma39 = t7 * t2047 + t1043;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t2053 = my_piecewise3(t1, 0, -t983 * t141 * t1033 / 0.1536e5 - t2025);
  tv4rhosigma310 = t7 * t2053 + t1036;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t2070 = my_piecewise3(t57, 0, -t983 * t152 * t1040 / 0.1536e5 - t2045 + t1037 * t1030 * t1020 * t80 / 0.192e4 - t2008 / t70 / t833 * t32 * t76 * t80 / 0.13824e6);
  tv4rhosigma319 = t7 * t2070 + t1043;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t2078 = my_piecewise3(t1, 0, t984 * t1090 / t40 / t873 * t1921 / 0.36864e6);
  tv4sigma40 = t7 * t2078;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t2085 = my_piecewise3(t57, 0, t1018 * t1090 / t70 / t956 * t2012 / 0.36864e6);
  tv4sigma414 = t7 * t2085;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

