/*
 * Copyright (c) 2023, Juniper Networks, Inc.
 * All rights reserved.
 * This SOFTWARE is licensed under the LICENSE provided in the
 * ../Copyright file. By downloading, installing, copying, or otherwise
 * using the SOFTWARE, you agree to be bound by the terms of that
 * LICENSE.
 * Phil Shafer, May 2023
 */

/*
 * This is generated by the code in the "unicode" branch, based on the file
 * UnicodeData.txt from unicode.org:
 *   https://unicode.org/Public/UNIDATA/UnicodeData.txt
 * I've attempted to make it simple, but can't stop it from being ugly.
 */

#include <stdio.h>
#include <wchar.h>

#include "xo_utf8.h"

wchar_t
xo_utf8_wtolower (wchar_t wc)
{

    if ((0x0100 <= wc && wc <= 0x012e)
            || (0x0132 <= wc && wc <= 0x0136)
            || (0x014a <= wc && wc <= 0x0176)
            || (0x0182 <= wc && wc <= 0x0184)
            || (wc == 0x0198)
            || (0x01a0 <= wc && wc <= 0x01a4)
            || (wc == 0x01ac)
            || (wc == 0x01b8)
            || (wc == 0x01bc)
            || (wc == 0x01c8)
            || (0x01de <= wc && wc <= 0x01ee)
            || (0x01f2 <= wc && wc <= 0x01f4)
            || (0x01f8 <= wc && wc <= 0x021e)
            || (0x0222 <= wc && wc <= 0x0232)
            || (0x0246 <= wc && wc <= 0x024e)
            || (0x0370 <= wc && wc <= 0x0372)
            || (wc == 0x0376)
            || (0x03d8 <= wc && wc <= 0x03ee)
            || (wc == 0x03fa)
            || (0x0460 <= wc && wc <= 0x0480)
            || (0x048a <= wc && wc <= 0x04be)
            || (0x04d0 <= wc && wc <= 0x052e)
            || (0x1e00 <= wc && wc <= 0x1e94)
            || (0x1ea0 <= wc && wc <= 0x1efe)
            || (wc == 0x2c60)
            || (wc == 0x2c72)
            || (0x2c80 <= wc && wc <= 0x2ce2)
            || (wc == 0x2cf2)
            || (0xa640 <= wc && wc <= 0xa66c)
            || (0xa680 <= wc && wc <= 0xa69a)
            || (0xa722 <= wc && wc <= 0xa72e)
            || (0xa732 <= wc && wc <= 0xa76e)
            || (0xa77e <= wc && wc <= 0xa786)
            || (0xa790 <= wc && wc <= 0xa792)
            || (0xa796 <= wc && wc <= 0xa7a8)
            || (0xa7b4 <= wc && wc <= 0xa7c2)
            || (wc == 0xa7d0)
            || (0xa7d6 <= wc && wc <= 0xa7d8)) {
        /* LATIN CAPITAL LETTER A WITH MACRON */
        /* LATIN CAPITAL LIGATURE IJ */
        /* LATIN CAPITAL LETTER ENG */
        /* LATIN CAPITAL LETTER B WITH TOPBAR */
        /* LATIN CAPITAL LETTER K WITH HOOK */
        /* LATIN CAPITAL LETTER O WITH HORN */
        /* LATIN CAPITAL LETTER T WITH HOOK */
        /* LATIN CAPITAL LETTER EZH REVERSED */
        /* LATIN CAPITAL LETTER TONE FIVE */
        /* LATIN CAPITAL LETTER L WITH SMALL LETTER J */
        /* LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON */
        /* LATIN CAPITAL LETTER D WITH SMALL LETTER Z */
        /* LATIN CAPITAL LETTER N WITH GRAVE */
        /* LATIN CAPITAL LETTER OU */
        /* LATIN CAPITAL LETTER E WITH STROKE */
        /* GREEK CAPITAL LETTER HETA */
        /* GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA */
        /* GREEK LETTER ARCHAIC KOPPA */
        /* GREEK CAPITAL LETTER SAN */
        /* CYRILLIC CAPITAL LETTER OMEGA */
        /* CYRILLIC CAPITAL LETTER SHORT I WITH TAIL */
        /* CYRILLIC CAPITAL LETTER A WITH BREVE */
        /* LATIN CAPITAL LETTER A WITH RING BELOW */
        /* LATIN CAPITAL LETTER A WITH DOT BELOW */
        /* LATIN CAPITAL LETTER L WITH DOUBLE BAR */
        /* LATIN CAPITAL LETTER W WITH HOOK */
        /* COPTIC CAPITAL LETTER ALFA */
        /* COPTIC CAPITAL LETTER BOHAIRIC KHEI */
        /* CYRILLIC CAPITAL LETTER ZEMLYA */
        /* CYRILLIC CAPITAL LETTER DWE */
        /* LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF */
        /* LATIN CAPITAL LETTER AA */
        /* LATIN CAPITAL LETTER TURNED INSULAR G */
        /* LATIN CAPITAL LETTER N WITH DESCENDER */
        /* LATIN CAPITAL LETTER B WITH FLOURISH */
        /* LATIN CAPITAL LETTER BETA */
        /* LATIN CAPITAL LETTER CLOSED INSULAR G */
        /* LATIN CAPITAL LETTER MIDDLE SCOTS S */
        wc |= 1;

    } else if ((wc == 0x0100)
            || (0x0139 <= wc && wc <= 0x0147)
            || (0x0179 <= wc && wc <= 0x017d)
            || (wc == 0x0187)
            || (wc == 0x018b)
            || (wc == 0x0191)
            || (wc == 0x01a7)
            || (wc == 0x01af)
            || (0x01b3 <= wc && wc <= 0x01b5)
            || (wc == 0x01c5)
            || (0x01cb <= wc && wc <= 0x01db)
            || (wc == 0x023b)
            || (wc == 0x0241)
            || (wc == 0x03f7)
            || (0x04c1 <= wc && wc <= 0x04cd)
            || (wc == 0x2183)
            || (0x2c67 <= wc && wc <= 0x2c6b)
            || (wc == 0x2c75)
            || (0x2ceb <= wc && wc <= 0x2ced)
            || (0xa779 <= wc && wc <= 0xa77b)
            || (wc == 0xa78b)
            || (0xa7c7 <= wc && wc <= 0xa7c9)
            || (wc == 0xa7f5)) {        /* LATIN CAPITAL LETTER A WITH MACRON */
        /* LATIN CAPITAL LETTER L WITH ACUTE */
        /* LATIN CAPITAL LETTER Z WITH ACUTE */
        /* LATIN CAPITAL LETTER C WITH HOOK */
        /* LATIN CAPITAL LETTER D WITH TOPBAR */
        /* LATIN CAPITAL LETTER F WITH HOOK */
        /* LATIN CAPITAL LETTER TONE TWO */
        /* LATIN CAPITAL LETTER U WITH HORN */
        /* LATIN CAPITAL LETTER Y WITH HOOK */
        /* LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON */
        /* LATIN CAPITAL LETTER N WITH SMALL LETTER J */
        /* LATIN CAPITAL LETTER C WITH STROKE */
        /* LATIN CAPITAL LETTER GLOTTAL STOP */
        /* GREEK CAPITAL LETTER SHO */
        /* CYRILLIC CAPITAL LETTER ZHE WITH BREVE */
        /* ROMAN NUMERAL REVERSED ONE HUNDRED */
        /* LATIN CAPITAL LETTER H WITH DESCENDER */
        /* LATIN CAPITAL LETTER HALF H */
        /* COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI */
        /* LATIN CAPITAL LETTER INSULAR D */
        /* LATIN CAPITAL LETTER SALTILLO */
        /* LATIN CAPITAL LETTER D WITH SHORT STROKE OVERLAY */
        /* LATIN CAPITAL LETTER REVERSED HALF H */
        wc += 1;
        wc &= ~1;

    } else if ((0x0041 <= wc && wc <= 0x005a)
            || (0x00c0 <= wc && wc <= 0x00d6)
            || (0x00d8 <= wc && wc <= 0x00de)
            || (0x0391 <= wc && wc <= 0x03a1)
            || (0x03a3 <= wc && wc <= 0x03ab)
            || (0x0410 <= wc && wc <= 0x042f)
            || (0xff21 <= wc && wc <= 0xff3a)
            || (0x118a0 <= wc && wc <= 0x118bf)
            || (0x16e40 <= wc && wc <= 0x16e5f)) {
        /* LATIN CAPITAL LETTER A */
        /* LATIN CAPITAL LETTER A WITH GRAVE */
        /* LATIN CAPITAL LETTER O WITH STROKE */
        /* GREEK CAPITAL LETTER ALPHA */
        /* GREEK CAPITAL LETTER SIGMA */
        /* CYRILLIC CAPITAL LETTER A */
        /* FULLWIDTH LATIN CAPITAL LETTER A */
        /* WARANG CITI CAPITAL LETTER NGAA */
        /* MEDEFAIDRIN CAPITAL LETTER M */
        wc += 0x0020;

    } else if ((0x0531 <= wc && wc <= 0x0556)
            || (0x2c00 <= wc && wc <= 0x2c2f)) {
        /* ARMENIAN CAPITAL LETTER AYB */
        /* GLAGOLITIC CAPITAL LETTER AZU */
        wc += 0x0030;

    } else if ((0x13a0 <= wc && wc <= 0x13ef)) {
        /* CHEROKEE LETTER A */
        wc += 0x97d0;

    } else if ((0x1f08 <= wc && wc <= 0x1f0f)
            || (0x1f18 <= wc && wc <= 0x1f1d)
            || (0x1f28 <= wc && wc <= 0x1f2f)
            || (0x1f38 <= wc && wc <= 0x1f3f)
            || (0x1f48 <= wc && wc <= 0x1f4d)
            || (wc == 0x1f59)
            || (wc == 0x1f5b)
            || (wc == 0x1f5d)
            || (wc == 0x1f5f)
            || (0x1f68 <= wc && wc <= 0x1f6f)
            || (0x1f88 <= wc && wc <= 0x1f8f)
            || (0x1f98 <= wc && wc <= 0x1f9f)
            || (0x1fa8 <= wc && wc <= 0x1faf)
            || (0x1fb8 <= wc && wc <= 0x1fb9)
            || (0x1fd8 <= wc && wc <= 0x1fd9)
            || (0x1fe8 <= wc && wc <= 0x1fe9)) {
        /* GREEK CAPITAL LETTER ALPHA WITH PSILI */
        /* GREEK CAPITAL LETTER EPSILON WITH PSILI */
        /* GREEK CAPITAL LETTER ETA WITH PSILI */
        /* GREEK CAPITAL LETTER IOTA WITH PSILI */
        /* GREEK CAPITAL LETTER OMICRON WITH PSILI */
        /* GREEK CAPITAL LETTER UPSILON WITH DASIA */
        /* GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA */
        /* GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA */
        /* GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI */
        /* GREEK CAPITAL LETTER OMEGA WITH PSILI */
        /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI */
        /* GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI */
        /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI */
        /* GREEK CAPITAL LETTER ALPHA WITH VRACHY */
        /* GREEK CAPITAL LETTER IOTA WITH VRACHY */
        /* GREEK CAPITAL LETTER UPSILON WITH VRACHY */
        wc -= 0x0008;

    } else if ((0x10400 <= wc && wc <= 0x10427)
            || (0x104b0 <= wc && wc <= 0x104d3)) {
        /* DESERET CAPITAL LETTER LONG I */
        /* OSAGE CAPITAL LETTER A */
        wc += 0x0028;

    } else if ((wc == 0x038c)
            || (0x10c80 <= wc && wc <= 0x10cb2)) {
        /* GREEK CAPITAL LETTER OMICRON WITH TONOS */
        /* OLD HUNGARIAN CAPITAL LETTER A */
        wc += 0x0040;

    } else if ((0x1c90 <= wc && wc <= 0x1cba)
            || (0x1cbd <= wc && wc <= 0x1cbf)) {
        /* GEORGIAN MTAVRULI CAPITAL LETTER AN */
        /* GEORGIAN MTAVRULI CAPITAL LETTER AEN */
        wc -= 0x0bc0;

    } else if ((0x10a0 <= wc && wc <= 0x10c5)
            || (wc == 0x10c7)
            || (wc == 0x10cd)) {        /* GEORGIAN CAPITAL LETTER AN */
        /* GEORGIAN CAPITAL LETTER YN */
        /* GEORGIAN CAPITAL LETTER AEN */
        wc += 0x1c60;

    } else if ((0x10570 <= wc && wc <= 0x1057a)
            || (0x1057c <= wc && wc <= 0x1058a)
            || (0x1058c <= wc && wc <= 0x10592)
            || (0x10594 <= wc && wc <= 0x10595)) {
        /* VITHKUQI CAPITAL LETTER A */
        /* VITHKUQI CAPITAL LETTER HA */
        /* VITHKUQI CAPITAL LETTER SE */
        /* VITHKUQI CAPITAL LETTER Y */
        wc += 0x0027;

    } else if ((0x1e900 <= wc && wc <= 0x1e921)) {
        /* ADLAM CAPITAL LETTER ALIF */
        wc += 0x0022;

    } else if ((0x24b6 <= wc && wc <= 0x24cf)) {
        /* CIRCLED LATIN CAPITAL LETTER A */
        wc += 0x001a;

    } else if ((0x0400 <= wc && wc <= 0x040f)) {
        /* CYRILLIC CAPITAL LETTER IE WITH GRAVE */
        wc += 0x0050;

    } else if ((0x2160 <= wc && wc <= 0x216f)) {
        /* ROMAN NUMERAL ONE */
        wc += 0x0010;

    } else if ((wc == 0x03cf)
            || (0x13f0 <= wc && wc <= 0x13f5)) {
        /* GREEK CAPITAL KAI SYMBOL */
        /* CHEROKEE LETTER YE */
        wc += 0x0008;

    } else {
        switch (wc) {
        case 0x0130: wc = 0x0069; break; /* LATIN CAPITAL LETTER I WITH DOT ABOVE */
        case 0x0178: wc = 0x00ff; break; /* LATIN CAPITAL LETTER Y WITH DIAERESIS */
        case 0x0181: wc = 0x0253; break; /* LATIN CAPITAL LETTER B WITH HOOK */
        case 0x0186: wc = 0x0254; break; /* LATIN CAPITAL LETTER OPEN O */
        case 0x0189: wc = 0x0256; break; /* LATIN CAPITAL LETTER AFRICAN D */
        case 0x018a: wc = 0x0257; break; /* LATIN CAPITAL LETTER D WITH HOOK */
        case 0x018e: wc = 0x01dd; break; /* LATIN CAPITAL LETTER REVERSED E */
        case 0x018f: wc = 0x0259; break; /* LATIN CAPITAL LETTER SCHWA */
        case 0x0190: wc = 0x025b; break; /* LATIN CAPITAL LETTER OPEN E */
        case 0x0193: wc = 0x0260; break; /* LATIN CAPITAL LETTER G WITH HOOK */
        case 0x0194: wc = 0x0263; break; /* LATIN CAPITAL LETTER GAMMA */
        case 0x0196: wc = 0x0269; break; /* LATIN CAPITAL LETTER IOTA */
        case 0x0197: wc = 0x0268; break; /* LATIN CAPITAL LETTER I WITH STROKE */
        case 0x019c: wc = 0x026f; break; /* LATIN CAPITAL LETTER TURNED M */
        case 0x019d: wc = 0x0272; break; /* LATIN CAPITAL LETTER N WITH LEFT HOOK */
        case 0x019f: wc = 0x0275; break; /* LATIN CAPITAL LETTER O WITH MIDDLE TILDE */
        case 0x01a6: wc = 0x0280; break; /* LATIN LETTER YR */
        case 0x01a9: wc = 0x0283; break; /* LATIN CAPITAL LETTER ESH */
        case 0x01ae: wc = 0x0288; break; /* LATIN CAPITAL LETTER T WITH RETROFLEX HOOK */
        case 0x01b1: wc = 0x028a; break; /* LATIN CAPITAL LETTER UPSILON */
        case 0x01b2: wc = 0x028b; break; /* LATIN CAPITAL LETTER V WITH HOOK */
        case 0x01b7: wc = 0x0292; break; /* LATIN CAPITAL LETTER EZH */
        case 0x01c4: wc = 0x01c6; break; /* LATIN CAPITAL LETTER DZ WITH CARON */
        case 0x01c7: wc = 0x01c9; break; /* LATIN CAPITAL LETTER LJ */
        case 0x01ca: wc = 0x01cc; break; /* LATIN CAPITAL LETTER NJ */
        case 0x01f1: wc = 0x01f3; break; /* LATIN CAPITAL LETTER DZ */
        case 0x01f6: wc = 0x0195; break; /* LATIN CAPITAL LETTER HWAIR */
        case 0x01f7: wc = 0x01bf; break; /* LATIN CAPITAL LETTER WYNN */
        case 0x0220: wc = 0x019e; break; /* LATIN CAPITAL LETTER N WITH LONG RIGHT LEG */
        case 0x023a: wc = 0x2c65; break; /* LATIN CAPITAL LETTER A WITH STROKE */
        case 0x023d: wc = 0x019a; break; /* LATIN CAPITAL LETTER L WITH BAR */
        case 0x023e: wc = 0x2c66; break; /* LATIN CAPITAL LETTER T WITH DIAGONAL STROKE */
        case 0x0243: wc = 0x0180; break; /* LATIN CAPITAL LETTER B WITH STROKE */
        case 0x0244: wc = 0x0289; break; /* LATIN CAPITAL LETTER U BAR */
        case 0x0245: wc = 0x028c; break; /* LATIN CAPITAL LETTER TURNED V */
        case 0x037f: wc = 0x03f3; break; /* GREEK CAPITAL LETTER YOT */
        case 0x0386: wc = 0x03ac; break; /* GREEK CAPITAL LETTER ALPHA WITH TONOS */
        case 0x0388: wc = 0x03ad; break; /* GREEK CAPITAL LETTER EPSILON WITH TONOS */
        case 0x0389: wc = 0x03ae; break; /* GREEK CAPITAL LETTER ETA WITH TONOS */
        case 0x038a: wc = 0x03af; break; /* GREEK CAPITAL LETTER IOTA WITH TONOS */
        case 0x038e: wc = 0x03cd; break; /* GREEK CAPITAL LETTER UPSILON WITH TONOS */
        case 0x038f: wc = 0x03ce; break; /* GREEK CAPITAL LETTER OMEGA WITH TONOS */
        case 0x03f4: wc = 0x03b8; break; /* GREEK CAPITAL THETA SYMBOL */
        case 0x03f9: wc = 0x03f2; break; /* GREEK CAPITAL LUNATE SIGMA SYMBOL */
        case 0x03fd: wc = 0x037b; break; /* GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL */
        case 0x03fe: wc = 0x037c; break; /* GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL */
        case 0x03ff: wc = 0x037d; break; /* GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL */
        case 0x04c0: wc = 0x04cf; break; /* CYRILLIC LETTER PALOCHKA */
        case 0x1e9e: wc = 0x00df; break; /* LATIN CAPITAL LETTER SHARP S */
        case 0x1fba: wc = 0x1f70; break; /* GREEK CAPITAL LETTER ALPHA WITH VARIA */
        case 0x1fbb: wc = 0x1f71; break; /* GREEK CAPITAL LETTER ALPHA WITH OXIA */
        case 0x1fbc: wc = 0x1fb3; break; /* GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI */
        case 0x1fc8: wc = 0x1f72; break; /* GREEK CAPITAL LETTER EPSILON WITH VARIA */
        case 0x1fc9: wc = 0x1f73; break; /* GREEK CAPITAL LETTER EPSILON WITH OXIA */
        case 0x1fca: wc = 0x1f74; break; /* GREEK CAPITAL LETTER ETA WITH VARIA */
        case 0x1fcb: wc = 0x1f75; break; /* GREEK CAPITAL LETTER ETA WITH OXIA */
        case 0x1fcc: wc = 0x1fc3; break; /* GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI */
        case 0x1fda: wc = 0x1f76; break; /* GREEK CAPITAL LETTER IOTA WITH VARIA */
        case 0x1fdb: wc = 0x1f77; break; /* GREEK CAPITAL LETTER IOTA WITH OXIA */
        case 0x1fea: wc = 0x1f7a; break; /* GREEK CAPITAL LETTER UPSILON WITH VARIA */
        case 0x1feb: wc = 0x1f7b; break; /* GREEK CAPITAL LETTER UPSILON WITH OXIA */
        case 0x1fec: wc = 0x1fe5; break; /* GREEK CAPITAL LETTER RHO WITH DASIA */
        case 0x1ff8: wc = 0x1f78; break; /* GREEK CAPITAL LETTER OMICRON WITH VARIA */
        case 0x1ff9: wc = 0x1f79; break; /* GREEK CAPITAL LETTER OMICRON WITH OXIA */
        case 0x1ffa: wc = 0x1f7c; break; /* GREEK CAPITAL LETTER OMEGA WITH VARIA */
        case 0x1ffb: wc = 0x1f7d; break; /* GREEK CAPITAL LETTER OMEGA WITH OXIA */
        case 0x1ffc: wc = 0x1ff3; break; /* GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI */
        case 0x2126: wc = 0x03c9; break; /* OHM SIGN */
        case 0x212a: wc = 0x006b; break; /* KELVIN SIGN */
        case 0x212b: wc = 0x00e5; break; /* ANGSTROM SIGN */
        case 0x2132: wc = 0x214e; break; /* TURNED CAPITAL F */
        case 0x2c62: wc = 0x026b; break; /* LATIN CAPITAL LETTER L WITH MIDDLE TILDE */
        case 0x2c63: wc = 0x1d7d; break; /* LATIN CAPITAL LETTER P WITH STROKE */
        case 0x2c64: wc = 0x027d; break; /* LATIN CAPITAL LETTER R WITH TAIL */
        case 0x2c6d: wc = 0x0251; break; /* LATIN CAPITAL LETTER ALPHA */
        case 0x2c6e: wc = 0x0271; break; /* LATIN CAPITAL LETTER M WITH HOOK */
        case 0x2c6f: wc = 0x0250; break; /* LATIN CAPITAL LETTER TURNED A */
        case 0x2c70: wc = 0x0252; break; /* LATIN CAPITAL LETTER TURNED ALPHA */
        case 0x2c7e: wc = 0x023f; break; /* LATIN CAPITAL LETTER S WITH SWASH TAIL */
        case 0x2c7f: wc = 0x0240; break; /* LATIN CAPITAL LETTER Z WITH SWASH TAIL */
        case 0xa77d: wc = 0x1d79; break; /* LATIN CAPITAL LETTER INSULAR G */
        case 0xa78d: wc = 0x0265; break; /* LATIN CAPITAL LETTER TURNED H */
        case 0xa7aa: wc = 0x0266; break; /* LATIN CAPITAL LETTER H WITH HOOK */
        case 0xa7ab: wc = 0x025c; break; /* LATIN CAPITAL LETTER REVERSED OPEN E */
        case 0xa7ac: wc = 0x0261; break; /* LATIN CAPITAL LETTER SCRIPT G */
        case 0xa7ad: wc = 0x026c; break; /* LATIN CAPITAL LETTER L WITH BELT */
        case 0xa7ae: wc = 0x026a; break; /* LATIN CAPITAL LETTER SMALL CAPITAL I */
        case 0xa7b0: wc = 0x029e; break; /* LATIN CAPITAL LETTER TURNED K */
        case 0xa7b1: wc = 0x0287; break; /* LATIN CAPITAL LETTER TURNED T */
        case 0xa7b2: wc = 0x029d; break; /* LATIN CAPITAL LETTER J WITH CROSSED-TAIL */
        case 0xa7b3: wc = 0xab53; break; /* LATIN CAPITAL LETTER CHI */
        case 0xa7c4: wc = 0xa794; break; /* LATIN CAPITAL LETTER C WITH PALATAL HOOK */
        case 0xa7c5: wc = 0x0282; break; /* LATIN CAPITAL LETTER S WITH HOOK */
        case 0xa7c6: wc = 0x1d8e; break; /* LATIN CAPITAL LETTER Z WITH PALATAL HOOK */
        }
    }

    return wc;
}
