________________________________________________________________________

This file is part of Logtalk <https://logtalk.org/>  
SPDX-FileCopyrightText: 1998-2025 Paulo Moura <pmoura@logtalk.org>  
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
________________________________________________________________________


To consult the documentation for all core, library, tools, and
contributions entities, open the file `index.html` with a web
browser.

This directory also includes SVG inheritance diagrams for the core
entities, the library, ports, developer tools, and contributions:

- `core_inheritance_diagram.svg`
- `library_inheritance_diagram.svg`
- `tools_inheritance_diagram.svg`
- `ports_inheritance_diagram.svg`
- `contributions_inheritance_diagram.svg`

The diagrams embed URL links to both API documentation (at the Logtalk
website) and source code (at the GitHub website).

The API HTML files and the diagrams SVG files are generated by running
the `scripts/update_html_docs.sh` and `scripts/update_svg_diagrams.sh`
shell scripts.

The HTML, PDF, Texinfo, ePub, and Markdown versions of the documentation
are generated from reStructuredText sources using Sphinx. These sources
are automatically generated by the `lgtdoc` tool. See the `sources/NOTES.md`
file for details. Only the HTML version is included in the sources
distribution. The other versions can be downloaded from the Logtalk website
(for the latest stable release) at:

https://logtalk.org/documentation.html

The Markdown format is a LLM friendly single file version. Users can copy
this single file to their project directory when using AI coding tools to
help avoid hallucinations and generate quality code. Depending on the LLM
pr AI coding tool, you may need to split in several files for indexing due
to file size limitations. For example, using the POSIX `split` utility
command:

	$ split -p '### (debugger|lgtunit|packs)' LogtalkAPIs-3.90.0.md LogtalkAPIs_
	$ for file in "LogtalkAPIs_"*; do mv "$file" "${file}.md"; done

Experiment with the section headers until all generated files are below
the maximum size.
