/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnenc.goals;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.cling.invoker.mvnenc.EncryptContext;
import org.apache.maven.cling.invoker.mvnenc.goals.GoalSupport;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;

public abstract class ConfiguredGoalSupport
extends GoalSupport {
    protected ConfiguredGoalSupport(MessageBuilderFactory messageBuilderFactory, SecDispatcher secDispatcher) {
        super(messageBuilderFactory, secDispatcher);
    }

    @Override
    public int execute(EncryptContext context) throws Exception {
        if (!this.validateConfiguration(context)) {
            context.terminal.writer().println(this.messageBuilderFactory.builder().error((Object)"Maven Encryption is not configured, run `mvnenc init` first.").build());
            return 1;
        }
        return this.doExecute(context);
    }

    protected boolean validateConfiguration(EncryptContext context) {
        SecDispatcher.ValidationResponse response = this.secDispatcher.validateConfiguration();
        if (!response.isValid() || context.invokerRequest.options().verbose().orElse(false).booleanValue()) {
            this.dumpResponse(context, "", response);
        }
        return response.isValid();
    }

    protected void dumpResponse(EncryptContext context, String indent, SecDispatcher.ValidationResponse response) {
        context.terminal.writer().println(this.messageBuilderFactory.builder().format(response.isValid() ? this.messageBuilderFactory.builder().success((Object)"%sConfiguration validation of %s: %s").build() : this.messageBuilderFactory.builder().failure((Object)"%sConfiguration validation of %s: %s").build(), new Object[]{indent, response.getSource(), response.isValid() ? "VALID" : "INVALID"}));
        for (Map.Entry entry : response.getReport().entrySet()) {
            Consumer<String> consumer = s -> context.terminal.writer().println(this.messageBuilderFactory.builder().info(s).build());
            if (entry.getKey() == SecDispatcher.ValidationResponse.Level.ERROR) {
                consumer = s -> context.terminal.writer().println(this.messageBuilderFactory.builder().error(s).build());
            } else if (entry.getKey() == SecDispatcher.ValidationResponse.Level.WARNING) {
                consumer = s -> context.terminal.writer().println(this.messageBuilderFactory.builder().warning(s).build());
            }
            for (String line : (List)entry.getValue()) {
                consumer.accept(indent + "  " + line);
            }
        }
        for (SecDispatcher.ValidationResponse subsystem : response.getSubsystems()) {
            this.dumpResponse(context, indent + "  ", subsystem);
        }
    }

    protected abstract int doExecute(EncryptContext var1) throws Exception;
}

