/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.transfer;

import java.io.PrintWriter;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.cling.transfer.FileSizeFormat;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

public abstract class AbstractMavenTransferListener
extends AbstractTransferListener {
    public static final String STYLE = ".transfer:-faint";
    protected final MessageBuilderFactory messageBuilderFactory;
    protected final PrintWriter out;

    protected AbstractMavenTransferListener(MessageBuilderFactory messageBuilderFactory, PrintWriter out) {
        this.messageBuilderFactory = messageBuilderFactory;
        this.out = out;
    }

    public void transferInitiated(TransferEvent event) {
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "to" : "from";
        TransferResource resource = event.getResource();
        MessageBuilder message = this.messageBuilderFactory.builder();
        message.style(STYLE).append((CharSequence)action).append(' ').append((CharSequence)direction).append(' ');
        message.resetStyle().append((CharSequence)resource.getRepositoryId());
        message.style(STYLE).append((CharSequence)": ").append((CharSequence)resource.getRepositoryUrl());
        message.resetStyle().append((CharSequence)resource.getResourceName());
        this.out.println(message.toString());
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.out.println("[WARNING] " + event.getException().getMessage() + " from " + resource.getRepositoryId() + " for " + resource.getRepositoryUrl() + resource.getResourceName());
    }

    public void transferSucceeded(TransferEvent event) {
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "to" : "from";
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        FileSizeFormat format = new FileSizeFormat();
        MessageBuilder message = this.messageBuilderFactory.builder();
        message.append((CharSequence)action).style(STYLE).append(' ').append((CharSequence)direction).append(' ');
        message.resetStyle().append((CharSequence)resource.getRepositoryId());
        message.style(STYLE).append((CharSequence)": ").append((CharSequence)resource.getRepositoryUrl());
        message.resetStyle().append((CharSequence)resource.getResourceName());
        message.style(STYLE).append((CharSequence)" (").append((CharSequence)format.format(contentLength));
        long duration = System.currentTimeMillis() - resource.getTransferStartTime();
        if (duration > 0L) {
            double bytesPerSecond = (double)contentLength / ((double)duration / 1000.0);
            message.append((CharSequence)" at ");
            format.format(message, (long)bytesPerSecond);
            message.append((CharSequence)"/s");
        }
        message.append(')').resetStyle();
        this.out.println(message.toString());
    }
}

