/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.Lifecycle;
import org.apache.maven.api.services.LifecycleRegistry;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;

public class Lifecycle {
    private String id;
    private List<String> phases;
    private Map<String, LifecyclePhase> defaultPhases;
    private org.apache.maven.api.Lifecycle lifecycle;

    public Lifecycle() {
    }

    public Lifecycle(String id, List<String> phases, Map<String, LifecyclePhase> defaultPhases) {
        this.id = id;
        this.phases = phases;
        this.defaultPhases = defaultPhases;
    }

    public Lifecycle(LifecycleRegistry registry, org.apache.maven.api.Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
        this.id = lifecycle.id();
        this.phases = registry.computePhases(lifecycle).stream().flatMap(p -> Stream.of("before:" + p, p, "after:" + p)).toList();
        this.defaultPhases = Lifecycle.getDefaultPhases(lifecycle);
    }

    public String getId() {
        return this.id;
    }

    public org.apache.maven.api.Lifecycle getDelegate() {
        return this.lifecycle;
    }

    public List<String> getPhases() {
        return this.phases;
    }

    static Map<String, LifecyclePhase> getDefaultPhases(org.apache.maven.api.Lifecycle lifecycle) {
        HashMap goals = new HashMap();
        lifecycle.allPhases().forEach(phase -> phase.plugins().forEach(plugin -> plugin.getExecutions().forEach(exec -> exec.getGoals().forEach(goal -> goals.computeIfAbsent(phase.name(), n -> new ArrayList()).add(plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion() + ":" + goal)))));
        return goals.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new LifecyclePhase(String.join((CharSequence)",", (Iterable)e.getValue()))));
    }

    public Map<String, LifecyclePhase> getDefaultLifecyclePhases() {
        return this.defaultPhases;
    }

    @Deprecated
    public Map<String, String> getDefaultPhases() {
        return LifecyclePhase.toLegacyMap(this.getDefaultLifecyclePhases());
    }

    public String toString() {
        return this.id + " -> " + this.lifecycle.allPhases().map(Lifecycle.Phase::name).collect(Collectors.joining(", ", "[", "]"));
    }
}

