/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ArtifactCoordinatesFactory;
import org.apache.maven.api.services.ArtifactCoordinatesFactoryRequest;
import org.apache.maven.internal.impl.DefaultArtifactCoordinates;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;

@Named
@Singleton
public class DefaultArtifactCoordinatesFactory
implements ArtifactCoordinatesFactory {
    public ArtifactCoordinates create(@Nonnull ArtifactCoordinatesFactoryRequest request) {
        String str1;
        Utils.nonNull(request, "request");
        InternalSession session = InternalSession.from(request.getSession());
        if (request.getCoordinatesString() != null) {
            return new DefaultArtifactCoordinates(session, (Artifact)new DefaultArtifact(request.getCoordinatesString()));
        }
        ArtifactType type = null;
        if (request.getType() != null) {
            type = session.getSession().getArtifactTypeRegistry().get(request.getType());
        }
        String classifier = (str1 = request.getClassifier()) != null && !str1.isEmpty() ? request.getClassifier() : (type != null ? type.getClassifier() : "");
        String str = request.getExtension();
        String extension = str != null && !str.isEmpty() ? request.getExtension() : (type != null ? type.getExtension() : "");
        return new DefaultArtifactCoordinates(session, (Artifact)new DefaultArtifact(request.getGroupId(), request.getArtifactId(), classifier, extension, request.getVersion(), type));
    }
}

