/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.v4;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.toolchain.InputLocation;
import org.apache.maven.api.toolchain.PersistedToolchains;
import org.apache.maven.api.toolchain.ToolchainModel;
import org.apache.maven.api.toolchain.TrackableBase;
import org.apache.maven.api.xml.XmlNode;

@Generated
public class MavenToolchainsMerger {
    private final boolean deepMerge;

    public MavenToolchainsMerger() {
        this(true);
    }

    public MavenToolchainsMerger(boolean deepMerge) {
        this.deepMerge = deepMerge;
    }

    public PersistedToolchains merge(PersistedToolchains target, PersistedToolchains source, boolean sourceDominant, Map<?, ?> hints) {
        Objects.requireNonNull(target, "target cannot be null");
        if (source == null) {
            return target;
        }
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        if (hints != null) {
            context.putAll(hints);
        }
        return this.mergePersistedToolchains(target, source, sourceDominant, context);
    }

    protected TrackableBase mergeTrackableBase(TrackableBase target, TrackableBase source, boolean sourceDominant, Map<Object, Object> context) {
        TrackableBase.Builder builder = TrackableBase.newBuilder((TrackableBase)target);
        this.mergeTrackableBase(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeTrackableBase(TrackableBase.Builder builder, TrackableBase target, TrackableBase source, boolean sourceDominant, Map<Object, Object> context) {
    }

    protected PersistedToolchains mergePersistedToolchains(PersistedToolchains target, PersistedToolchains source, boolean sourceDominant, Map<Object, Object> context) {
        PersistedToolchains.Builder builder = PersistedToolchains.newBuilder((PersistedToolchains)target);
        this.mergePersistedToolchains(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergePersistedToolchains(PersistedToolchains.Builder builder, PersistedToolchains target, PersistedToolchains source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeTrackableBase((TrackableBase.Builder)builder, (TrackableBase)target, (TrackableBase)source, sourceDominant, context);
        this.mergePersistedToolchains_Toolchains(builder, target, source, sourceDominant, context);
    }

    protected void mergePersistedToolchains_Toolchains(PersistedToolchains.Builder builder, PersistedToolchains target, PersistedToolchains source, boolean sourceDominant, Map<Object, Object> context) {
        if (this.deepMerge) {
            builder.toolchains(MavenToolchainsMerger.merge(target.getToolchains(), source.getToolchains(), this.getToolchainModelKey(), (t, s) -> this.mergeToolchainModel((ToolchainModel)t, (ToolchainModel)s, sourceDominant, context)));
        } else {
            builder.toolchains(MavenToolchainsMerger.merge(target.getToolchains(), source.getToolchains(), sourceDominant, this.getToolchainModelKey()));
        }
    }

    protected ToolchainModel mergeToolchainModel(ToolchainModel target, ToolchainModel source, boolean sourceDominant, Map<Object, Object> context) {
        ToolchainModel.Builder builder = ToolchainModel.newBuilder((ToolchainModel)target);
        this.mergeToolchainModel(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeToolchainModel(ToolchainModel.Builder builder, ToolchainModel target, ToolchainModel source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeTrackableBase((TrackableBase.Builder)builder, (TrackableBase)target, (TrackableBase)source, sourceDominant, context);
        this.mergeToolchainModel_Type(builder, target, source, sourceDominant, context);
        this.mergeToolchainModel_Provides(builder, target, source, sourceDominant, context);
        this.mergeToolchainModel_Configuration(builder, target, source, sourceDominant, context);
    }

    protected void mergeToolchainModel_Type(ToolchainModel.Builder builder, ToolchainModel target, ToolchainModel source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getType();
        String tgt = target.getType();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.type(src);
            builder.location((Object)"type", source.getLocation((Object)"type"));
        }
    }

    protected void mergeToolchainModel_Provides(ToolchainModel.Builder builder, ToolchainModel target, ToolchainModel source, boolean sourceDominant, Map<Object, Object> context) {
        Map src = source.getProvides();
        if (!src.isEmpty()) {
            Map tgt = target.getProvides();
            if (tgt.isEmpty()) {
                builder.provides(src);
                builder.location((Object)"provides", source.getLocation((Object)"provides"));
            } else {
                HashMap merged = new HashMap();
                merged.putAll(sourceDominant ? target.getProvides() : source.getProvides());
                merged.putAll(sourceDominant ? source.getProvides() : target.getProvides());
                builder.provides(merged);
                builder.location((Object)"provides", InputLocation.merge((InputLocation)target.getLocation((Object)"provides"), (InputLocation)source.getLocation((Object)"provides"), (boolean)sourceDominant));
            }
        }
    }

    protected void mergeToolchainModel_Configuration(ToolchainModel.Builder builder, ToolchainModel target, ToolchainModel source, boolean sourceDominant, Map<Object, Object> context) {
        XmlNode src = source.getConfiguration();
        if (src != null) {
            XmlNode tgt = target.getConfiguration();
            if (tgt == null) {
                builder.configuration(src);
                builder.location((Object)"configuration", source.getLocation((Object)"configuration"));
            } else if (sourceDominant) {
                builder.configuration(src.merge(tgt));
                builder.location((Object)"configuration", target.getLocation((Object)"configuration"));
            } else {
                builder.configuration(tgt.merge(src));
                builder.location((Object)"configuration", null);
            }
        }
    }

    protected KeyComputer<TrackableBase> getTrackableBaseKey() {
        return v -> v;
    }

    protected KeyComputer<PersistedToolchains> getPersistedToolchainsKey() {
        return v -> v;
    }

    protected KeyComputer<ToolchainModel> getToolchainModelKey() {
        return v -> v;
    }

    public static <T> List<T> merge(List<T> tgt, List<T> src, boolean sourceDominant, KeyComputer<T> computer) {
        return MavenToolchainsMerger.merge(tgt, src, computer, (t, s) -> sourceDominant ? s : t);
    }

    public static <T> List<T> merge(List<T> tgt, List<T> src, KeyComputer<T> computer, BinaryOperator<T> remapping) {
        MergingList<T> list;
        if (src.isEmpty()) {
            return tgt;
        }
        if (tgt instanceof MergingList) {
            list = (MergingList<T>)tgt;
        } else {
            list = new MergingList<T>(computer, src.size() + tgt.size());
            list.mergeAll(tgt, (t, s) -> s);
        }
        list.mergeAll(src, remapping);
        return list;
    }

    @FunctionalInterface
    public static interface KeyComputer<T>
    extends Function<T, Object> {
    }

    private static class MergingList<V>
    extends AbstractList<V>
    implements Serializable {
        private final KeyComputer<V> keyComputer;
        private Map<Object, V> map;
        private List<V> list;

        MergingList(KeyComputer<V> keyComputer, int initialCapacity) {
            this.map = new LinkedHashMap<Object, V>(initialCapacity);
            this.keyComputer = keyComputer;
        }

        Object writeReplace() throws ObjectStreamException {
            return new ArrayList(this);
        }

        @Override
        public Iterator<V> iterator() {
            if (this.map != null) {
                return this.map.values().iterator();
            }
            return this.list.iterator();
        }

        void mergeAll(Collection<V> vs, BinaryOperator<V> remapping) {
            if (this.map == null) {
                this.map = this.list.stream().collect(Collectors.toMap(this.keyComputer, Function.identity(), null, LinkedHashMap::new));
                this.list = null;
            }
            if (vs instanceof MergingList && ((MergingList)vs).map != null) {
                for (Map.Entry<Object, V> e : ((MergingList)vs).map.entrySet()) {
                    Object key = e.getKey();
                    V v = e.getValue();
                    this.map.merge(key, v, remapping);
                }
            } else {
                for (V v : vs) {
                    Object key = this.keyComputer.apply(v);
                    this.map.merge(key, v, remapping);
                }
            }
        }

        @Override
        public boolean contains(Object o) {
            if (this.map != null) {
                return this.map.containsValue(o);
            }
            return this.list.contains(o);
        }

        private List<V> asList() {
            if (this.list == null) {
                this.list = new ArrayList<V>(this.map.values());
                this.map = null;
            }
            return this.list;
        }

        @Override
        public void add(int index, V element) {
            this.asList().add(index, element);
        }

        @Override
        public V remove(int index) {
            return this.asList().remove(index);
        }

        @Override
        public V get(int index) {
            return this.asList().get(index);
        }

        @Override
        public int size() {
            if (this.map != null) {
                return this.map.size();
            }
            return this.list.size();
        }
    }
}

