/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvn;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.cli.ParseException;
import org.apache.maven.api.cli.Options;
import org.apache.maven.api.cli.ParserException;
import org.apache.maven.api.cli.mvn.MavenOptions;
import org.apache.maven.cling.invoker.BaseParser;
import org.apache.maven.cling.invoker.mvn.CommonsCliMavenOptions;
import org.apache.maven.cling.invoker.mvn.LayeredMavenOptions;
import org.apache.maven.cling.invoker.mvn.MavenInvokerRequest;

public class MavenParser
extends BaseParser {
    @Override
    protected List<Options> parseCliOptions(BaseParser.LocalContext context) throws ParserException, IOException {
        Path mavenConfig;
        ArrayList<Options> result = new ArrayList<Options>();
        result.add((Options)this.parseMavenCliOptions(context.parserRequest.args()));
        Path path = mavenConfig = context.rootDirectory != null ? context.rootDirectory.resolve(".mvn/maven.config") : null;
        if (mavenConfig != null && Files.isRegularFile(mavenConfig, new LinkOption[0])) {
            result.add((Options)this.parseMavenConfigOptions(mavenConfig));
        }
        return result;
    }

    protected MavenOptions parseMavenCliOptions(List<String> args) throws ParserException {
        return this.parseArgs("CLI", args);
    }

    protected MavenOptions parseMavenConfigOptions(Path configFile) throws ParserException, IOException {
        try (Stream<String> lines = Files.lines(configFile, Charset.defaultCharset());){
            List<String> args = lines.filter(arg -> !arg.isEmpty() && !arg.startsWith("#")).toList();
            MavenOptions options = this.parseArgs("maven.config", args);
            if (options.goals().isPresent()) {
                throw new ParserException("Unrecognized maven.config file entries: " + options.goals().get());
            }
            MavenOptions mavenOptions = options;
            return mavenOptions;
        }
    }

    protected MavenOptions parseArgs(String source, List<String> args) throws ParserException {
        try {
            return CommonsCliMavenOptions.parse(source, args.toArray(new String[0]));
        }
        catch (ParseException e) {
            throw new ParserException("Failed to parse source " + source + ": " + e.getMessage(), e.getCause());
        }
    }

    @Override
    protected MavenInvokerRequest getInvokerRequest(BaseParser.LocalContext context) {
        return new MavenInvokerRequest(context.parserRequest, context.cwd, context.installationDirectory, context.userHomeDirectory, context.userProperties, context.systemProperties, context.topDirectory, context.rootDirectory, context.parserRequest.in(), context.parserRequest.out(), context.parserRequest.err(), context.extensions, this.getJvmArguments(context.rootDirectory), (MavenOptions)context.options);
    }

    protected MavenOptions assembleOptions(List<Options> parsedOptions) {
        return LayeredMavenOptions.layerMavenOptions(parsedOptions);
    }
}

