/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.metadata.v4;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.metadata.Metadata;
import org.apache.maven.api.metadata.Plugin;
import org.apache.maven.api.metadata.Snapshot;
import org.apache.maven.api.metadata.SnapshotVersion;
import org.apache.maven.api.metadata.Versioning;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeStaxBuilder;

@Generated
public class MetadataStaxReader {
    private static final Map<String, String> DEFAULT_ENTITIES;
    private boolean addDefaultEntities = true;
    private final ContentTransformer contentTransformer;

    public MetadataStaxReader() {
        this((s, f) -> s);
    }

    public MetadataStaxReader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    public XMLInputFactory getXMLInputFactory() {
        return InputFactoryHolder.XML_INPUT_FACTORY;
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public Metadata read(Reader reader) throws XMLStreamException {
        return this.read(reader, true);
    }

    public Metadata read(Reader reader, boolean strict) throws XMLStreamException {
        StreamSource streamSource = new StreamSource(reader);
        XMLInputFactory factory = this.getXMLInputFactory();
        XMLStreamReader parser = factory.createXMLStreamReader(streamSource);
        return this.read(parser, strict);
    }

    public Metadata read(InputStream in) throws XMLStreamException {
        return this.read(in, true);
    }

    public Metadata read(InputStream in, boolean strict) throws XMLStreamException {
        StreamSource streamSource = new StreamSource(in);
        XMLInputFactory factory = this.getXMLInputFactory();
        XMLStreamReader parser = factory.createXMLStreamReader(streamSource);
        return this.read(parser, strict);
    }

    public Metadata read(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        Metadata metadata = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 8) {
            if (eventType == 1) {
                if (strict && !"metadata".equals(parser.getLocalName())) {
                    throw new XMLStreamException("Expected root element 'metadata' but found '" + parser.getName() + "'", parser.getLocation(), null);
                }
                if (parsed) {
                    throw new XMLStreamException("Duplicated tag: 'metadata'", parser.getLocation(), null);
                }
                metadata = this.parseMetadata(parser, strict);
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return metadata;
        }
        throw new XMLStreamException("Expected root element 'metadata' but found no element at all: invalid XML document", parser.getLocation(), null);
    }

    private Metadata parseMetadata(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Metadata.Builder metadata = Metadata.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns) || "xmlns".equals(name)) continue;
            if ("modelVersion".equals(name)) {
                metadata.modelVersion(this.interpolatedTrimmed(value, "modelVersion"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block15: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getLocalName(), parser, parsed)) {
                case "groupId": {
                    metadata.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    continue block15;
                }
                case "artifactId": {
                    metadata.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    continue block15;
                }
                case "versioning": {
                    metadata.versioning(this.parseVersioning(parser, strict));
                    continue block15;
                }
                case "version": {
                    metadata.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    continue block15;
                }
                case "plugins": {
                    ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parsePlugin(parser, strict));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    metadata.plugins(plugins);
                    continue block15;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        metadata.namespaceUri(parser.getNamespaceURI());
        metadata.modelEncoding(parser.getEncoding());
        return metadata.build();
    }

    private Versioning parseVersioning(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Versioning.Builder versioning = Versioning.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block17: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getLocalName(), parser, parsed)) {
                case "latest": {
                    versioning.latest(this.interpolatedTrimmed(this.nextText(parser, strict), "latest"));
                    continue block17;
                }
                case "release": {
                    versioning.release(this.interpolatedTrimmed(this.nextText(parser, strict), "release"));
                    continue block17;
                }
                case "versions": {
                    ArrayList<String> versions = new ArrayList<String>();
                    while (parser.nextTag() == 1) {
                        if ("version".equals(parser.getLocalName())) {
                            versions.add(this.interpolatedTrimmed(this.nextText(parser, strict), "versions"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    versioning.versions(versions);
                    continue block17;
                }
                case "lastUpdated": {
                    versioning.lastUpdated(this.interpolatedTrimmed(this.nextText(parser, strict), "lastUpdated"));
                    continue block17;
                }
                case "snapshot": {
                    versioning.snapshot(this.parseSnapshot(parser, strict));
                    continue block17;
                }
                case "snapshotVersions": {
                    ArrayList<SnapshotVersion> snapshotVersions = new ArrayList<SnapshotVersion>();
                    while (parser.nextTag() == 1) {
                        if ("snapshotVersion".equals(parser.getLocalName())) {
                            snapshotVersions.add(this.parseSnapshotVersion(parser, strict));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    versioning.snapshotVersions(snapshotVersions);
                    continue block17;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return versioning.build();
    }

    private Snapshot parseSnapshot(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Snapshot.Builder snapshot = Snapshot.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block11: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getLocalName(), parser, parsed)) {
                case "timestamp": {
                    snapshot.timestamp(this.interpolatedTrimmed(this.nextText(parser, strict), "timestamp"));
                    continue block11;
                }
                case "buildNumber": {
                    snapshot.buildNumber(this.getIntegerValue(this.interpolatedTrimmed(this.nextText(parser, strict), "buildNumber"), "buildNumber", parser, strict, 0));
                    continue block11;
                }
                case "localCopy": {
                    snapshot.localCopy(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "localCopy"), "localCopy", parser, false));
                    continue block11;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return snapshot.build();
    }

    private SnapshotVersion parseSnapshotVersion(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        String tagName = parser.getLocalName();
        SnapshotVersion.Builder snapshotVersion = SnapshotVersion.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block13: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getLocalName(), parser, parsed)) {
                case "classifier": {
                    snapshotVersion.classifier(this.interpolatedTrimmed(this.nextText(parser, strict), "classifier"));
                    continue block13;
                }
                case "extension": {
                    snapshotVersion.extension(this.interpolatedTrimmed(this.nextText(parser, strict), "extension"));
                    continue block13;
                }
                case "value": {
                    snapshotVersion.version(this.interpolatedTrimmed(this.nextText(parser, strict), "value"));
                    continue block13;
                }
                case "updated": {
                    snapshotVersion.updated(this.interpolatedTrimmed(this.nextText(parser, strict), "updated"));
                    continue block13;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return snapshotVersion.build();
    }

    private Plugin parsePlugin(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Plugin.Builder plugin = Plugin.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block11: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getLocalName(), parser, parsed)) {
                case "name": {
                    plugin.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    continue block11;
                }
                case "prefix": {
                    plugin.prefix(this.interpolatedTrimmed(this.nextText(parser, strict), "prefix"));
                    continue block11;
                }
                case "artifactId": {
                    plugin.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    continue block11;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return plugin.build();
    }

    private String checkDuplicate(String tagName, XMLStreamReader parser, Set<String> parsed) throws XMLStreamException {
        if (!parsed.add(tagName)) {
            throw new XMLStreamException("Duplicated tag: '" + tagName + "'", parser.getLocation(), null);
        }
        return tagName;
    }

    private void checkUnknownAttribute(XMLStreamReader parser, String attribute, String tagName, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser.getLocation(), null);
        }
    }

    private void checkUnknownElement(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unrecognised tag: '" + parser.getName() + "'", parser.getLocation(), null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = this.nextTag(parser);
            if (eventType == 1) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 2) continue;
            --unrecognizedTagCount;
        }
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XMLStreamReader parser) throws XMLStreamException {
        block4: while (true) {
            int next = parser.next();
            switch (next) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    continue block4;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
        }
    }

    private String nextText(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        int eventType = parser.getEventType();
        if (eventType != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", parser.getLocation(), null);
        }
        eventType = parser.next();
        StringBuilder result = new StringBuilder();
        while (true) {
            if (eventType == 4 || eventType == 12) {
                result.append(parser.getText());
            } else if (eventType == 9) {
                String val = null;
                if (strict) {
                    throw new XMLStreamException("Entities are not supported in strict mode", parser.getLocation(), null);
                }
                if (this.addDefaultEntities) {
                    val = DEFAULT_ENTITIES.get(parser.getLocalName());
                }
                if (val != null) {
                    result.append(val);
                } else {
                    result.append("&").append(parser.getLocalName()).append(";");
                }
            } else if (eventType != 5) break;
            eventType = parser.next();
        }
        if (eventType != 2) {
            throw new XMLStreamException("TEXT must be immediately followed by END_ELEMENT and not " + eventType, parser.getLocation(), null);
        }
        return result.toString();
    }

    private XmlNode buildXmlNode(XMLStreamReader parser) throws XMLStreamException {
        return XmlNodeStaxBuilder.build((XMLStreamReader)parser);
    }

    private boolean getBooleanValue(String s, String attribute, XMLStreamReader parser, boolean defaultValue) throws XMLStreamException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        return defaultValue;
    }

    private int getIntegerValue(String s, String attribute, XMLStreamReader parser, boolean strict, int defaultValue) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer", parser.getLocation(), nfe);
                }
            }
        }
        return defaultValue;
    }

    static {
        HashMap<String, String> entities = new HashMap<String, String>();
        entities.put("nbsp", "\u00a0");
        entities.put("iexcl", "\u00a1");
        entities.put("cent", "\u00a2");
        entities.put("pound", "\u00a3");
        entities.put("curren", "\u00a4");
        entities.put("yen", "\u00a5");
        entities.put("brvbar", "\u00a6");
        entities.put("sect", "\u00a7");
        entities.put("uml", "\u00a8");
        entities.put("copy", "\u00a9");
        entities.put("ordf", "\u00aa");
        entities.put("laquo", "\u00ab");
        entities.put("not", "\u00ac");
        entities.put("shy", "\u00ad");
        entities.put("reg", "\u00ae");
        entities.put("macr", "\u00af");
        entities.put("deg", "\u00b0");
        entities.put("plusmn", "\u00b1");
        entities.put("sup2", "\u00b2");
        entities.put("sup3", "\u00b3");
        entities.put("acute", "\u00b4");
        entities.put("micro", "\u00b5");
        entities.put("para", "\u00b6");
        entities.put("middot", "\u00b7");
        entities.put("cedil", "\u00b8");
        entities.put("sup1", "\u00b9");
        entities.put("ordm", "\u00ba");
        entities.put("raquo", "\u00bb");
        entities.put("frac14", "\u00bc");
        entities.put("frac12", "\u00bd");
        entities.put("frac34", "\u00be");
        entities.put("iquest", "\u00bf");
        entities.put("Agrave", "\u00c0");
        entities.put("Aacute", "\u00c1");
        entities.put("Acirc", "\u00c2");
        entities.put("Atilde", "\u00c3");
        entities.put("Auml", "\u00c4");
        entities.put("Aring", "\u00c5");
        entities.put("AElig", "\u00c6");
        entities.put("Ccedil", "\u00c7");
        entities.put("Egrave", "\u00c8");
        entities.put("Eacute", "\u00c9");
        entities.put("Ecirc", "\u00ca");
        entities.put("Euml", "\u00cb");
        entities.put("Igrave", "\u00cc");
        entities.put("Iacute", "\u00cd");
        entities.put("Icirc", "\u00ce");
        entities.put("Iuml", "\u00cf");
        entities.put("ETH", "\u00d0");
        entities.put("Ntilde", "\u00d1");
        entities.put("Ograve", "\u00d2");
        entities.put("Oacute", "\u00d3");
        entities.put("Ocirc", "\u00d4");
        entities.put("Otilde", "\u00d5");
        entities.put("Ouml", "\u00d6");
        entities.put("times", "\u00d7");
        entities.put("Oslash", "\u00d8");
        entities.put("Ugrave", "\u00d9");
        entities.put("Uacute", "\u00da");
        entities.put("Ucirc", "\u00db");
        entities.put("Uuml", "\u00dc");
        entities.put("Yacute", "\u00dd");
        entities.put("THORN", "\u00de");
        entities.put("szlig", "\u00df");
        entities.put("agrave", "\u00e0");
        entities.put("aacute", "\u00e1");
        entities.put("acirc", "\u00e2");
        entities.put("atilde", "\u00e3");
        entities.put("auml", "\u00e4");
        entities.put("aring", "\u00e5");
        entities.put("aelig", "\u00e6");
        entities.put("ccedil", "\u00e7");
        entities.put("egrave", "\u00e8");
        entities.put("eacute", "\u00e9");
        entities.put("ecirc", "\u00ea");
        entities.put("euml", "\u00eb");
        entities.put("igrave", "\u00ec");
        entities.put("iacute", "\u00ed");
        entities.put("icirc", "\u00ee");
        entities.put("iuml", "\u00ef");
        entities.put("eth", "\u00f0");
        entities.put("ntilde", "\u00f1");
        entities.put("ograve", "\u00f2");
        entities.put("oacute", "\u00f3");
        entities.put("ocirc", "\u00f4");
        entities.put("otilde", "\u00f5");
        entities.put("ouml", "\u00f6");
        entities.put("divide", "\u00f7");
        entities.put("oslash", "\u00f8");
        entities.put("ugrave", "\u00f9");
        entities.put("uacute", "\u00fa");
        entities.put("ucirc", "\u00fb");
        entities.put("uuml", "\u00fc");
        entities.put("yacute", "\u00fd");
        entities.put("thorn", "\u00fe");
        entities.put("yuml", "\u00ff");
        entities.put("OElig", "\u0152");
        entities.put("oelig", "\u0153");
        entities.put("Scaron", "\u0160");
        entities.put("scaron", "\u0161");
        entities.put("Yuml", "\u0178");
        entities.put("circ", "\u02c6");
        entities.put("tilde", "\u02dc");
        entities.put("ensp", "\u2002");
        entities.put("emsp", "\u2003");
        entities.put("thinsp", "\u2009");
        entities.put("zwnj", "\u200c");
        entities.put("zwj", "\u200d");
        entities.put("lrm", "\u200e");
        entities.put("rlm", "\u200f");
        entities.put("ndash", "\u2013");
        entities.put("mdash", "\u2014");
        entities.put("lsquo", "\u2018");
        entities.put("rsquo", "\u2019");
        entities.put("sbquo", "\u201a");
        entities.put("ldquo", "\u201c");
        entities.put("rdquo", "\u201d");
        entities.put("bdquo", "\u201e");
        entities.put("dagger", "\u2020");
        entities.put("Dagger", "\u2021");
        entities.put("permil", "\u2030");
        entities.put("lsaquo", "\u2039");
        entities.put("rsaquo", "\u203a");
        entities.put("euro", "\u20ac");
        entities.put("fnof", "\u0192");
        entities.put("Alpha", "\u0391");
        entities.put("Beta", "\u0392");
        entities.put("Gamma", "\u0393");
        entities.put("Delta", "\u0394");
        entities.put("Epsilon", "\u0395");
        entities.put("Zeta", "\u0396");
        entities.put("Eta", "\u0397");
        entities.put("Theta", "\u0398");
        entities.put("Iota", "\u0399");
        entities.put("Kappa", "\u039a");
        entities.put("Lambda", "\u039b");
        entities.put("Mu", "\u039c");
        entities.put("Nu", "\u039d");
        entities.put("Xi", "\u039e");
        entities.put("Omicron", "\u039f");
        entities.put("Pi", "\u03a0");
        entities.put("Rho", "\u03a1");
        entities.put("Sigma", "\u03a3");
        entities.put("Tau", "\u03a4");
        entities.put("Upsilon", "\u03a5");
        entities.put("Phi", "\u03a6");
        entities.put("Chi", "\u03a7");
        entities.put("Psi", "\u03a8");
        entities.put("Omega", "\u03a9");
        entities.put("alpha", "\u03b1");
        entities.put("beta", "\u03b2");
        entities.put("gamma", "\u03b3");
        entities.put("delta", "\u03b4");
        entities.put("epsilon", "\u03b5");
        entities.put("zeta", "\u03b6");
        entities.put("eta", "\u03b7");
        entities.put("theta", "\u03b8");
        entities.put("iota", "\u03b9");
        entities.put("kappa", "\u03ba");
        entities.put("lambda", "\u03bb");
        entities.put("mu", "\u03bc");
        entities.put("nu", "\u03bd");
        entities.put("xi", "\u03be");
        entities.put("omicron", "\u03bf");
        entities.put("pi", "\u03c0");
        entities.put("rho", "\u03c1");
        entities.put("sigmaf", "\u03c2");
        entities.put("sigma", "\u03c3");
        entities.put("tau", "\u03c4");
        entities.put("upsilon", "\u03c5");
        entities.put("phi", "\u03c6");
        entities.put("chi", "\u03c7");
        entities.put("psi", "\u03c8");
        entities.put("omega", "\u03c9");
        entities.put("thetasym", "\u03d1");
        entities.put("upsih", "\u03d2");
        entities.put("piv", "\u03d6");
        entities.put("bull", "\u2022");
        entities.put("hellip", "\u2026");
        entities.put("prime", "\u2032");
        entities.put("Prime", "\u2033");
        entities.put("oline", "\u203e");
        entities.put("frasl", "\u2044");
        entities.put("weierp", "\u2118");
        entities.put("image", "\u2111");
        entities.put("real", "\u211c");
        entities.put("trade", "\u2122");
        entities.put("alefsym", "\u2135");
        entities.put("larr", "\u2190");
        entities.put("uarr", "\u2191");
        entities.put("rarr", "\u2192");
        entities.put("darr", "\u2193");
        entities.put("harr", "\u2194");
        entities.put("crarr", "\u21b5");
        entities.put("lArr", "\u21d0");
        entities.put("uArr", "\u21d1");
        entities.put("rArr", "\u21d2");
        entities.put("dArr", "\u21d3");
        entities.put("hArr", "\u21d4");
        entities.put("forall", "\u2200");
        entities.put("part", "\u2202");
        entities.put("exist", "\u2203");
        entities.put("empty", "\u2205");
        entities.put("nabla", "\u2207");
        entities.put("isin", "\u2208");
        entities.put("notin", "\u2209");
        entities.put("ni", "\u220b");
        entities.put("prod", "\u220f");
        entities.put("sum", "\u2211");
        entities.put("minus", "\u2212");
        entities.put("lowast", "\u2217");
        entities.put("radic", "\u221a");
        entities.put("prop", "\u221d");
        entities.put("infin", "\u221e");
        entities.put("ang", "\u2220");
        entities.put("and", "\u2227");
        entities.put("or", "\u2228");
        entities.put("cap", "\u2229");
        entities.put("cup", "\u222a");
        entities.put("int", "\u222b");
        entities.put("there4", "\u2234");
        entities.put("sim", "\u223c");
        entities.put("cong", "\u2245");
        entities.put("asymp", "\u2248");
        entities.put("ne", "\u2260");
        entities.put("equiv", "\u2261");
        entities.put("le", "\u2264");
        entities.put("ge", "\u2265");
        entities.put("sub", "\u2282");
        entities.put("sup", "\u2283");
        entities.put("nsub", "\u2284");
        entities.put("sube", "\u2286");
        entities.put("supe", "\u2287");
        entities.put("oplus", "\u2295");
        entities.put("otimes", "\u2297");
        entities.put("perp", "\u22a5");
        entities.put("sdot", "\u22c5");
        entities.put("lceil", "\u2308");
        entities.put("rceil", "\u2309");
        entities.put("lfloor", "\u230a");
        entities.put("rfloor", "\u230b");
        entities.put("lang", "\u2329");
        entities.put("rang", "\u232a");
        entities.put("loz", "\u25ca");
        entities.put("spades", "\u2660");
        entities.put("clubs", "\u2663");
        entities.put("hearts", "\u2665");
        entities.put("diams", "\u2666");
        DEFAULT_ENTITIES = Collections.unmodifiableMap(entities);
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }

    static class InputFactoryHolder {
        static XMLInputFactory XML_INPUT_FACTORY;

        InputFactoryHolder() {
        }

        static {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            XML_INPUT_FACTORY = factory;
        }
    }
}

